pub trait Device {
    fn new() -> Self;
}

pub mod device {
    pub struct Cpu {}
    impl super::Device for Cpu {
        fn new() -> Self {
            println!("cpu");
            Self {}
        }
    }

    pub struct BrowserWebGpu {}
    impl super::Device for BrowserWebGpu {
        fn new() -> Self {
            Self {}
        }
    }

    pub struct Dx11 {}
    impl super::Device for Dx11 {
        fn new() -> Self {
            Self {}
        }
    }
    pub struct Dx12 {}
    impl super::Device for Dx12 {
        fn new() -> Self {
            Self {}
        }
    }
    pub struct Gl {}
    impl super::Device for Gl {
        fn new() -> Self {
            Self {}
        }
    }
    pub struct Metal {}
    impl super::Device for Metal {
        fn new() -> Self {
            Self {}
        }
    }
}

pub struct Tensor<D: Device> {
    data: D,
}
impl<D: Device> Tensor<D> {
    pub fn new() -> Self {
        Self { data: D::new() }
    }
}
