use std::marker::PhantomData;

struct Ax<A: Axis = Default> {
    _a: PhantomData<A>,
}
impl<A: Axis> Ax<A> {
    const N: usize = A::N;
}
trait Axis {
    const N: usize;
}

struct Default;
impl Axis for Default {
    const N: usize = 0;
}

macro_rules! axis {
    ($name:ident) => {
        struct $name<A: Axis = Default> {
            _a: PhantomData<A>,
        }
        impl<A: Axis> Axis for $name<A> {
            const N: usize = 1 + A::N;
        }
    };
}

struct Tensor<Axes, const N: usize> {
    _a: PhantomData<Axes>,
}
impl<A: Axis, const N: usize> Tensor<Ax<A>, N> {
    fn new(shape: [usize; N]) -> Self {
        println!("{}", Ax::<A>::N);
        Self { _a: PhantomData }
    }
}
fn main() {
    axis! {I};
    axis! {J};
    axis! {K};
    type X<F> = I<J<K<F>>>;
    let t = Tensor::<Ax, 0>::new([]);
}
