pub trait Dtype {
    fn zero() -> Self;
    fn one() -> Self;
}

impl Dtype for u32 {
    fn zero() -> Self {
        0
    }
    fn one() -> Self {
        1
    }
}

impl Dtype for i32 {
    fn zero() -> Self {
        0
    }
    fn one() -> Self {
        1
    }
}
impl Dtype for f32 {
    fn zero() -> Self {
        0.
    }
    fn one() -> Self {
        1.
    }
}
impl Dtype for bool {
    fn zero() -> Self {
        false
    }
    fn one() -> Self {
        true
    }
}
