use super::device_trait::Device;

pub struct Cpu {
    values: Vec<f32>,
}
impl Device for Cpu {
    fn new(values: Vec<f32>) -> Self {
        Self { values }
    }
    fn get(&self) -> &Vec<f32> {
        &self.values
    }
    fn device_info() -> &'static str {
        "Cpu"
    }
}

pub struct BrowserWebGpu {
    values: Vec<f32>,
}
impl Device for BrowserWebGpu {
    fn new(values: Vec<f32>) -> Self {
        Self { values }
    }
    fn get(&self) -> &Vec<f32> {
        &self.values
    }
    fn device_info() -> &'static str {
        "BrowserWebGpu"
    }
}

pub struct Dx11 {
    values: Vec<f32>,
}
impl Device for Dx11 {
    fn new(values: Vec<f32>) -> Self {
        Self { values }
    }
    fn get(&self) -> &Vec<f32> {
        &self.values
    }
    fn device_info() -> &'static str {
        "Dx11"
    }
}
pub struct Dx12 {
    values: Vec<f32>,
}
impl Device for Dx12 {
    fn new(values: Vec<f32>) -> Self {
        Self { values }
    }
    fn get(&self) -> &Vec<f32> {
        &self.values
    }
    fn device_info() -> &'static str {
        "Dx12"
    }
}
pub struct Gl {
    values: Vec<f32>,
}
impl Device for Gl {
    fn new(values: Vec<f32>) -> Self {
        Self { values }
    }
    fn get(&self) -> &Vec<f32> {
        &self.values
    }
    fn device_info() -> &'static str {
        "Gl"
    }
}
pub struct Metal {
    values: Vec<f32>,
}
impl Device for Metal {
    fn new(values: Vec<f32>) -> Self {
        Self { values }
    }
    fn get(&self) -> &Vec<f32> {
        &self.values
    }
    fn device_info() -> &'static str {
        "Metal"
    }
}
pub struct Vulkan {
    values: Vec<f32>,
}
impl Device for Vulkan {
    fn new(values: Vec<f32>) -> Self {
        Self { values }
    }
    fn get(&self) -> &Vec<f32> {
        &self.values
    }
    fn device_info() -> &'static str {
        "Vulkan"
    }
}
