use std::marker::PhantomData;

pub trait Axes {
    const N: usize;
}
pub struct Ax<
    A0: Axis = axis::Nil,
    A1: Axis = axis::Nil,
    A2: Axis = axis::Nil,
    A3: Axis = axis::Nil,
    A4: Axis = axis::Nil,
    A5: Axis = axis::Nil,
    A6: Axis = axis::Nil,
    A7: Axis = axis::Nil,
    A8: Axis = axis::Nil,
    A9: Axis = axis::Nil,
> {
    _a0: PhantomData<A0>,
    _a1: PhantomData<A1>,
    _a2: PhantomData<A2>,
    _a3: PhantomData<A3>,
    _a4: PhantomData<A4>,
    _a5: PhantomData<A5>,
    _a6: PhantomData<A6>,
    _a7: PhantomData<A7>,
    _a8: PhantomData<A8>,
    _a9: PhantomData<A9>,
}
impl<
        A0: Axis,
        A1: Axis,
        A2: Axis,
        A3: Axis,
        A4: Axis,
        A5: Axis,
        A6: Axis,
        A7: Axis,
        A8: Axis,
        A9: Axis,
    > Axes for Ax<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>
{
    const N: usize = A0::N + A1::N + A2::N + A3::N + A4::N + A5::N + A6::N + A7::N + A8::N + A9::N;
}

pub trait Axis {
    const N: usize;
}
trait IsOne {}
struct One;
impl Axis for One {
    const N: usize = 1;
}
impl IsOne for One {}

pub mod axis {
    pub struct Nil;
    impl super::Axis for Nil {
        const N: usize = 0;
    }
    macro_rules! axis {
        ($name:ident) => {
            pub struct $name<Ai: super::Axis = Nil> {
                _a: super::PhantomData<Ai>,
            }
            impl<Ai: super::Axis> super::Axis for $name<Ai> {
                const N: usize = 1;
            }
        };
    }
    axis! {A}
    axis! {B}
    axis! {C}
    axis! {D}
    axis! {E}
    axis! {F}
    axis! {G}
    axis! {H}
    axis! {I}
    axis! {J}
    axis! {K}
    axis! {L}
    axis! {M}
    axis! {N}
    axis! {O}
    axis! {P}
    axis! {Q}
    axis! {R}
    axis! {S}
    axis! {T}
    axis! {U}
    axis! {V}
    axis! {W}
    axis! {X}
    axis! {Y}
    axis! {Z}
    axis! {_0}
    axis! {_1}
    axis! {_2}
    axis! {_3}
    axis! {_4}
    axis! {_5}
    axis! {_6}
    axis! {_7}
    axis! {_8}
    axis! {_9}
}

pub struct Tensor<T: Dtype, A: Axes> {
    _t: PhantomData<T>,
    _a: PhantomData<A>,
}
pub trait Dtype {}
impl Dtype for f32 {}
impl<T: Dtype, A: Axes> Tensor<T, A> {
    pub fn new(shape: [usize; A::N]) -> Self {
        println!("{:?}", shape);
        Self {
            _a: PhantomData,
            _t: PhantomData,
        }
    }
    pub fn add(&self, b: &Self) {}
}
