#![feature(const_evaluatable_checked)]
#![feature(const_generics)]

use std::marker::PhantomData;
trait Axis {
    const N: usize;
}

struct Ax<A: Axis = Nil> {
    _a: PhantomData<A>,
}

struct Nil;
impl Axis for Nil {
    const N: usize = 0;
}

macro_rules! axis {
    ($name:ident) => {
        struct $name<A: Axis = Nil> {
            _a: PhantomData<A>,
        }
        impl<A: Axis> Axis for $name<A> {
            const N: usize = 1 + A::N;
        }
    };
}

struct Tensor<A, T: Dtype> {
    _a: PhantomData<A>,
    _t: PhantomData<T>,
}
trait Dtype {}
impl Dtype for f32 {}
impl<A: Axis, T: Dtype> Tensor<Ax<A>, T> {
    fn new(shape: [usize; A::N]) -> Self {
        println!("{:?}", shape);
        Self {
            _a: PhantomData,
            _t: PhantomData,
        }
    }
    fn add(&self, b: &Self) {}
}
fn main() {
    axis! {I};
    axis! {J};
    axis! {K};
    axis! {L};

    let t1 = Tensor::<Ax<I<J<I<K>>>>, f32>::new([1, 2, 8, 6]);
    let t2 = Tensor::<Ax<I<J<I<K>>>>, f32>::new([1, 2, 8, 6]);
    let t3 = Tensor::<Ax, f32>::new([]);
}
