use std::marker::PhantomData;

struct Ax<A: Axis, const N: usize> {
    _a: PhantomData<A>,
}
impl<A: Axis, const N: usize> Ax<A, N> {
    const N: usize = A::N;
}
trait Axis {
    const N: usize = 0;
}
struct Nil;
impl Axis for Nil {
    const N: usize = 0;
}

macro_rules! axis {
    ($name:ident) => {
        struct $name<A: Axis = Nil> {
            _a: PhantomData<A>,
        }
        impl<A: Axis> Axis for $name<A> {
            const N: usize = 1 + A::N;
        }
    };
}

macro_rules! Axis {
    () => {
        Nil
    };
    ($ax: ident $(,$ax2: ident)* $(,)*) => {
        $ax<Axis!{$($ax2, )*}>
    };
}
macro_rules! Ax {
    () => {
        Ax<Nil, { <Nil as Axis>::N }>
    };
    ($ax: ident $(,$ax2: ident)* $(,)*) => {
        Ax<Axis!{$ax, $($ax2, )*}, { <Axis!{$ax, $($ax2, )*} as Axis>::N }>
    };
}
struct Tensor<A> {
    _a: PhantomData<A>,
}
impl<A: Axis, const N: usize> Tensor<Ax<A, N>> {
    fn new(shape: [usize; N]) -> Self {
        println!("{:?}", shape);
        Self { _a: PhantomData }
    }
}

fn main() {
    axis! {I};
    axis! {J};
    axis! {K};
    axis! {L};
    println!("{}", <Axis![] as Axis>::N);
    println!("{}", <Axis![I] as Axis>::N);
    println!("{}", <Axis![I, I] as Axis>::N);
    println!("{}", <Axis![I, I,] as Axis>::N);

    let t1: Tensor<Ax![I, J, K, L]> = Tensor::<Ax![I, J, K, L]>::new([1, 2, 3, 8]);
    let t2 = Tensor::<Ax<I<J<K<L>>>, 4>>::new([1, 2, 3, 8]);
    let t3: Tensor<Ax<Axis![], 0>> = Tensor::<Ax<Axis![], 0>>::new([]);
    let t3: Tensor<Ax![]> = Tensor::<Ax![]>::new([]);
    let t4 = Tensor::<Ax<Nil, 0>>::new([]);
}
