use once_cell::sync::Lazy;
use std::collections::BTreeMap;
use std::iter::FromIterator;

/// A list of svg style and their ident using snake_case
/// [Reference](https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute)
pub(super) static SVG_STYLES: Lazy<BTreeMap<&'static str, &'static str>> = Lazy::new(|| {
    BTreeMap::from_iter([
        ("accent_height", "accent-height"),
        ("accumulate", "accumulate"),
        ("additive", "additive"),
        ("alignment_baseline", "alignment-baseline"),
        ("alphabetic", "alphabetic"),
        ("amplitude", "amplitude"),
        ("arabic_form", "arabic-form"),
        ("ascent", "ascent"),
        ("attribute_name", "attributeName"),
        ("attribute_type", "attributeType"),
        ("azimuth", "azimuth"),
        ("base_frequency", "baseFrequency"),
        ("baseline_shift", "baseline-shift"),
        ("baseProfile", "baseProfile"),
        ("bbox", "bbox"),
        ("begin", "begin"),
        ("bias", "bias"),
        ("by", "by"),
        ("calc_mode", "calcMode"),
        ("cap_height", "cap-height"),
        ("class", "class"),
        ("clip", "clip"),
        ("clip_path_units", "clipPathUnits"),
        ("clip_path", "clip-path"),
        ("clip_rule", "clip-rule"),
        ("color", "color"),
        ("color_interpolation", "color-interpolation"),
        ("color_interpolation_filters", "color-interpolation-filters"),
        ("color_profile", "color-profile"),
        ("color_rendering", "color-rendering"),
        ("content_script_type", "contentScriptType"),
        ("content_style_type", "contentStyleType"),
        ("crossorigin", "crossorigin"),
        ("cursor", "cursor"),
        ("cx", "cx"),
        ("cy", "cy"),
        ("d", "d"),
        ("decelerate", "decelerate"),
        ("descent", "descent"),
        ("diffuse_constant", "diffuseConstant"),
        ("direction", "direction"),
        ("display", "display"),
        ("divisor", "divisor"),
        ("dominant_baseline", "dominant-baseline"),
        ("dur", "dur"),
        ("dx", "dx"),
        ("dy", "dy"),
        ("edge_mode", "edgeMode"),
        ("elevation", "elevation"),
        ("enable_background", "enable-background"),
        ("end", "end"),
        ("exponent", "exponent"),
        ("fill", "fill"),
        ("fill_opacity", "fill-opacity"),
        ("fill_rule", "fill-rule"),
        ("filter", "filter"),
        ("filter_res", "filterRes"),
        ("filter_units", "filterUnits"),
        ("flood_color", "flood-color"),
        ("flood_opacity", "flood-opacity"),
        ("font_family", "font-family"),
        ("font_size", "font-size"),
        ("font_size_adjust", "font-size-adjust"),
        ("font_stretch", "font-stretch"),
        ("font_style", "font-style"),
        ("font_variant", "font-variant"),
        ("font_weight", "font-weight"),
        ("format", "format"),
        ("from", "from"),
        ("fr", "fr"),
        ("fx", "fx"),
        ("fy", "fy"),
        ("g1", "g1"),
        ("g2", "g2"),
        ("glyph_name", "glyph-name"),
        (
            "glyph_orientation_horizontal",
            "glyph-orientation-horizontal",
        ),
        ("glyph_orientation_vertical", "glyph-orientation-vertical"),
        ("glyph_ref", "glyphRef"),
        ("gradient_transform", "gradientTransform"),
        ("gradient_units", "gradientUnits"),
        ("hanging", "hanging"),
        ("height", "height"),
        ("href", "href"),
        ("hreflang", "hreflang"),
        ("horiz_adv_x", "horiz-adv-x"),
        ("horiz_origin_x", "horiz-origin-x"),
        ("id", "id"),
        ("ideographic", "ideographic"),
        ("image_rendering", "image-rendering"),
        ("in", "in"),
        ("in2", "in2"),
        ("intercept", "intercept"),
        ("k", "k"),
        ("k1", "k1"),
        ("k2", "k2"),
        ("k3", "k3"),
        ("k4", "k4"),
        ("kernel_matrix", "kernelMatrix"),
        ("kernel_unit_length", "kernelUnitLength"),
        ("kerning", "kerning"),
        ("key_points", "keyPoints"),
        ("key_splines", "keySplines"),
        ("key_times", "keyTimes"),
        ("lang", "lang"),
        ("length_adjust", "lengthAdjust"),
        ("letter_spacing", "letter-spacing"),
        ("lighting_color", "lighting-color"),
        ("limiting_cone_angle", "limitingConeAngle"),
        ("local", "local"),
        ("marker_end", "marker-end"),
        ("marker_mid", "marker-mid"),
        ("marker_start", "marker-start"),
        ("marker_height", "markerHeight"),
        ("marker_units", "markerUnits"),
        ("marker_width", "markerWidth"),
        ("mask", "mask"),
        ("mask_content_units", "maskContentUnits"),
        ("mask_units", "maskUnits"),
        ("mathematical", "mathematical"),
        ("max", "max"),
        ("media", "media"),
        ("method", "method"),
        ("min", "min"),
        ("mode", "mode"),
        ("name", "name"),
        ("num_octaves", "numOctaves"),
        ("offset", "offset"),
        ("opacity", "opacity"),
        ("operator", "operator"),
        ("order", "order"),
        ("orient", "orient"),
        ("orientation", "orientation"),
        ("origin", "origin"),
        ("overflow", "overflow"),
        ("overline_position", "overline-position"),
        ("overline_thickness", "overline-thickness"),
        ("panose_1", "panose-1"),
        ("paint_order", "paint-order"),
        ("path", "path"),
        ("path_length", "pathLength"),
        ("pattern_content_units", "patternContentUnits"),
        ("pattern_transform", "patternTransform"),
        ("pattern_units", "patternUnits"),
        ("ping", "ping"),
        ("pointer_events", "pointer-events"),
        ("points", "points"),
        ("points_at_x", "pointsAtX"),
        ("points_at_y", "pointsAtY"),
        ("points_at_z", "pointsAtZ"),
        ("preserve_alpha", "preserveAlpha"),
        ("preserve_aspect_ratio", "preserveAspectRatio"),
        ("primitive_units", "primitiveUnits"),
        ("r", "r"),
        ("radius", "radius"),
        ("referrer_policy", "referrerPolicy"),
        ("ref_x", "refX"),
        ("ref_y", "refY"),
        ("rel", "rel"),
        ("rendering_intent", "rendering-intent"),
        ("repeat_count", "repeatCount"),
        ("repeat_dur", "repeatDur"),
        ("required_extensions", "requiredExtensions"),
        ("required_features", "requiredFeatures"),
        ("restart", "restart"),
        ("result", "result"),
        ("rotate", "rotate"),
        ("rx", "rx"),
        ("ry", "ry"),
        ("scale", "scale"),
        ("seed", "seed"),
        ("shape_rendering", "shape-rendering"),
        ("slope", "slope"),
        ("spacing", "spacing"),
        ("specular_constant", "specularConstant"),
        ("specular_exponent", "specularExponent"),
        ("speed", "speed"),
        ("spread_method", "spreadMethod"),
        ("start_offset", "startOffset"),
        ("std_deviation", "stdDeviation"),
        ("stemh", "stemh"),
        ("stemv", "stemv"),
        ("stitch_tiles", "stitchTiles"),
        ("stop_color", "stop-color"),
        ("stop_opacity", "stop-opacity"),
        ("strikethrough_position", "strikethrough-position"),
        ("strikethrough_thickness", "strikethrough-thickness"),
        ("string", "string"),
        ("stroke", "stroke"),
        ("stroke_dasharray", "stroke-dasharray"),
        ("stroke_dashoffset", "stroke-dashoffset"),
        ("stroke_linecap", "stroke-linecap"),
        ("stroke_linejoin", "stroke-linejoin"),
        ("stroke_miterlimit", "stroke-miterlimit"),
        ("stroke_opacity", "stroke-opacity"),
        ("stroke_width", "stroke-width"),
        ("style", "style"),
        ("surface_scale", "surfaceScale"),
        ("system_language", "systemLanguage"),
        ("tabindex", "tabindex"),
        ("table_values", "tableValues"),
        ("target", "target"),
        ("target_x", "targetX"),
        ("target_y", "targetY"),
        ("text_anchor", "text-anchor"),
        ("text_decoration", "text-decoration"),
        ("text_rendering", "text-rendering"),
        ("text_length", "textLength"),
        ("to", "to"),
        ("transform", "transform"),
        ("transform_origin", "transform-origin"),
        ("type", "type"),
        ("u1", "u1"),
        ("u2", "u2"),
        ("underline_position", "underline-position"),
        ("underline_thickness", "underline-thickness"),
        ("unicode", "unicode"),
        ("unicode_bidi", "unicode-bidi"),
        ("unicode_range", "unicode-range"),
        ("units_per_em", "units-per-em"),
        ("v_alphabetic", "v-alphabetic"),
        ("v_hanging", "v-hanging"),
        ("v_ideographic", "v-ideographic"),
        ("v_mathematical", "v-mathematical"),
        ("values", "values"),
        ("vector_effect", "vector-effect"),
        ("version", "version"),
        ("vert_adv_y", "vert-adv-y"),
        ("vert_origin_x", "vert-origin-x"),
        ("vert_origin_y", "vert-origin-y"),
        ("view_box", "viewBox"),
        ("view_target", "viewTarget"),
        ("visibility", "visibility"),
        ("width", "width"),
        ("widths", "widths"),
        ("word_spacing", "word-spacing"),
        ("writing_mode", "writing-mode"),
        ("x", "x"),
        ("x_height", "x-height"),
        ("x1", "x1"),
        ("x2", "x2"),
        ("x_channel_selector", "xChannelSelector"),
        ("xlink_actuate", "xlink:actuate"),
        ("xlink_arcrole", "xlink:arcrole"),
        ("xlink_href", "xlink:href"),
        ("xlink_role", "xlink:role"),
        ("xlink_show", "xlink:show"),
        ("xlink_title", "xlink:title"),
        ("xlink_type", "xlink:type"),
        ("xml_base", "xml:base"),
        ("xml_lang", "xml:lang"),
        ("xml_space", "xml:space"),
        ("y", "y"),
        ("y1", "y1"),
        ("y2", "y2"),
        ("y_channel_selector", "yChannelSelector"),
        ("z", "z"),
        ("zoom_and_pan", "zoomAndPan"),
    ])
});
