# jsonpointer_flatten

Rust library to flatten a JSON object or array using JSON Pointer addressing as defined in [IETF RFC 6901](https://datatracker.ietf.org/doc/html/rfc6901).

## Usage

```rust
let value = json!(
    {
        "name": "John Smith",
        "age": 24,
        "address": {
            "country": "US",
            "zip": "00000"
        },
        "phones": [ "123", "456" ]
    }
);

let actual = jsonpointer_flatten::from_value(&value).unwrap();
```

Outputs
```json
{
  "": {},
  "/address": {},
  "/address/country": "US",
  "/address/zip": "00000",
  "/age": 24,
  "/name": "John Smith",
  "/phones": [],
  "/phones/0": "123",
  "/phones/1": "456"
}
```