# JSON-NLP

(C) 2021 by [Semiring Inc.], [Damir Cavar]

This is a [Rust] implementation of [JSON-NLP], a data structure for Natural Language Processing and Semantic analysis of text or speech.



## Introduction

This repository provides the [Rust] library *jsonnlp* for reading and writing [JSON-NLP] Schema conform data. [JSON-NLP] encodes outputs from Natural Language Processing (NLP) pipelines, functioning as a middleware to common NLP pipelines and components.

[JSON-NLP] wrappers for the output formats from various NLP pipelines are available:

- [Flair](https://github.com/flairNLP/flair) and [Flair-JSON-NLP](https://github.com/dcavar/Flair-JSON-NLP)
- [NLTK](http://nltk.org/) and [NLTK-JSON-NLP](https://github.com/dcavar/NLTK-JSON-NLP)
- [Polyglot](https://github.com/aboSamoor/polyglot) and [Polyglot-JSON-NLP](https://github.com/dcavar/Polyglot-JSON-NLP)
- [spaCy](https://spacy.io/) and [spaCy-JSON-NLP](https://github.com/dcavar/spaCy-JSON-NLP)
- [Xrenner](https://github.com/amir-zeldes/xrenner) and [Xrenner-JSON-NLP](https://github.com/dcavar/Xrenner-JSON-NLP)
- [Stanford CoreNLP](https://stanfordnlp.github.io/CoreNLP/)
- [OpenNLP](https://opennlp.apache.org/)

Many other wrappers and modules likely exist or will be made available.

[JSON-NLP] processing and validation modules exist for other languages as well, as for example:

- Java: [J-JSON-NLP](https://github.com/dcavar/J-JSON-NLP)
- Python: [Py-JSON-NLP](https://github.com/dcavar/Py-JSON-NLP)
- Go or Golang: [GoJSONNLP](https://github.com/SemiringInc/GoJSONNLP)


## Installation

more soon...


## Visualization of JSON-NLP

There is a visualizer for [JSON-NLP] available here: [https://semiringinc.github.io/JSON-NLP-Viz/](https://semiringinc.github.io/JSON-NLP-Viz/)


## License

Licensed under:

    Apache License, Version 2.0, (LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0)



[Semiring Inc.]: https://semiring.com/ "Semiring Inc."
[Damir Cavar]: http://damir.cavar.me/ "Damir Cavar"
[JSON-NLP]: https://github.com/SemiringInc/JSON-NLP "JSON-NLP"
[Go]: https://golang.org/ "Golang"
[Rust]: https://www.rust-lang.org/ "Rust"
