const BASE_URL: &str = "http://localhost:8080";

fn watch_pod_logs(pod_name: &String) {
    let api_resp = reqwest::blocking::get(format!("{}/api/v1/namespaces/mortgage/pods", BASE_URL))
        .expect("GET failed")
        .text()
        .expect("Failed retrieve response body.");

    let json: Value = serde_json::from_str(&api_resp).expect("failed to parse body");
    let pretty = serde_json::to_string_pretty(&json).unwrap();
    println!("{}", pretty);
}
