# json-log-parse
CLI tool for tailing logs from deployments using JSON log format.

## Installing
This is implemented in Rust and published as binary crate on [crates.io](crates.io)

First, install rust if you don't already have it:
```shell
curl --proto '=https' --tlsv1.2 -sSf https://sh.rustup.rs | sh
```

Then, install the tool:
```shell
cargo install json-log-parse
```

You will also need `stern` installed:
```shell
brew install stern
```

## Usage
Example, using service-mortgage and leveraging stern for a standalone command:
```shell
json-log-parse stern -a service-mortgage -s 5m
```

Example, using stdin:
```shell
echo -n '{"timestamp": "1", "logger.thread_name": "thread1", "logger.name": "name1", "level": "INFO", "message": "log message 1"}' | json-log-parse stdin
```

To get help:
```shell
json-log-parse --help
```
