
#![doc = include_str!("../README.md")]

// AUTO-GENERATED LIB FILE - DON'T MODIFY

extern crate proc_macro;

use proc_macro::{LexError, TokenStream};
use std::process::Command;
use proc_macro_error::*;

fn run_node_macro(
    macro_input: TokenStream,
    macro_args: Option<TokenStream>,
    node_script_path: &str,
) -> Result<TokenStream, LexError> {
    let output = Command::new("node")
        .arg("-e")
        .arg(format!(
            r"
                MACRO_INPUT = {:?};
                MACRO_ARGUMENTS = {:?};
                MACRO_OUTPUT = '';
                require({:?});
                console.log('MACRO_OUTPUT: ' + MACRO_OUTPUT);
            ",
            macro_input.to_string(),
            macro_args.map(|a| a.to_string()).unwrap_or_default(),
            node_script_path
        ))
        .output()
        .unwrap_or_else(|e| {
            if let std::io::ErrorKind::NotFound = e.kind() {
                panic!("No `node` command found in PATH");
            }

            panic!("IO Error running JS macro: {}", e)
        });

    if !output.status.success() {
        emit_call_site_error!(format!("Error occurred running JS macro:\n{}\n", String::from_utf8_lossy(&output.stderr)));
        return Ok(Default::default());
    }

    let macro_output = std::str::from_utf8(&output.stdout)
        .expect("JS Macro had unexpected non-utf8 output")
        .split("MACRO_OUTPUT: ")
        .nth(1)
        .expect("JS Macro unexpectedly missing macro output");

    macro_output.parse()
}
#[proc_macro_error]
                #[proc_macro_derive(SayHello, attributes(hello_message))]
                #[allow(non_snake_case)] #[doc(hidden)]
                pub fn SayHello(input: TokenStream) -> TokenStream {
                    run_node_macro(input, None, "/Users/agrant/w/js-macros/target/debug/build/js-macros-b6529c7221092006/out/custom_derive.js").unwrap()
                }#[proc_macro_error]
                #[proc_macro]
                #[allow(non_snake_case)] #[doc(hidden)]
                pub fn hello_world(input: TokenStream) -> TokenStream {
                    run_node_macro(input, None, "/Users/agrant/w/js-macros/target/debug/build/js-macros-b6529c7221092006/out/custom_function.js").unwrap()
                }#[proc_macro_error]
                #[proc_macro_attribute]
                #[allow(non_snake_case)] #[doc(hidden)]
                pub fn say_hello(args: TokenStream, input: TokenStream) -> TokenStream {
                    run_node_macro(input, Some(args), "/Users/agrant/w/js-macros/target/debug/build/js-macros-b6529c7221092006/out/custom_attribute.js").unwrap()
                }