use crate::node_type::NodeType;

#[derive(Debug)]
pub struct Node {
    pub node_type: NodeType,
    pub value: Option<String>,
    pub children: Option<Vec<Node>>
}

impl Node {
    pub fn new(node_type: NodeType, children: Option<Vec<Node>>, value: Option<String>) -> Self {
        Self {
            node_type: node_type,
            children: children,
            value: value
        }
    }
}