use std::error::Error;
use std::fmt;

#[derive(Debug)]
pub struct ParserError {
    message: String
}

impl ParserError {
    pub fn new(details: &str) -> Self {
        Self {
            message: details.to_string()
        }
    }
}

impl fmt::Display for ParserError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{}", self.message)
    }
}

impl Error for ParserError {
    fn description(&self) -> &str {
        &self.message
    }
}
