# JQ Lang [![Rust](https://github.com/schultyy/jq_lang/actions/workflows/rust.yml/badge.svg)](https://github.com/schultyy/jq_lang/actions/workflows/rust.yml)

Implements the [jq](https://stedolan.github.io/jq/) syntax in Rust, providing an abstract syntax tree.

## Language

### Identity

The simplest filter is `.`. It consumes JSON and produces the same output, unchanged.

`.` produces the following AST:

```
    Program
        |
        |
    Identity
```

## Usage

Use it like this in your program:

```rust
use jq_lang::to_ast;
use jq_lang::node_type::NodeType;

let ast = to_ast(".").unwrap();
assert_eq!(ast.node_type, NodeType::Program);
```

## License

MIT