# Changelog
All notable changes to this project will be documented in this file.

## [0.6.0] - 2021-10-13

### Bug Fixes

- :art: New way to integrate `image` crate
- :green_heart: Fix CI
- :rotating_light: Fix clippy
- :bug: Fix potential use-after-free
- :bug: Fix #9
- :green_heart: Fix memory leaks

### Documentation

- :memo: Update docs

### Features

- :sparkles: Automatically figure out pixel types
- :sparkles: Add luma only color encoding
- :arrow_up: Upgrade `libjxl` to v0.6
- Remove size requirement for JPEG data

### Refactor

- :art: Remove `unwrap()`s
- :white_check_mark: Increase code coverage
- :white_check_mark: Continue improve code coverage
- :white_check_mark: Continue improve code coverage
- :art: Use `derive_builder`
- :art: Memory manager API consistency
- :art: Remove unused setters
- :art: Remove Cell

## [0.3.7] - 2021-04-13

### Refactor

- :memo: Update docs

### Build

- :arrow_up: Bump to v0.3.7

### Ci

- :construction_worker: Add code coverage

## [0.3.5] - 2021-03-25

### Features

- :sparkles: Check signature first

### Refactor

- :art: Use manually generated C bindings
- :art: Refactor to expose more functionalites
- :art: Break up decode

### Security

- :construction_worker: Add security audit

### Build

- :arrow_up: Upgrade to v0.3.5

## [0.3.3] - 2021-03-13

### Features

- :sparkles: Output icc profile
- :sparkles: Store JPEG reconstuction metadata

### Refactor

- :art: Rename feature `without-build` to `system-jpegxl`

### Build

- :arrow_up: Bump libjxl version

## [0.3.2] - 2021-02-16

### Features

- :sparkles: Add color encoding option

### Refactor

- :art: Mask names from `jpegxl-sys` crate

<!-- generated by git-cliff -->
