use nalgebra as na;
use nom::{
    combinator::map,
    number::streaming::{le_i16, le_u8},
    sequence::tuple,
    IResult,
};

pub fn parse_i16_vec3(input: &[u8]) -> IResult<&[u8], na::Vector3<i16>> {
    map(tuple((le_i16, le_i16, le_i16)), |(x, y, z)| {
        na::Vector3::<i16>::new(x, y, z)
    })(input)
}

pub fn parse_stick_data(input: &[u8]) -> IResult<&[u8], (u16, u16)> {
    map(tuple((le_u8, le_u8, le_u8)), |(v0, v1, v2)| {
        let x = u16::from(v0) | ((u16::from(v1) & 0x0F) << 8);
        let y = (u16::from(v1) >> 4) | (u16::from(v2) << 4);
        (x, y)
    })(input)
}

pub fn parse_stick_data_var(input: &[u8]) -> IResult<&[u8], (u16, u16)> {
    if input.len() >= 4 {
        let (input, (v0, v1, v2, v3)) = tuple((le_u8, le_u8, le_u8, le_u8))(input)?;
        let x = u16::from_le_bytes([v0, v1]);
        let y = u16::from_le_bytes([v2, v3]);
        Ok((input, (x, y)))
    } else {
        parse_stick_data(input)
    }
}
