use hidapi::HidError;
use thiserror::Error;

#[derive(Error, Debug)]
pub enum JoyConDriverError {
    #[error("hid error: {0}")]
    HidError(HidError),
    #[error("invalid vendor id {0}")]
    InvalidVendorId(u16),
    #[error("invalid product id {0}")]
    InvalidProductId(u16),
    #[error("buf is too small, size: {0}")]
    BufferIsTooSmall(usize),
    #[error("buf is too large, size: {0}")]
    BufferIsTooLarge(usize),
    #[error("invalid buffer result")]
    InvalidResultBuffer,
    #[error("not supported report id: {0}")]
    NotSupportedReportId(u8),
    #[error("")]
    SubCommandFailed,
}

impl From<HidError> for JoyConDriverError {
    fn from(error: HidError) -> Self {
        Self::HidError(error)
    }
}

pub type JoyConDriverResult<T> = Result<T, JoyConDriverError>;
