use enumflags2::{bitflags, BitFlags};

#[bitflags]
#[repr(u16)]
#[derive(Debug, Clone, Copy)]
#[allow(non_camel_case_types)]
#[rustfmt::skip]
pub enum SimpleButton {
    Down       = 0b0000_0000_0000_0001,
    Right      = 0b0000_0000_0000_0010,
    Left       = 0b0000_0000_0000_0100,
    Up         = 0b0000_0000_0000_1000,
    SL         = 0b0000_0000_0001_0000,
    SR         = 0b0000_0000_0010_0000,
    Unknown1   = 0b0000_0000_0100_0000,
    Unknown2   = 0b0000_0000_1000_0000,
    Minus      = 0b0000_0001_0000_0000,
    Plus       = 0b0000_0010_0000_0000,
    LeftStick  = 0b0000_0100_0000_0000,
    RightStick = 0b0000_1000_0000_0000,
    Home       = 0b0001_0000_0000_0000,
    Capture    = 0b0010_0000_0000_0000,
    L_OR_R     = 0b0100_0000_0000_0000,
    ZL_OR_ZR   = 0b1000_0000_0000_0000,
}

pub type SimpleButtons = BitFlags<SimpleButton>;

#[bitflags]
#[repr(u8)]
#[derive(Debug, Clone, Copy)]
#[rustfmt::skip]
pub enum RightButton {
    Y  = 0b0000_0001,
    X  = 0b0000_0010,
    B  = 0b0000_0100,
    A  = 0b0000_1000,
    SR = 0b0001_0000,
    SL = 0b0010_0000,
    R  = 0b0100_0000,
    ZR = 0b1000_0000,
}

pub type RightButtons = BitFlags<RightButton>;

#[bitflags]
#[repr(u8)]
#[derive(Debug, Clone, Copy)]
#[rustfmt::skip]
pub enum SharedButton {
    Minus        = 0b0000_0001,
    Plus         = 0b0000_0010,
    RStick       = 0b0000_0100,
    LStick       = 0b0000_1000,
    Home         = 0b0001_0000,
    Capture      = 0b0010_0000,
    Unknown      = 0b0100_0000,
    ChargingGrip = 0b1000_0000,
}

pub type SharedButtons = BitFlags<SharedButton>;

#[bitflags]
#[repr(u8)]
#[derive(Debug, Clone, Copy)]
#[rustfmt::skip]
pub enum LeftButton {
    Down  = 0b0000_0001,
    Up    = 0b0000_0010,
    Right = 0b0000_0100,
    Left  = 0b0000_1000,
    SR    = 0b0001_0000,
    SL    = 0b0010_0000,
    L     = 0b0100_0000,
    ZL    = 0b1000_0000,
}

pub type LeftButtons = BitFlags<LeftButton>;
