use anyhow::Result;
use joycon_driver::{prelude::*, report::InputReport};

fn main() -> Result<()> {
    let api = HidApi::new()?;
    let devices = JoyConDevice::list_devices(&api)?;

    if let Some(device) = devices.get(0) {
        let calib_data = device.read_calibration_data()?;
        device.set_input_report_mode(InputReportMode::StandardFullMode)?;
        device.imu_feature(true)?;

        println!("{:?}", calib_data.imu_factory_calib);

        while let InputReport::StandardFull(report) = device.input_report()? {
            println!("-----");
            println!("{:?}", report.imu_raw.to_data());
            println!(
                "{:?}",
                report
                    .imu_raw
                    .to_data_with_calib(&calib_data.imu_factory_calib)
            );
        }
    } else {
        println!("Devices are not found")
    }

    Ok(())
}
