use anyhow;
use anyhow::Context;
use jotty;
use jotty::{JobDef, JobType, TaskDef};
use std::collections::HashMap;
use std::env;
use std::sync::Arc;
use std::time::Duration;
use zookeeper;

struct NoopWatcher;

impl zookeeper::Watcher for NoopWatcher {
    fn handle(&self, _ev: zookeeper::WatchedEvent) {}
}

fn zk_server_urls() -> String {
    let key = "ZOOKEEPER_SERVERS";
    match env::var(key) {
        Ok(val) => val,
        Err(_) => "gpn1.lab.volf.co:2181".to_string(),
    }
}

fn main() -> anyhow::Result<()> {
    env_logger::init();
    let zk_urls = zk_server_urls();
    let zk =
        zookeeper::ZooKeeper::connect(&*zk_urls, Duration::from_millis(2500), NoopWatcher).unwrap();
    let zka = Arc::new(zk);

    let jotty = jotty::Builder::new("co.volf.jotty.testing".to_string())
        .executor(false)
        .channels(12)
        .build(zka)
        .context("yp yp")?;

    let job = JobDef {
        name: Some("my-job".to_string()),
        tree: JobType::Branch(
            Box::new(JobType::Single(TaskDef {
                method: "echo".to_string(),
                arguments: serde_json::from_str("{\"string\": \"Hello World\"}")?,
                resources: Default::default(),
                policy: None,
            })),
            Some(Box::new(JobType::Single(TaskDef {
                method: "echo".to_string(),
                arguments: serde_json::from_str("{\"string\": \"I'm on Success!\"}")?,
                resources: Default::default(),
                policy: None,
            }))),
            Some(Box::new(JobType::Single(TaskDef {
                method: "echo".to_string(),
                arguments: serde_json::from_str("{\"string\": \"I'm on Failure :(\"}")?,
                resources: Default::default(),
                policy: None,
            }))),
        ),
        policy: None,
        constraints: None,
    };

    jotty.client.add_job(job)?;

    Ok(())
    //
}
