use anyhow;
use anyhow::Context;
use jotty;
use std::collections::HashMap;
use std::env;
use std::sync::Arc;
use std::time::Duration;
use zookeeper;

struct NoopWatcher;

impl zookeeper::Watcher for NoopWatcher {
    fn handle(&self, _ev: zookeeper::WatchedEvent) {}
}

fn zk_server_urls() -> String {
    let key = "ZOOKEEPER_SERVERS";
    match env::var(key) {
        Ok(val) => val,
        Err(_) => "localhost:2181".to_string(),
    }
}

fn main() -> anyhow::Result<()> {
    env_logger::init();
    let zk_urls = zk_server_urls();
    let zk =
        zookeeper::ZooKeeper::connect(&*zk_urls, Duration::from_millis(2500), NoopWatcher).unwrap();
    let zka = Arc::new(zk);

    let jotty = jotty::Builder::new("co.volf.jotty.testing".to_string())
        .executor(true)
        .channels(12)
        .build(zka)
        .context("yp yp")?;

    jotty.client.add_task(
        "echo",
        serde_json::from_str("{\"string\": \"Hello World\"}")?,
        HashMap::new(),
    )?;

    Ok(())
    //
}
