use phf::phf_map;

pub const DEFAULT_DIR: &str = "";
pub const DEFAULT_FILE: &str = "";

// all those glyphs will show as weird squares if you don't have the correct patched font
// My advice is to use NerdFonts which can be found here:
// https://github.com/ryanoasis/nerd-fonts
pub static FILE_NODE_EXTENSIONS: phf::Map<&'static str, &'static str> = phf_map! {
    "7z"       => "",
    "a"        => "",
    "ai"       => "",
    "apk"      => "",
    "asm"      => "",
    "asp"      => "",
    "aup"      => "",
    "avi"      => "",
    "awk"      => "",
    "bash"     => "",
    "bat"      => "",
    "bmp"      => "",
    "bz2"      => "",
    "c"        => "",
    "c++"      => "",
    "cab"      => "",
    "cbr"      => "",
    "cbz"      => "",
    "cc"       => "",
    "class"    => "",
    "clj"      => "",
    "cljc"     => "",
    "cljs"     => "",
    "cmake"    => "",
    "coffee"   => "",
    "conf"     => "",
    "cp"       => "",
    "cpio"     => "",
    "cpp"      => "",
    "cs"       => "",
    "csh"      => "",
    "css"      => "",
    "cue"      => "",
    "cvs"      => "",
    "cxx"      => "",
    "d"        => "",
    "dart"     => "",
    "db"       => "",
    "deb"      => "",
    "diff"     => "",
    "dll"      => "",
    "doc"      => "",
    "docx"     => "",
    "dump"     => "",
    "edn"      => "",
    "eex"      => "",
    "efi"      => "",
    "ejs"      => "",
    "elf"      => "",
    "elm"      => "",
    "epub"     => "",
    "erl"      => "",
    "ex"       => "",
    "exe"      => "",
    "exs"      => "",
    "f//"       => "",
    "fifo"     => "|",
    "fish"     => "",
    "flac"     => "",
    "flv"      => "",
    "fs"       => "",
    "fsi"      => "",
    "fsscript" => "",
    "fsx"      => "",
    "gem"      => "",
    "gemspec"  => "",
    "gif"      => "",
    "go"       => "",
    "gz"       => "",
    "gzip"     => "",
    "h"        => "",
    "haml"     => "",
    "hbs"      => "",
    "hh"       => "",
    "hpp"      => "",
    "hrl"      => "",
    "hs"       => "",
    "htaccess" => "",
    "htm"      => "",
    "html"     => "",
    "htpasswd" => "",
    "hxx"      => "",
    "ico"      => "",
    "img"      => "",
    "ini"      => "",
    "iso"      => "",
    "jar"      => "",
    "java"     => "",
    "jl"       => "",
    "jpeg"     => "",
    "jpg"      => "",
    "js"       => "",
    "json"     => "",
    "jsx"      => "",
    "key"      => "",
    "ksh"      => "",
    "leex"     => "",
    "less"     => "",
    "lha"      => "",
    "lhs"      => "",
    "log"      => "",
    "lua"      => "",
    "lzh"      => "",
    "lzma"     => "",
    "m4a"      => "",
    "m4v"      => "",
    "markdown" => "",
    "md"       => "",
    "mdx"      => "",
    "mjs"      => "",
    "mkv"      => "",
    "ml"       => "λ",
    "mli"      => "λ",
    "mov"      => "",
    "mp3"      => "",
    "mp4"      => "",
    "mpeg"     => "",
    "mpg"      => "",
    "msi"      => "",
    "mustache" => "",
    "nix"      => "",
    "o"        => "",
    "ogg"      => "",
    "pdf"      => "",
    "php"      => "",
    "pl"       => "",
    "pm"       => "",
    "png"      => "",
    "pp"       => "",
    "ppt"      => "",
    "pptx"     => "",
    "ps1"      => "",
    "psb"      => "",
    "psd"      => "",
    "pub"      => "",
    "py"       => "",
    "pyc"      => "",
    "pyd"      => "",
    "pyo"      => "",
    "r"        => "ﳒ",
    "rake"     => "",
    "rar"      => "",
    "rb"       => "",
    "rc"       => "",
    "rlib"     => "",
    "rmd"      => "",
    "rom"      => "",
    "rpm"      => "",
    "rproj"    => "鉶",
    "rs"       => "",
    "rss"      => "",
    "rtf"      => "",
    "s"        => "",
    "sass"     => "",
    "scala"    => "",
    "scss"     => "",
    "sh"       => "",
    "slim"     => "",
    "sln"      => "",
    "so"       => "",
    "sql"      => "",
    "styl"     => "",
    "suo"      => "",
    "swift"    => "",
    "t"        => "",
    "tar"      => "",
    "tex"      => "ﭨ",
    "tgz"      => "",
    "toml"     => "",
    "ts"       => "",
    "tsx"      => "",
    "twig"     => "",
    "vim"      => "",
    "vimrc"    => "",
    "vue"      => "﵂",
    "wav"      => "",
    "webm"     => "",
    "webmanifest" => "",
    "webp"     => "",
    "xbps"     => "",
    "xcplayground" => "",
    "xhtml"    => "",
    "xls"      => "",
    "xlsx"     => "",
    "xml"      => "",
    "xul"      => "",
    "xz"       => "",
    "yaml"     => "",
    "yml"      => "",
    "zip"      => "",
    "zsh"      => "",
};

pub static DIR_NODE_EXACT_MATCHES: phf::Map<&'static str, &'static str> = phf_map! {
// English
    ".git"                             => "",
    "Desktop"                          => "",
    "Documents"                        => "",
    "Downloads"                        => "",
    "Dotfiles"                         => "",
    "Dropbox"                          => "",
    "Music"                            => "",
    "Pictures"                         => "",
    "Public"                           => "",
    "Templates"                        => "",
    "Videos"                           => "",
// Spanish
    "Escritorio"                       => "",
    "Documentos"                       => "",
    "Descargas"                        => "",
    "Música"                           => "",
    "Imágenes"                         => "",
    "Público"                          => "",
    "Plantillas"                       => "",
    // "Vídeos"                           => "",
// French
    "Bureau"                           => "",
    "Images"                           => "",
    "Musique"                          => "",
    "Publique"                         => "",
    "Téléchargements"                  => "",
    "Vidéos"                           => "",
// Portuguese
    "Imagens"                          => "",
    "Modelos"                          => "",
    "Vídeos"                           => "",
    "Área de trabalho"                 => "",
// Italian
    "Documenti"                        => "",
    "Immagini"                         => "",
    "Modelli"                          => "",
    "Musica"                           => "",
    "Pubblici"                         => "",
    "Scaricati"                        => "",
    "Scrivania"                        => "",
    "Video"                            => "",
// German
    "Bilder"                           => "",
    "Dokumente"                        => "",
    "Musik"                            => "",
    "Schreibtisch"                     => "",
    "Vorlagen"                         => "",
    "Öffentlich"                       => "",
// Hungarian
    "Dokumentumok"                     => "",
    "Képek"                            => "",
    "Zene"                             => "",
    "Letöltések"                       => "",
    "Számítógép"                       => "",
    "Videók"                           => "",
};

pub static FILE_NODE_EXACT_MATCHES: phf::Map<&'static str, &'static str> = phf_map! {
    ".bash_aliases"                    => "",
    ".bash_history"                    => "",
    ".bash_logout"                     => "",
    ".bash_profile"                    => "",
    ".bashprofile"                     => "",
    ".bashrc"                          => "",
    ".dmrc"                            => "",
    ".DS_Store"                        => "",
    ".fasd"                            => "",
    ".fehbg"                           => "",
    ".gitattributes"                   => "",
    ".gitconfig"                       => "",
    ".gitignore"                       => "",
    ".gitlab-ci.yml"                   => "",
    ".gvimrc"                          => "",
    ".inputrc"                         => "",
    ".jack-settings"                   => "",
    ".mime.types"                      => "",
    ".ncmpcpp"                         => "",
    ".nvidia-settings-rc"              => "",
    ".pam_environment"                 => "",
    ".profile"                         => "",
    ".recently-used"                   => "",
    ".selected_editor"                 => "",
    ".vim"                             => "",
    ".viminfo"                         => "",
    ".vimrc"                           => "",
    ".Xauthority"                      => "",
    ".Xdefaults"                       => "",
    ".xinitrc"                         => "",
    ".xinputrc"                        => "",
    ".Xresources"                      => "",
    ".zshrc"                           => "",
    "_gvimrc"                          => "",
    "_vimrc"                           => "",
    "a.out"                            => "",
    "authorized_keys"                  => "",
    "bspwmrc"                          => "",
    "cmakelists.txt"                   => "",
    "config"                           => "",
    "config.ac"                        => "",
    "config.m4"                        => "",
    "config.mk"                        => "",
    "config.ru"                        => "",
    "configure"                        => "",
    "docker-compose.yml"               => "",
    "dockerfile"                       => "",
    "Dockerfile"                       => "",
    "dropbox"                          => "",
    "exact-match-case-sensitive-1.txt" => "X1",
    "exact-match-case-sensitive-2"     => "X2",
    "favicon.ico"                      => "",
    "gemfile"                          => "",
    "gruntfile.coffee"                 => "",
    "gruntfile.js"                     => "",
    "gruntfile.ls"                     => "",
    "gulpfile.coffee"                  => "",
    "gulpfile.js"                      => "",
    "gulpfile.ls"                      => "",
    "ini"                              => "",
    "known_hosts"                      => "",
    "ledger"                           => "",
    "license"                          => "",
    "LICENSE"                          => "",
    "LICENSE.md"                       => "",
    "LICENSE.txt"                      => "",
    "Makefile"                         => "",
    "makefile"                         => "",
    "Makefile.ac"                      => "",
    "Makefile.in"                      => "",
    "mimeapps.list"                    => "",
    "mix.lock"                         => "",
    "node_modules"                     => "",
    "package-lock.json"                => "",
    "package.json"                     => "",
    "playlists"                        => "",
    "procfile"                         => "",
    "Rakefile"                         => "",
    "rakefile"                         => "",
    "react.jsx"                        => "",
    "README"                           => "",
    "README.markdown"                  => "",
    "README.md"                        => "",
    "README.rst"                       => "",
    "README.txt"                       => "",
    "sxhkdrc"                          => "",
    "user-dirs.dirs"                   => "",
    "webpack.config.js"                => "",
};
