use clap::App;
use log::{LevelFilter, debug};
use std::{path::PathBuf, str::FromStr};

pub fn create_app() -> String {
    let yml = clap::load_yaml!("app.yml");
    let m = App::from_yaml(yml).get_matches();
    let termlog = LevelFilter::from_str(m.value_of("termlog").unwrap_or("info")).unwrap();
    let filelog = LevelFilter::from_str(m.value_of("filelog").unwrap_or("debug")).unwrap();
    let logfile = PathBuf::from_str(m.value_of("logfile").unwrap_or("jokolink.log")).unwrap();
    debug!("the terminal log level: {:?}, the file log lvl: {:?}, the logfile name: {:?}", termlog, filelog, &logfile);
    crate::log_init(termlog, filelog, logfile).unwrap();
    debug!("created app and initialized logging");
    let key = m.value_of("mumble").unwrap_or("MumbleLink").to_string();
    debug!("the mumble link name: {}", &key);
    key
}
