# jokolink
A crate to extract info from Guild Wars 2 MumbleLink and also allow to copy it to /dev/shm in linux

it will also get the x11 window id of the gw2 window and paste it at the end of the mumblelink data in /dev/shm. the format is simply 1193 bytes of useful mumblelink data AND an isize (for xid). will sleep for 10 ms every frame, so will copy upto 100 times per second. we can unlock it if necessary in future and expose it as a command line option.

supports the following options in commandline arguments:
    * termlog:
        short: t
        help: max logging level to terminal stdout/stderr
        possible_values: [error, warn, info, debug, trace]
        takes_value: true
    
    * filelog:
        short: l
        help: max logging level to logfile
        possible_values: [error, warn, info, debug, trace]
        takes_value: true
    
    * logfile:
        short: f
        help: the filepath to logfile.
        takes_value: true
    * mumble:
        short: m
        help: the mumble link name that gw2 uses
        takes_value: true

sample script provided as `run_jokolink.sh`

```
#!/bin/bash

# copy this script and jokolink.exe into the prefix folder of gw2. and set it as the prelaunch script for gw2 in lutris

# variables used as options for jokolink

# the mumble link name
link_name=MumbleLink
# the log level of jokolink for terminal
jl_tlog=debug
# the log lvl of jokolink for file
jl_flog=debug
# the filename where jokolink dumps its logs to.
jl_logfile=jokolink.log
# this command will use $WINE from lutris and use the above options to run jokolink in bg
$WINE "./jokolink.exe" -t $jl_tlog -l $jl_flog -m $link_name -f $jl_logfile &
```
## Instructions:
1. right click Guild Wars 2 in Lutris, and click on Browse Files to open the prefix folder. 
2. Copy `jokolink.exe` and `run_jokolink.sh` to that folder. you can change the variables as you need in the script. 
3. right click Guild Wars 2 in Lutris again, and click on configure. make sure `Show Advanced Options` is checked at the bottom of the window.
4. go to System options tab, go down until you find the `Pre-launch script`, click on browse and select the `run_jokolink.sh` file that we pasted in prefix folder.
5. start Guild Wars 2 and you should see a `/dev/shm/{link_name}` file with link_name replaced by the mumble link name (usually "MumbleLink" if you didn't change the variables).
6. if you can't find any such file, it means jokolink probably failed to start, you can go check the prefix folder for a `jokolink.log` (unless you changed the variable) file.
7. raise an issue along with that log.

## Quirks:
the Jokolink.exe will keep on running in the background until gw2 is closed or crashed. then, all the prelaunch scripts and their child process will be killed by lutris with SIGTERM signal. 