use std::time::{Duration, Instant};
use std::{io::Write, path::PathBuf};
// use std::io::BufWriter;
use jokolink::mlink::{CMumbleLink, USEFUL_C_MUMBLE_LINK_SIZE};
use std::io::{Seek, SeekFrom};
#[cfg(target_os = "windows")]
fn main() {
    use jokolink::win::{create_link_shared_mem, get_xid};
    use log::trace;
    // get all the cmd line args and initialize logs.
    let mumble_link_key = jokolink::cli::create_app();
    let key: &str = &mumble_link_key;

    // create shared memory using the mumble link key
    let link = create_link_shared_mem(key);
    log::trace!("created shared memory {:?}", link);

    // check that we created shared memory successfully or panic. get ptr to shared memory
    let link_ptr = link.unwrap();

    // create a shared memory file in /dev/shm/mumble_link_key_name so that jokolay can mumble stuff from there.
    let shmpath: PathBuf = ["z:\\", "dev", "shm", key].iter().collect();
    trace!("{:?}", &shmpath);

    let shm = std::fs::File::create(&shmpath);
    log::trace!("{:?}", &shm);
    let mut shm = shm.unwrap();

    // buffer to hold mumble link and xid of gw2 window data.
    let mut buffer = [0u8; USEFUL_C_MUMBLE_LINK_SIZE + std::mem::size_of::<isize>()];

    // use a timer to check how long has it been since last timer reset
    let mut timer = Instant::now();

    loop {
        // copy the bytes from mumble link into shared memory file
        CMumbleLink::copy_raw_bytes_into(link_ptr, &mut buffer[..USEFUL_C_MUMBLE_LINK_SIZE]);
        // we sleep for 10 milliseconds to avoid reading mumblelink too many times. we will read it around 100 times per second
        std::thread::sleep(std::time::Duration::from_millis(10));

        // every 5 seconds
        if timer.elapsed() > Duration::from_secs(5) {
            // reset the timer
            timer = Instant::now();
            // check if mumble is initialized
            if CMumbleLink::is_valid(link_ptr) {
                // then get the window id of the gw2 window and write it to the buffer
                let xid = get_xid(link_ptr)
                    .map_err(|e| {
                        log::error!("could not get xid. error: {:?}", &e);
                        e
                    })
                    .unwrap();
                buffer[USEFUL_C_MUMBLE_LINK_SIZE..].copy_from_slice(&xid.to_ne_bytes());

                trace!("xid of gw2 window: {}", xid);
            } else {
                log::debug!("the MumbleLink is not init yet. ");
            }
        }

        // write buffer to the file
        shm.write(&buffer).unwrap();
        // seek back so that we will write to file again from start
        shm.seek(SeekFrom::Start(0)).unwrap();
    }
}
