# jokolink
A crate to extract info from Guild Wars 2 MumbleLink and also allow to copy it to /dev/shm in linux

it will also get the x11 window id of the gw2 window and paste it at the end of the mumblelink data in /dev/shm. the format is simply 1193 bytes of useful mumblelink data AND an isize (for xid). will sleep for 10 ms every frame, so will copy upto 100 times per second. we can unlock it if necessary in future and expose it as a command line option.

supports the following options in commandline arguments:
    * termlog:
        short: t
        help: max logging level to terminal stdout/stderr
        possible_values: [error, warn, info, debug, trace]
        takes_value: true
    
    * filelog:
        short: l
        help: max logging level to logfile
        possible_values: [error, warn, info, debug, trace]
        takes_value: true
    
    * logfile:
        short: f
        help: the filepath to logfile.
        takes_value: true
    * mumble:
        short: m
        help: the mumble link name that gw2 uses
        takes_value: true

sample script provided as `run_jokolink.sh`

```
#!/bin/bash

# A sample script derived from lutris using "lutris guild-wars-2 --output-script script_name.sh" and removing extra content.

# Environment variables
# wine prefix path of guild wars 2 game. this is the folder that contains drive_c and other wine stuff
export WINEPREFIX="/home/$USER/game/guild-wars-2"
export WINEFSYNC="1"
# the runner used to run gw2. if prefix/fsync/runner don't match, jokolink will just crash.
export WINE="/home/$USER/.local/share/lutris/runners/wine/lutris-gw2-6.14-3-x86_64/bin/wine"
# Command
$WINE 'jokolink.exe' -t trace -l trace -m MumbleLink -f jokolink.log
```
