use std::time::{Duration, Instant};
use std::{io::Write, path::PathBuf};
// use std::io::BufWriter;
use jokolink::mlink::{CMumbleLink, USEFUL_C_MUMBLE_LINK_SIZE};
use std::io::{Seek, SeekFrom};
#[cfg(target_os = "windows")]
fn main() {
    use jokolink::win::{create_link_shared_mem, get_win_pos_dim};
    use log::trace;

    jokolink::cli::create_app();
    trace!("starting udp sync server");
    let key = "MumbleLink";
    let link = create_link_shared_mem(key);
    log::trace!("created shared memory {:?}", link);
    let link_ptr = link.unwrap();
    let shmpath: PathBuf = ["z:\\", "dev", "shm", key].iter().collect();
    trace!("{:?}", &shmpath);
    let shm = std::fs::File::create(&shmpath);
    log::trace!("{:?}", &shm);
    let mut shm = shm.unwrap();

    let mut buffer = [0u8; USEFUL_C_MUMBLE_LINK_SIZE + 16];
    let mut timer = Instant::now();
    loop {
        CMumbleLink::copy_raw_bytes_into(link_ptr, &mut buffer[..USEFUL_C_MUMBLE_LINK_SIZE]);
        if timer.elapsed() > Duration::from_secs(5) {
            timer = Instant::now();
            let windim = get_win_pos_dim(link_ptr);
            trace!("{:?}", windim);
            let windim = windim.unwrap();
            windim.copy_raw_bytes_into(&mut buffer[USEFUL_C_MUMBLE_LINK_SIZE..]);
        }
        shm.write(&buffer).unwrap();
        shm.seek(SeekFrom::Start(0)).unwrap();
        std::thread::sleep(std::time::Duration::from_millis(15));
    }
}
