use clap::App;
use log::{trace, LevelFilter};
use std::{path::PathBuf, str::FromStr};

pub fn create_app() {
    let yml = clap::load_yaml!("app.yml");
    let m = App::from_yaml(yml).get_matches();
    let termlog = LevelFilter::from_str(m.value_of("termlog").unwrap_or("info")).unwrap();
    let filelog = LevelFilter::from_str(m.value_of("filelog").unwrap_or("debug")).unwrap();
    let logfile = PathBuf::from_str(m.value_of("logfile").unwrap_or("jokolink.log")).unwrap();

    crate::log_init(termlog, filelog, logfile).unwrap();
    trace!("created app and initialized logging");
}
