use self::mumble_link::CMumbleLink;
use num_derive::{FromPrimitive, ToPrimitive};
use std::collections::BTreeMap;
use std::net::UdpSocket;

pub mod mumble_link;

type MLmap = BTreeMap<String, *const CMumbleLink>;
#[derive(Debug)]
pub struct Engine {
    pub socket: UdpSocket,
    pub mlinks: MLmap,
}

impl Engine {
    #[cfg(target_os = "windows")]
    pub fn create(port: u16) -> Self {
        let mlinks = MLmap::new();
        let socket = UdpSocket::bind(("127.0.0.1", port)).unwrap();
        Engine { socket, mlinks }
    }
    pub fn get_link_ptr(&mut self, key: &str) -> *const CMumbleLink {
        *(self
            .mlinks
            .entry(key.to_string())
            .or_insert(CMumbleLink::new(key)))
    }
}

#[derive(FromPrimitive, ToPrimitive)]
pub enum RequestFor {
    Nothing = 0,
    MumbleLinkData = 1,
    WindowSize = 2,
}

#[derive(FromPrimitive, ToPrimitive)]
pub enum Response {
    Nothing = 0,
    InvalidKey = 1,
    InvalidRequest = 2,
    MumbleLinkNotInit = 3,
    Failed = 4,
    Success = 5,
}
