#[cfg(target_os = "windows")]
#[cfg(not(feature = "async"))]
fn main() -> anyhow::Result<()> {
    use jokolink::server::synchronous::start_udp_server_multi_sync;
    use log::{error, trace};
    let (ip, port) = jokolink::cli::create_app()
        .map_err(|e| {
            error!("could not initialize app {}", e);
        })
        .unwrap();
    trace!("starting udp sync server");

    start_udp_server_multi_sync(std::net::SocketAddr::new(std::net::IpAddr::V4(ip), port))?;
    trace!("exiting main");

    Ok(())
}

#[cfg(target_os = "windows")]
#[cfg(feature = "async")]
#[tokio::main]
async fn main() -> anyhow::Result<()> {
    use jokolink::server::asynchronous::{
        start_grpc_server_multi_async, start_udp_server_multi_async,
    };
    use log::{error, trace};
    trace!("starting..");
    let (ip, port) = jokolink::cli::create_app()
        .map_err(|e| {
            error!("could not initialize app {}", e);
        })
        .unwrap();
        let mode = jokolink::server::asynchronous::ServerMode::Grpc;
    match mode {
        jokolink::server::asynchronous::ServerMode::Udp => {
            start_udp_server_multi_async(std::net::IpAddr::V4(ip), port).await?
        }
        jokolink::server::asynchronous::ServerMode::Grpc => {
            start_grpc_server_multi_async(std::net::IpAddr::V4(ip), port).await?
        }
    }

    Ok(())
}

#[cfg(not(target_os = "windows"))]
fn main() {
    panic!("only works on windows");
}
