use clap::App;
use log::{LevelFilter, trace};
use std::{net::Ipv4Addr, path::PathBuf, str::FromStr};
// #[cfg(feature="async")]
// use crate::server::asynchronous::ServerMode;

pub fn create_app() -> anyhow::Result<(Ipv4Addr, u16)> {
    let yml = clap::load_yaml!("app.yml");
    let m = App::from_yaml(yml).get_matches();
    let termlog = LevelFilter::from_str(m.value_of("termlog").unwrap_or("info"))?;
    let filelog = LevelFilter::from_str(m.value_of("filelog").unwrap_or("debug"))?;
    let logfile = PathBuf::from_str(m.value_of("logfile").unwrap_or("jokolink.log"))?;
    let ip_addr = Ipv4Addr::from_str(m.value_of("ip").unwrap_or("127.0.0.1"))?;
    let port = m.value_of("port").unwrap_or("7187").parse::<u16>()?;
 

    crate::log_init(termlog, filelog, logfile)?;
    trace!("created app and init log");

    Ok((ip_addr, port))

    
}
