#[cfg(target_os = "windows")]
fn main() -> anyhow::Result<()> {
    use jokolink::engine::Engine;
    use log::error;
    println!("starting..");
    let (ip, port, mode) = jokolink::cli::create_app().map_err(|e| {
        error!("could not initialize app {}", e);       
    }).unwrap();

    let engine = Engine::create(std::net::IpAddr::V4(ip), port).map_err(|e| {
        error!("could not create engine {}", e);
    }).unwrap();
    engine.start_server(mode).map_err(|e| {
        error!("could not create engine {}", e);
    }).unwrap();
    Ok(())
}

#[cfg(not(target_os = "windows"))]
fn main() {
    panic!("only works on windows");
}
