//! Jokolink is a crate to deal with Mumble Link data exposed by other games/apps on windows via shared memory

//! Joko link is a windows only crate. designed to primarily get the MumbleLink or the window
//! size of the GW2 window for Jokolay (an crossplatform overlay for Guild Wars 2). It can also
//! expose the data through a server. can easily be modified to get data from other applications too.
//! on windows, you can use it to get the pointer. and on linux, you can run jokolink in wine,
//! so that you can easily request the data from a linux native application.
//! It can multiple accessing data of multiple MumbleLinks, and allows multiple clients
//! to request the data.

use std::path::PathBuf;

use log::LevelFilter;

pub mod cross_platform;
pub mod mlp {
    tonic::include_proto!("mlp");
}

#[cfg(target_os = "windows")]
pub mod engine;
#[cfg(target_os = "windows")]
pub mod cli;

/// initializes global logging backend that is used by log macros
/// Takes in a filter for stdout/stderr, a filter for logfile and finally the path to logfile
pub fn log_init_panic(
    term_filter: LevelFilter,
    file_filter: LevelFilter,
    file_path: PathBuf,
) -> anyhow::Result<()> {
    use simplelog::*;
    use std::fs::File;
    human_panic::setup_panic!();

    CombinedLogger::init(vec![
        TermLogger::new(
            term_filter,
            Config::default(),
            TerminalMode::Mixed,
            ColorChoice::Auto,
        ),
        WriteLogger::new(
            file_filter,
            Config::default(),
            File::create(file_path)?,
        ),
    ])?;
    Ok(())
}
/*
Ctypes -> clink, context,
            from, from
usefulT -> umlink (umctx)

CacheT -> LinkCache

Multiple -> MlMap

Concurrent -> Mutex, Arc

udp -> async, sync
grpc -> async

*/
