use crate::cross_platform::cmltypes::CMumbleLink;
use crate::mlp::{MumbleLink, WindowDimensions};
use std::time::Instant;

#[derive(Debug, Clone)]
pub struct LinkCache {
    pub link: MumbleLink,
    pub win_dim: WindowDimensions,
    pub last_updated: Instant,
    pub link_ptr: *const CMumbleLink,
}
impl LinkCache {
    pub fn new(key: &str) -> anyhow::Result<Self> {
        let link_ptr = CMumbleLink::new_ptr(key)?;

        let mut link =  MumbleLink::default();
        link.update(link_ptr)?;

        let mut win_dim = WindowDimensions::default();
        win_dim.update(link_ptr)?;

        let last_updated = Instant::now();

        Ok(LinkCache {
            link_ptr,
            link,
            last_updated,
            win_dim,
        })
    }
}

impl Default for LinkCache {
    fn default() -> Self {
        LinkCache {
            last_updated: Instant::now(),
            link_ptr: std::ptr::null::<CMumbleLink>(),
            ..Default::default()
        }
    }
}

unsafe impl Send for LinkCache {
    
}