
#[cfg(target_os = "windows")]
#[tokio::main]
async fn main() -> anyhow::Result<()> {
    use std::net::{IpAddr, Ipv4Addr};

    use jokolink::engine::Engine;
    let engine = Engine::create(IpAddr::V4(Ipv4Addr::LOCALHOST), 7187)?;
    engine.start_grpc_server_multi_async().await?;
    Ok(())
    }

#[cfg(not(target_os="windows"))  ]
fn main() {

}