#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Empty {}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RawLink {
    #[prost(uint32, repeated, tag = "1")]
    pub raw_bytes: ::prost::alloc::vec::Vec<u32>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MumbleLinkRequest {
    #[prost(string, tag = "1")]
    pub mumble_link_name: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MumbleLinkResponse {
    ///Default
    #[prost(enumeration = "mumble_link_response::MumbleStatus", tag = "1")]
    pub status: i32,
    #[prost(message, optional, tag = "2")]
    pub mumble_link: ::core::option::Option<MumbleLink>,
}
/// Nested message and enum types in `MumbleLinkResponse`.
pub mod mumble_link_response {
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum MumbleStatus {
        Failed = 0,
        InvalidKey = 1,
        MumbleLinkNotInit = 2,
        Success = 3,
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MumbleLink {
    #[prost(uint32, tag = "1")]
    pub ui_tick: u32,
    #[prost(float, repeated, tag = "2")]
    pub f_avatar_position: ::prost::alloc::vec::Vec<f32>,
    #[prost(float, repeated, tag = "3")]
    pub f_avatar_front: ::prost::alloc::vec::Vec<f32>,
    #[prost(float, repeated, tag = "4")]
    pub f_camera_position: ::prost::alloc::vec::Vec<f32>,
    #[prost(float, repeated, tag = "5")]
    pub f_camera_front: ::prost::alloc::vec::Vec<f32>,
    #[prost(message, optional, tag = "6")]
    pub identity: ::core::option::Option<MumbleIdentity>,
    #[prost(message, optional, tag = "7")]
    pub context: ::core::option::Option<MumbleContext>,
}
#[derive(serde::Deserialize, Clone, PartialEq, ::prost::Message)]
pub struct MumbleIdentity {
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(uint32, tag = "2")]
    pub profession: u32,
    #[prost(uint32, tag = "3")]
    pub spec: u32,
    #[prost(uint32, tag = "4")]
    pub race: u32,
    #[prost(uint32, tag = "5")]
    pub map_id: u32,
    #[prost(uint32, tag = "6")]
    pub world_id: u32,
    #[prost(uint32, tag = "7")]
    pub team_color_id: u32,
    #[prost(bool, tag = "8")]
    pub commander: bool,
    #[prost(float, tag = "9")]
    pub fov: f32,
    #[prost(uint32, tag = "10")]
    pub uisz: u32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MumbleContext {
    #[prost(uint32, tag = "1")]
    pub server_address: u32,
    #[prost(uint32, tag = "2")]
    pub map_id: u32,
    #[prost(uint32, tag = "3")]
    pub map_type: u32,
    #[prost(uint32, tag = "4")]
    pub shard_id: u32,
    #[prost(uint32, tag = "5")]
    pub instance: u32,
    #[prost(uint32, tag = "6")]
    pub build_id: u32,
    ///Bitmask: Bit 1 = IsMapOpen, Bit 2 = IsCompassTopRight,
    ///Bit 3 = DoesCompassHaveRotationEnabled, Bit 4 = Game
    ///has focus, Bit 5 = Is in Competitive game mode, Bit 6
    ///= Textbox has focus, Bit 7 = Is in Combat
    #[prost(uint32, tag = "7")]
    pub ui_state: u32,
    #[prost(uint32, tag = "8")]
    pub compass_width: u32,
    #[prost(uint32, tag = "9")]
    pub compass_height: u32,
    #[prost(float, tag = "10")]
    pub compass_rotation: f32,
    #[prost(float, tag = "11")]
    pub player_x: f32,
    #[prost(float, tag = "12")]
    pub player_y: f32,
    #[prost(float, tag = "13")]
    pub map_center_x: f32,
    #[prost(float, tag = "14")]
    pub map_center_y: f32,
    #[prost(float, tag = "15")]
    pub map_scale: f32,
    #[prost(uint32, tag = "16")]
    pub process_id: u32,
    #[prost(uint32, tag = "17")]
    pub mount_index: u32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WindowDimensions {
    #[prost(uint32, tag = "1")]
    pub x: u32,
    #[prost(uint32, tag = "2")]
    pub y: u32,
    #[prost(uint32, tag = "3")]
    pub width: u32,
    #[prost(uint32, tag = "4")]
    pub height: u32,
}
#[doc = r" Generated client implementations."]
pub mod mumble_service_client {
    #![allow(unused_variables, dead_code, missing_docs)]
    use tonic::codegen::*;
    pub struct MumbleServiceClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl MumbleServiceClient<tonic::transport::Channel> {
        #[doc = r" Attempt to create a new client by connecting to a given endpoint."]
        pub async fn connect<D>(dst: D) -> Result<Self, tonic::transport::Error>
        where
            D: std::convert::TryInto<tonic::transport::Endpoint>,
            D::Error: Into<StdError>,
        {
            let conn = tonic::transport::Endpoint::new(dst)?.connect().await?;
            Ok(Self::new(conn))
        }
    }
    impl<T> MumbleServiceClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::BoxBody>,
        T::ResponseBody: Body + HttpBody + Send + 'static,
        T::Error: Into<StdError>,
        <T::ResponseBody as HttpBody>::Error: Into<StdError> + Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_interceptor(inner: T, interceptor: impl Into<tonic::Interceptor>) -> Self {
            let inner = tonic::client::Grpc::with_interceptor(inner, interceptor);
            Self { inner }
        }
        pub async fn get_mumble_link(
            &mut self,
            request: impl tonic::IntoRequest<super::MumbleLinkRequest>,
        ) -> Result<tonic::Response<super::MumbleLinkResponse>, tonic::Status> {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::new(
                    tonic::Code::Unknown,
                    format!("Service was not ready: {}", e.into()),
                )
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/mlp.MumbleService/getMumbleLink");
            self.inner.unary(request.into_request(), path, codec).await
        }
        pub async fn get_raw_link(
            &mut self,
            request: impl tonic::IntoRequest<super::Empty>,
        ) -> Result<tonic::Response<super::RawLink>, tonic::Status> {
            self.inner.ready().await.map_err(|e| {
                tonic::Status::new(
                    tonic::Code::Unknown,
                    format!("Service was not ready: {}", e.into()),
                )
            })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static("/mlp.MumbleService/getRawLink");
            self.inner.unary(request.into_request(), path, codec).await
        }
    }
    impl<T: Clone> Clone for MumbleServiceClient<T> {
        fn clone(&self) -> Self {
            Self {
                inner: self.inner.clone(),
            }
        }
    }
    impl<T> std::fmt::Debug for MumbleServiceClient<T> {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
            write!(f, "MumbleServiceClient {{ ... }}")
        }
    }
}
#[doc = r" Generated server implementations."]
pub mod mumble_service_server {
    #![allow(unused_variables, dead_code, missing_docs)]
    use tonic::codegen::*;
    #[doc = "Generated trait containing gRPC methods that should be implemented for use with MumbleServiceServer."]
    #[async_trait]
    pub trait MumbleService: Send + Sync + 'static {
        async fn get_mumble_link(
            &self,
            request: tonic::Request<super::MumbleLinkRequest>,
        ) -> Result<tonic::Response<super::MumbleLinkResponse>, tonic::Status>;
        async fn get_raw_link(
            &self,
            request: tonic::Request<super::Empty>,
        ) -> Result<tonic::Response<super::RawLink>, tonic::Status>;
    }
    #[derive(Debug)]
    pub struct MumbleServiceServer<T: MumbleService> {
        inner: _Inner<T>,
    }
    struct _Inner<T>(Arc<T>, Option<tonic::Interceptor>);
    impl<T: MumbleService> MumbleServiceServer<T> {
        pub fn new(inner: T) -> Self {
            let inner = Arc::new(inner);
            let inner = _Inner(inner, None);
            Self { inner }
        }
        pub fn with_interceptor(inner: T, interceptor: impl Into<tonic::Interceptor>) -> Self {
            let inner = Arc::new(inner);
            let inner = _Inner(inner, Some(interceptor.into()));
            Self { inner }
        }
    }
    impl<T, B> Service<http::Request<B>> for MumbleServiceServer<T>
    where
        T: MumbleService,
        B: HttpBody + Send + Sync + 'static,
        B::Error: Into<StdError> + Send + 'static,
    {
        type Response = http::Response<tonic::body::BoxBody>;
        type Error = Never;
        type Future = BoxFuture<Self::Response, Self::Error>;
        fn poll_ready(&mut self, _cx: &mut Context<'_>) -> Poll<Result<(), Self::Error>> {
            Poll::Ready(Ok(()))
        }
        fn call(&mut self, req: http::Request<B>) -> Self::Future {
            let inner = self.inner.clone();
            match req.uri().path() {
                "/mlp.MumbleService/getMumbleLink" => {
                    #[allow(non_camel_case_types)]
                    struct getMumbleLinkSvc<T: MumbleService>(pub Arc<T>);
                    impl<T: MumbleService> tonic::server::UnaryService<super::MumbleLinkRequest>
                        for getMumbleLinkSvc<T>
                    {
                        type Response = super::MumbleLinkResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::MumbleLinkRequest>,
                        ) -> Self::Future {
                            let inner = self.0.clone();
                            let fut = async move { (*inner).get_mumble_link(request).await };
                            Box::pin(fut)
                        }
                    }
                    let inner = self.inner.clone();
                    let fut = async move {
                        let interceptor = inner.1.clone();
                        let inner = inner.0;
                        let method = getMumbleLinkSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = if let Some(interceptor) = interceptor {
                            tonic::server::Grpc::with_interceptor(codec, interceptor)
                        } else {
                            tonic::server::Grpc::new(codec)
                        };
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/mlp.MumbleService/getRawLink" => {
                    #[allow(non_camel_case_types)]
                    struct getRawLinkSvc<T: MumbleService>(pub Arc<T>);
                    impl<T: MumbleService> tonic::server::UnaryService<super::Empty> for getRawLinkSvc<T> {
                        type Response = super::RawLink;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(&mut self, request: tonic::Request<super::Empty>) -> Self::Future {
                            let inner = self.0.clone();
                            let fut = async move { (*inner).get_raw_link(request).await };
                            Box::pin(fut)
                        }
                    }
                    let inner = self.inner.clone();
                    let fut = async move {
                        let interceptor = inner.1.clone();
                        let inner = inner.0;
                        let method = getRawLinkSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = if let Some(interceptor) = interceptor {
                            tonic::server::Grpc::with_interceptor(codec, interceptor)
                        } else {
                            tonic::server::Grpc::new(codec)
                        };
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                _ => Box::pin(async move {
                    Ok(http::Response::builder()
                        .status(200)
                        .header("grpc-status", "12")
                        .header("content-type", "application/grpc")
                        .body(tonic::body::BoxBody::empty())
                        .unwrap())
                }),
            }
        }
    }
    impl<T: MumbleService> Clone for MumbleServiceServer<T> {
        fn clone(&self) -> Self {
            let inner = self.inner.clone();
            Self { inner }
        }
    }
    impl<T: MumbleService> Clone for _Inner<T> {
        fn clone(&self) -> Self {
            Self(self.0.clone(), self.1.clone())
        }
    }
    impl<T: std::fmt::Debug> std::fmt::Debug for _Inner<T> {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
            write!(f, "{:?}", self.0)
        }
    }
    impl<T: MumbleService> tonic::transport::NamedService for MumbleServiceServer<T> {
        const NAME: &'static str = "mlp.MumbleService";
    }
}
