mod engine;
fn main() {
    let engine = engine::Engine::create("MumbleLink", 0);
    let mlinfo =         String::from_utf16_lossy(&engine.handles[0].get_mumble_link().identity);

    println!(
        "mumbleLink info: {}", mlinfo
    );
    println!("{:?}", std::env::current_dir().unwrap());
    let win_pos_dim = engine.handles[0].get_mumble_link().get_win_pos_dim();

    println!("window size: {:?}", win_pos_dim);
    std::fs::write("mlinfo", format!("{}\n{:?}", mlinfo, win_pos_dim)).unwrap();

    std::thread::sleep(std::time::Duration::from_secs(15));
}
