use serde::{Serialize, Deserialize};
#[allow(dead_code)]
#[repr(C)]
pub struct MumbleLink {
    ui_version: u32,
    ui_tick: u32,
    f_avatar_position: [f32; 3],
    f_avatar_front: [f32; 3],
    f_avatar_top: [f32; 3],
    name: [u8; 512],
    f_camera_position: [f32; 3],
    f_camera_front: [f32; 3],
    f_camera_top: [f32; 3],
    identity: [u8; 512],
    context_len: u32,
    context: [u8; 256],
    description: [u8; 4096],
}
#[allow(dead_code)]
#[repr(C)]
struct MumbleContext {
    server_address: [u8; 28], // contains sockaddr_in or sockaddr_in6
    map_id: u32,
    map_type: u32,
    shard_id: u32,
    instance: u32,
    build_id: u32,
    // Additional data beyond the 48 bytes Mumble uses for identification
    ui_state: u32, // Bitmask: Bit 1 = IsMapOpen, Bit 2 = IsCompassTopRight, Bit 3 = DoesCompassHaveRotationEnabled, Bit 4 = Game has focus, Bit 5 = Is in Competitive game mode, Bit 6 = Textbox has focus, Bit 7 = Is in Combat
    compass_width: u16, // pixels
    compass_height: u16, // pixels
    compass_rotation: f32, // radians
    player_x: f32, // continentCoords
    player_y: f32, // continentCoords
    map_center_x: f32, // continentCoords
    map_center_y: f32, // continentCoords
    map_scale: f32,
    process_id: u32,
    mount_index: u8,
}
#[allow(dead_code)]
#[derive(Serialize, Deserialize)]
pub struct Identity {
    name: String,
    profession: u8,
    spec: u8,
    race: u8,
    map_id: u16,
    world_id: u16,
    team_color_id: u16,
    commander: bool,
    fov: f32,
    uisz: u8,
}
