use super::{EndPoint, EndPointIds};




type WorldId = u32;
const E_P_URL: &str = const_format::concatcp!(crate::API_BASE_V2_URL, "/worlds");
#[derive(serde::Serialize, serde::Deserialize)]
pub struct World {
    id: u32,
    name: String,
    population: String
}



pub struct Worlds;

impl EndPoint for Worlds {
    type RType = Vec<WorldId>;
    fn get_url() -> &'static str {
        E_P_URL
    }
}

impl EndPointIds for Worlds {
    type Id = WorldId;
    type RType = Vec<World>;

    fn get_url() -> &'static str {
        E_P_URL
    }
}

#[cfg(test)]
mod tests {
    use ureq::Agent;

    use crate::end_point::{EndPoint, EndPointIds};

    use super::Worlds;

    #[test]
    fn check_world() {
        let agent = Agent::new();
        let result = Worlds::get(agent.clone()).unwrap();
        assert_eq!(result[0], Worlds::get_with_id(agent, &[result[0]]).unwrap()[0].id )
    }
}
