use itertools::Itertools;
use serde::de::DeserializeOwned;
use std::{any::type_name, fmt::Display};
use ureq::{Agent, Error};

mod quaggans;
mod minis;
mod worlds;
mod colors;
mod daily_crafting;
mod items;
mod outfits;
pub trait EndPointAuthId {
    type Id;
    type RType;
    fn get_url(id: &Self::Id) -> String;
    fn get_auth_with_id(agent: Agent, api_key: &str, id: &Self::Id) -> Result<Self::RType, Error>
    where
        Self::RType: DeserializeOwned,
        Self::Id: Display,
    {
        let res = agent
            .get(&Self::get_url(id))
            .set("Authorization", &format!("Bearer {}", api_key))
            .call()?;
        Ok(res.into_json().expect(&format!(
            "couldn't convert json result to rust type {}",
            type_name::<Self::RType>()
        )))
    }
}
pub trait EndPointAuthIds {
    type Id;
    type RType;
    fn get_url() -> &'static str;
    fn get_auth_with_id(agent: Agent, api_key: &str, ids: &[Self::Id]) -> Result<Self::RType, Error>
    where
        Self::RType: DeserializeOwned,
        Self::Id: Display,
    {
        let res = agent
            .get(Self::get_url())
            .set("Authorization", &format!("Bearer {}", api_key))
            .query("ids", &ids.iter().join(","))
            .call()?;
        Ok(res.into_json().expect(&format!(
            "couldn't convert json result to rust type {}",
            type_name::<Self::RType>()
        )))
    }
}
pub trait EndPointAuth {
    type RType;
    fn get_url() -> &'static str;
    fn get_auth(agent: Agent, api_key: &str) -> Result<Self::RType, Error>
    where
        Self::RType: DeserializeOwned,
    {
        let res = agent
            .get(Self::get_url())
            .set("Authorization", &format!("Bearer {}", api_key))
            .call()?;
        Ok(res.into_json().expect(&format!(
            "couldn't convert json result to rust type {}",
            type_name::<Self::RType>()
        )))
    }
}
pub trait EndPointIds {
    type Id;
    type RType;
    fn get_url() -> &'static str;
    fn get_with_id(agent: Agent, ids: &[Self::Id]) -> Result<Self::RType, Error>
    where
        Self::RType: DeserializeOwned,
        Self::Id: Display,
    {
        let res = agent
            .get(Self::get_url())
            .query("ids", &ids.iter().join(","))
            .call()?;
        Ok(res.into_json().expect(&format!(
            "couldn't convert json result to rust type {}",
            type_name::<Self::RType>()
        )))
    }
}

pub trait EndPoint {
    type RType;
    fn get_url() -> &'static str;
    fn get(agent: Agent) -> Result<Self::RType, Error>
    where
        Self::RType: DeserializeOwned,
    {
        let res = agent.get(Self::get_url()).call()?;
        Ok(res.into_json().expect(&format!(
            "couldn't convert json result to rust type {}",
            type_name::<Self::RType>()
        )))
    }
}



/*

pub(crate) enum V2 {
    Account,
    AccountBank,
    AccountBuildstorage,
    AccountDailycrafting,
    AccountDungeons,
    AccountDyes,
    AccountEmotes,
    AccountFinishers,
    AccountGliders,
    AccountHome,
    AccountHomeCats,
    AccountHomeNodes,
    AccountInventory,
    AccountLuck,
    AccountMailcarriers,
    AccountMapchests,
    AccountMasteries,
    AccountMasteryPoints,
    AccountMaterials,
    AccountMinis,
    AccountMounts,
    AccountMountsSkins,
    AccountMountsTypes,
    AccountNovelties,
    AccountOutfits,
    AccountPvpHeroes,
    AccountRaids,
    AccountRecipes,
    AccountSkins,
    AccountTitles,
    AccountWallet,
    AccountWorldbosses,
    Achievements,
    AchievementsCategories,
    AchievementsDaily,
    AchievementsDailyTomorrow,
    AchievementsGroups,
    Backstory,
    BackstoryAnswers,
    BackstoryQuestions,
    Build,
    Characters,
    CharactersBackstory,
    CharactersBuildtabs,
    CharactersCore,
    CharactersCrafting,
    CharactersEquipment,
    CharactersEquipmenttabs,
    CharactersHeropoints,
    CharactersInventory,
    CharactersQuests,
    CharactersRecipes,
    CharactersSab,
    CharactersSkills,
    CharactersSpecializations,
    CharactersTraining,
    Colors,
    Commerce,
    CommerceDelivery,
    CommerceExchange,
    CommerceExchangeCoins,
    CommerceExchangeGems,
    CommerceListings,
    CommercePrices,
    CommerceTransactions,
    Continents,
    Createsubtoken,
    Currencies,
    Dailycrafting,
    Dungeons,
    Emblem,
    EmblemBackgrounds,
    EmblemForegrounds,
    Emotes,
    Files,
    Finishers,
    Gliders,
    Guild,
    GuildLog,
    GuildMembers,
    GuildPermissions,
    GuildRanks,
    GuildStash,
    GuildStorage,
    GuildTeams,
    GuildTreasury,
    GuildUpgrades,
    GuildSearch,
    HomeCats,
    HomeNodes,
    Items,
    Itemstats,
    Legends,
    Mailcarriers,
    Mapchests,
    Maps,
    Masteries,
    Materials,
    Minis,
    Mounts,
    MountsSkins,
    MountsTypes,
    Novelties,
    Outfits,
    Pets,
    Professions,
    Pvp,
    PvpAmulets,
    PvpGames,
    PvpHeroes,
    PvpRanks,
    PvpSeasons,
    PvpSeasonsLeaderboards,
    PvpStandings,
    PvpStats,
    Quaggans(Quaggans),
    Quests,
    Races,
    Raids,
    Recipes,
    RecipesSearch,
    Skills,
    Skins,
    Specializations,
    Stories,
    StoriesSeasons,
    Titles,
    TokenInfo,
    Traits,
    Worldbosses,
    Worlds,
    Wvw,
    WvwAbilities,
    WvwMatches,
    WvwMatchesStatsTeams,
    WvwObjectives,
    WvwRanks,
    WvwUpgrades,
}
*/