#![allow(deref_nullptr)]
/* generated from Julia version 1.6.4 */
/* automatically generated by rust-bindgen 0.59.2 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___sigset_t() {
    assert_eq!(
        ::std::mem::size_of::<__sigset_t>(),
        128usize,
        concat!("Size of: ", stringify!(__sigset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigset_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigset_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigset_t),
            "::",
            stringify!(__val)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[test]
fn bindgen_test_layout___pthread_internal_list() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_list>(),
        16usize,
        concat!("Size of: ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_list>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__prev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__next)
        )
    );
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
#[test]
fn bindgen_test_layout___pthread_mutex_s() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_mutex_s>(),
        40usize,
        concat!("Size of: ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_mutex_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__lock as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__count as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__owner as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__owner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__nusers as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__nusers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__kind as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__kind)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__spins as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__spins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__elision as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__elision)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__list as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__list)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_rwlock_arch_t {
    pub __readers: ::std::os::raw::c_uint,
    pub __writers: ::std::os::raw::c_uint,
    pub __wrphase_futex: ::std::os::raw::c_uint,
    pub __writers_futex: ::std::os::raw::c_uint,
    pub __pad3: ::std::os::raw::c_uint,
    pub __pad4: ::std::os::raw::c_uint,
    pub __cur_writer: ::std::os::raw::c_int,
    pub __shared: ::std::os::raw::c_int,
    pub __rwelision: ::std::os::raw::c_schar,
    pub __pad1: [::std::os::raw::c_uchar; 7usize],
    pub __pad2: ::std::os::raw::c_ulong,
    pub __flags: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_rwlock_arch_t() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_rwlock_arch_t>(),
        56usize,
        concat!("Size of: ", stringify!(__pthread_rwlock_arch_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_rwlock_arch_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_rwlock_arch_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__readers as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__readers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__writers as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__writers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__wrphase_futex as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__wrphase_futex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__writers_futex as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__writers_futex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad3 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad4 as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__cur_writer as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__cur_writer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__shared as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__shared)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__rwelision as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__rwelision)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad1 as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad2 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__flags as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__flags)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_cond_s {
    pub __bindgen_anon_1: __pthread_cond_s__bindgen_ty_1,
    pub __bindgen_anon_2: __pthread_cond_s__bindgen_ty_2,
    pub __g_refs: [::std::os::raw::c_uint; 2usize],
    pub __g_size: [::std::os::raw::c_uint; 2usize],
    pub __g1_orig_size: ::std::os::raw::c_uint,
    pub __wrefs: ::std::os::raw::c_uint,
    pub __g_signals: [::std::os::raw::c_uint; 2usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_1 {
    pub __wseq: ::std::os::raw::c_ulonglong,
    pub __wseq32: __pthread_cond_s__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_1__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>())).__low
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__low)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1__bindgen_ty_1>())).__high
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(__high)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_cond_s__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1>())).__wseq as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1),
            "::",
            stringify!(__wseq)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_1>())).__wseq32 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_1),
            "::",
            stringify!(__wseq32)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __pthread_cond_s__bindgen_ty_2 {
    pub __g1_start: ::std::os::raw::c_ulonglong,
    pub __g1_start32: __pthread_cond_s__bindgen_ty_2__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_cond_s__bindgen_ty_2__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>())).__low
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__low)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2__bindgen_ty_1>())).__high
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(__high)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s__bindgen_ty_2>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_cond_s__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s__bindgen_ty_2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2>())).__g1_start as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2),
            "::",
            stringify!(__g1_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_cond_s__bindgen_ty_2>())).__g1_start32 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s__bindgen_ty_2),
            "::",
            stringify!(__g1_start32)
        )
    );
}
#[test]
fn bindgen_test_layout___pthread_cond_s() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s>(),
        48usize,
        concat!("Size of: ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_refs as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_refs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_size as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g1_orig_size as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g1_orig_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__wrefs as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__wrefs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_signals as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_signals)
        )
    );
}
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: __pthread_cond_s,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: __pthread_rwlock_arch_t,
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__align)
        )
    );
}
pub type uint_t = u64;
pub type sig_atomic_t = __sig_atomic_t;
pub type __jmp_buf = [::std::os::raw::c_long; 8usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __jmp_buf_tag {
    pub __jmpbuf: __jmp_buf,
    pub __mask_was_saved: ::std::os::raw::c_int,
    pub __saved_mask: __sigset_t,
}
#[test]
fn bindgen_test_layout___jmp_buf_tag() {
    assert_eq!(
        ::std::mem::size_of::<__jmp_buf_tag>(),
        200usize,
        concat!("Size of: ", stringify!(__jmp_buf_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<__jmp_buf_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(__jmp_buf_tag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__jmp_buf_tag>())).__jmpbuf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__jmp_buf_tag),
            "::",
            stringify!(__jmpbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__jmp_buf_tag>())).__mask_was_saved as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__jmp_buf_tag),
            "::",
            stringify!(__mask_was_saved)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__jmp_buf_tag>())).__saved_mask as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__jmp_buf_tag),
            "::",
            stringify!(__saved_mask)
        )
    );
}
pub type uv__io_cb = ::std::option::Option<
    unsafe extern "C" fn(loop_: *mut uv_loop_s, w: *mut uv__io_s, events: ::std::os::raw::c_uint),
>;
pub type uv__io_t = uv__io_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uv__io_s {
    pub cb: uv__io_cb,
    pub pending_queue: [*mut ::std::os::raw::c_void; 2usize],
    pub watcher_queue: [*mut ::std::os::raw::c_void; 2usize],
    pub pevents: ::std::os::raw::c_uint,
    pub events: ::std::os::raw::c_uint,
    pub fd: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_uv__io_s() {
    assert_eq!(
        ::std::mem::size_of::<uv__io_s>(),
        56usize,
        concat!("Size of: ", stringify!(uv__io_s))
    );
    assert_eq!(
        ::std::mem::align_of::<uv__io_s>(),
        8usize,
        concat!("Alignment of ", stringify!(uv__io_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv__io_s>())).cb as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv__io_s),
            "::",
            stringify!(cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv__io_s>())).pending_queue as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(uv__io_s),
            "::",
            stringify!(pending_queue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv__io_s>())).watcher_queue as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(uv__io_s),
            "::",
            stringify!(watcher_queue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv__io_s>())).pevents as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(uv__io_s),
            "::",
            stringify!(pevents)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv__io_s>())).events as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(uv__io_s),
            "::",
            stringify!(events)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv__io_s>())).fd as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(uv__io_s),
            "::",
            stringify!(fd)
        )
    );
}
pub type uv_mutex_t = pthread_mutex_t;
pub type uv_rwlock_t = pthread_rwlock_t;
pub type uv_cond_t = pthread_cond_t;
pub const uv_handle_type_UV_UNKNOWN_HANDLE: uv_handle_type = 0;
pub const uv_handle_type_UV_ASYNC: uv_handle_type = 1;
pub const uv_handle_type_UV_CHECK: uv_handle_type = 2;
pub const uv_handle_type_UV_FS_EVENT: uv_handle_type = 3;
pub const uv_handle_type_UV_FS_POLL: uv_handle_type = 4;
pub const uv_handle_type_UV_HANDLE: uv_handle_type = 5;
pub const uv_handle_type_UV_IDLE: uv_handle_type = 6;
pub const uv_handle_type_UV_NAMED_PIPE: uv_handle_type = 7;
pub const uv_handle_type_UV_POLL: uv_handle_type = 8;
pub const uv_handle_type_UV_PREPARE: uv_handle_type = 9;
pub const uv_handle_type_UV_PROCESS: uv_handle_type = 10;
pub const uv_handle_type_UV_STREAM: uv_handle_type = 11;
pub const uv_handle_type_UV_TCP: uv_handle_type = 12;
pub const uv_handle_type_UV_TIMER: uv_handle_type = 13;
pub const uv_handle_type_UV_TTY: uv_handle_type = 14;
pub const uv_handle_type_UV_UDP: uv_handle_type = 15;
pub const uv_handle_type_UV_SIGNAL: uv_handle_type = 16;
pub const uv_handle_type_UV_FILE: uv_handle_type = 17;
pub const uv_handle_type_UV_HANDLE_TYPE_MAX: uv_handle_type = 18;
pub type uv_handle_type = ::std::os::raw::c_uint;
pub type uv_loop_t = uv_loop_s;
pub type uv_handle_t = uv_handle_s;
pub type uv_async_t = uv_async_s;
pub type uv_signal_t = uv_signal_s;
pub type uv_close_cb = ::std::option::Option<unsafe extern "C" fn(handle: *mut uv_handle_t)>;
pub type uv_async_cb = ::std::option::Option<unsafe extern "C" fn(handle: *mut uv_async_t)>;
pub type uv_signal_cb = ::std::option::Option<
    unsafe extern "C" fn(handle: *mut uv_signal_t, signum: ::std::os::raw::c_int),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uv_handle_s {
    pub data: *mut ::std::os::raw::c_void,
    pub loop_: *mut uv_loop_t,
    pub type_: uv_handle_type,
    pub close_cb: uv_close_cb,
    pub handle_queue: [*mut ::std::os::raw::c_void; 2usize],
    pub next_closing: *mut uv_handle_t,
    pub flags: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_uv_handle_s() {
    assert_eq!(
        ::std::mem::size_of::<uv_handle_s>(),
        64usize,
        concat!("Size of: ", stringify!(uv_handle_s))
    );
    assert_eq!(
        ::std::mem::align_of::<uv_handle_s>(),
        8usize,
        concat!("Alignment of ", stringify!(uv_handle_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_handle_s>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_handle_s),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_handle_s>())).loop_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_handle_s),
            "::",
            stringify!(loop_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_handle_s>())).type_ as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_handle_s),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_handle_s>())).close_cb as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_handle_s),
            "::",
            stringify!(close_cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_handle_s>())).handle_queue as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_handle_s),
            "::",
            stringify!(handle_queue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_handle_s>())).next_closing as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_handle_s),
            "::",
            stringify!(next_closing)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_handle_s>())).flags as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_handle_s),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uv_async_s {
    pub data: *mut ::std::os::raw::c_void,
    pub loop_: *mut uv_loop_t,
    pub type_: uv_handle_type,
    pub close_cb: uv_close_cb,
    pub handle_queue: [*mut ::std::os::raw::c_void; 2usize],
    pub next_closing: *mut uv_handle_t,
    pub flags: ::std::os::raw::c_uint,
    pub async_cb: uv_async_cb,
    pub queue: [*mut ::std::os::raw::c_void; 2usize],
    pub pending: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_uv_async_s() {
    assert_eq!(
        ::std::mem::size_of::<uv_async_s>(),
        96usize,
        concat!("Size of: ", stringify!(uv_async_s))
    );
    assert_eq!(
        ::std::mem::align_of::<uv_async_s>(),
        8usize,
        concat!("Alignment of ", stringify!(uv_async_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).loop_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(loop_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).type_ as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).close_cb as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(close_cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).handle_queue as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(handle_queue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).next_closing as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(next_closing)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).flags as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).async_cb as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(async_cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).queue as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(queue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).pending as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(pending)
        )
    );
}
extern "C" {
    pub fn uv_async_send(async_: *mut uv_async_t) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uv_signal_s {
    pub data: *mut ::std::os::raw::c_void,
    pub loop_: *mut uv_loop_t,
    pub type_: uv_handle_type,
    pub close_cb: uv_close_cb,
    pub handle_queue: [*mut ::std::os::raw::c_void; 2usize],
    pub next_closing: *mut uv_handle_t,
    pub flags: ::std::os::raw::c_uint,
    pub signal_cb: uv_signal_cb,
    pub signum: ::std::os::raw::c_int,
    pub tree_entry: uv_signal_s__bindgen_ty_1,
    pub caught_signals: ::std::os::raw::c_uint,
    pub dispatched_signals: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uv_signal_s__bindgen_ty_1 {
    pub rbe_left: *mut uv_signal_s,
    pub rbe_right: *mut uv_signal_s,
    pub rbe_parent: *mut uv_signal_s,
    pub rbe_color: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_uv_signal_s__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<uv_signal_s__bindgen_ty_1>(),
        32usize,
        concat!("Size of: ", stringify!(uv_signal_s__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<uv_signal_s__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(uv_signal_s__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<uv_signal_s__bindgen_ty_1>())).rbe_left as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_signal_s__bindgen_ty_1),
            "::",
            stringify!(rbe_left)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<uv_signal_s__bindgen_ty_1>())).rbe_right as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_signal_s__bindgen_ty_1),
            "::",
            stringify!(rbe_right)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<uv_signal_s__bindgen_ty_1>())).rbe_parent as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_signal_s__bindgen_ty_1),
            "::",
            stringify!(rbe_parent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<uv_signal_s__bindgen_ty_1>())).rbe_color as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_signal_s__bindgen_ty_1),
            "::",
            stringify!(rbe_color)
        )
    );
}
#[test]
fn bindgen_test_layout_uv_signal_s() {
    assert_eq!(
        ::std::mem::size_of::<uv_signal_s>(),
        120usize,
        concat!("Size of: ", stringify!(uv_signal_s))
    );
    assert_eq!(
        ::std::mem::align_of::<uv_signal_s>(),
        8usize,
        concat!("Alignment of ", stringify!(uv_signal_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_signal_s>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_signal_s),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_signal_s>())).loop_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_signal_s),
            "::",
            stringify!(loop_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_signal_s>())).type_ as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_signal_s),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_signal_s>())).close_cb as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_signal_s),
            "::",
            stringify!(close_cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_signal_s>())).handle_queue as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_signal_s),
            "::",
            stringify!(handle_queue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_signal_s>())).next_closing as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_signal_s),
            "::",
            stringify!(next_closing)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_signal_s>())).flags as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_signal_s),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_signal_s>())).signal_cb as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_signal_s),
            "::",
            stringify!(signal_cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_signal_s>())).signum as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_signal_s),
            "::",
            stringify!(signum)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_signal_s>())).tree_entry as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_signal_s),
            "::",
            stringify!(tree_entry)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_signal_s>())).caught_signals as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_signal_s),
            "::",
            stringify!(caught_signals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_signal_s>())).dispatched_signals as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_signal_s),
            "::",
            stringify!(dispatched_signals)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct uv_loop_s {
    pub data: *mut ::std::os::raw::c_void,
    pub active_handles: ::std::os::raw::c_uint,
    pub handle_queue: [*mut ::std::os::raw::c_void; 2usize],
    pub active_reqs: uv_loop_s__bindgen_ty_1,
    pub internal_fields: *mut ::std::os::raw::c_void,
    pub stop_flag: ::std::os::raw::c_uint,
    pub reserved: [*mut ::std::os::raw::c_void; 4usize],
    pub flags: ::std::os::raw::c_ulong,
    pub backend_fd: ::std::os::raw::c_int,
    pub pending_queue: [*mut ::std::os::raw::c_void; 2usize],
    pub watcher_queue: [*mut ::std::os::raw::c_void; 2usize],
    pub watchers: *mut *mut uv__io_t,
    pub nwatchers: ::std::os::raw::c_uint,
    pub nfds: ::std::os::raw::c_uint,
    pub wq: [*mut ::std::os::raw::c_void; 2usize],
    pub wq_mutex: uv_mutex_t,
    pub wq_async: uv_async_t,
    pub cloexec_lock: uv_rwlock_t,
    pub closing_handles: *mut uv_handle_t,
    pub process_handles: [*mut ::std::os::raw::c_void; 2usize],
    pub prepare_handles: [*mut ::std::os::raw::c_void; 2usize],
    pub check_handles: [*mut ::std::os::raw::c_void; 2usize],
    pub idle_handles: [*mut ::std::os::raw::c_void; 2usize],
    pub async_handles: [*mut ::std::os::raw::c_void; 2usize],
    pub async_unused: ::std::option::Option<unsafe extern "C" fn()>,
    pub async_io_watcher: uv__io_t,
    pub async_wfd: ::std::os::raw::c_int,
    pub timer_heap: uv_loop_s__bindgen_ty_2,
    pub timer_counter: u64,
    pub time: u64,
    pub signal_pipefd: [::std::os::raw::c_int; 2usize],
    pub signal_io_watcher: uv__io_t,
    pub child_watcher: uv_signal_t,
    pub emfile_fd: ::std::os::raw::c_int,
    pub inotify_read_watcher: uv__io_t,
    pub inotify_watchers: *mut ::std::os::raw::c_void,
    pub inotify_fd: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uv_loop_s__bindgen_ty_1 {
    pub unused: *mut ::std::os::raw::c_void,
    pub count: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_uv_loop_s__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<uv_loop_s__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(uv_loop_s__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<uv_loop_s__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(uv_loop_s__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s__bindgen_ty_1>())).unused as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s__bindgen_ty_1),
            "::",
            stringify!(unused)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s__bindgen_ty_1>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s__bindgen_ty_1),
            "::",
            stringify!(count)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uv_loop_s__bindgen_ty_2 {
    pub min: *mut ::std::os::raw::c_void,
    pub nelts: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_uv_loop_s__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<uv_loop_s__bindgen_ty_2>(),
        16usize,
        concat!("Size of: ", stringify!(uv_loop_s__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<uv_loop_s__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(uv_loop_s__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s__bindgen_ty_2>())).min as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s__bindgen_ty_2),
            "::",
            stringify!(min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s__bindgen_ty_2>())).nelts as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s__bindgen_ty_2),
            "::",
            stringify!(nelts)
        )
    );
}
#[test]
fn bindgen_test_layout_uv_loop_s() {
    assert_eq!(
        ::std::mem::size_of::<uv_loop_s>(),
        816usize,
        concat!("Size of: ", stringify!(uv_loop_s))
    );
    assert_eq!(
        ::std::mem::align_of::<uv_loop_s>(),
        8usize,
        concat!("Alignment of ", stringify!(uv_loop_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).active_handles as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(active_handles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).handle_queue as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(handle_queue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).active_reqs as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(active_reqs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).internal_fields as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(internal_fields)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).stop_flag as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(stop_flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).reserved as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).flags as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).backend_fd as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(backend_fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).pending_queue as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(pending_queue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).watcher_queue as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(watcher_queue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).watchers as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(watchers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).nwatchers as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(nwatchers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).nfds as *const _ as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(nfds)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).wq as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(wq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).wq_mutex as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(wq_mutex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).wq_async as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(wq_async)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).cloexec_lock as *const _ as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(cloexec_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).closing_handles as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(closing_handles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).process_handles as *const _ as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(process_handles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).prepare_handles as *const _ as usize },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(prepare_handles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).check_handles as *const _ as usize },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(check_handles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).idle_handles as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(idle_handles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).async_handles as *const _ as usize },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(async_handles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).async_unused as *const _ as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(async_unused)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).async_io_watcher as *const _ as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(async_io_watcher)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).async_wfd as *const _ as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(async_wfd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).timer_heap as *const _ as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(timer_heap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).timer_counter as *const _ as usize },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(timer_counter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).time as *const _ as usize },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).signal_pipefd as *const _ as usize },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(signal_pipefd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).signal_io_watcher as *const _ as usize },
        560usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(signal_io_watcher)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).child_watcher as *const _ as usize },
        616usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(child_watcher)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).emfile_fd as *const _ as usize },
        736usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(emfile_fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).inotify_read_watcher as *const _ as usize },
        744usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(inotify_read_watcher)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).inotify_watchers as *const _ as usize },
        800usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(inotify_watchers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).inotify_fd as *const _ as usize },
        808usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(inotify_fd)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct htable_t {
    pub size: usize,
    pub table: *mut *mut ::std::os::raw::c_void,
    pub _space: [*mut ::std::os::raw::c_void; 32usize],
}
#[test]
fn bindgen_test_layout_htable_t() {
    assert_eq!(
        ::std::mem::size_of::<htable_t>(),
        272usize,
        concat!("Size of: ", stringify!(htable_t))
    );
    assert_eq!(
        ::std::mem::align_of::<htable_t>(),
        8usize,
        concat!("Alignment of ", stringify!(htable_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htable_t>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(htable_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htable_t>())).table as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(htable_t),
            "::",
            stringify!(table)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htable_t>()))._space as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(htable_t),
            "::",
            stringify!(_space)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct arraylist_t {
    pub len: usize,
    pub max: usize,
    pub items: *mut *mut ::std::os::raw::c_void,
    pub _space: [*mut ::std::os::raw::c_void; 29usize],
}
#[test]
fn bindgen_test_layout_arraylist_t() {
    assert_eq!(
        ::std::mem::size_of::<arraylist_t>(),
        256usize,
        concat!("Size of: ", stringify!(arraylist_t))
    );
    assert_eq!(
        ::std::mem::align_of::<arraylist_t>(),
        8usize,
        concat!("Alignment of ", stringify!(arraylist_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<arraylist_t>())).len as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(arraylist_t),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<arraylist_t>())).max as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(arraylist_t),
            "::",
            stringify!(max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<arraylist_t>())).items as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(arraylist_t),
            "::",
            stringify!(items)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<arraylist_t>()))._space as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(arraylist_t),
            "::",
            stringify!(_space)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct small_arraylist_t {
    pub len: u32,
    pub max: u32,
    pub items: *mut *mut ::std::os::raw::c_void,
    pub _space: [*mut ::std::os::raw::c_void; 6usize],
}
#[test]
fn bindgen_test_layout_small_arraylist_t() {
    assert_eq!(
        ::std::mem::size_of::<small_arraylist_t>(),
        64usize,
        concat!("Size of: ", stringify!(small_arraylist_t))
    );
    assert_eq!(
        ::std::mem::align_of::<small_arraylist_t>(),
        8usize,
        concat!("Alignment of ", stringify!(small_arraylist_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<small_arraylist_t>())).len as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(small_arraylist_t),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<small_arraylist_t>())).max as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(small_arraylist_t),
            "::",
            stringify!(max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<small_arraylist_t>())).items as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(small_arraylist_t),
            "::",
            stringify!(items)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<small_arraylist_t>()))._space as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(small_arraylist_t),
            "::",
            stringify!(_space)
        )
    );
}
pub type sigjmp_buf = [__jmp_buf_tag; 1usize];
pub type jl_taggedvalue_t = _jl_taggedvalue_t;
pub type jl_tls_states_t = _jl_tls_states_t;
pub type jl_ptls_t = *mut jl_tls_states_t;
extern "C" {
    pub fn jl_get_ptls_states() -> jl_ptls_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_ucontext_t {
    pub uc_mcontext: sigjmp_buf,
}
#[test]
fn bindgen_test_layout_jl_ucontext_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_ucontext_t>(),
        200usize,
        concat!("Size of: ", stringify!(jl_ucontext_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_ucontext_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_ucontext_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_ucontext_t>())).uc_mcontext as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_ucontext_t),
            "::",
            stringify!(uc_mcontext)
        )
    );
}
pub type jl_thread_t = pthread_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_mutex_t {
    pub owner: jl_thread_t,
    pub count: u32,
}
#[test]
fn bindgen_test_layout_jl_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_mutex_t>(),
        16usize,
        concat!("Size of: ", stringify!(jl_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_mutex_t>())).owner as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_mutex_t),
            "::",
            stringify!(owner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_mutex_t>())).count as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_mutex_t),
            "::",
            stringify!(count)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_gc_pool_t {
    pub freelist: *mut jl_taggedvalue_t,
    pub newpages: *mut jl_taggedvalue_t,
    pub osize: u16,
}
#[test]
fn bindgen_test_layout_jl_gc_pool_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_gc_pool_t>(),
        24usize,
        concat!("Size of: ", stringify!(jl_gc_pool_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_gc_pool_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_gc_pool_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_pool_t>())).freelist as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_pool_t),
            "::",
            stringify!(freelist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_pool_t>())).newpages as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_pool_t),
            "::",
            stringify!(newpages)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_pool_t>())).osize as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_pool_t),
            "::",
            stringify!(osize)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_thread_gc_num_t {
    pub allocd: i64,
    pub freed: i64,
    pub malloc: u64,
    pub realloc: u64,
    pub poolalloc: u64,
    pub bigalloc: u64,
    pub freecall: u64,
}
#[test]
fn bindgen_test_layout_jl_thread_gc_num_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_thread_gc_num_t>(),
        56usize,
        concat!("Size of: ", stringify!(jl_thread_gc_num_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_thread_gc_num_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_thread_gc_num_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_gc_num_t>())).allocd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_gc_num_t),
            "::",
            stringify!(allocd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_gc_num_t>())).freed as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_gc_num_t),
            "::",
            stringify!(freed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_gc_num_t>())).malloc as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_gc_num_t),
            "::",
            stringify!(malloc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_gc_num_t>())).realloc as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_gc_num_t),
            "::",
            stringify!(realloc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_gc_num_t>())).poolalloc as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_gc_num_t),
            "::",
            stringify!(poolalloc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_gc_num_t>())).bigalloc as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_gc_num_t),
            "::",
            stringify!(bigalloc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_gc_num_t>())).freecall as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_gc_num_t),
            "::",
            stringify!(freecall)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_thread_heap_t {
    pub weak_refs: arraylist_t,
    pub live_tasks: arraylist_t,
    pub mallocarrays: *mut _mallocarray_t,
    pub mafreelist: *mut _mallocarray_t,
    pub big_objects: *mut _bigval_t,
    pub rem_bindings: arraylist_t,
    pub _remset: [arraylist_t; 2usize],
    pub remset_nptr: ::std::os::raw::c_int,
    pub remset: *mut arraylist_t,
    pub last_remset: *mut arraylist_t,
    pub norm_pools: [jl_gc_pool_t; 41usize],
    pub free_stacks: [arraylist_t; 16usize],
}
#[test]
fn bindgen_test_layout_jl_thread_heap_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_thread_heap_t>(),
        6408usize,
        concat!("Size of: ", stringify!(jl_thread_heap_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_thread_heap_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_thread_heap_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).weak_refs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(weak_refs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).live_tasks as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(live_tasks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).mallocarrays as *const _ as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(mallocarrays)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).mafreelist as *const _ as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(mafreelist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).big_objects as *const _ as usize },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(big_objects)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).rem_bindings as *const _ as usize },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(rem_bindings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>()))._remset as *const _ as usize },
        792usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(_remset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).remset_nptr as *const _ as usize },
        1304usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(remset_nptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).remset as *const _ as usize },
        1312usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(remset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).last_remset as *const _ as usize },
        1320usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(last_remset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).norm_pools as *const _ as usize },
        1328usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(norm_pools)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).free_stacks as *const _ as usize },
        2312usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(free_stacks)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _jl_gc_mark_data {
    _unused: [u8; 0],
}
pub type jl_gc_mark_data_t = _jl_gc_mark_data;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_gc_mark_sp_t {
    pub pc: *mut *mut ::std::os::raw::c_void,
    pub data: *mut jl_gc_mark_data_t,
    pub pc_start: *mut *mut ::std::os::raw::c_void,
    pub pc_end: *mut *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_jl_gc_mark_sp_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_gc_mark_sp_t>(),
        32usize,
        concat!("Size of: ", stringify!(jl_gc_mark_sp_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_gc_mark_sp_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_gc_mark_sp_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_sp_t>())).pc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_sp_t),
            "::",
            stringify!(pc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_sp_t>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_sp_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_sp_t>())).pc_start as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_sp_t),
            "::",
            stringify!(pc_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_sp_t>())).pc_end as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_sp_t),
            "::",
            stringify!(pc_end)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_gc_mark_cache_t {
    pub perm_scanned_bytes: usize,
    pub scanned_bytes: usize,
    pub nbig_obj: usize,
    pub big_obj: [*mut ::std::os::raw::c_void; 1024usize],
    pub stack_lock: jl_mutex_t,
    pub pc_stack: *mut *mut ::std::os::raw::c_void,
    pub pc_stack_end: *mut *mut ::std::os::raw::c_void,
    pub data_stack: *mut jl_gc_mark_data_t,
}
#[test]
fn bindgen_test_layout_jl_gc_mark_cache_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_gc_mark_cache_t>(),
        8256usize,
        concat!("Size of: ", stringify!(jl_gc_mark_cache_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_gc_mark_cache_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_gc_mark_cache_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<jl_gc_mark_cache_t>())).perm_scanned_bytes as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_cache_t),
            "::",
            stringify!(perm_scanned_bytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<jl_gc_mark_cache_t>())).scanned_bytes as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_cache_t),
            "::",
            stringify!(scanned_bytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_cache_t>())).nbig_obj as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_cache_t),
            "::",
            stringify!(nbig_obj)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_cache_t>())).big_obj as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_cache_t),
            "::",
            stringify!(big_obj)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_cache_t>())).stack_lock as *const _ as usize },
        8216usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_cache_t),
            "::",
            stringify!(stack_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_cache_t>())).pc_stack as *const _ as usize },
        8232usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_cache_t),
            "::",
            stringify!(pc_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_cache_t>())).pc_stack_end as *const _ as usize },
        8240usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_cache_t),
            "::",
            stringify!(pc_stack_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_cache_t>())).data_stack as *const _ as usize },
        8248usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_cache_t),
            "::",
            stringify!(data_stack)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_bt_element_t {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _jl_tls_states_t {
    pub pgcstack: *mut _jl_gcframe_t,
    pub world_age: usize,
    pub tid: i16,
    pub rngseed: u64,
    pub safepoint: *mut usize,
    pub sleep_check_state: i8,
    pub gc_state: i8,
    pub in_finalizer: i8,
    pub disable_gc: i8,
    pub heap: jl_thread_heap_t,
    pub gc_num: jl_thread_gc_num_t,
    pub sleep_lock: uv_mutex_t,
    pub wake_signal: uv_cond_t,
    pub defer_signal: sig_atomic_t,
    pub current_task: *mut _jl_task_t,
    pub next_task: *mut _jl_task_t,
    pub root_task: *mut _jl_task_t,
    pub timing_stack: *mut _jl_timing_block_t,
    pub stackbase: *mut ::std::os::raw::c_void,
    pub stacksize: usize,
    pub base_ctx: jl_ucontext_t,
    pub safe_restore: *mut sigjmp_buf,
    pub sig_exception: *mut _jl_value_t,
    pub bt_data: *mut _jl_bt_element_t,
    pub bt_size: usize,
    pub signal_request: sig_atomic_t,
    pub io_wait: sig_atomic_t,
    pub signal_stack: *mut ::std::os::raw::c_void,
    pub system_id: jl_thread_t,
    pub in_pure_callback: ::std::os::raw::c_int,
    pub finalizers_inhibited: ::std::os::raw::c_int,
    pub finalizers: arraylist_t,
    pub gc_cache: jl_gc_mark_cache_t,
    pub sweep_objs: arraylist_t,
    pub gc_mark_sp: jl_gc_mark_sp_t,
    pub previous_exception: *mut _jl_value_t,
    pub locks: small_arraylist_t,
}
#[test]
fn bindgen_test_layout__jl_tls_states_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_tls_states_t>(),
        15792usize,
        concat!("Size of: ", stringify!(_jl_tls_states_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_tls_states_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_tls_states_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).pgcstack as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(pgcstack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).world_age as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(world_age)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).tid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).rngseed as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(rngseed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).safepoint as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(safepoint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_tls_states_t>())).sleep_check_state as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(sleep_check_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).gc_state as *const _ as usize },
        41usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(gc_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).in_finalizer as *const _ as usize },
        42usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(in_finalizer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).disable_gc as *const _ as usize },
        43usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(disable_gc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).heap as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(heap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).gc_num as *const _ as usize },
        6456usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(gc_num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).sleep_lock as *const _ as usize },
        6512usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(sleep_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).wake_signal as *const _ as usize },
        6552usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(wake_signal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).defer_signal as *const _ as usize },
        6600usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(defer_signal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).current_task as *const _ as usize },
        6608usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(current_task)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).next_task as *const _ as usize },
        6616usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(next_task)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).root_task as *const _ as usize },
        6624usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(root_task)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).timing_stack as *const _ as usize },
        6632usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(timing_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).stackbase as *const _ as usize },
        6640usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(stackbase)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).stacksize as *const _ as usize },
        6648usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(stacksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).base_ctx as *const _ as usize },
        6656usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(base_ctx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).safe_restore as *const _ as usize },
        6856usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(safe_restore)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).sig_exception as *const _ as usize },
        6864usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(sig_exception)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).bt_data as *const _ as usize },
        6872usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(bt_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).bt_size as *const _ as usize },
        6880usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(bt_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).signal_request as *const _ as usize },
        6888usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(signal_request)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).io_wait as *const _ as usize },
        6892usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(io_wait)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).signal_stack as *const _ as usize },
        6896usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(signal_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).system_id as *const _ as usize },
        6904usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(system_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_tls_states_t>())).in_pure_callback as *const _ as usize
        },
        6912usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(in_pure_callback)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_tls_states_t>())).finalizers_inhibited as *const _ as usize
        },
        6916usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(finalizers_inhibited)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).finalizers as *const _ as usize },
        6920usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(finalizers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).gc_cache as *const _ as usize },
        7176usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(gc_cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).sweep_objs as *const _ as usize },
        15432usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(sweep_objs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).gc_mark_sp as *const _ as usize },
        15688usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(gc_mark_sp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_tls_states_t>())).previous_exception as *const _ as usize
        },
        15720usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(previous_exception)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).locks as *const _ as usize },
        15728usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(locks)
        )
    );
}
extern "C" {
    pub fn jl_gc_safepoint();
}
pub type jl_value_t = _jl_value_t;
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct _jl_taggedvalue_bits {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 7usize],
}
#[test]
fn bindgen_test_layout__jl_taggedvalue_bits() {
    assert_eq!(
        ::std::mem::size_of::<_jl_taggedvalue_bits>(),
        8usize,
        concat!("Size of: ", stringify!(_jl_taggedvalue_bits))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_taggedvalue_bits>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_taggedvalue_bits))
    );
}
impl _jl_taggedvalue_bits {
    #[inline]
    pub fn gc(&self) -> usize {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u64) }
    }
    #[inline]
    pub fn set_gc(&mut self, val: usize) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(gc: usize) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let gc: u64 = unsafe { ::std::mem::transmute(gc) };
            gc as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _jl_taggedvalue_t {
    pub __bindgen_anon_1: _jl_taggedvalue_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _jl_taggedvalue_t__bindgen_ty_1 {
    pub header: usize,
    pub next: *mut jl_taggedvalue_t,
    pub type_: *mut jl_value_t,
    pub bits: _jl_taggedvalue_bits,
}
#[test]
fn bindgen_test_layout__jl_taggedvalue_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_jl_taggedvalue_t__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(_jl_taggedvalue_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_taggedvalue_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_taggedvalue_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_taggedvalue_t__bindgen_ty_1>())).header as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_taggedvalue_t__bindgen_ty_1),
            "::",
            stringify!(header)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_taggedvalue_t__bindgen_ty_1>())).next as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_taggedvalue_t__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_taggedvalue_t__bindgen_ty_1>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_taggedvalue_t__bindgen_ty_1),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_taggedvalue_t__bindgen_ty_1>())).bits as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_taggedvalue_t__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
}
#[test]
fn bindgen_test_layout__jl_taggedvalue_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_taggedvalue_t>(),
        8usize,
        concat!("Size of: ", stringify!(_jl_taggedvalue_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_taggedvalue_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_taggedvalue_t))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_sym_t {
    pub left: *mut _jl_sym_t,
    pub right: *mut _jl_sym_t,
    pub hash: usize,
}
#[test]
fn bindgen_test_layout__jl_sym_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_sym_t>(),
        24usize,
        concat!("Size of: ", stringify!(_jl_sym_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_sym_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_sym_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_sym_t>())).left as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_sym_t),
            "::",
            stringify!(left)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_sym_t>())).right as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_sym_t),
            "::",
            stringify!(right)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_sym_t>())).hash as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_sym_t),
            "::",
            stringify!(hash)
        )
    );
}
pub type jl_sym_t = _jl_sym_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_svec_t {
    pub length: usize,
}
#[test]
fn bindgen_test_layout_jl_svec_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_svec_t>(),
        8usize,
        concat!("Size of: ", stringify!(jl_svec_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_svec_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_svec_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_svec_t>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_svec_t),
            "::",
            stringify!(length)
        )
    );
}
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct jl_array_flags_t {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout_jl_array_flags_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_array_flags_t>(),
        2usize,
        concat!("Size of: ", stringify!(jl_array_flags_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_array_flags_t>(),
        2usize,
        concat!("Alignment of ", stringify!(jl_array_flags_t))
    );
}
impl jl_array_flags_t {
    #[inline]
    pub fn how(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set_how(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn ndims(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 9u8) as u16) }
    }
    #[inline]
    pub fn set_ndims(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub fn pooled(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_pooled(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ptrarray(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_ptrarray(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hasptr(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_hasptr(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn isshared(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_isshared(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn isaligned(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_isaligned(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        how: u16,
        ndims: u16,
        pooled: u16,
        ptrarray: u16,
        hasptr: u16,
        isshared: u16,
        isaligned: u16,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let how: u16 = unsafe { ::std::mem::transmute(how) };
            how as u64
        });
        __bindgen_bitfield_unit.set(2usize, 9u8, {
            let ndims: u16 = unsafe { ::std::mem::transmute(ndims) };
            ndims as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let pooled: u16 = unsafe { ::std::mem::transmute(pooled) };
            pooled as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let ptrarray: u16 = unsafe { ::std::mem::transmute(ptrarray) };
            ptrarray as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let hasptr: u16 = unsafe { ::std::mem::transmute(hasptr) };
            hasptr as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let isshared: u16 = unsafe { ::std::mem::transmute(isshared) };
            isshared as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let isaligned: u16 = unsafe { ::std::mem::transmute(isaligned) };
            isaligned as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct jl_array_t {
    pub data: *mut ::std::os::raw::c_void,
    pub length: usize,
    pub flags: jl_array_flags_t,
    pub elsize: u16,
    pub offset: u32,
    pub nrows: usize,
    pub __bindgen_anon_1: jl_array_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union jl_array_t__bindgen_ty_1 {
    pub maxsize: usize,
    pub ncols: usize,
}
#[test]
fn bindgen_test_layout_jl_array_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<jl_array_t__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(jl_array_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_array_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_array_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<jl_array_t__bindgen_ty_1>())).maxsize as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_array_t__bindgen_ty_1),
            "::",
            stringify!(maxsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_array_t__bindgen_ty_1>())).ncols as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_array_t__bindgen_ty_1),
            "::",
            stringify!(ncols)
        )
    );
}
#[test]
fn bindgen_test_layout_jl_array_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_array_t>(),
        40usize,
        concat!("Size of: ", stringify!(jl_array_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_array_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_array_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_array_t>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_array_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_array_t>())).length as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_array_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_array_t>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_array_t),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_array_t>())).elsize as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_array_t),
            "::",
            stringify!(elsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_array_t>())).offset as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_array_t),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_array_t>())).nrows as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_array_t),
            "::",
            stringify!(nrows)
        )
    );
}
pub type jl_tupletype_t = _jl_datatype_t;
pub type jl_typemap_t = jl_value_t;
pub type jl_call_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut jl_value_t,
        arg2: *mut *mut jl_value_t,
        arg3: u32,
        arg4: *mut _jl_code_instance_t,
    ) -> *mut jl_value_t,
>;
pub type jl_callptr_t = jl_call_t;
pub type jl_fptr_args_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut jl_value_t,
        arg2: *mut *mut jl_value_t,
        arg3: u32,
    ) -> *mut jl_value_t,
>;
pub type jl_fptr_sparam_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut jl_value_t,
        arg2: *mut *mut jl_value_t,
        arg3: u32,
        arg4: *mut jl_svec_t,
    ) -> *mut jl_value_t,
>;
#[repr(C)]
#[derive(Copy, Clone)]
pub union jl_generic_specptr_t {
    pub fptr: *mut ::std::os::raw::c_void,
    pub fptr1: jl_fptr_args_t,
    pub fptr3: jl_fptr_sparam_t,
}
#[test]
fn bindgen_test_layout_jl_generic_specptr_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_generic_specptr_t>(),
        8usize,
        concat!("Size of: ", stringify!(jl_generic_specptr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_generic_specptr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_generic_specptr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_generic_specptr_t>())).fptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_generic_specptr_t),
            "::",
            stringify!(fptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_generic_specptr_t>())).fptr1 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_generic_specptr_t),
            "::",
            stringify!(fptr1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_generic_specptr_t>())).fptr3 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_generic_specptr_t),
            "::",
            stringify!(fptr3)
        )
    );
}
pub type jl_method_instance_t = _jl_method_instance_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_method_t {
    pub name: *mut jl_sym_t,
    pub module: *mut _jl_module_t,
    pub file: *mut jl_sym_t,
    pub line: i32,
    pub primary_world: usize,
    pub deleted_world: usize,
    pub sig: *mut jl_value_t,
    pub specializations: *mut jl_svec_t,
    pub speckeyset: *mut jl_array_t,
    pub slot_syms: *mut jl_value_t,
    pub source: *mut jl_value_t,
    pub unspecialized: *mut _jl_method_instance_t,
    pub generator: *mut jl_value_t,
    pub roots: *mut jl_array_t,
    pub ccallable: *mut jl_svec_t,
    pub invokes: *mut jl_typemap_t,
    pub nargs: i32,
    pub called: i32,
    pub nospecialize: i32,
    pub nkw: i32,
    pub isva: u8,
    pub pure_: u8,
    pub writelock: jl_mutex_t,
}
#[test]
fn bindgen_test_layout__jl_method_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_method_t>(),
        168usize,
        concat!("Size of: ", stringify!(_jl_method_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_method_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_method_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).module as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).file as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).line as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).primary_world as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(primary_world)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).deleted_world as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(deleted_world)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).sig as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).specializations as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(specializations)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).speckeyset as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(speckeyset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).slot_syms as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(slot_syms)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).source as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(source)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).unspecialized as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(unspecialized)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).generator as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(generator)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).roots as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(roots)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).ccallable as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(ccallable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).invokes as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(invokes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).nargs as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(nargs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).called as *const _ as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(called)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).nospecialize as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(nospecialize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).nkw as *const _ as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(nkw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).isva as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(isva)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).pure_ as *const _ as usize },
        145usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(pure_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).writelock as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(writelock)
        )
    );
}
pub type jl_method_t = _jl_method_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _jl_method_instance_t {
    pub def: _jl_method_instance_t__bindgen_ty_1,
    pub specTypes: *mut jl_value_t,
    pub sparam_vals: *mut jl_svec_t,
    pub uninferred: *mut jl_value_t,
    pub backedges: *mut jl_array_t,
    pub callbacks: *mut jl_array_t,
    pub cache: *mut _jl_code_instance_t,
    pub inInference: u8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _jl_method_instance_t__bindgen_ty_1 {
    pub value: *mut jl_value_t,
    pub module: *mut _jl_module_t,
    pub method: *mut jl_method_t,
}
#[test]
fn bindgen_test_layout__jl_method_instance_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_jl_method_instance_t__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(_jl_method_instance_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_method_instance_t__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(_jl_method_instance_t__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_method_instance_t__bindgen_ty_1>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_method_instance_t__bindgen_ty_1>())).module as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t__bindgen_ty_1),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_method_instance_t__bindgen_ty_1>())).method as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t__bindgen_ty_1),
            "::",
            stringify!(method)
        )
    );
}
#[test]
fn bindgen_test_layout__jl_method_instance_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_method_instance_t>(),
        64usize,
        concat!("Size of: ", stringify!(_jl_method_instance_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_method_instance_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_method_instance_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_instance_t>())).def as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t),
            "::",
            stringify!(def)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_instance_t>())).specTypes as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t),
            "::",
            stringify!(specTypes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_method_instance_t>())).sparam_vals as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t),
            "::",
            stringify!(sparam_vals)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_method_instance_t>())).uninferred as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t),
            "::",
            stringify!(uninferred)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_instance_t>())).backedges as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t),
            "::",
            stringify!(backedges)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_instance_t>())).callbacks as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t),
            "::",
            stringify!(callbacks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_instance_t>())).cache as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t),
            "::",
            stringify!(cache)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_method_instance_t>())).inInference as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t),
            "::",
            stringify!(inInference)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _jl_code_instance_t {
    pub def: *mut jl_method_instance_t,
    pub next: *mut _jl_code_instance_t,
    pub min_world: usize,
    pub max_world: usize,
    pub rettype: *mut jl_value_t,
    pub rettype_const: *mut jl_value_t,
    pub inferred: *mut jl_value_t,
    pub isspecsig: u8,
    pub precompile: u8,
    pub invoke: jl_callptr_t,
    pub specptr: jl_generic_specptr_t,
}
#[test]
fn bindgen_test_layout__jl_code_instance_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_code_instance_t>(),
        80usize,
        concat!("Size of: ", stringify!(_jl_code_instance_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_code_instance_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_code_instance_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).def as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(def)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).min_world as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(min_world)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).max_world as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(max_world)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).rettype as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(rettype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_code_instance_t>())).rettype_const as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(rettype_const)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).inferred as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(inferred)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).isspecsig as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(isspecsig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).precompile as *const _ as usize },
        57usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(precompile)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).invoke as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(invoke)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).specptr as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(specptr)
        )
    );
}
pub type jl_code_instance_t = _jl_code_instance_t;
pub type jl_function_t = jl_value_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_tvar_t {
    pub name: *mut jl_sym_t,
    pub lb: *mut jl_value_t,
    pub ub: *mut jl_value_t,
}
#[test]
fn bindgen_test_layout_jl_tvar_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_tvar_t>(),
        24usize,
        concat!("Size of: ", stringify!(jl_tvar_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_tvar_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_tvar_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_tvar_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_tvar_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_tvar_t>())).lb as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_tvar_t),
            "::",
            stringify!(lb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_tvar_t>())).ub as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_tvar_t),
            "::",
            stringify!(ub)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_unionall_t {
    pub var: *mut jl_tvar_t,
    pub body: *mut jl_value_t,
}
#[test]
fn bindgen_test_layout_jl_unionall_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_unionall_t>(),
        16usize,
        concat!("Size of: ", stringify!(jl_unionall_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_unionall_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_unionall_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_unionall_t>())).var as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_unionall_t),
            "::",
            stringify!(var)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_unionall_t>())).body as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_unionall_t),
            "::",
            stringify!(body)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_typename_t {
    pub name: *mut jl_sym_t,
    pub module: *mut _jl_module_t,
    pub names: *mut jl_svec_t,
    pub wrapper: *mut jl_value_t,
    pub cache: *mut jl_svec_t,
    pub linearcache: *mut jl_svec_t,
    pub hash: isize,
    pub mt: *mut _jl_methtable_t,
    pub partial: *mut jl_array_t,
}
#[test]
fn bindgen_test_layout_jl_typename_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_typename_t>(),
        72usize,
        concat!("Size of: ", stringify!(jl_typename_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_typename_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_typename_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).module as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).names as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(names)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).wrapper as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(wrapper)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).cache as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).linearcache as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(linearcache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).hash as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).mt as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(mt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).partial as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(partial)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_uniontype_t {
    pub a: *mut jl_value_t,
    pub b: *mut jl_value_t,
}
#[test]
fn bindgen_test_layout_jl_uniontype_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_uniontype_t>(),
        16usize,
        concat!("Size of: ", stringify!(jl_uniontype_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_uniontype_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_uniontype_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_uniontype_t>())).a as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_uniontype_t),
            "::",
            stringify!(a)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_uniontype_t>())).b as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_uniontype_t),
            "::",
            stringify!(b)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_fielddesc8_t {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub offset: u8,
}
#[test]
fn bindgen_test_layout_jl_fielddesc8_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_fielddesc8_t>(),
        2usize,
        concat!("Size of: ", stringify!(jl_fielddesc8_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_fielddesc8_t>(),
        1usize,
        concat!("Alignment of ", stringify!(jl_fielddesc8_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_fielddesc8_t>())).offset as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_fielddesc8_t),
            "::",
            stringify!(offset)
        )
    );
}
impl jl_fielddesc8_t {
    #[inline]
    pub fn isptr(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_isptr(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn size(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 7u8) as u8) }
    }
    #[inline]
    pub fn set_size(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(isptr: u8, size: u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let isptr: u8 = unsafe { ::std::mem::transmute(isptr) };
            isptr as u64
        });
        __bindgen_bitfield_unit.set(1usize, 7u8, {
            let size: u8 = unsafe { ::std::mem::transmute(size) };
            size as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_fielddesc16_t {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub offset: u16,
}
#[test]
fn bindgen_test_layout_jl_fielddesc16_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_fielddesc16_t>(),
        4usize,
        concat!("Size of: ", stringify!(jl_fielddesc16_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_fielddesc16_t>(),
        2usize,
        concat!("Alignment of ", stringify!(jl_fielddesc16_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_fielddesc16_t>())).offset as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_fielddesc16_t),
            "::",
            stringify!(offset)
        )
    );
}
impl jl_fielddesc16_t {
    #[inline]
    pub fn isptr(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_isptr(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn size(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 15u8) as u16) }
    }
    #[inline]
    pub fn set_size(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(isptr: u16, size: u16) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let isptr: u16 = unsafe { ::std::mem::transmute(isptr) };
            isptr as u64
        });
        __bindgen_bitfield_unit.set(1usize, 15u8, {
            let size: u16 = unsafe { ::std::mem::transmute(size) };
            size as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_fielddesc32_t {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub offset: u32,
}
#[test]
fn bindgen_test_layout_jl_fielddesc32_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_fielddesc32_t>(),
        8usize,
        concat!("Size of: ", stringify!(jl_fielddesc32_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_fielddesc32_t>(),
        4usize,
        concat!("Alignment of ", stringify!(jl_fielddesc32_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_fielddesc32_t>())).offset as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_fielddesc32_t),
            "::",
            stringify!(offset)
        )
    );
}
impl jl_fielddesc32_t {
    #[inline]
    pub fn isptr(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_isptr(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn size(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set_size(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(isptr: u32, size: u32) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let isptr: u32 = unsafe { ::std::mem::transmute(isptr) };
            isptr as u64
        });
        __bindgen_bitfield_unit.set(1usize, 31u8, {
            let size: u32 = unsafe { ::std::mem::transmute(size) };
            size as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_datatype_layout_t {
    pub nfields: u32,
    pub npointers: u32,
    pub first_ptr: i32,
    pub alignment: u16,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: u8,
}
#[test]
fn bindgen_test_layout_jl_datatype_layout_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_datatype_layout_t>(),
        16usize,
        concat!("Size of: ", stringify!(jl_datatype_layout_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_datatype_layout_t>(),
        4usize,
        concat!("Alignment of ", stringify!(jl_datatype_layout_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_datatype_layout_t>())).nfields as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_datatype_layout_t),
            "::",
            stringify!(nfields)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_datatype_layout_t>())).npointers as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_datatype_layout_t),
            "::",
            stringify!(npointers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_datatype_layout_t>())).first_ptr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_datatype_layout_t),
            "::",
            stringify!(first_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_datatype_layout_t>())).alignment as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_datatype_layout_t),
            "::",
            stringify!(alignment)
        )
    );
}
impl jl_datatype_layout_t {
    #[inline]
    pub fn haspadding(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_haspadding(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fielddesc_type(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set_fielddesc_type(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        haspadding: u16,
        fielddesc_type: u16,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let haspadding: u16 = unsafe { ::std::mem::transmute(haspadding) };
            haspadding as u64
        });
        __bindgen_bitfield_unit.set(1usize, 2u8, {
            let fielddesc_type: u16 = unsafe { ::std::mem::transmute(fielddesc_type) };
            fielddesc_type as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_datatype_t {
    pub name: *mut jl_typename_t,
    pub super_: *mut _jl_datatype_t,
    pub parameters: *mut jl_svec_t,
    pub types: *mut jl_svec_t,
    pub names: *mut jl_svec_t,
    pub instance: *mut jl_value_t,
    pub layout: *const jl_datatype_layout_t,
    pub size: i32,
    pub ninitialized: i32,
    pub hash: u32,
    pub abstract_: u8,
    pub mutabl: u8,
    pub hasfreetypevars: u8,
    pub isconcretetype: u8,
    pub isdispatchtuple: u8,
    pub isbitstype: u8,
    pub zeroinit: u8,
    pub isinlinealloc: u8,
    pub has_concrete_subtype: u8,
    pub cached_by_hash: u8,
}
#[test]
fn bindgen_test_layout__jl_datatype_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_datatype_t>(),
        80usize,
        concat!("Size of: ", stringify!(_jl_datatype_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_datatype_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_datatype_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).super_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(super_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).parameters as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(parameters)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).types as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(types)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).names as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(names)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).instance as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).layout as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(layout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).ninitialized as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(ninitialized)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).hash as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).abstract_ as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(abstract_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).mutabl as *const _ as usize },
        69usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(mutabl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).hasfreetypevars as *const _ as usize },
        70usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(hasfreetypevars)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).isconcretetype as *const _ as usize },
        71usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(isconcretetype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).isdispatchtuple as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(isdispatchtuple)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).isbitstype as *const _ as usize },
        73usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(isbitstype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).zeroinit as *const _ as usize },
        74usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(zeroinit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).isinlinealloc as *const _ as usize },
        75usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(isinlinealloc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_datatype_t>())).has_concrete_subtype as *const _ as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(has_concrete_subtype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).cached_by_hash as *const _ as usize },
        77usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(cached_by_hash)
        )
    );
}
pub type jl_datatype_t = _jl_datatype_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_weakref_t {
    pub value: *mut jl_value_t,
}
#[test]
fn bindgen_test_layout_jl_weakref_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_weakref_t>(),
        8usize,
        concat!("Size of: ", stringify!(jl_weakref_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_weakref_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_weakref_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_weakref_t>())).value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_weakref_t),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_uuid_t {
    pub hi: u64,
    pub lo: u64,
}
#[test]
fn bindgen_test_layout_jl_uuid_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_uuid_t>(),
        16usize,
        concat!("Size of: ", stringify!(jl_uuid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_uuid_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_uuid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_uuid_t>())).hi as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_uuid_t),
            "::",
            stringify!(hi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_uuid_t>())).lo as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_uuid_t),
            "::",
            stringify!(lo)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_module_t {
    pub name: *mut jl_sym_t,
    pub parent: *mut _jl_module_t,
    pub bindings: htable_t,
    pub usings: arraylist_t,
    pub build_id: u64,
    pub uuid: jl_uuid_t,
    pub primary_world: usize,
    pub counter: u32,
    pub nospecialize: i32,
    pub optlevel: i8,
    pub compile: i8,
    pub infer: i8,
    pub istopmod: u8,
    pub lock: jl_mutex_t,
}
#[test]
fn bindgen_test_layout__jl_module_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_module_t>(),
        608usize,
        concat!("Size of: ", stringify!(_jl_module_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_module_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_module_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).parent as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).bindings as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(bindings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).usings as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(usings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).build_id as *const _ as usize },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(build_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).uuid as *const _ as usize },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).primary_world as *const _ as usize },
        568usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(primary_world)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).counter as *const _ as usize },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(counter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).nospecialize as *const _ as usize },
        580usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(nospecialize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).optlevel as *const _ as usize },
        584usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(optlevel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).compile as *const _ as usize },
        585usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(compile)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).infer as *const _ as usize },
        586usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(infer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).istopmod as *const _ as usize },
        587usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(istopmod)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).lock as *const _ as usize },
        592usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(lock)
        )
    );
}
pub type jl_module_t = _jl_module_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _jl_typemap_entry_t {
    pub next: *mut _jl_typemap_entry_t,
    pub sig: *mut jl_tupletype_t,
    pub simplesig: *mut jl_tupletype_t,
    pub guardsigs: *mut jl_svec_t,
    pub min_world: usize,
    pub max_world: usize,
    pub func: _jl_typemap_entry_t__bindgen_ty_1,
    pub isleafsig: i8,
    pub issimplesig: i8,
    pub va: i8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _jl_typemap_entry_t__bindgen_ty_1 {
    pub value: *mut jl_value_t,
    pub linfo: *mut jl_method_instance_t,
    pub method: *mut jl_method_t,
}
#[test]
fn bindgen_test_layout__jl_typemap_entry_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_jl_typemap_entry_t__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(_jl_typemap_entry_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_typemap_entry_t__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(_jl_typemap_entry_t__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_typemap_entry_t__bindgen_ty_1>())).value as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_typemap_entry_t__bindgen_ty_1>())).linfo as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t__bindgen_ty_1),
            "::",
            stringify!(linfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_typemap_entry_t__bindgen_ty_1>())).method as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t__bindgen_ty_1),
            "::",
            stringify!(method)
        )
    );
}
#[test]
fn bindgen_test_layout__jl_typemap_entry_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_typemap_entry_t>(),
        64usize,
        concat!("Size of: ", stringify!(_jl_typemap_entry_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_typemap_entry_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_typemap_entry_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).sig as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).simplesig as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(simplesig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).guardsigs as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(guardsigs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).min_world as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(min_world)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).max_world as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(max_world)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).func as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(func)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).isleafsig as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(isleafsig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).issimplesig as *const _ as usize },
        57usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(issimplesig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).va as *const _ as usize },
        58usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(va)
        )
    );
}
pub type jl_typemap_entry_t = _jl_typemap_entry_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_typemap_level_t {
    pub arg1: *mut jl_array_t,
    pub targ: *mut jl_array_t,
    pub name1: *mut jl_array_t,
    pub tname: *mut jl_array_t,
    pub linear: *mut jl_typemap_entry_t,
    pub any: *mut jl_typemap_t,
}
#[test]
fn bindgen_test_layout__jl_typemap_level_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_typemap_level_t>(),
        48usize,
        concat!("Size of: ", stringify!(_jl_typemap_level_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_typemap_level_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_typemap_level_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_level_t>())).arg1 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_level_t),
            "::",
            stringify!(arg1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_level_t>())).targ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_level_t),
            "::",
            stringify!(targ)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_level_t>())).name1 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_level_t),
            "::",
            stringify!(name1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_level_t>())).tname as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_level_t),
            "::",
            stringify!(tname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_level_t>())).linear as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_level_t),
            "::",
            stringify!(linear)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_level_t>())).any as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_level_t),
            "::",
            stringify!(any)
        )
    );
}
pub type jl_typemap_level_t = _jl_typemap_level_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_methtable_t {
    pub name: *mut jl_sym_t,
    pub defs: *mut jl_typemap_t,
    pub leafcache: *mut jl_array_t,
    pub cache: *mut jl_typemap_t,
    pub max_args: isize,
    pub kwsorter: *mut jl_value_t,
    pub module: *mut jl_module_t,
    pub backedges: *mut jl_array_t,
    pub writelock: jl_mutex_t,
    pub offs: u8,
    pub frozen: u8,
}
#[test]
fn bindgen_test_layout__jl_methtable_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_methtable_t>(),
        88usize,
        concat!("Size of: ", stringify!(_jl_methtable_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_methtable_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_methtable_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).defs as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(defs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).leafcache as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(leafcache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).cache as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).max_args as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(max_args)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).kwsorter as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(kwsorter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).module as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).backedges as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(backedges)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).writelock as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(writelock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).offs as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(offs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).frozen as *const _ as usize },
        81usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(frozen)
        )
    );
}
pub type jl_methtable_t = _jl_methtable_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_expr_t {
    pub head: *mut jl_sym_t,
    pub args: *mut jl_array_t,
}
#[test]
fn bindgen_test_layout_jl_expr_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_expr_t>(),
        16usize,
        concat!("Size of: ", stringify!(jl_expr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_expr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_expr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_expr_t>())).head as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_expr_t),
            "::",
            stringify!(head)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_expr_t>())).args as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_expr_t),
            "::",
            stringify!(args)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_method_match_t {
    pub spec_types: *mut jl_tupletype_t,
    pub sparams: *mut jl_svec_t,
    pub method: *mut jl_method_t,
    pub fully_covers: u8,
}
#[test]
fn bindgen_test_layout_jl_method_match_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_method_match_t>(),
        32usize,
        concat!("Size of: ", stringify!(jl_method_match_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_method_match_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_method_match_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_method_match_t>())).spec_types as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_method_match_t),
            "::",
            stringify!(spec_types)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_method_match_t>())).sparams as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_method_match_t),
            "::",
            stringify!(sparams)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_method_match_t>())).method as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_method_match_t),
            "::",
            stringify!(method)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_method_match_t>())).fully_covers as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_method_match_t),
            "::",
            stringify!(fully_covers)
        )
    );
}
extern "C" {
    pub static mut jl_typeofbottom_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_datatype_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_uniontype_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_unionall_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_tvar_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_any_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_type_type: *mut jl_unionall_t;
}
extern "C" {
    pub static mut jl_typename_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_type_typename: *mut jl_typename_t;
}
extern "C" {
    pub static mut jl_symbol_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_ssavalue_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_abstractslot_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_slotnumber_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_typedslot_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_argument_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_const_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_partial_struct_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_method_match_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_simplevector_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_tuple_typename: *mut jl_typename_t;
}
extern "C" {
    pub static mut jl_vecelement_typename: *mut jl_typename_t;
}
extern "C" {
    pub static mut jl_anytuple_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_emptytuple_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_anytuple_type_type: *mut jl_unionall_t;
}
extern "C" {
    pub static mut jl_vararg_type: *mut jl_unionall_t;
}
extern "C" {
    pub static mut jl_vararg_typename: *mut jl_typename_t;
}
extern "C" {
    pub static mut jl_function_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_builtin_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_bottom_type: *mut jl_value_t;
}
extern "C" {
    pub static mut jl_method_instance_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_code_instance_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_code_info_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_method_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_module_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_abstractarray_type: *mut jl_unionall_t;
}
extern "C" {
    pub static mut jl_densearray_type: *mut jl_unionall_t;
}
extern "C" {
    pub static mut jl_array_type: *mut jl_unionall_t;
}
extern "C" {
    pub static mut jl_array_typename: *mut jl_typename_t;
}
extern "C" {
    pub static mut jl_weakref_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_abstractstring_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_string_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_errorexception_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_argumenterror_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_loaderror_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_initerror_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_typeerror_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_methoderror_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_undefvarerror_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_lineinfonode_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_stackovf_exception: *mut jl_value_t;
}
extern "C" {
    pub static mut jl_memory_exception: *mut jl_value_t;
}
extern "C" {
    pub static mut jl_readonlymemory_exception: *mut jl_value_t;
}
extern "C" {
    pub static mut jl_diverror_exception: *mut jl_value_t;
}
extern "C" {
    pub static mut jl_undefref_exception: *mut jl_value_t;
}
extern "C" {
    pub static mut jl_interrupt_exception: *mut jl_value_t;
}
extern "C" {
    pub static mut jl_boundserror_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_an_empty_vec_any: *mut jl_value_t;
}
extern "C" {
    pub static mut jl_an_empty_string: *mut jl_value_t;
}
extern "C" {
    pub static mut jl_bool_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_char_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_int8_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_uint8_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_int16_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_uint16_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_int32_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_uint32_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_int64_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_uint64_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_float16_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_float32_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_float64_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_floatingpoint_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_number_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_nothing_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_signed_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_voidpointer_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_pointer_type: *mut jl_unionall_t;
}
extern "C" {
    pub static mut jl_llvmpointer_type: *mut jl_unionall_t;
}
extern "C" {
    pub static mut jl_ref_type: *mut jl_unionall_t;
}
extern "C" {
    pub static mut jl_pointer_typename: *mut jl_typename_t;
}
extern "C" {
    pub static mut jl_llvmpointer_typename: *mut jl_typename_t;
}
extern "C" {
    pub static mut jl_namedtuple_typename: *mut jl_typename_t;
}
extern "C" {
    pub static mut jl_namedtuple_type: *mut jl_unionall_t;
}
extern "C" {
    pub static mut jl_task_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_array_uint8_type: *mut jl_value_t;
}
extern "C" {
    pub static mut jl_array_any_type: *mut jl_value_t;
}
extern "C" {
    pub static mut jl_array_symbol_type: *mut jl_value_t;
}
extern "C" {
    pub static mut jl_array_int32_type: *mut jl_value_t;
}
extern "C" {
    pub static mut jl_expr_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_globalref_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_linenumbernode_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_gotonode_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_gotoifnot_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_returnnode_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_phinode_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_pinode_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_phicnode_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_upsilonnode_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_quotenode_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_newvarnode_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_intrinsic_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_methtable_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_typemap_level_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_typemap_entry_type: *mut jl_datatype_t;
}
extern "C" {
    pub static mut jl_emptysvec: *mut jl_svec_t;
}
extern "C" {
    pub static mut jl_emptytuple: *mut jl_value_t;
}
extern "C" {
    pub static mut jl_true: *mut jl_value_t;
}
extern "C" {
    pub static mut jl_false: *mut jl_value_t;
}
extern "C" {
    pub static mut jl_nothing: *mut jl_value_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_gcframe_t {
    pub nroots: usize,
    pub prev: *mut _jl_gcframe_t,
}
#[test]
fn bindgen_test_layout__jl_gcframe_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_gcframe_t>(),
        16usize,
        concat!("Size of: ", stringify!(_jl_gcframe_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_gcframe_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_gcframe_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_gcframe_t>())).nroots as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_gcframe_t),
            "::",
            stringify!(nroots)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_gcframe_t>())).prev as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_gcframe_t),
            "::",
            stringify!(prev)
        )
    );
}
pub type jl_gcframe_t = _jl_gcframe_t;
extern "C" {
    pub fn jl_gc_enable(on: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jl_gc_is_enabled() -> ::std::os::raw::c_int;
}
pub const jl_gc_collection_t_JL_GC_AUTO: jl_gc_collection_t = 0;
pub const jl_gc_collection_t_JL_GC_FULL: jl_gc_collection_t = 1;
pub const jl_gc_collection_t_JL_GC_INCREMENTAL: jl_gc_collection_t = 2;
pub type jl_gc_collection_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn jl_gc_collect(arg1: jl_gc_collection_t);
}
extern "C" {
    pub fn jl_gc_add_finalizer(v: *mut jl_value_t, f: *mut jl_function_t);
}
extern "C" {
    pub fn jl_gc_add_ptr_finalizer(
        ptls: jl_ptls_t,
        v: *mut jl_value_t,
        f: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn jl_gc_queue_root(root: *mut jl_value_t);
}
extern "C" {
    pub fn jl_array_typetagdata(a: *mut jl_array_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn jl_compute_fieldtypes(
        st: *mut jl_datatype_t,
        stack: *mut ::std::os::raw::c_void,
    ) -> *mut jl_svec_t;
}
extern "C" {
    pub fn jl_subtype(a: *mut jl_value_t, b: *mut jl_value_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jl_egal(a: *mut jl_value_t, b: *mut jl_value_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jl_object_id(v: *mut jl_value_t) -> usize;
}
extern "C" {
    pub fn jl_isa(a: *mut jl_value_t, t: *mut jl_value_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jl_type_union(ts: *mut *mut jl_value_t, n: usize) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_type_unionall(v: *mut jl_tvar_t, body: *mut jl_value_t) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_typename_str(v: *mut jl_value_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn jl_typeof_str(v: *mut jl_value_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn jl_new_typevar(
        name: *mut jl_sym_t,
        lb: *mut jl_value_t,
        ub: *mut jl_value_t,
    ) -> *mut jl_tvar_t;
}
extern "C" {
    pub fn jl_apply_type(
        tc: *mut jl_value_t,
        params: *mut *mut jl_value_t,
        n: usize,
    ) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_apply_tuple_type_v(p: *mut *mut jl_value_t, np: usize) -> *mut jl_tupletype_t;
}
extern "C" {
    pub fn jl_new_structv(
        type_: *mut jl_datatype_t,
        args: *mut *mut jl_value_t,
        na: u32,
    ) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_new_struct_uninit(type_: *mut jl_datatype_t) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_alloc_svec(n: usize) -> *mut jl_svec_t;
}
extern "C" {
    pub fn jl_alloc_svec_uninit(n: usize) -> *mut jl_svec_t;
}
extern "C" {
    pub fn jl_symbol(str_: *const ::std::os::raw::c_char) -> *mut jl_sym_t;
}
extern "C" {
    pub fn jl_symbol_n(str_: *const ::std::os::raw::c_char, len: usize) -> *mut jl_sym_t;
}
extern "C" {
    pub fn jl_get_kwsorter(ty: *mut jl_value_t) -> *mut jl_function_t;
}
extern "C" {
    pub fn jl_box_bool(x: i8) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_box_int8(x: i8) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_box_uint8(x: u8) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_box_int16(x: i16) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_box_uint16(x: u16) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_box_int32(x: i32) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_box_uint32(x: u32) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_box_char(x: u32) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_box_int64(x: i64) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_box_uint64(x: u64) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_box_float32(x: f32) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_box_float64(x: f64) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_box_voidpointer(x: *mut ::std::os::raw::c_void) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_unbox_int8(v: *mut jl_value_t) -> i8;
}
extern "C" {
    pub fn jl_unbox_uint8(v: *mut jl_value_t) -> u8;
}
extern "C" {
    pub fn jl_unbox_int16(v: *mut jl_value_t) -> i16;
}
extern "C" {
    pub fn jl_unbox_uint16(v: *mut jl_value_t) -> u16;
}
extern "C" {
    pub fn jl_unbox_int32(v: *mut jl_value_t) -> i32;
}
extern "C" {
    pub fn jl_unbox_uint32(v: *mut jl_value_t) -> u32;
}
extern "C" {
    pub fn jl_unbox_int64(v: *mut jl_value_t) -> i64;
}
extern "C" {
    pub fn jl_unbox_uint64(v: *mut jl_value_t) -> u64;
}
extern "C" {
    pub fn jl_unbox_float32(v: *mut jl_value_t) -> f32;
}
extern "C" {
    pub fn jl_unbox_float64(v: *mut jl_value_t) -> f64;
}
extern "C" {
    pub fn jl_unbox_voidpointer(v: *mut jl_value_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn jl_field_index(
        t: *mut jl_datatype_t,
        fld: *mut jl_sym_t,
        err: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jl_get_nth_field(v: *mut jl_value_t, i: usize) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_get_nth_field_noalloc(v: *mut jl_value_t, i: usize) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_set_nth_field(v: *mut jl_value_t, i: usize, rhs: *mut jl_value_t);
}
extern "C" {
    pub fn jl_islayout_inline(
        eltype: *mut jl_value_t,
        fsz: *mut usize,
        al: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jl_new_array(atype: *mut jl_value_t, dims: *mut jl_value_t) -> *mut jl_array_t;
}
extern "C" {
    pub fn jl_ptr_to_array_1d(
        atype: *mut jl_value_t,
        data: *mut ::std::os::raw::c_void,
        nel: usize,
        own_buffer: ::std::os::raw::c_int,
    ) -> *mut jl_array_t;
}
extern "C" {
    pub fn jl_ptr_to_array(
        atype: *mut jl_value_t,
        data: *mut ::std::os::raw::c_void,
        dims: *mut jl_value_t,
        own_buffer: ::std::os::raw::c_int,
    ) -> *mut jl_array_t;
}
extern "C" {
    pub fn jl_alloc_array_1d(atype: *mut jl_value_t, nr: usize) -> *mut jl_array_t;
}
extern "C" {
    pub fn jl_alloc_array_2d(atype: *mut jl_value_t, nr: usize, nc: usize) -> *mut jl_array_t;
}
extern "C" {
    pub fn jl_alloc_array_3d(
        atype: *mut jl_value_t,
        nr: usize,
        nc: usize,
        z: usize,
    ) -> *mut jl_array_t;
}
extern "C" {
    pub fn jl_pchar_to_array(str_: *const ::std::os::raw::c_char, len: usize) -> *mut jl_array_t;
}
extern "C" {
    pub fn jl_pchar_to_string(str_: *const ::std::os::raw::c_char, len: usize) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_apply_array_type(type_: *mut jl_value_t, dim: usize) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_array_eltype(a: *mut jl_value_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub static mut jl_main_module: *mut jl_module_t;
}
extern "C" {
    pub static mut jl_core_module: *mut jl_module_t;
}
extern "C" {
    pub static mut jl_base_module: *mut jl_module_t;
}
extern "C" {
    pub fn jl_get_global(m: *mut jl_module_t, var: *mut jl_sym_t) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_set_global(m: *mut jl_module_t, var: *mut jl_sym_t, val: *mut jl_value_t);
}
extern "C" {
    pub fn jl_set_const(m: *mut jl_module_t, var: *mut jl_sym_t, val: *mut jl_value_t);
}
extern "C" {
    pub fn jl_is_imported(m: *mut jl_module_t, s: *mut jl_sym_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jl_cpu_threads() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jl_getpagesize() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn jl_getallocationgranularity() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn jl_is_debugbuild() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jl_get_UNAME() -> *mut jl_sym_t;
}
extern "C" {
    pub fn jl_get_ARCH() -> *mut jl_sym_t;
}
extern "C" {
    pub fn jl_get_libllvm() -> *mut jl_value_t;
}
extern "C" {
    pub static mut jl_n_threads: ::std::os::raw::c_int;
}
extern "C" {
    pub fn jl_environ(i: ::std::os::raw::c_int) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_exception_occurred() -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_init__threading();
}
extern "C" {
    pub fn jl_init_with_image__threading(
        julia_bindir: *const ::std::os::raw::c_char,
        image_relative_path: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn jl_is_initialized() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jl_atexit_hook(status: ::std::os::raw::c_int);
}
extern "C" {
    pub fn jl_eval_string(str_: *const ::std::os::raw::c_char) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_apply_generic(
        F: *mut jl_value_t,
        args: *mut *mut jl_value_t,
        nargs: u32,
    ) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_call(
        f: *mut jl_function_t,
        args: *mut *mut jl_value_t,
        nargs: i32,
    ) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_call0(f: *mut jl_function_t) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_call1(f: *mut jl_function_t, a: *mut jl_value_t) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_call2(
        f: *mut jl_function_t,
        a: *mut jl_value_t,
        b: *mut jl_value_t,
    ) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_call3(
        f: *mut jl_function_t,
        a: *mut jl_value_t,
        b: *mut jl_value_t,
        c: *mut jl_value_t,
    ) -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_yield();
}
pub type jl_timing_block_t = _jl_timing_block_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_excstack_t {
    _unused: [u8; 0],
}
pub type jl_excstack_t = _jl_excstack_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_handler_t {
    pub eh_ctx: sigjmp_buf,
    pub gcstack: *mut jl_gcframe_t,
    pub prev: *mut _jl_handler_t,
    pub gc_state: i8,
    pub locks_len: usize,
    pub defer_signal: sig_atomic_t,
    pub timing_stack: *mut jl_timing_block_t,
    pub world_age: usize,
}
#[test]
fn bindgen_test_layout__jl_handler_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_handler_t>(),
        256usize,
        concat!("Size of: ", stringify!(_jl_handler_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_handler_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_handler_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_handler_t>())).eh_ctx as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_handler_t),
            "::",
            stringify!(eh_ctx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_handler_t>())).gcstack as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_handler_t),
            "::",
            stringify!(gcstack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_handler_t>())).prev as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_handler_t),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_handler_t>())).gc_state as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_handler_t),
            "::",
            stringify!(gc_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_handler_t>())).locks_len as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_handler_t),
            "::",
            stringify!(locks_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_handler_t>())).defer_signal as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_handler_t),
            "::",
            stringify!(defer_signal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_handler_t>())).timing_stack as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_handler_t),
            "::",
            stringify!(timing_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_handler_t>())).world_age as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_handler_t),
            "::",
            stringify!(world_age)
        )
    );
}
pub type jl_handler_t = _jl_handler_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_task_t {
    pub next: *mut jl_value_t,
    pub queue: *mut jl_value_t,
    pub tls: *mut jl_value_t,
    pub donenotify: *mut jl_value_t,
    pub result: *mut jl_value_t,
    pub logstate: *mut jl_value_t,
    pub start: *mut jl_function_t,
    pub _state: u8,
    pub sticky: u8,
    pub _isexception: u8,
    pub tid: i16,
    pub prio: i16,
    pub excstack: *mut jl_excstack_t,
    pub eh: *mut jl_handler_t,
    pub ctx: jl_ucontext_t,
    pub stkbuf: *mut ::std::os::raw::c_void,
    pub bufsz: usize,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub gcstack: *mut jl_gcframe_t,
}
#[test]
fn bindgen_test_layout__jl_task_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_task_t>(),
        312usize,
        concat!("Size of: ", stringify!(_jl_task_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_task_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_task_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).queue as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(queue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).tls as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(tls)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).donenotify as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(donenotify)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).result as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(result)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).logstate as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(logstate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).start as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>()))._state as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).sticky as *const _ as usize },
        57usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(sticky)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>()))._isexception as *const _ as usize },
        58usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(_isexception)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).tid as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).prio as *const _ as usize },
        62usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(prio)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).excstack as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(excstack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).eh as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(eh)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).ctx as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(ctx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).stkbuf as *const _ as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(stkbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).bufsz as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(bufsz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).gcstack as *const _ as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(gcstack)
        )
    );
}
impl _jl_task_t {
    #[inline]
    pub fn copy_stack(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set_copy_stack(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn started(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_started(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        copy_stack: ::std::os::raw::c_uint,
        started: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 31u8, {
            let copy_stack: u32 = unsafe { ::std::mem::transmute(copy_stack) };
            copy_stack as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let started: u32 = unsafe { ::std::mem::transmute(started) };
            started as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type jl_task_t = _jl_task_t;
extern "C" {
    pub fn jl_process_events() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jl_stdout_obj() -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_stderr_obj() -> *mut jl_value_t;
}
extern "C" {
    pub fn jl_ver_major() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jl_ver_minor() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jl_ver_patch() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jl_ver_is_release() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn jl_ver_string() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn jl_git_branch() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn jl_git_commit() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn jl_get_current_task() -> *mut jl_value_t;
}
pub const jlrs_result_tag_t_JLRS_RESULT_VOID: jlrs_result_tag_t = 0;
pub const jlrs_result_tag_t_JLRS_RESULT_VALUE: jlrs_result_tag_t = 1;
pub const jlrs_result_tag_t_JLRS_RESULT_ERR: jlrs_result_tag_t = 2;
#[doc = " Flag used by `jlrs_result_t` that indicates what the union field of that struct contains."]
pub type jlrs_result_tag_t = ::std::os::raw::c_uint;
#[doc = " Container for the result of some function called in a JULIA_TRY block. The flag indicates what"]
#[doc = " the union field contains. If the flag is `JLRS_RESULT_VOID` `data` is set to a null"]
#[doc = " pointer, if it's `JLRS_RESULT_ERR` `data` is set to the pointer to the exception."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jlrs_result_t {
    pub flag: jlrs_result_tag_t,
    pub data: *mut jl_value_t,
}
#[test]
fn bindgen_test_layout_jlrs_result_t() {
    assert_eq!(
        ::std::mem::size_of::<jlrs_result_t>(),
        16usize,
        concat!("Size of: ", stringify!(jlrs_result_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jlrs_result_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jlrs_result_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jlrs_result_t>())).flag as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jlrs_result_t),
            "::",
            stringify!(flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jlrs_result_t>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jlrs_result_t),
            "::",
            stringify!(data)
        )
    );
}
extern "C" {
    pub fn jlrs_print_stack(frame: *mut jl_gcframe_t);
}
extern "C" {
    pub fn jlrs_alloc_array_1d(atype: *mut jl_value_t, nr: usize) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_alloc_array_2d(atype: *mut jl_value_t, nr: usize, nc: usize) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_alloc_array_3d(
        atype: *mut jl_value_t,
        nr: usize,
        nc: usize,
        z: usize,
    ) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_apply_array_type(ty: *mut jl_value_t, dim: usize) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_apply_type(
        tc: *mut jl_value_t,
        params: *mut *mut jl_value_t,
        n: usize,
    ) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_new_array(atype: *mut jl_value_t, dims: *mut jl_value_t) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_new_structv(
        type_: *mut jl_datatype_t,
        args: *mut *mut jl_value_t,
        na: u32,
    ) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_new_typevar(
        name: *mut jl_sym_t,
        lb: *mut jl_value_t,
        ub: *mut jl_value_t,
    ) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_set_const(
        m: *mut jl_module_t,
        var: *mut jl_sym_t,
        val: *mut jl_value_t,
    ) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_set_global(
        m: *mut jl_module_t,
        var: *mut jl_sym_t,
        val: *mut jl_value_t,
    ) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_set_nth_field(v: *mut jl_value_t, i: usize, rhs: *mut jl_value_t) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_type_union(ts: *mut *mut jl_value_t, n: usize) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_type_unionall(v: *mut jl_tvar_t, body: *mut jl_value_t) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_reshape_array(
        atype: *mut jl_value_t,
        data: *mut jl_array_t,
        _dims: *mut jl_value_t,
    ) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_array_grow_end(a: *mut jl_array_t, inc: usize) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_array_del_end(a: *mut jl_array_t, dec: usize) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_array_grow_beg(a: *mut jl_array_t, inc: usize) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_array_del_beg(a: *mut jl_array_t, dec: usize) -> jlrs_result_t;
}
extern "C" {
    pub fn jlrs_array_data_owner_offset(n_dims: u16) -> uint_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _mallocarray_t {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _bigval_t {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_timing_block_t {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_value_t {
    pub _address: u8,
}
