#![allow(deref_nullptr)]
/* generated from Julia version 1.6.4 */
/* automatically generated by rust-bindgen 0.59.2 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub type uint_t = u64;
pub type WORD = ::std::os::raw::c_ushort;
pub type DWORD = ::std::os::raw::c_ulong;
pub type UINT_PTR = ::std::os::raw::c_ulonglong;
pub type ULONG_PTR = ::std::os::raw::c_ulonglong;
pub type PVOID = *mut ::std::os::raw::c_void;
pub type LONG = ::std::os::raw::c_long;
pub type HANDLE = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _LIST_ENTRY {
    pub Flink: *mut _LIST_ENTRY,
    pub Blink: *mut _LIST_ENTRY,
}
#[test]
fn bindgen_test_layout__LIST_ENTRY() {
    assert_eq!(
        ::std::mem::size_of::<_LIST_ENTRY>(),
        16usize,
        concat!("Size of: ", stringify!(_LIST_ENTRY))
    );
    assert_eq!(
        ::std::mem::align_of::<_LIST_ENTRY>(),
        8usize,
        concat!("Alignment of ", stringify!(_LIST_ENTRY))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_LIST_ENTRY>())).Flink as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_LIST_ENTRY),
            "::",
            stringify!(Flink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_LIST_ENTRY>())).Blink as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_LIST_ENTRY),
            "::",
            stringify!(Blink)
        )
    );
}
pub type LIST_ENTRY = _LIST_ENTRY;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RTL_CRITICAL_SECTION_DEBUG {
    pub Type: WORD,
    pub CreatorBackTraceIndex: WORD,
    pub CriticalSection: *mut _RTL_CRITICAL_SECTION,
    pub ProcessLocksList: LIST_ENTRY,
    pub EntryCount: DWORD,
    pub ContentionCount: DWORD,
    pub Flags: DWORD,
    pub CreatorBackTraceIndexHigh: WORD,
    pub SpareWORD: WORD,
}
#[test]
fn bindgen_test_layout__RTL_CRITICAL_SECTION_DEBUG() {
    assert_eq!(
        ::std::mem::size_of::<_RTL_CRITICAL_SECTION_DEBUG>(),
        48usize,
        concat!("Size of: ", stringify!(_RTL_CRITICAL_SECTION_DEBUG))
    );
    assert_eq!(
        ::std::mem::align_of::<_RTL_CRITICAL_SECTION_DEBUG>(),
        8usize,
        concat!("Alignment of ", stringify!(_RTL_CRITICAL_SECTION_DEBUG))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_RTL_CRITICAL_SECTION_DEBUG>())).Type as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_RTL_CRITICAL_SECTION_DEBUG),
            "::",
            stringify!(Type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_RTL_CRITICAL_SECTION_DEBUG>())).CreatorBackTraceIndex
                as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_RTL_CRITICAL_SECTION_DEBUG),
            "::",
            stringify!(CreatorBackTraceIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_RTL_CRITICAL_SECTION_DEBUG>())).CriticalSection as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_RTL_CRITICAL_SECTION_DEBUG),
            "::",
            stringify!(CriticalSection)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_RTL_CRITICAL_SECTION_DEBUG>())).ProcessLocksList as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_RTL_CRITICAL_SECTION_DEBUG),
            "::",
            stringify!(ProcessLocksList)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_RTL_CRITICAL_SECTION_DEBUG>())).EntryCount as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_RTL_CRITICAL_SECTION_DEBUG),
            "::",
            stringify!(EntryCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_RTL_CRITICAL_SECTION_DEBUG>())).ContentionCount as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_RTL_CRITICAL_SECTION_DEBUG),
            "::",
            stringify!(ContentionCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_RTL_CRITICAL_SECTION_DEBUG>())).Flags as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_RTL_CRITICAL_SECTION_DEBUG),
            "::",
            stringify!(Flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_RTL_CRITICAL_SECTION_DEBUG>())).CreatorBackTraceIndexHigh
                as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(_RTL_CRITICAL_SECTION_DEBUG),
            "::",
            stringify!(CreatorBackTraceIndexHigh)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_RTL_CRITICAL_SECTION_DEBUG>())).SpareWORD as *const _ as usize
        },
        46usize,
        concat!(
            "Offset of field: ",
            stringify!(_RTL_CRITICAL_SECTION_DEBUG),
            "::",
            stringify!(SpareWORD)
        )
    );
}
pub type PRTL_CRITICAL_SECTION_DEBUG = *mut _RTL_CRITICAL_SECTION_DEBUG;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RTL_CRITICAL_SECTION {
    pub DebugInfo: PRTL_CRITICAL_SECTION_DEBUG,
    pub LockCount: LONG,
    pub RecursionCount: LONG,
    pub OwningThread: HANDLE,
    pub LockSemaphore: HANDLE,
    pub SpinCount: ULONG_PTR,
}
#[test]
fn bindgen_test_layout__RTL_CRITICAL_SECTION() {
    assert_eq!(
        ::std::mem::size_of::<_RTL_CRITICAL_SECTION>(),
        40usize,
        concat!("Size of: ", stringify!(_RTL_CRITICAL_SECTION))
    );
    assert_eq!(
        ::std::mem::align_of::<_RTL_CRITICAL_SECTION>(),
        8usize,
        concat!("Alignment of ", stringify!(_RTL_CRITICAL_SECTION))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RTL_CRITICAL_SECTION>())).DebugInfo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_RTL_CRITICAL_SECTION),
            "::",
            stringify!(DebugInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RTL_CRITICAL_SECTION>())).LockCount as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_RTL_CRITICAL_SECTION),
            "::",
            stringify!(LockCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_RTL_CRITICAL_SECTION>())).RecursionCount as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_RTL_CRITICAL_SECTION),
            "::",
            stringify!(RecursionCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_RTL_CRITICAL_SECTION>())).OwningThread as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_RTL_CRITICAL_SECTION),
            "::",
            stringify!(OwningThread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_RTL_CRITICAL_SECTION>())).LockSemaphore as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_RTL_CRITICAL_SECTION),
            "::",
            stringify!(LockSemaphore)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RTL_CRITICAL_SECTION>())).SpinCount as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_RTL_CRITICAL_SECTION),
            "::",
            stringify!(SpinCount)
        )
    );
}
pub type RTL_CRITICAL_SECTION = _RTL_CRITICAL_SECTION;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _RTL_CONDITION_VARIABLE {
    pub Ptr: PVOID,
}
#[test]
fn bindgen_test_layout__RTL_CONDITION_VARIABLE() {
    assert_eq!(
        ::std::mem::size_of::<_RTL_CONDITION_VARIABLE>(),
        8usize,
        concat!("Size of: ", stringify!(_RTL_CONDITION_VARIABLE))
    );
    assert_eq!(
        ::std::mem::align_of::<_RTL_CONDITION_VARIABLE>(),
        8usize,
        concat!("Alignment of ", stringify!(_RTL_CONDITION_VARIABLE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_RTL_CONDITION_VARIABLE>())).Ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_RTL_CONDITION_VARIABLE),
            "::",
            stringify!(Ptr)
        )
    );
}
pub type RTL_CONDITION_VARIABLE = _RTL_CONDITION_VARIABLE;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _OVERLAPPED {
    pub Internal: ULONG_PTR,
    pub InternalHigh: ULONG_PTR,
    pub __bindgen_anon_1: _OVERLAPPED__bindgen_ty_1,
    pub hEvent: HANDLE,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _OVERLAPPED__bindgen_ty_1 {
    pub __bindgen_anon_1: _OVERLAPPED__bindgen_ty_1__bindgen_ty_1,
    pub Pointer: PVOID,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _OVERLAPPED__bindgen_ty_1__bindgen_ty_1 {
    pub Offset: DWORD,
    pub OffsetHigh: DWORD,
}
#[test]
fn bindgen_test_layout__OVERLAPPED__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_OVERLAPPED__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(_OVERLAPPED__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_OVERLAPPED__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_OVERLAPPED__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_OVERLAPPED__bindgen_ty_1__bindgen_ty_1>())).Offset as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(Offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_OVERLAPPED__bindgen_ty_1__bindgen_ty_1>())).OffsetHigh
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(OffsetHigh)
        )
    );
}
#[test]
fn bindgen_test_layout__OVERLAPPED__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_OVERLAPPED__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(_OVERLAPPED__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_OVERLAPPED__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(_OVERLAPPED__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_OVERLAPPED__bindgen_ty_1>())).Pointer as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED__bindgen_ty_1),
            "::",
            stringify!(Pointer)
        )
    );
}
#[test]
fn bindgen_test_layout__OVERLAPPED() {
    assert_eq!(
        ::std::mem::size_of::<_OVERLAPPED>(),
        32usize,
        concat!("Size of: ", stringify!(_OVERLAPPED))
    );
    assert_eq!(
        ::std::mem::align_of::<_OVERLAPPED>(),
        8usize,
        concat!("Alignment of ", stringify!(_OVERLAPPED))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_OVERLAPPED>())).Internal as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED),
            "::",
            stringify!(Internal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_OVERLAPPED>())).InternalHigh as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED),
            "::",
            stringify!(InternalHigh)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_OVERLAPPED>())).hEvent as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED),
            "::",
            stringify!(hEvent)
        )
    );
}
pub type OVERLAPPED = _OVERLAPPED;
pub type CRITICAL_SECTION = RTL_CRITICAL_SECTION;
pub type CONDITION_VARIABLE = RTL_CONDITION_VARIABLE;
pub type SOCKET = UINT_PTR;
pub type uv_mutex_t = CRITICAL_SECTION;
pub type uv_cond_t = CONDITION_VARIABLE;
pub const uv_handle_type_UV_UNKNOWN_HANDLE: uv_handle_type = 0;
pub const uv_handle_type_UV_ASYNC: uv_handle_type = 1;
pub const uv_handle_type_UV_CHECK: uv_handle_type = 2;
pub const uv_handle_type_UV_FS_EVENT: uv_handle_type = 3;
pub const uv_handle_type_UV_FS_POLL: uv_handle_type = 4;
pub const uv_handle_type_UV_HANDLE: uv_handle_type = 5;
pub const uv_handle_type_UV_IDLE: uv_handle_type = 6;
pub const uv_handle_type_UV_NAMED_PIPE: uv_handle_type = 7;
pub const uv_handle_type_UV_POLL: uv_handle_type = 8;
pub const uv_handle_type_UV_PREPARE: uv_handle_type = 9;
pub const uv_handle_type_UV_PROCESS: uv_handle_type = 10;
pub const uv_handle_type_UV_STREAM: uv_handle_type = 11;
pub const uv_handle_type_UV_TCP: uv_handle_type = 12;
pub const uv_handle_type_UV_TIMER: uv_handle_type = 13;
pub const uv_handle_type_UV_TTY: uv_handle_type = 14;
pub const uv_handle_type_UV_UDP: uv_handle_type = 15;
pub const uv_handle_type_UV_SIGNAL: uv_handle_type = 16;
pub const uv_handle_type_UV_FILE: uv_handle_type = 17;
pub const uv_handle_type_UV_HANDLE_TYPE_MAX: uv_handle_type = 18;
pub type uv_handle_type = ::std::os::raw::c_uint;
pub const uv_req_type_UV_UNKNOWN_REQ: uv_req_type = 0;
pub const uv_req_type_UV_REQ: uv_req_type = 1;
pub const uv_req_type_UV_CONNECT: uv_req_type = 2;
pub const uv_req_type_UV_WRITE: uv_req_type = 3;
pub const uv_req_type_UV_SHUTDOWN: uv_req_type = 4;
pub const uv_req_type_UV_UDP_SEND: uv_req_type = 5;
pub const uv_req_type_UV_FS: uv_req_type = 6;
pub const uv_req_type_UV_WORK: uv_req_type = 7;
pub const uv_req_type_UV_GETADDRINFO: uv_req_type = 8;
pub const uv_req_type_UV_GETNAMEINFO: uv_req_type = 9;
pub const uv_req_type_UV_RANDOM: uv_req_type = 10;
pub const uv_req_type_UV_ACCEPT: uv_req_type = 11;
pub const uv_req_type_UV_FS_EVENT_REQ: uv_req_type = 12;
pub const uv_req_type_UV_POLL_REQ: uv_req_type = 13;
pub const uv_req_type_UV_PROCESS_EXIT: uv_req_type = 14;
pub const uv_req_type_UV_READ: uv_req_type = 15;
pub const uv_req_type_UV_UDP_RECV: uv_req_type = 16;
pub const uv_req_type_UV_WAKEUP: uv_req_type = 17;
pub const uv_req_type_UV_SIGNAL_REQ: uv_req_type = 18;
pub const uv_req_type_UV_REQ_TYPE_MAX: uv_req_type = 19;
pub type uv_req_type = ::std::os::raw::c_uint;
pub type uv_loop_t = uv_loop_s;
pub type uv_handle_t = uv_handle_s;
pub type uv_async_t = uv_async_s;
pub type uv_req_t = uv_req_s;
pub type uv_close_cb = ::std::option::Option<unsafe extern "C" fn(handle: *mut uv_handle_t)>;
pub type uv_async_cb = ::std::option::Option<unsafe extern "C" fn(handle: *mut uv_async_t)>;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct uv_req_s {
    pub data: *mut ::std::os::raw::c_void,
    pub loop_: *mut uv_loop_t,
    pub type_: uv_req_type,
    pub reserved: [*mut ::std::os::raw::c_void; 6usize],
    pub u: uv_req_s__bindgen_ty_1,
    pub next_req: *mut uv_req_s,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uv_req_s__bindgen_ty_1 {
    pub io: uv_req_s__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct uv_req_s__bindgen_ty_1__bindgen_ty_1 {
    pub overlapped: OVERLAPPED,
    pub queued_bytes: usize,
}
#[test]
fn bindgen_test_layout_uv_req_s__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<uv_req_s__bindgen_ty_1__bindgen_ty_1>(),
        40usize,
        concat!(
            "Size of: ",
            stringify!(uv_req_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<uv_req_s__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(uv_req_s__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<uv_req_s__bindgen_ty_1__bindgen_ty_1>())).overlapped as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_req_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(overlapped)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<uv_req_s__bindgen_ty_1__bindgen_ty_1>())).queued_bytes
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_req_s__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(queued_bytes)
        )
    );
}
#[test]
fn bindgen_test_layout_uv_req_s__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<uv_req_s__bindgen_ty_1>(),
        40usize,
        concat!("Size of: ", stringify!(uv_req_s__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<uv_req_s__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(uv_req_s__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_req_s__bindgen_ty_1>())).io as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_req_s__bindgen_ty_1),
            "::",
            stringify!(io)
        )
    );
}
#[test]
fn bindgen_test_layout_uv_req_s() {
    assert_eq!(
        ::std::mem::size_of::<uv_req_s>(),
        120usize,
        concat!("Size of: ", stringify!(uv_req_s))
    );
    assert_eq!(
        ::std::mem::align_of::<uv_req_s>(),
        8usize,
        concat!("Alignment of ", stringify!(uv_req_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_req_s>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_req_s),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_req_s>())).loop_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_req_s),
            "::",
            stringify!(loop_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_req_s>())).type_ as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_req_s),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_req_s>())).reserved as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_req_s),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_req_s>())).u as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_req_s),
            "::",
            stringify!(u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_req_s>())).next_req as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_req_s),
            "::",
            stringify!(next_req)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uv_handle_s {
    pub data: *mut ::std::os::raw::c_void,
    pub loop_: *mut uv_loop_t,
    pub type_: uv_handle_type,
    pub close_cb: uv_close_cb,
    pub handle_queue: [*mut ::std::os::raw::c_void; 2usize],
    pub endgame_next: *mut uv_handle_t,
    pub flags: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_uv_handle_s() {
    assert_eq!(
        ::std::mem::size_of::<uv_handle_s>(),
        64usize,
        concat!("Size of: ", stringify!(uv_handle_s))
    );
    assert_eq!(
        ::std::mem::align_of::<uv_handle_s>(),
        8usize,
        concat!("Alignment of ", stringify!(uv_handle_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_handle_s>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_handle_s),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_handle_s>())).loop_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_handle_s),
            "::",
            stringify!(loop_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_handle_s>())).type_ as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_handle_s),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_handle_s>())).close_cb as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_handle_s),
            "::",
            stringify!(close_cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_handle_s>())).handle_queue as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_handle_s),
            "::",
            stringify!(handle_queue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_handle_s>())).endgame_next as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_handle_s),
            "::",
            stringify!(endgame_next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_handle_s>())).flags as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_handle_s),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uv_async_s {
    pub data: *mut ::std::os::raw::c_void,
    pub loop_: *mut uv_loop_t,
    pub type_: uv_handle_type,
    pub close_cb: uv_close_cb,
    pub handle_queue: [*mut ::std::os::raw::c_void; 2usize],
    pub endgame_next: *mut uv_handle_t,
    pub flags: ::std::os::raw::c_uint,
    pub queue: [*mut ::std::os::raw::c_void; 2usize],
    pub async_cb: uv_async_cb,
    pub async_sent: LONG,
}
#[test]
fn bindgen_test_layout_uv_async_s() {
    assert_eq!(
        ::std::mem::size_of::<uv_async_s>(),
        96usize,
        concat!("Size of: ", stringify!(uv_async_s))
    );
    assert_eq!(
        ::std::mem::align_of::<uv_async_s>(),
        8usize,
        concat!("Alignment of ", stringify!(uv_async_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).loop_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(loop_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).type_ as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).close_cb as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(close_cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).handle_queue as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(handle_queue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).endgame_next as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(endgame_next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).flags as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).queue as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(queue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).async_cb as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(async_cb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_async_s>())).async_sent as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_async_s),
            "::",
            stringify!(async_sent)
        )
    );
}
#[link(name = "libjulia")]
extern "C" {
    pub fn uv_async_send(async_: *mut uv_async_t) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct uv_loop_s {
    pub data: *mut ::std::os::raw::c_void,
    pub active_handles: ::std::os::raw::c_uint,
    pub handle_queue: [*mut ::std::os::raw::c_void; 2usize],
    pub active_reqs: uv_loop_s__bindgen_ty_1,
    pub internal_fields: *mut ::std::os::raw::c_void,
    pub stop_flag: ::std::os::raw::c_uint,
    pub reserved: [*mut ::std::os::raw::c_void; 4usize],
    pub iocp: HANDLE,
    pub time: u64,
    pub pending_reqs_tail: *mut uv_req_t,
    pub endgame_handles: *mut uv_handle_t,
    pub timer_heap: uv_loop_s__bindgen_ty_2,
    pub timer_counter: u64,
    pub prepare_handles: [*mut ::std::os::raw::c_void; 2usize],
    pub check_handles: [*mut ::std::os::raw::c_void; 2usize],
    pub idle_handles: [*mut ::std::os::raw::c_void; 2usize],
    pub poll_peer_sockets: [SOCKET; 3usize],
    pub wq: [*mut ::std::os::raw::c_void; 2usize],
    pub wq_mutex: uv_mutex_t,
    pub wq_async: uv_async_t,
    pub async_req: uv_req_s,
    pub async_handles: [*mut ::std::os::raw::c_void; 2usize],
    pub loops_queue: [*mut ::std::os::raw::c_void; 2usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union uv_loop_s__bindgen_ty_1 {
    pub unused: *mut ::std::os::raw::c_void,
    pub count: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_uv_loop_s__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<uv_loop_s__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(uv_loop_s__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<uv_loop_s__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(uv_loop_s__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s__bindgen_ty_1>())).unused as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s__bindgen_ty_1),
            "::",
            stringify!(unused)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s__bindgen_ty_1>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s__bindgen_ty_1),
            "::",
            stringify!(count)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct uv_loop_s__bindgen_ty_2 {
    pub min: *mut ::std::os::raw::c_void,
    pub nelts: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_uv_loop_s__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<uv_loop_s__bindgen_ty_2>(),
        16usize,
        concat!("Size of: ", stringify!(uv_loop_s__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<uv_loop_s__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(uv_loop_s__bindgen_ty_2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s__bindgen_ty_2>())).min as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s__bindgen_ty_2),
            "::",
            stringify!(min)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s__bindgen_ty_2>())).nelts as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s__bindgen_ty_2),
            "::",
            stringify!(nelts)
        )
    );
}
#[test]
fn bindgen_test_layout_uv_loop_s() {
    assert_eq!(
        ::std::mem::size_of::<uv_loop_s>(),
        520usize,
        concat!("Size of: ", stringify!(uv_loop_s))
    );
    assert_eq!(
        ::std::mem::align_of::<uv_loop_s>(),
        8usize,
        concat!("Alignment of ", stringify!(uv_loop_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).active_handles as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(active_handles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).handle_queue as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(handle_queue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).active_reqs as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(active_reqs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).internal_fields as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(internal_fields)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).stop_flag as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(stop_flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).reserved as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).iocp as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(iocp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).time as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).pending_reqs_tail as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(pending_reqs_tail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).endgame_handles as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(endgame_handles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).timer_heap as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(timer_heap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).timer_counter as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(timer_counter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).prepare_handles as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(prepare_handles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).check_handles as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(check_handles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).idle_handles as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(idle_handles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).poll_peer_sockets as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(poll_peer_sockets)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).wq as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(wq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).wq_mutex as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(wq_mutex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).wq_async as *const _ as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(wq_async)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).async_req as *const _ as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(async_req)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).async_handles as *const _ as usize },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(async_handles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<uv_loop_s>())).loops_queue as *const _ as usize },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(uv_loop_s),
            "::",
            stringify!(loops_queue)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct htable_t {
    pub size: usize,
    pub table: *mut *mut ::std::os::raw::c_void,
    pub _space: [*mut ::std::os::raw::c_void; 32usize],
}
#[test]
fn bindgen_test_layout_htable_t() {
    assert_eq!(
        ::std::mem::size_of::<htable_t>(),
        272usize,
        concat!("Size of: ", stringify!(htable_t))
    );
    assert_eq!(
        ::std::mem::align_of::<htable_t>(),
        8usize,
        concat!("Alignment of ", stringify!(htable_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htable_t>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(htable_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htable_t>())).table as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(htable_t),
            "::",
            stringify!(table)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<htable_t>()))._space as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(htable_t),
            "::",
            stringify!(_space)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct arraylist_t {
    pub len: usize,
    pub max: usize,
    pub items: *mut *mut ::std::os::raw::c_void,
    pub _space: [*mut ::std::os::raw::c_void; 29usize],
}
#[test]
fn bindgen_test_layout_arraylist_t() {
    assert_eq!(
        ::std::mem::size_of::<arraylist_t>(),
        256usize,
        concat!("Size of: ", stringify!(arraylist_t))
    );
    assert_eq!(
        ::std::mem::align_of::<arraylist_t>(),
        8usize,
        concat!("Alignment of ", stringify!(arraylist_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<arraylist_t>())).len as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(arraylist_t),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<arraylist_t>())).max as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(arraylist_t),
            "::",
            stringify!(max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<arraylist_t>())).items as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(arraylist_t),
            "::",
            stringify!(items)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<arraylist_t>()))._space as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(arraylist_t),
            "::",
            stringify!(_space)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct small_arraylist_t {
    pub len: u32,
    pub max: u32,
    pub items: *mut *mut ::std::os::raw::c_void,
    pub _space: [*mut ::std::os::raw::c_void; 6usize],
}
#[test]
fn bindgen_test_layout_small_arraylist_t() {
    assert_eq!(
        ::std::mem::size_of::<small_arraylist_t>(),
        64usize,
        concat!("Size of: ", stringify!(small_arraylist_t))
    );
    assert_eq!(
        ::std::mem::align_of::<small_arraylist_t>(),
        8usize,
        concat!("Alignment of ", stringify!(small_arraylist_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<small_arraylist_t>())).len as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(small_arraylist_t),
            "::",
            stringify!(len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<small_arraylist_t>())).max as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(small_arraylist_t),
            "::",
            stringify!(max)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<small_arraylist_t>())).items as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(small_arraylist_t),
            "::",
            stringify!(items)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<small_arraylist_t>()))._space as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(small_arraylist_t),
            "::",
            stringify!(_space)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _SETJMP_FLOAT128 {
    pub Part: [::std::os::raw::c_ulonglong; 2usize],
}
#[test]
fn bindgen_test_layout__SETJMP_FLOAT128() {
    assert_eq!(
        ::std::mem::size_of::<_SETJMP_FLOAT128>(),
        16usize,
        concat!("Size of: ", stringify!(_SETJMP_FLOAT128))
    );
    assert_eq!(
        ::std::mem::align_of::<_SETJMP_FLOAT128>(),
        8usize,
        concat!("Alignment of ", stringify!(_SETJMP_FLOAT128))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_SETJMP_FLOAT128>())).Part as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_SETJMP_FLOAT128),
            "::",
            stringify!(Part)
        )
    );
}
pub type SETJMP_FLOAT128 = _SETJMP_FLOAT128;
pub type _JBTYPE = SETJMP_FLOAT128;
pub type jmp_buf = [_JBTYPE; 16usize];
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct win32_ucontext_t {
    pub uc_stack: win32_ucontext_t_stack_t,
    pub uc_mcontext: jmp_buf,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct win32_ucontext_t_stack_t {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_size: usize,
}
#[test]
fn bindgen_test_layout_win32_ucontext_t_stack_t() {
    assert_eq!(
        ::std::mem::size_of::<win32_ucontext_t_stack_t>(),
        16usize,
        concat!("Size of: ", stringify!(win32_ucontext_t_stack_t))
    );
    assert_eq!(
        ::std::mem::align_of::<win32_ucontext_t_stack_t>(),
        8usize,
        concat!("Alignment of ", stringify!(win32_ucontext_t_stack_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<win32_ucontext_t_stack_t>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(win32_ucontext_t_stack_t),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<win32_ucontext_t_stack_t>())).ss_size as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(win32_ucontext_t_stack_t),
            "::",
            stringify!(ss_size)
        )
    );
}
#[test]
fn bindgen_test_layout_win32_ucontext_t() {
    assert_eq!(
        ::std::mem::size_of::<win32_ucontext_t>(),
        272usize,
        concat!("Size of: ", stringify!(win32_ucontext_t))
    );
    assert_eq!(
        ::std::mem::align_of::<win32_ucontext_t>(),
        16usize,
        concat!("Alignment of ", stringify!(win32_ucontext_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<win32_ucontext_t>())).uc_stack as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(win32_ucontext_t),
            "::",
            stringify!(uc_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<win32_ucontext_t>())).uc_mcontext as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(win32_ucontext_t),
            "::",
            stringify!(uc_mcontext)
        )
    );
}
pub type jl_taggedvalue_t = _jl_taggedvalue_t;
pub type sig_atomic_t = ::std::os::raw::c_int;
pub type jl_tls_states_t = _jl_tls_states_t;
pub type jl_ptls_t = *mut jl_tls_states_t;
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_get_ptls_states() -> jl_ptls_t;
}
pub type jl_ucontext_t = win32_ucontext_t;
pub type jl_thread_t = DWORD;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_mutex_t {
    pub owner: jl_thread_t,
    pub count: u32,
}
#[test]
fn bindgen_test_layout_jl_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_mutex_t>(),
        8usize,
        concat!("Size of: ", stringify!(jl_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_mutex_t>(),
        4usize,
        concat!("Alignment of ", stringify!(jl_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_mutex_t>())).owner as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_mutex_t),
            "::",
            stringify!(owner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_mutex_t>())).count as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_mutex_t),
            "::",
            stringify!(count)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_gc_pool_t {
    pub freelist: *mut jl_taggedvalue_t,
    pub newpages: *mut jl_taggedvalue_t,
    pub osize: u16,
}
#[test]
fn bindgen_test_layout_jl_gc_pool_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_gc_pool_t>(),
        24usize,
        concat!("Size of: ", stringify!(jl_gc_pool_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_gc_pool_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_gc_pool_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_pool_t>())).freelist as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_pool_t),
            "::",
            stringify!(freelist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_pool_t>())).newpages as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_pool_t),
            "::",
            stringify!(newpages)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_pool_t>())).osize as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_pool_t),
            "::",
            stringify!(osize)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_thread_gc_num_t {
    pub allocd: i64,
    pub freed: i64,
    pub malloc: u64,
    pub realloc: u64,
    pub poolalloc: u64,
    pub bigalloc: u64,
    pub freecall: u64,
}
#[test]
fn bindgen_test_layout_jl_thread_gc_num_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_thread_gc_num_t>(),
        56usize,
        concat!("Size of: ", stringify!(jl_thread_gc_num_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_thread_gc_num_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_thread_gc_num_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_gc_num_t>())).allocd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_gc_num_t),
            "::",
            stringify!(allocd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_gc_num_t>())).freed as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_gc_num_t),
            "::",
            stringify!(freed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_gc_num_t>())).malloc as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_gc_num_t),
            "::",
            stringify!(malloc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_gc_num_t>())).realloc as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_gc_num_t),
            "::",
            stringify!(realloc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_gc_num_t>())).poolalloc as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_gc_num_t),
            "::",
            stringify!(poolalloc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_gc_num_t>())).bigalloc as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_gc_num_t),
            "::",
            stringify!(bigalloc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_gc_num_t>())).freecall as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_gc_num_t),
            "::",
            stringify!(freecall)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_thread_heap_t {
    pub weak_refs: arraylist_t,
    pub live_tasks: arraylist_t,
    pub mallocarrays: *mut _mallocarray_t,
    pub mafreelist: *mut _mallocarray_t,
    pub big_objects: *mut _bigval_t,
    pub rem_bindings: arraylist_t,
    pub _remset: [arraylist_t; 2usize],
    pub remset_nptr: ::std::os::raw::c_int,
    pub remset: *mut arraylist_t,
    pub last_remset: *mut arraylist_t,
    pub norm_pools: [jl_gc_pool_t; 41usize],
    pub free_stacks: [arraylist_t; 16usize],
}
#[test]
fn bindgen_test_layout_jl_thread_heap_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_thread_heap_t>(),
        6408usize,
        concat!("Size of: ", stringify!(jl_thread_heap_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_thread_heap_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_thread_heap_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).weak_refs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(weak_refs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).live_tasks as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(live_tasks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).mallocarrays as *const _ as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(mallocarrays)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).mafreelist as *const _ as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(mafreelist)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).big_objects as *const _ as usize },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(big_objects)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).rem_bindings as *const _ as usize },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(rem_bindings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>()))._remset as *const _ as usize },
        792usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(_remset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).remset_nptr as *const _ as usize },
        1304usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(remset_nptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).remset as *const _ as usize },
        1312usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(remset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).last_remset as *const _ as usize },
        1320usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(last_remset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).norm_pools as *const _ as usize },
        1328usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(norm_pools)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_thread_heap_t>())).free_stacks as *const _ as usize },
        2312usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_thread_heap_t),
            "::",
            stringify!(free_stacks)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _jl_gc_mark_data {
    _unused: [u8; 0],
}
pub type jl_gc_mark_data_t = _jl_gc_mark_data;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_gc_mark_sp_t {
    pub pc: *mut *mut ::std::os::raw::c_void,
    pub data: *mut jl_gc_mark_data_t,
    pub pc_start: *mut *mut ::std::os::raw::c_void,
    pub pc_end: *mut *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_jl_gc_mark_sp_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_gc_mark_sp_t>(),
        32usize,
        concat!("Size of: ", stringify!(jl_gc_mark_sp_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_gc_mark_sp_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_gc_mark_sp_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_sp_t>())).pc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_sp_t),
            "::",
            stringify!(pc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_sp_t>())).data as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_sp_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_sp_t>())).pc_start as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_sp_t),
            "::",
            stringify!(pc_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_sp_t>())).pc_end as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_sp_t),
            "::",
            stringify!(pc_end)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_gc_mark_cache_t {
    pub perm_scanned_bytes: usize,
    pub scanned_bytes: usize,
    pub nbig_obj: usize,
    pub big_obj: [*mut ::std::os::raw::c_void; 1024usize],
    pub stack_lock: jl_mutex_t,
    pub pc_stack: *mut *mut ::std::os::raw::c_void,
    pub pc_stack_end: *mut *mut ::std::os::raw::c_void,
    pub data_stack: *mut jl_gc_mark_data_t,
}
#[test]
fn bindgen_test_layout_jl_gc_mark_cache_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_gc_mark_cache_t>(),
        8248usize,
        concat!("Size of: ", stringify!(jl_gc_mark_cache_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_gc_mark_cache_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_gc_mark_cache_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<jl_gc_mark_cache_t>())).perm_scanned_bytes as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_cache_t),
            "::",
            stringify!(perm_scanned_bytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<jl_gc_mark_cache_t>())).scanned_bytes as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_cache_t),
            "::",
            stringify!(scanned_bytes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_cache_t>())).nbig_obj as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_cache_t),
            "::",
            stringify!(nbig_obj)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_cache_t>())).big_obj as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_cache_t),
            "::",
            stringify!(big_obj)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_cache_t>())).stack_lock as *const _ as usize },
        8216usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_cache_t),
            "::",
            stringify!(stack_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_cache_t>())).pc_stack as *const _ as usize },
        8224usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_cache_t),
            "::",
            stringify!(pc_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_cache_t>())).pc_stack_end as *const _ as usize },
        8232usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_cache_t),
            "::",
            stringify!(pc_stack_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_gc_mark_cache_t>())).data_stack as *const _ as usize },
        8240usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_gc_mark_cache_t),
            "::",
            stringify!(data_stack)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_bt_element_t {
    _unused: [u8; 0],
}
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct _jl_tls_states_t {
    pub pgcstack: *mut _jl_gcframe_t,
    pub world_age: usize,
    pub tid: i16,
    pub rngseed: u64,
    pub safepoint: *mut usize,
    pub sleep_check_state: i8,
    pub gc_state: i8,
    pub in_finalizer: i8,
    pub disable_gc: i8,
    pub heap: jl_thread_heap_t,
    pub gc_num: jl_thread_gc_num_t,
    pub sleep_lock: uv_mutex_t,
    pub wake_signal: uv_cond_t,
    pub defer_signal: sig_atomic_t,
    pub current_task: *mut _jl_task_t,
    pub next_task: *mut _jl_task_t,
    pub root_task: *mut _jl_task_t,
    pub timing_stack: *mut _jl_timing_block_t,
    pub stackbase: *mut ::std::os::raw::c_void,
    pub stacksize: usize,
    pub __bindgen_padding_0: u64,
    pub base_ctx: jl_ucontext_t,
    pub safe_restore: *mut jmp_buf,
    pub sig_exception: *mut _jl_value_t,
    pub bt_data: *mut _jl_bt_element_t,
    pub bt_size: usize,
    pub signal_request: sig_atomic_t,
    pub io_wait: sig_atomic_t,
    pub needs_resetstkoflw: ::std::os::raw::c_int,
    pub system_id: jl_thread_t,
    pub in_pure_callback: ::std::os::raw::c_int,
    pub finalizers_inhibited: ::std::os::raw::c_int,
    pub finalizers: arraylist_t,
    pub gc_cache: jl_gc_mark_cache_t,
    pub sweep_objs: arraylist_t,
    pub gc_mark_sp: jl_gc_mark_sp_t,
    pub previous_exception: *mut _jl_value_t,
    pub locks: small_arraylist_t,
}
#[test]
fn bindgen_test_layout__jl_tls_states_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_tls_states_t>(),
        15824usize,
        concat!("Size of: ", stringify!(_jl_tls_states_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_tls_states_t>(),
        16usize,
        concat!("Alignment of ", stringify!(_jl_tls_states_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).pgcstack as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(pgcstack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).world_age as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(world_age)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).tid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).rngseed as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(rngseed)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).safepoint as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(safepoint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_tls_states_t>())).sleep_check_state as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(sleep_check_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).gc_state as *const _ as usize },
        41usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(gc_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).in_finalizer as *const _ as usize },
        42usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(in_finalizer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).disable_gc as *const _ as usize },
        43usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(disable_gc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).heap as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(heap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).gc_num as *const _ as usize },
        6456usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(gc_num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).sleep_lock as *const _ as usize },
        6512usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(sleep_lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).wake_signal as *const _ as usize },
        6552usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(wake_signal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).defer_signal as *const _ as usize },
        6560usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(defer_signal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).current_task as *const _ as usize },
        6568usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(current_task)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).next_task as *const _ as usize },
        6576usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(next_task)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).root_task as *const _ as usize },
        6584usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(root_task)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).timing_stack as *const _ as usize },
        6592usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(timing_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).stackbase as *const _ as usize },
        6600usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(stackbase)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).stacksize as *const _ as usize },
        6608usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(stacksize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).base_ctx as *const _ as usize },
        6624usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(base_ctx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).safe_restore as *const _ as usize },
        6896usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(safe_restore)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).sig_exception as *const _ as usize },
        6904usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(sig_exception)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).bt_data as *const _ as usize },
        6912usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(bt_data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).bt_size as *const _ as usize },
        6920usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(bt_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).signal_request as *const _ as usize },
        6928usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(signal_request)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).io_wait as *const _ as usize },
        6932usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(io_wait)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_tls_states_t>())).needs_resetstkoflw as *const _ as usize
        },
        6936usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(needs_resetstkoflw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).system_id as *const _ as usize },
        6940usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(system_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_tls_states_t>())).in_pure_callback as *const _ as usize
        },
        6944usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(in_pure_callback)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_tls_states_t>())).finalizers_inhibited as *const _ as usize
        },
        6948usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(finalizers_inhibited)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).finalizers as *const _ as usize },
        6952usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(finalizers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).gc_cache as *const _ as usize },
        7208usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(gc_cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).sweep_objs as *const _ as usize },
        15456usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(sweep_objs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).gc_mark_sp as *const _ as usize },
        15712usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(gc_mark_sp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_tls_states_t>())).previous_exception as *const _ as usize
        },
        15744usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(previous_exception)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_tls_states_t>())).locks as *const _ as usize },
        15752usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_tls_states_t),
            "::",
            stringify!(locks)
        )
    );
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_gc_safepoint();
}
pub type jl_value_t = _jl_value_t;
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct _jl_taggedvalue_bits {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 7usize],
}
#[test]
fn bindgen_test_layout__jl_taggedvalue_bits() {
    assert_eq!(
        ::std::mem::size_of::<_jl_taggedvalue_bits>(),
        8usize,
        concat!("Size of: ", stringify!(_jl_taggedvalue_bits))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_taggedvalue_bits>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_taggedvalue_bits))
    );
}
impl _jl_taggedvalue_bits {
    #[inline]
    pub fn gc(&self) -> usize {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u64) }
    }
    #[inline]
    pub fn set_gc(&mut self, val: usize) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(gc: usize) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let gc: u64 = unsafe { ::std::mem::transmute(gc) };
            gc as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _jl_taggedvalue_t {
    pub __bindgen_anon_1: _jl_taggedvalue_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _jl_taggedvalue_t__bindgen_ty_1 {
    pub header: usize,
    pub next: *mut jl_taggedvalue_t,
    pub type_: *mut jl_value_t,
    pub bits: _jl_taggedvalue_bits,
}
#[test]
fn bindgen_test_layout__jl_taggedvalue_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_jl_taggedvalue_t__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(_jl_taggedvalue_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_taggedvalue_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_taggedvalue_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_taggedvalue_t__bindgen_ty_1>())).header as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_taggedvalue_t__bindgen_ty_1),
            "::",
            stringify!(header)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_taggedvalue_t__bindgen_ty_1>())).next as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_taggedvalue_t__bindgen_ty_1),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_taggedvalue_t__bindgen_ty_1>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_taggedvalue_t__bindgen_ty_1),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_taggedvalue_t__bindgen_ty_1>())).bits as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_taggedvalue_t__bindgen_ty_1),
            "::",
            stringify!(bits)
        )
    );
}
#[test]
fn bindgen_test_layout__jl_taggedvalue_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_taggedvalue_t>(),
        8usize,
        concat!("Size of: ", stringify!(_jl_taggedvalue_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_taggedvalue_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_taggedvalue_t))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_sym_t {
    pub left: *mut _jl_sym_t,
    pub right: *mut _jl_sym_t,
    pub hash: usize,
}
#[test]
fn bindgen_test_layout__jl_sym_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_sym_t>(),
        24usize,
        concat!("Size of: ", stringify!(_jl_sym_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_sym_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_sym_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_sym_t>())).left as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_sym_t),
            "::",
            stringify!(left)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_sym_t>())).right as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_sym_t),
            "::",
            stringify!(right)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_sym_t>())).hash as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_sym_t),
            "::",
            stringify!(hash)
        )
    );
}
pub type jl_sym_t = _jl_sym_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_svec_t {
    pub length: usize,
}
#[test]
fn bindgen_test_layout_jl_svec_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_svec_t>(),
        8usize,
        concat!("Size of: ", stringify!(jl_svec_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_svec_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_svec_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_svec_t>())).length as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_svec_t),
            "::",
            stringify!(length)
        )
    );
}
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct jl_array_flags_t {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout_jl_array_flags_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_array_flags_t>(),
        2usize,
        concat!("Size of: ", stringify!(jl_array_flags_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_array_flags_t>(),
        2usize,
        concat!("Alignment of ", stringify!(jl_array_flags_t))
    );
}
impl jl_array_flags_t {
    #[inline]
    pub fn how(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set_how(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn ndims(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 9u8) as u16) }
    }
    #[inline]
    pub fn set_ndims(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub fn pooled(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_pooled(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ptrarray(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_ptrarray(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn hasptr(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_hasptr(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn isshared(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_isshared(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn isaligned(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_isaligned(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        how: u16,
        ndims: u16,
        pooled: u16,
        ptrarray: u16,
        hasptr: u16,
        isshared: u16,
        isaligned: u16,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let how: u16 = unsafe { ::std::mem::transmute(how) };
            how as u64
        });
        __bindgen_bitfield_unit.set(2usize, 9u8, {
            let ndims: u16 = unsafe { ::std::mem::transmute(ndims) };
            ndims as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let pooled: u16 = unsafe { ::std::mem::transmute(pooled) };
            pooled as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let ptrarray: u16 = unsafe { ::std::mem::transmute(ptrarray) };
            ptrarray as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let hasptr: u16 = unsafe { ::std::mem::transmute(hasptr) };
            hasptr as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let isshared: u16 = unsafe { ::std::mem::transmute(isshared) };
            isshared as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let isaligned: u16 = unsafe { ::std::mem::transmute(isaligned) };
            isaligned as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct jl_array_t {
    pub data: *mut ::std::os::raw::c_void,
    pub length: usize,
    pub flags: jl_array_flags_t,
    pub elsize: u16,
    pub offset: u32,
    pub nrows: usize,
    pub __bindgen_anon_1: jl_array_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union jl_array_t__bindgen_ty_1 {
    pub maxsize: usize,
    pub ncols: usize,
}
#[test]
fn bindgen_test_layout_jl_array_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<jl_array_t__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(jl_array_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_array_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_array_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<jl_array_t__bindgen_ty_1>())).maxsize as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_array_t__bindgen_ty_1),
            "::",
            stringify!(maxsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_array_t__bindgen_ty_1>())).ncols as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_array_t__bindgen_ty_1),
            "::",
            stringify!(ncols)
        )
    );
}
#[test]
fn bindgen_test_layout_jl_array_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_array_t>(),
        40usize,
        concat!("Size of: ", stringify!(jl_array_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_array_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_array_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_array_t>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_array_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_array_t>())).length as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_array_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_array_t>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_array_t),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_array_t>())).elsize as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_array_t),
            "::",
            stringify!(elsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_array_t>())).offset as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_array_t),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_array_t>())).nrows as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_array_t),
            "::",
            stringify!(nrows)
        )
    );
}
pub type jl_tupletype_t = _jl_datatype_t;
pub type jl_typemap_t = jl_value_t;
pub type jl_call_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut jl_value_t,
        arg2: *mut *mut jl_value_t,
        arg3: u32,
        arg4: *mut _jl_code_instance_t,
    ) -> *mut jl_value_t,
>;
pub type jl_callptr_t = jl_call_t;
pub type jl_fptr_args_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut jl_value_t,
        arg2: *mut *mut jl_value_t,
        arg3: u32,
    ) -> *mut jl_value_t,
>;
pub type jl_fptr_sparam_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut jl_value_t,
        arg2: *mut *mut jl_value_t,
        arg3: u32,
        arg4: *mut jl_svec_t,
    ) -> *mut jl_value_t,
>;
#[repr(C)]
#[derive(Copy, Clone)]
pub union jl_generic_specptr_t {
    pub fptr: *mut ::std::os::raw::c_void,
    pub fptr1: jl_fptr_args_t,
    pub fptr3: jl_fptr_sparam_t,
}
#[test]
fn bindgen_test_layout_jl_generic_specptr_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_generic_specptr_t>(),
        8usize,
        concat!("Size of: ", stringify!(jl_generic_specptr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_generic_specptr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_generic_specptr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_generic_specptr_t>())).fptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_generic_specptr_t),
            "::",
            stringify!(fptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_generic_specptr_t>())).fptr1 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_generic_specptr_t),
            "::",
            stringify!(fptr1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_generic_specptr_t>())).fptr3 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_generic_specptr_t),
            "::",
            stringify!(fptr3)
        )
    );
}
pub type jl_method_instance_t = _jl_method_instance_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_method_t {
    pub name: *mut jl_sym_t,
    pub module: *mut _jl_module_t,
    pub file: *mut jl_sym_t,
    pub line: i32,
    pub primary_world: usize,
    pub deleted_world: usize,
    pub sig: *mut jl_value_t,
    pub specializations: *mut jl_svec_t,
    pub speckeyset: *mut jl_array_t,
    pub slot_syms: *mut jl_value_t,
    pub source: *mut jl_value_t,
    pub unspecialized: *mut _jl_method_instance_t,
    pub generator: *mut jl_value_t,
    pub roots: *mut jl_array_t,
    pub ccallable: *mut jl_svec_t,
    pub invokes: *mut jl_typemap_t,
    pub nargs: i32,
    pub called: i32,
    pub nospecialize: i32,
    pub nkw: i32,
    pub isva: u8,
    pub pure_: u8,
    pub writelock: jl_mutex_t,
}
#[test]
fn bindgen_test_layout__jl_method_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_method_t>(),
        160usize,
        concat!("Size of: ", stringify!(_jl_method_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_method_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_method_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).module as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).file as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).line as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).primary_world as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(primary_world)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).deleted_world as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(deleted_world)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).sig as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).specializations as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(specializations)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).speckeyset as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(speckeyset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).slot_syms as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(slot_syms)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).source as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(source)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).unspecialized as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(unspecialized)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).generator as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(generator)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).roots as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(roots)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).ccallable as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(ccallable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).invokes as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(invokes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).nargs as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(nargs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).called as *const _ as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(called)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).nospecialize as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(nospecialize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).nkw as *const _ as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(nkw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).isva as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(isva)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).pure_ as *const _ as usize },
        145usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(pure_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_t>())).writelock as *const _ as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_t),
            "::",
            stringify!(writelock)
        )
    );
}
pub type jl_method_t = _jl_method_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _jl_method_instance_t {
    pub def: _jl_method_instance_t__bindgen_ty_1,
    pub specTypes: *mut jl_value_t,
    pub sparam_vals: *mut jl_svec_t,
    pub uninferred: *mut jl_value_t,
    pub backedges: *mut jl_array_t,
    pub callbacks: *mut jl_array_t,
    pub cache: *mut _jl_code_instance_t,
    pub inInference: u8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _jl_method_instance_t__bindgen_ty_1 {
    pub value: *mut jl_value_t,
    pub module: *mut _jl_module_t,
    pub method: *mut jl_method_t,
}
#[test]
fn bindgen_test_layout__jl_method_instance_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_jl_method_instance_t__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(_jl_method_instance_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_method_instance_t__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(_jl_method_instance_t__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_method_instance_t__bindgen_ty_1>())).value as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_method_instance_t__bindgen_ty_1>())).module as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t__bindgen_ty_1),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_method_instance_t__bindgen_ty_1>())).method as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t__bindgen_ty_1),
            "::",
            stringify!(method)
        )
    );
}
#[test]
fn bindgen_test_layout__jl_method_instance_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_method_instance_t>(),
        64usize,
        concat!("Size of: ", stringify!(_jl_method_instance_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_method_instance_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_method_instance_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_instance_t>())).def as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t),
            "::",
            stringify!(def)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_instance_t>())).specTypes as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t),
            "::",
            stringify!(specTypes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_method_instance_t>())).sparam_vals as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t),
            "::",
            stringify!(sparam_vals)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_method_instance_t>())).uninferred as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t),
            "::",
            stringify!(uninferred)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_instance_t>())).backedges as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t),
            "::",
            stringify!(backedges)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_instance_t>())).callbacks as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t),
            "::",
            stringify!(callbacks)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_method_instance_t>())).cache as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t),
            "::",
            stringify!(cache)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_method_instance_t>())).inInference as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_method_instance_t),
            "::",
            stringify!(inInference)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _jl_code_instance_t {
    pub def: *mut jl_method_instance_t,
    pub next: *mut _jl_code_instance_t,
    pub min_world: usize,
    pub max_world: usize,
    pub rettype: *mut jl_value_t,
    pub rettype_const: *mut jl_value_t,
    pub inferred: *mut jl_value_t,
    pub isspecsig: u8,
    pub precompile: u8,
    pub invoke: jl_callptr_t,
    pub specptr: jl_generic_specptr_t,
}
#[test]
fn bindgen_test_layout__jl_code_instance_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_code_instance_t>(),
        80usize,
        concat!("Size of: ", stringify!(_jl_code_instance_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_code_instance_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_code_instance_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).def as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(def)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).min_world as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(min_world)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).max_world as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(max_world)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).rettype as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(rettype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_code_instance_t>())).rettype_const as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(rettype_const)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).inferred as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(inferred)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).isspecsig as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(isspecsig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).precompile as *const _ as usize },
        57usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(precompile)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).invoke as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(invoke)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_code_instance_t>())).specptr as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_code_instance_t),
            "::",
            stringify!(specptr)
        )
    );
}
pub type jl_code_instance_t = _jl_code_instance_t;
pub type jl_function_t = jl_value_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_tvar_t {
    pub name: *mut jl_sym_t,
    pub lb: *mut jl_value_t,
    pub ub: *mut jl_value_t,
}
#[test]
fn bindgen_test_layout_jl_tvar_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_tvar_t>(),
        24usize,
        concat!("Size of: ", stringify!(jl_tvar_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_tvar_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_tvar_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_tvar_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_tvar_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_tvar_t>())).lb as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_tvar_t),
            "::",
            stringify!(lb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_tvar_t>())).ub as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_tvar_t),
            "::",
            stringify!(ub)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_unionall_t {
    pub var: *mut jl_tvar_t,
    pub body: *mut jl_value_t,
}
#[test]
fn bindgen_test_layout_jl_unionall_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_unionall_t>(),
        16usize,
        concat!("Size of: ", stringify!(jl_unionall_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_unionall_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_unionall_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_unionall_t>())).var as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_unionall_t),
            "::",
            stringify!(var)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_unionall_t>())).body as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_unionall_t),
            "::",
            stringify!(body)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_typename_t {
    pub name: *mut jl_sym_t,
    pub module: *mut _jl_module_t,
    pub names: *mut jl_svec_t,
    pub wrapper: *mut jl_value_t,
    pub cache: *mut jl_svec_t,
    pub linearcache: *mut jl_svec_t,
    pub hash: isize,
    pub mt: *mut _jl_methtable_t,
    pub partial: *mut jl_array_t,
}
#[test]
fn bindgen_test_layout_jl_typename_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_typename_t>(),
        72usize,
        concat!("Size of: ", stringify!(jl_typename_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_typename_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_typename_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).module as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).names as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(names)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).wrapper as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(wrapper)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).cache as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).linearcache as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(linearcache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).hash as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).mt as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(mt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_typename_t>())).partial as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_typename_t),
            "::",
            stringify!(partial)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_uniontype_t {
    pub a: *mut jl_value_t,
    pub b: *mut jl_value_t,
}
#[test]
fn bindgen_test_layout_jl_uniontype_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_uniontype_t>(),
        16usize,
        concat!("Size of: ", stringify!(jl_uniontype_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_uniontype_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_uniontype_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_uniontype_t>())).a as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_uniontype_t),
            "::",
            stringify!(a)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_uniontype_t>())).b as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_uniontype_t),
            "::",
            stringify!(b)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_fielddesc8_t {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub offset: u8,
}
#[test]
fn bindgen_test_layout_jl_fielddesc8_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_fielddesc8_t>(),
        2usize,
        concat!("Size of: ", stringify!(jl_fielddesc8_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_fielddesc8_t>(),
        1usize,
        concat!("Alignment of ", stringify!(jl_fielddesc8_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_fielddesc8_t>())).offset as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_fielddesc8_t),
            "::",
            stringify!(offset)
        )
    );
}
impl jl_fielddesc8_t {
    #[inline]
    pub fn isptr(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_isptr(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn size(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 7u8) as u8) }
    }
    #[inline]
    pub fn set_size(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(isptr: u8, size: u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let isptr: u8 = unsafe { ::std::mem::transmute(isptr) };
            isptr as u64
        });
        __bindgen_bitfield_unit.set(1usize, 7u8, {
            let size: u8 = unsafe { ::std::mem::transmute(size) };
            size as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_fielddesc16_t {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub offset: u16,
}
#[test]
fn bindgen_test_layout_jl_fielddesc16_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_fielddesc16_t>(),
        4usize,
        concat!("Size of: ", stringify!(jl_fielddesc16_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_fielddesc16_t>(),
        2usize,
        concat!("Alignment of ", stringify!(jl_fielddesc16_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_fielddesc16_t>())).offset as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_fielddesc16_t),
            "::",
            stringify!(offset)
        )
    );
}
impl jl_fielddesc16_t {
    #[inline]
    pub fn isptr(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_isptr(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn size(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 15u8) as u16) }
    }
    #[inline]
    pub fn set_size(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 15u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(isptr: u16, size: u16) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let isptr: u16 = unsafe { ::std::mem::transmute(isptr) };
            isptr as u64
        });
        __bindgen_bitfield_unit.set(1usize, 15u8, {
            let size: u16 = unsafe { ::std::mem::transmute(size) };
            size as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_fielddesc32_t {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub offset: u32,
}
#[test]
fn bindgen_test_layout_jl_fielddesc32_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_fielddesc32_t>(),
        8usize,
        concat!("Size of: ", stringify!(jl_fielddesc32_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_fielddesc32_t>(),
        4usize,
        concat!("Alignment of ", stringify!(jl_fielddesc32_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_fielddesc32_t>())).offset as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_fielddesc32_t),
            "::",
            stringify!(offset)
        )
    );
}
impl jl_fielddesc32_t {
    #[inline]
    pub fn isptr(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_isptr(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn size(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set_size(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(isptr: u32, size: u32) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let isptr: u32 = unsafe { ::std::mem::transmute(isptr) };
            isptr as u64
        });
        __bindgen_bitfield_unit.set(1usize, 31u8, {
            let size: u32 = unsafe { ::std::mem::transmute(size) };
            size as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_datatype_layout_t {
    pub nfields: u32,
    pub npointers: u32,
    pub first_ptr: i32,
    pub alignment: u16,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: u8,
}
#[test]
fn bindgen_test_layout_jl_datatype_layout_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_datatype_layout_t>(),
        16usize,
        concat!("Size of: ", stringify!(jl_datatype_layout_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_datatype_layout_t>(),
        4usize,
        concat!("Alignment of ", stringify!(jl_datatype_layout_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_datatype_layout_t>())).nfields as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_datatype_layout_t),
            "::",
            stringify!(nfields)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_datatype_layout_t>())).npointers as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_datatype_layout_t),
            "::",
            stringify!(npointers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_datatype_layout_t>())).first_ptr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_datatype_layout_t),
            "::",
            stringify!(first_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_datatype_layout_t>())).alignment as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_datatype_layout_t),
            "::",
            stringify!(alignment)
        )
    );
}
impl jl_datatype_layout_t {
    #[inline]
    pub fn haspadding(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_haspadding(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fielddesc_type(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set_fielddesc_type(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        haspadding: u16,
        fielddesc_type: u16,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let haspadding: u16 = unsafe { ::std::mem::transmute(haspadding) };
            haspadding as u64
        });
        __bindgen_bitfield_unit.set(1usize, 2u8, {
            let fielddesc_type: u16 = unsafe { ::std::mem::transmute(fielddesc_type) };
            fielddesc_type as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_datatype_t {
    pub name: *mut jl_typename_t,
    pub super_: *mut _jl_datatype_t,
    pub parameters: *mut jl_svec_t,
    pub types: *mut jl_svec_t,
    pub names: *mut jl_svec_t,
    pub instance: *mut jl_value_t,
    pub layout: *const jl_datatype_layout_t,
    pub size: i32,
    pub ninitialized: i32,
    pub hash: u32,
    pub abstract_: u8,
    pub mutabl: u8,
    pub hasfreetypevars: u8,
    pub isconcretetype: u8,
    pub isdispatchtuple: u8,
    pub isbitstype: u8,
    pub zeroinit: u8,
    pub isinlinealloc: u8,
    pub has_concrete_subtype: u8,
    pub cached_by_hash: u8,
}
#[test]
fn bindgen_test_layout__jl_datatype_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_datatype_t>(),
        80usize,
        concat!("Size of: ", stringify!(_jl_datatype_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_datatype_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_datatype_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).super_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(super_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).parameters as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(parameters)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).types as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(types)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).names as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(names)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).instance as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(instance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).layout as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(layout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).ninitialized as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(ninitialized)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).hash as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).abstract_ as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(abstract_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).mutabl as *const _ as usize },
        69usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(mutabl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).hasfreetypevars as *const _ as usize },
        70usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(hasfreetypevars)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).isconcretetype as *const _ as usize },
        71usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(isconcretetype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).isdispatchtuple as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(isdispatchtuple)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).isbitstype as *const _ as usize },
        73usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(isbitstype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).zeroinit as *const _ as usize },
        74usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(zeroinit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).isinlinealloc as *const _ as usize },
        75usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(isinlinealloc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_datatype_t>())).has_concrete_subtype as *const _ as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(has_concrete_subtype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_datatype_t>())).cached_by_hash as *const _ as usize },
        77usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_datatype_t),
            "::",
            stringify!(cached_by_hash)
        )
    );
}
pub type jl_datatype_t = _jl_datatype_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_weakref_t {
    pub value: *mut jl_value_t,
}
#[test]
fn bindgen_test_layout_jl_weakref_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_weakref_t>(),
        8usize,
        concat!("Size of: ", stringify!(jl_weakref_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_weakref_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_weakref_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_weakref_t>())).value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_weakref_t),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_uuid_t {
    pub hi: u64,
    pub lo: u64,
}
#[test]
fn bindgen_test_layout_jl_uuid_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_uuid_t>(),
        16usize,
        concat!("Size of: ", stringify!(jl_uuid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_uuid_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_uuid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_uuid_t>())).hi as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_uuid_t),
            "::",
            stringify!(hi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_uuid_t>())).lo as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_uuid_t),
            "::",
            stringify!(lo)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_module_t {
    pub name: *mut jl_sym_t,
    pub parent: *mut _jl_module_t,
    pub bindings: htable_t,
    pub usings: arraylist_t,
    pub build_id: u64,
    pub uuid: jl_uuid_t,
    pub primary_world: usize,
    pub counter: u32,
    pub nospecialize: i32,
    pub optlevel: i8,
    pub compile: i8,
    pub infer: i8,
    pub istopmod: u8,
    pub lock: jl_mutex_t,
}
#[test]
fn bindgen_test_layout__jl_module_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_module_t>(),
        600usize,
        concat!("Size of: ", stringify!(_jl_module_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_module_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_module_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).parent as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(parent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).bindings as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(bindings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).usings as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(usings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).build_id as *const _ as usize },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(build_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).uuid as *const _ as usize },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).primary_world as *const _ as usize },
        568usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(primary_world)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).counter as *const _ as usize },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(counter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).nospecialize as *const _ as usize },
        580usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(nospecialize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).optlevel as *const _ as usize },
        584usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(optlevel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).compile as *const _ as usize },
        585usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(compile)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).infer as *const _ as usize },
        586usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(infer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).istopmod as *const _ as usize },
        587usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(istopmod)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_module_t>())).lock as *const _ as usize },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_module_t),
            "::",
            stringify!(lock)
        )
    );
}
pub type jl_module_t = _jl_module_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _jl_typemap_entry_t {
    pub next: *mut _jl_typemap_entry_t,
    pub sig: *mut jl_tupletype_t,
    pub simplesig: *mut jl_tupletype_t,
    pub guardsigs: *mut jl_svec_t,
    pub min_world: usize,
    pub max_world: usize,
    pub func: _jl_typemap_entry_t__bindgen_ty_1,
    pub isleafsig: i8,
    pub issimplesig: i8,
    pub va: i8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _jl_typemap_entry_t__bindgen_ty_1 {
    pub value: *mut jl_value_t,
    pub linfo: *mut jl_method_instance_t,
    pub method: *mut jl_method_t,
}
#[test]
fn bindgen_test_layout__jl_typemap_entry_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_jl_typemap_entry_t__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(_jl_typemap_entry_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_typemap_entry_t__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(_jl_typemap_entry_t__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_typemap_entry_t__bindgen_ty_1>())).value as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t__bindgen_ty_1),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_typemap_entry_t__bindgen_ty_1>())).linfo as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t__bindgen_ty_1),
            "::",
            stringify!(linfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_jl_typemap_entry_t__bindgen_ty_1>())).method as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t__bindgen_ty_1),
            "::",
            stringify!(method)
        )
    );
}
#[test]
fn bindgen_test_layout__jl_typemap_entry_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_typemap_entry_t>(),
        64usize,
        concat!("Size of: ", stringify!(_jl_typemap_entry_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_typemap_entry_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_typemap_entry_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).sig as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).simplesig as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(simplesig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).guardsigs as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(guardsigs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).min_world as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(min_world)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).max_world as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(max_world)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).func as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(func)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).isleafsig as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(isleafsig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).issimplesig as *const _ as usize },
        57usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(issimplesig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_entry_t>())).va as *const _ as usize },
        58usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_entry_t),
            "::",
            stringify!(va)
        )
    );
}
pub type jl_typemap_entry_t = _jl_typemap_entry_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_typemap_level_t {
    pub arg1: *mut jl_array_t,
    pub targ: *mut jl_array_t,
    pub name1: *mut jl_array_t,
    pub tname: *mut jl_array_t,
    pub linear: *mut jl_typemap_entry_t,
    pub any: *mut jl_typemap_t,
}
#[test]
fn bindgen_test_layout__jl_typemap_level_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_typemap_level_t>(),
        48usize,
        concat!("Size of: ", stringify!(_jl_typemap_level_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_typemap_level_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_typemap_level_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_level_t>())).arg1 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_level_t),
            "::",
            stringify!(arg1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_level_t>())).targ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_level_t),
            "::",
            stringify!(targ)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_level_t>())).name1 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_level_t),
            "::",
            stringify!(name1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_level_t>())).tname as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_level_t),
            "::",
            stringify!(tname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_level_t>())).linear as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_level_t),
            "::",
            stringify!(linear)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_typemap_level_t>())).any as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_typemap_level_t),
            "::",
            stringify!(any)
        )
    );
}
pub type jl_typemap_level_t = _jl_typemap_level_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_methtable_t {
    pub name: *mut jl_sym_t,
    pub defs: *mut jl_typemap_t,
    pub leafcache: *mut jl_array_t,
    pub cache: *mut jl_typemap_t,
    pub max_args: isize,
    pub kwsorter: *mut jl_value_t,
    pub module: *mut jl_module_t,
    pub backedges: *mut jl_array_t,
    pub writelock: jl_mutex_t,
    pub offs: u8,
    pub frozen: u8,
}
#[test]
fn bindgen_test_layout__jl_methtable_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_methtable_t>(),
        80usize,
        concat!("Size of: ", stringify!(_jl_methtable_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_methtable_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_methtable_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).defs as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(defs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).leafcache as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(leafcache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).cache as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(cache)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).max_args as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(max_args)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).kwsorter as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(kwsorter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).module as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).backedges as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(backedges)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).writelock as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(writelock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).offs as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(offs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_methtable_t>())).frozen as *const _ as usize },
        73usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_methtable_t),
            "::",
            stringify!(frozen)
        )
    );
}
pub type jl_methtable_t = _jl_methtable_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_expr_t {
    pub head: *mut jl_sym_t,
    pub args: *mut jl_array_t,
}
#[test]
fn bindgen_test_layout_jl_expr_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_expr_t>(),
        16usize,
        concat!("Size of: ", stringify!(jl_expr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_expr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_expr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_expr_t>())).head as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_expr_t),
            "::",
            stringify!(head)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_expr_t>())).args as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_expr_t),
            "::",
            stringify!(args)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_method_match_t {
    pub spec_types: *mut jl_tupletype_t,
    pub sparams: *mut jl_svec_t,
    pub method: *mut jl_method_t,
    pub fully_covers: u8,
}
#[test]
fn bindgen_test_layout_jl_method_match_t() {
    assert_eq!(
        ::std::mem::size_of::<jl_method_match_t>(),
        32usize,
        concat!("Size of: ", stringify!(jl_method_match_t))
    );
    assert_eq!(
        ::std::mem::align_of::<jl_method_match_t>(),
        8usize,
        concat!("Alignment of ", stringify!(jl_method_match_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_method_match_t>())).spec_types as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_method_match_t),
            "::",
            stringify!(spec_types)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_method_match_t>())).sparams as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_method_match_t),
            "::",
            stringify!(sparams)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_method_match_t>())).method as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_method_match_t),
            "::",
            stringify!(method)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<jl_method_match_t>())).fully_covers as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(jl_method_match_t),
            "::",
            stringify!(fully_covers)
        )
    );
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_typeofbottom_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_datatype_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_uniontype_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_unionall_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_tvar_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_any_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_type_type: *mut jl_unionall_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_typename_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_type_typename: *mut jl_typename_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_symbol_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_ssavalue_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_abstractslot_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_slotnumber_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_typedslot_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_argument_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_const_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_partial_struct_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_method_match_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_simplevector_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_tuple_typename: *mut jl_typename_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_vecelement_typename: *mut jl_typename_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_anytuple_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_emptytuple_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_anytuple_type_type: *mut jl_unionall_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_vararg_type: *mut jl_unionall_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_vararg_typename: *mut jl_typename_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_function_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_builtin_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_bottom_type: *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_method_instance_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_code_instance_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_code_info_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_method_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_module_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_abstractarray_type: *mut jl_unionall_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_densearray_type: *mut jl_unionall_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_array_type: *mut jl_unionall_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_array_typename: *mut jl_typename_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_weakref_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_abstractstring_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_string_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_errorexception_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_argumenterror_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_loaderror_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_initerror_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_typeerror_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_methoderror_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_undefvarerror_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_lineinfonode_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_stackovf_exception: *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_memory_exception: *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_readonlymemory_exception: *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_diverror_exception: *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_undefref_exception: *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_interrupt_exception: *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_boundserror_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_an_empty_vec_any: *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_an_empty_string: *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_bool_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_char_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_int8_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_uint8_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_int16_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_uint16_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_int32_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_uint32_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_int64_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_uint64_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_float16_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_float32_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_float64_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_floatingpoint_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_number_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_nothing_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_signed_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_voidpointer_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_pointer_type: *mut jl_unionall_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_llvmpointer_type: *mut jl_unionall_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_ref_type: *mut jl_unionall_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_pointer_typename: *mut jl_typename_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_llvmpointer_typename: *mut jl_typename_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_namedtuple_typename: *mut jl_typename_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_namedtuple_type: *mut jl_unionall_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_task_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_array_uint8_type: *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_array_any_type: *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_array_symbol_type: *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_array_int32_type: *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_expr_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_globalref_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_linenumbernode_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_gotonode_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_gotoifnot_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_returnnode_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_phinode_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_pinode_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_phicnode_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_upsilonnode_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_quotenode_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_newvarnode_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_intrinsic_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_methtable_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_typemap_level_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_typemap_entry_type: *mut jl_datatype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_emptysvec: *mut jl_svec_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_emptytuple: *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_true: *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_false: *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_nothing: *mut jl_value_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_gcframe_t {
    pub nroots: usize,
    pub prev: *mut _jl_gcframe_t,
}
#[test]
fn bindgen_test_layout__jl_gcframe_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_gcframe_t>(),
        16usize,
        concat!("Size of: ", stringify!(_jl_gcframe_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_gcframe_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_jl_gcframe_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_gcframe_t>())).nroots as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_gcframe_t),
            "::",
            stringify!(nroots)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_gcframe_t>())).prev as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_gcframe_t),
            "::",
            stringify!(prev)
        )
    );
}
pub type jl_gcframe_t = _jl_gcframe_t;
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_gc_enable(on: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_gc_is_enabled() -> ::std::os::raw::c_int;
}
pub const jl_gc_collection_t_JL_GC_AUTO: jl_gc_collection_t = 0;
pub const jl_gc_collection_t_JL_GC_FULL: jl_gc_collection_t = 1;
pub const jl_gc_collection_t_JL_GC_INCREMENTAL: jl_gc_collection_t = 2;
pub type jl_gc_collection_t = ::std::os::raw::c_uint;
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_gc_collect(arg1: jl_gc_collection_t);
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_gc_add_finalizer(v: *mut jl_value_t, f: *mut jl_function_t);
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_gc_add_ptr_finalizer(
        ptls: jl_ptls_t,
        v: *mut jl_value_t,
        f: *mut ::std::os::raw::c_void,
    );
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_gc_queue_root(root: *mut jl_value_t);
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_array_typetagdata(a: *mut jl_array_t) -> *mut ::std::os::raw::c_char;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_compute_fieldtypes(
        st: *mut jl_datatype_t,
        stack: *mut ::std::os::raw::c_void,
    ) -> *mut jl_svec_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_subtype(a: *mut jl_value_t, b: *mut jl_value_t) -> ::std::os::raw::c_int;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_egal(a: *mut jl_value_t, b: *mut jl_value_t) -> ::std::os::raw::c_int;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_object_id(v: *mut jl_value_t) -> usize;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_isa(a: *mut jl_value_t, t: *mut jl_value_t) -> ::std::os::raw::c_int;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_type_union(ts: *mut *mut jl_value_t, n: usize) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_type_unionall(v: *mut jl_tvar_t, body: *mut jl_value_t) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_typename_str(v: *mut jl_value_t) -> *const ::std::os::raw::c_char;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_typeof_str(v: *mut jl_value_t) -> *const ::std::os::raw::c_char;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_new_typevar(
        name: *mut jl_sym_t,
        lb: *mut jl_value_t,
        ub: *mut jl_value_t,
    ) -> *mut jl_tvar_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_apply_type(
        tc: *mut jl_value_t,
        params: *mut *mut jl_value_t,
        n: usize,
    ) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_apply_tuple_type_v(p: *mut *mut jl_value_t, np: usize) -> *mut jl_tupletype_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_new_structv(
        type_: *mut jl_datatype_t,
        args: *mut *mut jl_value_t,
        na: u32,
    ) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_new_struct_uninit(type_: *mut jl_datatype_t) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_alloc_svec(n: usize) -> *mut jl_svec_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_alloc_svec_uninit(n: usize) -> *mut jl_svec_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_symbol(str_: *const ::std::os::raw::c_char) -> *mut jl_sym_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_symbol_n(str_: *const ::std::os::raw::c_char, len: usize) -> *mut jl_sym_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_get_kwsorter(ty: *mut jl_value_t) -> *mut jl_function_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_box_bool(x: i8) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_box_int8(x: i8) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_box_uint8(x: u8) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_box_int16(x: i16) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_box_uint16(x: u16) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_box_int32(x: i32) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_box_uint32(x: u32) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_box_char(x: u32) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_box_int64(x: i64) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_box_uint64(x: u64) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_box_float32(x: f32) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_box_float64(x: f64) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_box_voidpointer(x: *mut ::std::os::raw::c_void) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_unbox_int8(v: *mut jl_value_t) -> i8;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_unbox_uint8(v: *mut jl_value_t) -> u8;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_unbox_int16(v: *mut jl_value_t) -> i16;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_unbox_uint16(v: *mut jl_value_t) -> u16;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_unbox_int32(v: *mut jl_value_t) -> i32;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_unbox_uint32(v: *mut jl_value_t) -> u32;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_unbox_int64(v: *mut jl_value_t) -> i64;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_unbox_uint64(v: *mut jl_value_t) -> u64;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_unbox_float32(v: *mut jl_value_t) -> f32;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_unbox_float64(v: *mut jl_value_t) -> f64;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_unbox_voidpointer(v: *mut jl_value_t) -> *mut ::std::os::raw::c_void;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_field_index(
        t: *mut jl_datatype_t,
        fld: *mut jl_sym_t,
        err: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_get_nth_field(v: *mut jl_value_t, i: usize) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_get_nth_field_noalloc(v: *mut jl_value_t, i: usize) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_set_nth_field(v: *mut jl_value_t, i: usize, rhs: *mut jl_value_t);
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_islayout_inline(
        eltype: *mut jl_value_t,
        fsz: *mut usize,
        al: *mut usize,
    ) -> ::std::os::raw::c_int;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_new_array(atype: *mut jl_value_t, dims: *mut jl_value_t) -> *mut jl_array_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_ptr_to_array_1d(
        atype: *mut jl_value_t,
        data: *mut ::std::os::raw::c_void,
        nel: usize,
        own_buffer: ::std::os::raw::c_int,
    ) -> *mut jl_array_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_ptr_to_array(
        atype: *mut jl_value_t,
        data: *mut ::std::os::raw::c_void,
        dims: *mut jl_value_t,
        own_buffer: ::std::os::raw::c_int,
    ) -> *mut jl_array_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_alloc_array_1d(atype: *mut jl_value_t, nr: usize) -> *mut jl_array_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_alloc_array_2d(atype: *mut jl_value_t, nr: usize, nc: usize) -> *mut jl_array_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_alloc_array_3d(
        atype: *mut jl_value_t,
        nr: usize,
        nc: usize,
        z: usize,
    ) -> *mut jl_array_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_pchar_to_array(str_: *const ::std::os::raw::c_char, len: usize) -> *mut jl_array_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_pchar_to_string(str_: *const ::std::os::raw::c_char, len: usize) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_apply_array_type(type_: *mut jl_value_t, dim: usize) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_array_eltype(a: *mut jl_value_t) -> *mut ::std::os::raw::c_void;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_main_module: *mut jl_module_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_core_module: *mut jl_module_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_base_module: *mut jl_module_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_get_global(m: *mut jl_module_t, var: *mut jl_sym_t) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_set_global(m: *mut jl_module_t, var: *mut jl_sym_t, val: *mut jl_value_t);
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_set_const(m: *mut jl_module_t, var: *mut jl_sym_t, val: *mut jl_value_t);
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_is_imported(m: *mut jl_module_t, s: *mut jl_sym_t) -> ::std::os::raw::c_int;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_cpu_threads() -> ::std::os::raw::c_int;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_getpagesize() -> ::std::os::raw::c_long;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_getallocationgranularity() -> ::std::os::raw::c_long;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_is_debugbuild() -> ::std::os::raw::c_int;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_get_UNAME() -> *mut jl_sym_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_get_ARCH() -> *mut jl_sym_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_get_libllvm() -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub static mut jl_n_threads: ::std::os::raw::c_int;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_environ(i: ::std::os::raw::c_int) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_exception_occurred() -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_init__threading();
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_init_with_image__threading(
        julia_bindir: *const ::std::os::raw::c_char,
        image_relative_path: *const ::std::os::raw::c_char,
    );
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_is_initialized() -> ::std::os::raw::c_int;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_atexit_hook(status: ::std::os::raw::c_int);
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_eval_string(str_: *const ::std::os::raw::c_char) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_apply_generic(
        F: *mut jl_value_t,
        args: *mut *mut jl_value_t,
        nargs: u32,
    ) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_call(
        f: *mut jl_function_t,
        args: *mut *mut jl_value_t,
        nargs: i32,
    ) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_call0(f: *mut jl_function_t) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_call1(f: *mut jl_function_t, a: *mut jl_value_t) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_call2(
        f: *mut jl_function_t,
        a: *mut jl_value_t,
        b: *mut jl_value_t,
    ) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_call3(
        f: *mut jl_function_t,
        a: *mut jl_value_t,
        b: *mut jl_value_t,
        c: *mut jl_value_t,
    ) -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_yield();
}
pub type jl_timing_block_t = _jl_timing_block_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_excstack_t {
    _unused: [u8; 0],
}
pub type jl_excstack_t = _jl_excstack_t;
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct _jl_handler_t {
    pub eh_ctx: jmp_buf,
    pub gcstack: *mut jl_gcframe_t,
    pub prev: *mut _jl_handler_t,
    pub gc_state: i8,
    pub locks_len: usize,
    pub defer_signal: sig_atomic_t,
    pub timing_stack: *mut jl_timing_block_t,
    pub world_age: usize,
}
#[test]
fn bindgen_test_layout__jl_handler_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_handler_t>(),
        320usize,
        concat!("Size of: ", stringify!(_jl_handler_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_handler_t>(),
        16usize,
        concat!("Alignment of ", stringify!(_jl_handler_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_handler_t>())).eh_ctx as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_handler_t),
            "::",
            stringify!(eh_ctx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_handler_t>())).gcstack as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_handler_t),
            "::",
            stringify!(gcstack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_handler_t>())).prev as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_handler_t),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_handler_t>())).gc_state as *const _ as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_handler_t),
            "::",
            stringify!(gc_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_handler_t>())).locks_len as *const _ as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_handler_t),
            "::",
            stringify!(locks_len)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_handler_t>())).defer_signal as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_handler_t),
            "::",
            stringify!(defer_signal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_handler_t>())).timing_stack as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_handler_t),
            "::",
            stringify!(timing_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_handler_t>())).world_age as *const _ as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_handler_t),
            "::",
            stringify!(world_age)
        )
    );
}
pub type jl_handler_t = _jl_handler_t;
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct _jl_task_t {
    pub next: *mut jl_value_t,
    pub queue: *mut jl_value_t,
    pub tls: *mut jl_value_t,
    pub donenotify: *mut jl_value_t,
    pub result: *mut jl_value_t,
    pub logstate: *mut jl_value_t,
    pub start: *mut jl_function_t,
    pub _state: u8,
    pub sticky: u8,
    pub _isexception: u8,
    pub tid: i16,
    pub prio: i16,
    pub excstack: *mut jl_excstack_t,
    pub eh: *mut jl_handler_t,
    pub ctx: jl_ucontext_t,
    pub stkbuf: *mut ::std::os::raw::c_void,
    pub bufsz: usize,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub gcstack: *mut jl_gcframe_t,
}
#[test]
fn bindgen_test_layout__jl_task_t() {
    assert_eq!(
        ::std::mem::size_of::<_jl_task_t>(),
        384usize,
        concat!("Size of: ", stringify!(_jl_task_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_jl_task_t>(),
        16usize,
        concat!("Alignment of ", stringify!(_jl_task_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).queue as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(queue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).tls as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(tls)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).donenotify as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(donenotify)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).result as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(result)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).logstate as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(logstate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).start as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>()))._state as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(_state)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).sticky as *const _ as usize },
        57usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(sticky)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>()))._isexception as *const _ as usize },
        58usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(_isexception)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).tid as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).prio as *const _ as usize },
        62usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(prio)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).excstack as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(excstack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).eh as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(eh)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).ctx as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(ctx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).stkbuf as *const _ as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(stkbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).bufsz as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(bufsz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_jl_task_t>())).gcstack as *const _ as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(_jl_task_t),
            "::",
            stringify!(gcstack)
        )
    );
}
impl _jl_task_t {
    #[inline]
    pub fn copy_stack(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set_copy_stack(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub fn started(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_started(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        copy_stack: ::std::os::raw::c_uint,
        started: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 31u8, {
            let copy_stack: u32 = unsafe { ::std::mem::transmute(copy_stack) };
            copy_stack as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let started: u32 = unsafe { ::std::mem::transmute(started) };
            started as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type jl_task_t = _jl_task_t;
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_process_events() -> ::std::os::raw::c_int;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_stdout_obj() -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_stderr_obj() -> *mut jl_value_t;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_ver_major() -> ::std::os::raw::c_int;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_ver_minor() -> ::std::os::raw::c_int;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_ver_patch() -> ::std::os::raw::c_int;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_ver_is_release() -> ::std::os::raw::c_int;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_ver_string() -> *const ::std::os::raw::c_char;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_git_branch() -> *const ::std::os::raw::c_char;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_git_commit() -> *const ::std::os::raw::c_char;
}
#[link(name = "libjulia")]
extern "C" {
    pub fn jl_get_current_task() -> *mut jl_value_t;
}
extern "C" {
    pub fn jlrs_print_stack(frame: *mut jl_gcframe_t);
}
extern "C" {
    pub fn jlrs_array_data_owner_offset(n_dims: u16) -> uint_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _mallocarray_t {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _bigval_t {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_timing_block_t {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_value_t {
    pub _address: u8,
}
