#![allow(bad_style)]
use libc::*;

/* automatically generated by rust-bindgen 0.59.1 */

pub const JIT_NATIVE_INT64: u32 = 1;
pub const JIT_MEMORY_OK: u32 = 0;
pub const JIT_MEMORY_RESTART: u32 = 1;
pub const JIT_MEMORY_TOO_BIG: u32 = 2;
pub const JIT_MEMORY_ERROR: u32 = 3;
pub const JIT_OPTION_CACHE_LIMIT: u32 = 10000;
pub const JIT_OPTION_CACHE_PAGE_SIZE: u32 = 10001;
pub const JIT_OPTION_PRE_COMPILE: u32 = 10002;
pub const JIT_OPTION_DONT_FOLD: u32 = 10003;
pub const JIT_OPTION_POSITION_INDEPENDENT: u32 = 10004;
pub const JIT_OPTION_CACHE_MAX_PAGE_FACTOR: u32 = 10005;
pub const JIT_TYPE_INVALID: i32 = -1;
pub const JIT_TYPE_VOID: u32 = 0;
pub const JIT_TYPE_SBYTE: u32 = 1;
pub const JIT_TYPE_UBYTE: u32 = 2;
pub const JIT_TYPE_SHORT: u32 = 3;
pub const JIT_TYPE_USHORT: u32 = 4;
pub const JIT_TYPE_INT: u32 = 5;
pub const JIT_TYPE_UINT: u32 = 6;
pub const JIT_TYPE_NINT: u32 = 7;
pub const JIT_TYPE_NUINT: u32 = 8;
pub const JIT_TYPE_LONG: u32 = 9;
pub const JIT_TYPE_ULONG: u32 = 10;
pub const JIT_TYPE_FLOAT32: u32 = 11;
pub const JIT_TYPE_FLOAT64: u32 = 12;
pub const JIT_TYPE_NFLOAT: u32 = 13;
pub const JIT_TYPE_MAX_PRIMITIVE: u32 = 13;
pub const JIT_TYPE_STRUCT: u32 = 14;
pub const JIT_TYPE_UNION: u32 = 15;
pub const JIT_TYPE_SIGNATURE: u32 = 16;
pub const JIT_TYPE_PTR: u32 = 17;
pub const JIT_TYPE_FIRST_TAGGED: u32 = 32;
pub const JIT_TYPETAG_NAME: u32 = 10000;
pub const JIT_TYPETAG_STRUCT_NAME: u32 = 10001;
pub const JIT_TYPETAG_UNION_NAME: u32 = 10002;
pub const JIT_TYPETAG_ENUM_NAME: u32 = 10003;
pub const JIT_TYPETAG_CONST: u32 = 10004;
pub const JIT_TYPETAG_VOLATILE: u32 = 10005;
pub const JIT_TYPETAG_REFERENCE: u32 = 10006;
pub const JIT_TYPETAG_OUTPUT: u32 = 10007;
pub const JIT_TYPETAG_RESTRICT: u32 = 10008;
pub const JIT_TYPETAG_SYS_BOOL: u32 = 10009;
pub const JIT_TYPETAG_SYS_CHAR: u32 = 10010;
pub const JIT_TYPETAG_SYS_SCHAR: u32 = 10011;
pub const JIT_TYPETAG_SYS_UCHAR: u32 = 10012;
pub const JIT_TYPETAG_SYS_SHORT: u32 = 10013;
pub const JIT_TYPETAG_SYS_USHORT: u32 = 10014;
pub const JIT_TYPETAG_SYS_INT: u32 = 10015;
pub const JIT_TYPETAG_SYS_UINT: u32 = 10016;
pub const JIT_TYPETAG_SYS_LONG: u32 = 10017;
pub const JIT_TYPETAG_SYS_ULONG: u32 = 10018;
pub const JIT_TYPETAG_SYS_LONGLONG: u32 = 10019;
pub const JIT_TYPETAG_SYS_ULONGLONG: u32 = 10020;
pub const JIT_TYPETAG_SYS_FLOAT: u32 = 10021;
pub const JIT_TYPETAG_SYS_DOUBLE: u32 = 10022;
pub const JIT_TYPETAG_SYS_LONGDOUBLE: u32 = 10023;
pub const JIT_DEBUGGER_TYPE_QUIT: u32 = 0;
pub const JIT_DEBUGGER_TYPE_HARD_BREAKPOINT: u32 = 1;
pub const JIT_DEBUGGER_TYPE_SOFT_BREAKPOINT: u32 = 2;
pub const JIT_DEBUGGER_TYPE_USER_BREAKPOINT: u32 = 3;
pub const JIT_DEBUGGER_TYPE_ATTACH_THREAD: u32 = 4;
pub const JIT_DEBUGGER_TYPE_DETACH_THREAD: u32 = 5;
pub const JIT_DEBUGGER_FLAG_THREAD: u32 = 1;
pub const JIT_DEBUGGER_FLAG_FUNCTION: u32 = 2;
pub const JIT_DEBUGGER_FLAG_DATA1: u32 = 4;
pub const JIT_DEBUGGER_FLAG_DATA2: u32 = 8;
pub const JIT_DEBUGGER_DATA1_FIRST: u32 = 10000;
pub const JIT_DEBUGGER_DATA1_LINE: u32 = 10000;
pub const JIT_DEBUGGER_DATA1_ENTER: u32 = 10001;
pub const JIT_DEBUGGER_DATA1_LEAVE: u32 = 10002;
pub const JIT_DEBUGGER_DATA1_THROW: u32 = 10003;
pub const JIT_READELF_FLAG_FORCE: u32 = 1;
pub const JIT_READELF_FLAG_DEBUG: u32 = 2;
pub const JIT_READELF_OK: u32 = 0;
pub const JIT_READELF_CANNOT_OPEN: u32 = 1;
pub const JIT_READELF_NOT_ELF: u32 = 2;
pub const JIT_READELF_WRONG_ARCH: u32 = 3;
pub const JIT_READELF_BAD_FORMAT: u32 = 4;
pub const JIT_READELF_MEMORY: u32 = 5;
pub const JIT_RESULT_OK: u32 = 1;
pub const JIT_RESULT_OVERFLOW: u32 = 0;
pub const JIT_RESULT_ARITHMETIC: i32 = -1;
pub const JIT_RESULT_DIVISION_BY_ZERO: i32 = -2;
pub const JIT_RESULT_COMPILE_ERROR: i32 = -3;
pub const JIT_RESULT_OUT_OF_MEMORY: i32 = -4;
pub const JIT_RESULT_NULL_REFERENCE: i32 = -5;
pub const JIT_RESULT_NULL_FUNCTION: i32 = -6;
pub const JIT_RESULT_CALLED_NESTED: i32 = -7;
pub const JIT_RESULT_OUT_OF_BOUNDS: i32 = -8;
pub const JIT_RESULT_UNDEFINED_LABEL: i32 = -9;
pub const JIT_RESULT_MEMORY_FULL: i32 = -10000;
pub const JIT_OPTLEVEL_NONE: u32 = 0;
pub const JIT_OPTLEVEL_NORMAL: u32 = 1;
pub const JIT_CALL_NOTHROW: u32 = 1;
pub const JIT_CALL_NORETURN: u32 = 2;
pub const JIT_CALL_TAIL: u32 = 4;
pub const JITOM_MODIFIER_ACCESS_MASK: u32 = 7;
pub const JITOM_MODIFIER_PUBLIC: u32 = 0;
pub const JITOM_MODIFIER_PRIVATE: u32 = 1;
pub const JITOM_MODIFIER_PROTECTED: u32 = 2;
pub const JITOM_MODIFIER_PACKAGE: u32 = 3;
pub const JITOM_MODIFIER_PACKAGE_OR_PROTECTED: u32 = 4;
pub const JITOM_MODIFIER_PACKAGE_AND_PROTECTED: u32 = 5;
pub const JITOM_MODIFIER_OTHER1: u32 = 6;
pub const JITOM_MODIFIER_OTHER2: u32 = 7;
pub const JITOM_MODIFIER_STATIC: u32 = 8;
pub const JITOM_MODIFIER_VIRTUAL: u32 = 16;
pub const JITOM_MODIFIER_NEW_SLOT: u32 = 32;
pub const JITOM_MODIFIER_ABSTRACT: u32 = 64;
pub const JITOM_MODIFIER_LITERAL: u32 = 128;
pub const JITOM_MODIFIER_CTOR: u32 = 256;
pub const JITOM_MODIFIER_STATIC_CTOR: u32 = 512;
pub const JITOM_MODIFIER_DTOR: u32 = 1024;
pub const JITOM_MODIFIER_INTERFACE: u32 = 2048;
pub const JITOM_MODIFIER_VALUE: u32 = 4096;
pub const JITOM_MODIFIER_FINAL: u32 = 8192;
pub const JITOM_MODIFIER_DELETE: u32 = 16384;
pub const JITOM_MODIFIER_REFERENCE_COUNTED: u32 = 32768;
pub const JITOM_TYPETAG_CLASS: u32 = 11000;
pub const JITOM_TYPETAG_VALUE: u32 = 11001;
pub const JIT_OP_NOP: u32 = 0;
pub const JIT_OP_TRUNC_SBYTE: u32 = 1;
pub const JIT_OP_TRUNC_UBYTE: u32 = 2;
pub const JIT_OP_TRUNC_SHORT: u32 = 3;
pub const JIT_OP_TRUNC_USHORT: u32 = 4;
pub const JIT_OP_TRUNC_INT: u32 = 5;
pub const JIT_OP_TRUNC_UINT: u32 = 6;
pub const JIT_OP_CHECK_SBYTE: u32 = 7;
pub const JIT_OP_CHECK_UBYTE: u32 = 8;
pub const JIT_OP_CHECK_SHORT: u32 = 9;
pub const JIT_OP_CHECK_USHORT: u32 = 10;
pub const JIT_OP_CHECK_INT: u32 = 11;
pub const JIT_OP_CHECK_UINT: u32 = 12;
pub const JIT_OP_LOW_WORD: u32 = 13;
pub const JIT_OP_EXPAND_INT: u32 = 14;
pub const JIT_OP_EXPAND_UINT: u32 = 15;
pub const JIT_OP_CHECK_LOW_WORD: u32 = 16;
pub const JIT_OP_CHECK_SIGNED_LOW_WORD: u32 = 17;
pub const JIT_OP_CHECK_LONG: u32 = 18;
pub const JIT_OP_CHECK_ULONG: u32 = 19;
pub const JIT_OP_FLOAT32_TO_INT: u32 = 20;
pub const JIT_OP_FLOAT32_TO_UINT: u32 = 21;
pub const JIT_OP_FLOAT32_TO_LONG: u32 = 22;
pub const JIT_OP_FLOAT32_TO_ULONG: u32 = 23;
pub const JIT_OP_CHECK_FLOAT32_TO_INT: u32 = 24;
pub const JIT_OP_CHECK_FLOAT32_TO_UINT: u32 = 25;
pub const JIT_OP_CHECK_FLOAT32_TO_LONG: u32 = 26;
pub const JIT_OP_CHECK_FLOAT32_TO_ULONG: u32 = 27;
pub const JIT_OP_INT_TO_FLOAT32: u32 = 28;
pub const JIT_OP_UINT_TO_FLOAT32: u32 = 29;
pub const JIT_OP_LONG_TO_FLOAT32: u32 = 30;
pub const JIT_OP_ULONG_TO_FLOAT32: u32 = 31;
pub const JIT_OP_FLOAT32_TO_FLOAT64: u32 = 32;
pub const JIT_OP_FLOAT64_TO_INT: u32 = 33;
pub const JIT_OP_FLOAT64_TO_UINT: u32 = 34;
pub const JIT_OP_FLOAT64_TO_LONG: u32 = 35;
pub const JIT_OP_FLOAT64_TO_ULONG: u32 = 36;
pub const JIT_OP_CHECK_FLOAT64_TO_INT: u32 = 37;
pub const JIT_OP_CHECK_FLOAT64_TO_UINT: u32 = 38;
pub const JIT_OP_CHECK_FLOAT64_TO_LONG: u32 = 39;
pub const JIT_OP_CHECK_FLOAT64_TO_ULONG: u32 = 40;
pub const JIT_OP_INT_TO_FLOAT64: u32 = 41;
pub const JIT_OP_UINT_TO_FLOAT64: u32 = 42;
pub const JIT_OP_LONG_TO_FLOAT64: u32 = 43;
pub const JIT_OP_ULONG_TO_FLOAT64: u32 = 44;
pub const JIT_OP_FLOAT64_TO_FLOAT32: u32 = 45;
pub const JIT_OP_NFLOAT_TO_INT: u32 = 46;
pub const JIT_OP_NFLOAT_TO_UINT: u32 = 47;
pub const JIT_OP_NFLOAT_TO_LONG: u32 = 48;
pub const JIT_OP_NFLOAT_TO_ULONG: u32 = 49;
pub const JIT_OP_CHECK_NFLOAT_TO_INT: u32 = 50;
pub const JIT_OP_CHECK_NFLOAT_TO_UINT: u32 = 51;
pub const JIT_OP_CHECK_NFLOAT_TO_LONG: u32 = 52;
pub const JIT_OP_CHECK_NFLOAT_TO_ULONG: u32 = 53;
pub const JIT_OP_INT_TO_NFLOAT: u32 = 54;
pub const JIT_OP_UINT_TO_NFLOAT: u32 = 55;
pub const JIT_OP_LONG_TO_NFLOAT: u32 = 56;
pub const JIT_OP_ULONG_TO_NFLOAT: u32 = 57;
pub const JIT_OP_NFLOAT_TO_FLOAT32: u32 = 58;
pub const JIT_OP_NFLOAT_TO_FLOAT64: u32 = 59;
pub const JIT_OP_FLOAT32_TO_NFLOAT: u32 = 60;
pub const JIT_OP_FLOAT64_TO_NFLOAT: u32 = 61;
pub const JIT_OP_IADD: u32 = 62;
pub const JIT_OP_IADD_OVF: u32 = 63;
pub const JIT_OP_IADD_OVF_UN: u32 = 64;
pub const JIT_OP_ISUB: u32 = 65;
pub const JIT_OP_ISUB_OVF: u32 = 66;
pub const JIT_OP_ISUB_OVF_UN: u32 = 67;
pub const JIT_OP_IMUL: u32 = 68;
pub const JIT_OP_IMUL_OVF: u32 = 69;
pub const JIT_OP_IMUL_OVF_UN: u32 = 70;
pub const JIT_OP_IDIV: u32 = 71;
pub const JIT_OP_IDIV_UN: u32 = 72;
pub const JIT_OP_IREM: u32 = 73;
pub const JIT_OP_IREM_UN: u32 = 74;
pub const JIT_OP_INEG: u32 = 75;
pub const JIT_OP_LADD: u32 = 76;
pub const JIT_OP_LADD_OVF: u32 = 77;
pub const JIT_OP_LADD_OVF_UN: u32 = 78;
pub const JIT_OP_LSUB: u32 = 79;
pub const JIT_OP_LSUB_OVF: u32 = 80;
pub const JIT_OP_LSUB_OVF_UN: u32 = 81;
pub const JIT_OP_LMUL: u32 = 82;
pub const JIT_OP_LMUL_OVF: u32 = 83;
pub const JIT_OP_LMUL_OVF_UN: u32 = 84;
pub const JIT_OP_LDIV: u32 = 85;
pub const JIT_OP_LDIV_UN: u32 = 86;
pub const JIT_OP_LREM: u32 = 87;
pub const JIT_OP_LREM_UN: u32 = 88;
pub const JIT_OP_LNEG: u32 = 89;
pub const JIT_OP_FADD: u32 = 90;
pub const JIT_OP_FSUB: u32 = 91;
pub const JIT_OP_FMUL: u32 = 92;
pub const JIT_OP_FDIV: u32 = 93;
pub const JIT_OP_FREM: u32 = 94;
pub const JIT_OP_FREM_IEEE: u32 = 95;
pub const JIT_OP_FNEG: u32 = 96;
pub const JIT_OP_DADD: u32 = 97;
pub const JIT_OP_DSUB: u32 = 98;
pub const JIT_OP_DMUL: u32 = 99;
pub const JIT_OP_DDIV: u32 = 100;
pub const JIT_OP_DREM: u32 = 101;
pub const JIT_OP_DREM_IEEE: u32 = 102;
pub const JIT_OP_DNEG: u32 = 103;
pub const JIT_OP_NFADD: u32 = 104;
pub const JIT_OP_NFSUB: u32 = 105;
pub const JIT_OP_NFMUL: u32 = 106;
pub const JIT_OP_NFDIV: u32 = 107;
pub const JIT_OP_NFREM: u32 = 108;
pub const JIT_OP_NFREM_IEEE: u32 = 109;
pub const JIT_OP_NFNEG: u32 = 110;
pub const JIT_OP_IAND: u32 = 111;
pub const JIT_OP_IOR: u32 = 112;
pub const JIT_OP_IXOR: u32 = 113;
pub const JIT_OP_INOT: u32 = 114;
pub const JIT_OP_ISHL: u32 = 115;
pub const JIT_OP_ISHR: u32 = 116;
pub const JIT_OP_ISHR_UN: u32 = 117;
pub const JIT_OP_LAND: u32 = 118;
pub const JIT_OP_LOR: u32 = 119;
pub const JIT_OP_LXOR: u32 = 120;
pub const JIT_OP_LNOT: u32 = 121;
pub const JIT_OP_LSHL: u32 = 122;
pub const JIT_OP_LSHR: u32 = 123;
pub const JIT_OP_LSHR_UN: u32 = 124;
pub const JIT_OP_BR: u32 = 125;
pub const JIT_OP_BR_IFALSE: u32 = 126;
pub const JIT_OP_BR_ITRUE: u32 = 127;
pub const JIT_OP_BR_IEQ: u32 = 128;
pub const JIT_OP_BR_INE: u32 = 129;
pub const JIT_OP_BR_ILT: u32 = 130;
pub const JIT_OP_BR_ILT_UN: u32 = 131;
pub const JIT_OP_BR_ILE: u32 = 132;
pub const JIT_OP_BR_ILE_UN: u32 = 133;
pub const JIT_OP_BR_IGT: u32 = 134;
pub const JIT_OP_BR_IGT_UN: u32 = 135;
pub const JIT_OP_BR_IGE: u32 = 136;
pub const JIT_OP_BR_IGE_UN: u32 = 137;
pub const JIT_OP_BR_LFALSE: u32 = 138;
pub const JIT_OP_BR_LTRUE: u32 = 139;
pub const JIT_OP_BR_LEQ: u32 = 140;
pub const JIT_OP_BR_LNE: u32 = 141;
pub const JIT_OP_BR_LLT: u32 = 142;
pub const JIT_OP_BR_LLT_UN: u32 = 143;
pub const JIT_OP_BR_LLE: u32 = 144;
pub const JIT_OP_BR_LLE_UN: u32 = 145;
pub const JIT_OP_BR_LGT: u32 = 146;
pub const JIT_OP_BR_LGT_UN: u32 = 147;
pub const JIT_OP_BR_LGE: u32 = 148;
pub const JIT_OP_BR_LGE_UN: u32 = 149;
pub const JIT_OP_BR_FEQ: u32 = 150;
pub const JIT_OP_BR_FNE: u32 = 151;
pub const JIT_OP_BR_FLT: u32 = 152;
pub const JIT_OP_BR_FLE: u32 = 153;
pub const JIT_OP_BR_FGT: u32 = 154;
pub const JIT_OP_BR_FGE: u32 = 155;
pub const JIT_OP_BR_FLT_INV: u32 = 156;
pub const JIT_OP_BR_FLE_INV: u32 = 157;
pub const JIT_OP_BR_FGT_INV: u32 = 158;
pub const JIT_OP_BR_FGE_INV: u32 = 159;
pub const JIT_OP_BR_DEQ: u32 = 160;
pub const JIT_OP_BR_DNE: u32 = 161;
pub const JIT_OP_BR_DLT: u32 = 162;
pub const JIT_OP_BR_DLE: u32 = 163;
pub const JIT_OP_BR_DGT: u32 = 164;
pub const JIT_OP_BR_DGE: u32 = 165;
pub const JIT_OP_BR_DLT_INV: u32 = 166;
pub const JIT_OP_BR_DLE_INV: u32 = 167;
pub const JIT_OP_BR_DGT_INV: u32 = 168;
pub const JIT_OP_BR_DGE_INV: u32 = 169;
pub const JIT_OP_BR_NFEQ: u32 = 170;
pub const JIT_OP_BR_NFNE: u32 = 171;
pub const JIT_OP_BR_NFLT: u32 = 172;
pub const JIT_OP_BR_NFLE: u32 = 173;
pub const JIT_OP_BR_NFGT: u32 = 174;
pub const JIT_OP_BR_NFGE: u32 = 175;
pub const JIT_OP_BR_NFLT_INV: u32 = 176;
pub const JIT_OP_BR_NFLE_INV: u32 = 177;
pub const JIT_OP_BR_NFGT_INV: u32 = 178;
pub const JIT_OP_BR_NFGE_INV: u32 = 179;
pub const JIT_OP_ICMP: u32 = 180;
pub const JIT_OP_ICMP_UN: u32 = 181;
pub const JIT_OP_LCMP: u32 = 182;
pub const JIT_OP_LCMP_UN: u32 = 183;
pub const JIT_OP_FCMPL: u32 = 184;
pub const JIT_OP_FCMPG: u32 = 185;
pub const JIT_OP_DCMPL: u32 = 186;
pub const JIT_OP_DCMPG: u32 = 187;
pub const JIT_OP_NFCMPL: u32 = 188;
pub const JIT_OP_NFCMPG: u32 = 189;
pub const JIT_OP_IEQ: u32 = 190;
pub const JIT_OP_INE: u32 = 191;
pub const JIT_OP_ILT: u32 = 192;
pub const JIT_OP_ILT_UN: u32 = 193;
pub const JIT_OP_ILE: u32 = 194;
pub const JIT_OP_ILE_UN: u32 = 195;
pub const JIT_OP_IGT: u32 = 196;
pub const JIT_OP_IGT_UN: u32 = 197;
pub const JIT_OP_IGE: u32 = 198;
pub const JIT_OP_IGE_UN: u32 = 199;
pub const JIT_OP_LEQ: u32 = 200;
pub const JIT_OP_LNE: u32 = 201;
pub const JIT_OP_LLT: u32 = 202;
pub const JIT_OP_LLT_UN: u32 = 203;
pub const JIT_OP_LLE: u32 = 204;
pub const JIT_OP_LLE_UN: u32 = 205;
pub const JIT_OP_LGT: u32 = 206;
pub const JIT_OP_LGT_UN: u32 = 207;
pub const JIT_OP_LGE: u32 = 208;
pub const JIT_OP_LGE_UN: u32 = 209;
pub const JIT_OP_FEQ: u32 = 210;
pub const JIT_OP_FNE: u32 = 211;
pub const JIT_OP_FLT: u32 = 212;
pub const JIT_OP_FLE: u32 = 213;
pub const JIT_OP_FGT: u32 = 214;
pub const JIT_OP_FGE: u32 = 215;
pub const JIT_OP_FLT_INV: u32 = 216;
pub const JIT_OP_FLE_INV: u32 = 217;
pub const JIT_OP_FGT_INV: u32 = 218;
pub const JIT_OP_FGE_INV: u32 = 219;
pub const JIT_OP_DEQ: u32 = 220;
pub const JIT_OP_DNE: u32 = 221;
pub const JIT_OP_DLT: u32 = 222;
pub const JIT_OP_DLE: u32 = 223;
pub const JIT_OP_DGT: u32 = 224;
pub const JIT_OP_DGE: u32 = 225;
pub const JIT_OP_DLT_INV: u32 = 226;
pub const JIT_OP_DLE_INV: u32 = 227;
pub const JIT_OP_DGT_INV: u32 = 228;
pub const JIT_OP_DGE_INV: u32 = 229;
pub const JIT_OP_NFEQ: u32 = 230;
pub const JIT_OP_NFNE: u32 = 231;
pub const JIT_OP_NFLT: u32 = 232;
pub const JIT_OP_NFLE: u32 = 233;
pub const JIT_OP_NFGT: u32 = 234;
pub const JIT_OP_NFGE: u32 = 235;
pub const JIT_OP_NFLT_INV: u32 = 236;
pub const JIT_OP_NFLE_INV: u32 = 237;
pub const JIT_OP_NFGT_INV: u32 = 238;
pub const JIT_OP_NFGE_INV: u32 = 239;
pub const JIT_OP_IS_FNAN: u32 = 240;
pub const JIT_OP_IS_FINF: u32 = 241;
pub const JIT_OP_IS_FFINITE: u32 = 242;
pub const JIT_OP_IS_DNAN: u32 = 243;
pub const JIT_OP_IS_DINF: u32 = 244;
pub const JIT_OP_IS_DFINITE: u32 = 245;
pub const JIT_OP_IS_NFNAN: u32 = 246;
pub const JIT_OP_IS_NFINF: u32 = 247;
pub const JIT_OP_IS_NFFINITE: u32 = 248;
pub const JIT_OP_FACOS: u32 = 249;
pub const JIT_OP_FASIN: u32 = 250;
pub const JIT_OP_FATAN: u32 = 251;
pub const JIT_OP_FATAN2: u32 = 252;
pub const JIT_OP_FCEIL: u32 = 253;
pub const JIT_OP_FCOS: u32 = 254;
pub const JIT_OP_FCOSH: u32 = 255;
pub const JIT_OP_FEXP: u32 = 256;
pub const JIT_OP_FFLOOR: u32 = 257;
pub const JIT_OP_FLOG: u32 = 258;
pub const JIT_OP_FLOG10: u32 = 259;
pub const JIT_OP_FPOW: u32 = 260;
pub const JIT_OP_FRINT: u32 = 261;
pub const JIT_OP_FROUND: u32 = 262;
pub const JIT_OP_FSIN: u32 = 263;
pub const JIT_OP_FSINH: u32 = 264;
pub const JIT_OP_FSQRT: u32 = 265;
pub const JIT_OP_FTAN: u32 = 266;
pub const JIT_OP_FTANH: u32 = 267;
pub const JIT_OP_FTRUNC: u32 = 268;
pub const JIT_OP_DACOS: u32 = 269;
pub const JIT_OP_DASIN: u32 = 270;
pub const JIT_OP_DATAN: u32 = 271;
pub const JIT_OP_DATAN2: u32 = 272;
pub const JIT_OP_DCEIL: u32 = 273;
pub const JIT_OP_DCOS: u32 = 274;
pub const JIT_OP_DCOSH: u32 = 275;
pub const JIT_OP_DEXP: u32 = 276;
pub const JIT_OP_DFLOOR: u32 = 277;
pub const JIT_OP_DLOG: u32 = 278;
pub const JIT_OP_DLOG10: u32 = 279;
pub const JIT_OP_DPOW: u32 = 280;
pub const JIT_OP_DRINT: u32 = 281;
pub const JIT_OP_DROUND: u32 = 282;
pub const JIT_OP_DSIN: u32 = 283;
pub const JIT_OP_DSINH: u32 = 284;
pub const JIT_OP_DSQRT: u32 = 285;
pub const JIT_OP_DTAN: u32 = 286;
pub const JIT_OP_DTANH: u32 = 287;
pub const JIT_OP_DTRUNC: u32 = 288;
pub const JIT_OP_NFACOS: u32 = 289;
pub const JIT_OP_NFASIN: u32 = 290;
pub const JIT_OP_NFATAN: u32 = 291;
pub const JIT_OP_NFATAN2: u32 = 292;
pub const JIT_OP_NFCEIL: u32 = 293;
pub const JIT_OP_NFCOS: u32 = 294;
pub const JIT_OP_NFCOSH: u32 = 295;
pub const JIT_OP_NFEXP: u32 = 296;
pub const JIT_OP_NFFLOOR: u32 = 297;
pub const JIT_OP_NFLOG: u32 = 298;
pub const JIT_OP_NFLOG10: u32 = 299;
pub const JIT_OP_NFPOW: u32 = 300;
pub const JIT_OP_NFRINT: u32 = 301;
pub const JIT_OP_NFROUND: u32 = 302;
pub const JIT_OP_NFSIN: u32 = 303;
pub const JIT_OP_NFSINH: u32 = 304;
pub const JIT_OP_NFSQRT: u32 = 305;
pub const JIT_OP_NFTAN: u32 = 306;
pub const JIT_OP_NFTANH: u32 = 307;
pub const JIT_OP_NFTRUNC: u32 = 308;
pub const JIT_OP_IABS: u32 = 309;
pub const JIT_OP_LABS: u32 = 310;
pub const JIT_OP_FABS: u32 = 311;
pub const JIT_OP_DABS: u32 = 312;
pub const JIT_OP_NFABS: u32 = 313;
pub const JIT_OP_IMIN: u32 = 314;
pub const JIT_OP_IMIN_UN: u32 = 315;
pub const JIT_OP_LMIN: u32 = 316;
pub const JIT_OP_LMIN_UN: u32 = 317;
pub const JIT_OP_FMIN: u32 = 318;
pub const JIT_OP_DMIN: u32 = 319;
pub const JIT_OP_NFMIN: u32 = 320;
pub const JIT_OP_IMAX: u32 = 321;
pub const JIT_OP_IMAX_UN: u32 = 322;
pub const JIT_OP_LMAX: u32 = 323;
pub const JIT_OP_LMAX_UN: u32 = 324;
pub const JIT_OP_FMAX: u32 = 325;
pub const JIT_OP_DMAX: u32 = 326;
pub const JIT_OP_NFMAX: u32 = 327;
pub const JIT_OP_ISIGN: u32 = 328;
pub const JIT_OP_LSIGN: u32 = 329;
pub const JIT_OP_FSIGN: u32 = 330;
pub const JIT_OP_DSIGN: u32 = 331;
pub const JIT_OP_NFSIGN: u32 = 332;
pub const JIT_OP_CHECK_NULL: u32 = 333;
pub const JIT_OP_CALL: u32 = 334;
pub const JIT_OP_CALL_TAIL: u32 = 335;
pub const JIT_OP_CALL_INDIRECT: u32 = 336;
pub const JIT_OP_CALL_INDIRECT_TAIL: u32 = 337;
pub const JIT_OP_CALL_VTABLE_PTR: u32 = 338;
pub const JIT_OP_CALL_VTABLE_PTR_TAIL: u32 = 339;
pub const JIT_OP_CALL_EXTERNAL: u32 = 340;
pub const JIT_OP_CALL_EXTERNAL_TAIL: u32 = 341;
pub const JIT_OP_RETURN: u32 = 342;
pub const JIT_OP_RETURN_INT: u32 = 343;
pub const JIT_OP_RETURN_LONG: u32 = 344;
pub const JIT_OP_RETURN_FLOAT32: u32 = 345;
pub const JIT_OP_RETURN_FLOAT64: u32 = 346;
pub const JIT_OP_RETURN_NFLOAT: u32 = 347;
pub const JIT_OP_RETURN_SMALL_STRUCT: u32 = 348;
pub const JIT_OP_IMPORT: u32 = 349;
pub const JIT_OP_THROW: u32 = 350;
pub const JIT_OP_RETHROW: u32 = 351;
pub const JIT_OP_LOAD_PC: u32 = 352;
pub const JIT_OP_LOAD_EXCEPTION_PC: u32 = 353;
pub const JIT_OP_ENTER_FINALLY: u32 = 354;
pub const JIT_OP_LEAVE_FINALLY: u32 = 355;
pub const JIT_OP_CALL_FINALLY: u32 = 356;
pub const JIT_OP_ENTER_FILTER: u32 = 357;
pub const JIT_OP_LEAVE_FILTER: u32 = 358;
pub const JIT_OP_CALL_FILTER: u32 = 359;
pub const JIT_OP_CALL_FILTER_RETURN: u32 = 360;
pub const JIT_OP_ADDRESS_OF_LABEL: u32 = 361;
pub const JIT_OP_COPY_LOAD_SBYTE: u32 = 362;
pub const JIT_OP_COPY_LOAD_UBYTE: u32 = 363;
pub const JIT_OP_COPY_LOAD_SHORT: u32 = 364;
pub const JIT_OP_COPY_LOAD_USHORT: u32 = 365;
pub const JIT_OP_COPY_INT: u32 = 366;
pub const JIT_OP_COPY_LONG: u32 = 367;
pub const JIT_OP_COPY_FLOAT32: u32 = 368;
pub const JIT_OP_COPY_FLOAT64: u32 = 369;
pub const JIT_OP_COPY_NFLOAT: u32 = 370;
pub const JIT_OP_COPY_STRUCT: u32 = 371;
pub const JIT_OP_COPY_STORE_BYTE: u32 = 372;
pub const JIT_OP_COPY_STORE_SHORT: u32 = 373;
pub const JIT_OP_ADDRESS_OF: u32 = 374;
pub const JIT_OP_INCOMING_REG: u32 = 375;
pub const JIT_OP_INCOMING_FRAME_POSN: u32 = 376;
pub const JIT_OP_OUTGOING_REG: u32 = 377;
pub const JIT_OP_RETURN_REG: u32 = 378;
pub const JIT_OP_RETRIEVE_FRAME_POINTER: u32 = 379;
pub const JIT_OP_PUSH_INT: u32 = 380;
pub const JIT_OP_PUSH_LONG: u32 = 381;
pub const JIT_OP_PUSH_FLOAT32: u32 = 382;
pub const JIT_OP_PUSH_FLOAT64: u32 = 383;
pub const JIT_OP_PUSH_NFLOAT: u32 = 384;
pub const JIT_OP_PUSH_STRUCT: u32 = 385;
pub const JIT_OP_POP_STACK: u32 = 386;
pub const JIT_OP_FLUSH_SMALL_STRUCT: u32 = 387;
pub const JIT_OP_SET_PARAM_INT: u32 = 388;
pub const JIT_OP_SET_PARAM_LONG: u32 = 389;
pub const JIT_OP_SET_PARAM_FLOAT32: u32 = 390;
pub const JIT_OP_SET_PARAM_FLOAT64: u32 = 391;
pub const JIT_OP_SET_PARAM_NFLOAT: u32 = 392;
pub const JIT_OP_SET_PARAM_STRUCT: u32 = 393;
pub const JIT_OP_PUSH_RETURN_AREA_PTR: u32 = 394;
pub const JIT_OP_LOAD_RELATIVE_SBYTE: u32 = 395;
pub const JIT_OP_LOAD_RELATIVE_UBYTE: u32 = 396;
pub const JIT_OP_LOAD_RELATIVE_SHORT: u32 = 397;
pub const JIT_OP_LOAD_RELATIVE_USHORT: u32 = 398;
pub const JIT_OP_LOAD_RELATIVE_INT: u32 = 399;
pub const JIT_OP_LOAD_RELATIVE_LONG: u32 = 400;
pub const JIT_OP_LOAD_RELATIVE_FLOAT32: u32 = 401;
pub const JIT_OP_LOAD_RELATIVE_FLOAT64: u32 = 402;
pub const JIT_OP_LOAD_RELATIVE_NFLOAT: u32 = 403;
pub const JIT_OP_LOAD_RELATIVE_STRUCT: u32 = 404;
pub const JIT_OP_STORE_RELATIVE_BYTE: u32 = 405;
pub const JIT_OP_STORE_RELATIVE_SHORT: u32 = 406;
pub const JIT_OP_STORE_RELATIVE_INT: u32 = 407;
pub const JIT_OP_STORE_RELATIVE_LONG: u32 = 408;
pub const JIT_OP_STORE_RELATIVE_FLOAT32: u32 = 409;
pub const JIT_OP_STORE_RELATIVE_FLOAT64: u32 = 410;
pub const JIT_OP_STORE_RELATIVE_NFLOAT: u32 = 411;
pub const JIT_OP_STORE_RELATIVE_STRUCT: u32 = 412;
pub const JIT_OP_ADD_RELATIVE: u32 = 413;
pub const JIT_OP_LOAD_ELEMENT_SBYTE: u32 = 414;
pub const JIT_OP_LOAD_ELEMENT_UBYTE: u32 = 415;
pub const JIT_OP_LOAD_ELEMENT_SHORT: u32 = 416;
pub const JIT_OP_LOAD_ELEMENT_USHORT: u32 = 417;
pub const JIT_OP_LOAD_ELEMENT_INT: u32 = 418;
pub const JIT_OP_LOAD_ELEMENT_LONG: u32 = 419;
pub const JIT_OP_LOAD_ELEMENT_FLOAT32: u32 = 420;
pub const JIT_OP_LOAD_ELEMENT_FLOAT64: u32 = 421;
pub const JIT_OP_LOAD_ELEMENT_NFLOAT: u32 = 422;
pub const JIT_OP_STORE_ELEMENT_BYTE: u32 = 423;
pub const JIT_OP_STORE_ELEMENT_SHORT: u32 = 424;
pub const JIT_OP_STORE_ELEMENT_INT: u32 = 425;
pub const JIT_OP_STORE_ELEMENT_LONG: u32 = 426;
pub const JIT_OP_STORE_ELEMENT_FLOAT32: u32 = 427;
pub const JIT_OP_STORE_ELEMENT_FLOAT64: u32 = 428;
pub const JIT_OP_STORE_ELEMENT_NFLOAT: u32 = 429;
pub const JIT_OP_MEMCPY: u32 = 430;
pub const JIT_OP_MEMMOVE: u32 = 431;
pub const JIT_OP_MEMSET: u32 = 432;
pub const JIT_OP_ALLOCA: u32 = 433;
pub const JIT_OP_MARK_OFFSET: u32 = 434;
pub const JIT_OP_MARK_BREAKPOINT: u32 = 435;
pub const JIT_OP_JUMP_TABLE: u32 = 436;
pub const JIT_OP_NUM_OPCODES: u32 = 437;
pub const JIT_OPCODE_DEST_MASK: u32 = 15;
pub const JIT_OPCODE_DEST_EMPTY: u32 = 0;
pub const JIT_OPCODE_DEST_INT: u32 = 1;
pub const JIT_OPCODE_DEST_LONG: u32 = 2;
pub const JIT_OPCODE_DEST_FLOAT32: u32 = 3;
pub const JIT_OPCODE_DEST_FLOAT64: u32 = 4;
pub const JIT_OPCODE_DEST_NFLOAT: u32 = 5;
pub const JIT_OPCODE_DEST_ANY: u32 = 6;
pub const JIT_OPCODE_SRC1_MASK: u32 = 240;
pub const JIT_OPCODE_SRC1_EMPTY: u32 = 0;
pub const JIT_OPCODE_SRC1_INT: u32 = 16;
pub const JIT_OPCODE_SRC1_LONG: u32 = 32;
pub const JIT_OPCODE_SRC1_FLOAT32: u32 = 48;
pub const JIT_OPCODE_SRC1_FLOAT64: u32 = 64;
pub const JIT_OPCODE_SRC1_NFLOAT: u32 = 80;
pub const JIT_OPCODE_SRC1_ANY: u32 = 96;
pub const JIT_OPCODE_SRC2_MASK: u32 = 3840;
pub const JIT_OPCODE_SRC2_EMPTY: u32 = 0;
pub const JIT_OPCODE_SRC2_INT: u32 = 256;
pub const JIT_OPCODE_SRC2_LONG: u32 = 512;
pub const JIT_OPCODE_SRC2_FLOAT32: u32 = 768;
pub const JIT_OPCODE_SRC2_FLOAT64: u32 = 1024;
pub const JIT_OPCODE_SRC2_NFLOAT: u32 = 1280;
pub const JIT_OPCODE_SRC2_ANY: u32 = 1536;
pub const JIT_OPCODE_IS_BRANCH: u32 = 4096;
pub const JIT_OPCODE_IS_CALL: u32 = 8192;
pub const JIT_OPCODE_IS_CALL_EXTERNAL: u32 = 16384;
pub const JIT_OPCODE_IS_REG: u32 = 32768;
pub const JIT_OPCODE_IS_ADDROF_LABEL: u32 = 65536;
pub const JIT_OPCODE_IS_JUMP_TABLE: u32 = 131072;
pub const JIT_OPCODE_OPER_MASK: u32 = 32505856;
pub const JIT_OPCODE_OPER_NONE: u32 = 0;
pub const JIT_OPCODE_OPER_ADD: u32 = 1048576;
pub const JIT_OPCODE_OPER_SUB: u32 = 2097152;
pub const JIT_OPCODE_OPER_MUL: u32 = 3145728;
pub const JIT_OPCODE_OPER_DIV: u32 = 4194304;
pub const JIT_OPCODE_OPER_REM: u32 = 5242880;
pub const JIT_OPCODE_OPER_NEG: u32 = 6291456;
pub const JIT_OPCODE_OPER_AND: u32 = 7340032;
pub const JIT_OPCODE_OPER_OR: u32 = 8388608;
pub const JIT_OPCODE_OPER_XOR: u32 = 9437184;
pub const JIT_OPCODE_OPER_NOT: u32 = 10485760;
pub const JIT_OPCODE_OPER_EQ: u32 = 11534336;
pub const JIT_OPCODE_OPER_NE: u32 = 12582912;
pub const JIT_OPCODE_OPER_LT: u32 = 13631488;
pub const JIT_OPCODE_OPER_LE: u32 = 14680064;
pub const JIT_OPCODE_OPER_GT: u32 = 15728640;
pub const JIT_OPCODE_OPER_GE: u32 = 16777216;
pub const JIT_OPCODE_OPER_SHL: u32 = 17825792;
pub const JIT_OPCODE_OPER_SHR: u32 = 18874368;
pub const JIT_OPCODE_OPER_SHR_UN: u32 = 19922944;
pub const JIT_OPCODE_OPER_COPY: u32 = 20971520;
pub const JIT_OPCODE_OPER_ADDRESS_OF: u32 = 22020096;
pub const JIT_OPCODE_DEST_PTR: u32 = 2;
pub const JIT_OPCODE_SRC1_PTR: u32 = 32;
pub const JIT_OPCODE_SRC2_PTR: u32 = 512;
pub const JIT_OP_FEQ_INV: u32 = 210;
pub const JIT_OP_FNE_INV: u32 = 211;
pub const JIT_OP_DEQ_INV: u32 = 220;
pub const JIT_OP_DNE_INV: u32 = 221;
pub const JIT_OP_NFEQ_INV: u32 = 230;
pub const JIT_OP_NFNE_INV: u32 = 231;
pub const JIT_OP_BR_FEQ_INV: u32 = 150;
pub const JIT_OP_BR_FNE_INV: u32 = 151;
pub const JIT_OP_BR_DEQ_INV: u32 = 160;
pub const JIT_OP_BR_DNE_INV: u32 = 161;
pub const JIT_OP_BR_NFEQ_INV: u32 = 170;
pub const JIT_OP_BR_NFNE_INV: u32 = 171;
pub const JIT_FAST_GET_CURRENT_FRAME: u32 = 1;

pub const jit_label_undefined: jit_label_t = !0;
pub const JIT_NO_OFFSET: c_uint = !0;

pub type jit_sbyte = ::std::os::raw::c_char;
pub type jit_ubyte = ::std::os::raw::c_uchar;
pub type jit_short = ::std::os::raw::c_short;
pub type jit_ushort = ::std::os::raw::c_ushort;
pub type jit_int = ::std::os::raw::c_int;
pub type jit_uint = ::std::os::raw::c_uint;
pub type jit_nint = ::std::os::raw::c_long;
pub type jit_nuint = ::std::os::raw::c_ulong;
pub type jit_long = ::std::os::raw::c_long;
pub type jit_ulong = ::std::os::raw::c_ulong;
pub type jit_float32 = f32;
pub type jit_float64 = f64;
pub type jit_nfloat = jit_float64;
pub type jit_ptr = *mut ::std::os::raw::c_void;
pub type jit_size_t = jit_nuint;
pub type _jit_context = c_void;
pub type jit_context_t = *mut _jit_context;
pub type _jit_function = c_void;
pub type jit_function_t = *mut _jit_function;
pub type _jit_block = c_void;
pub type jit_block_t = *mut _jit_block;
pub type _jit_insn = c_void;
pub type jit_insn_t = *mut _jit_insn;
pub type _jit_value = c_void;
pub type jit_value_t = *mut _jit_value;
pub type _jit_type = c_void;
pub type jit_type_t = *mut _jit_type;
pub type jit_stack_trace = c_void;
pub type jit_stack_trace_t = *mut jit_stack_trace;
pub type jit_label_t = jit_nuint;
pub type jit_meta_free_func =
    ::std::option::Option<unsafe extern "C" fn(data: *mut ::std::os::raw::c_void)>;
pub type jit_on_demand_func =
    ::std::option::Option<unsafe extern "C" fn(func: jit_function_t) -> ::std::os::raw::c_int>;
pub type jit_on_demand_driver_func = ::std::option::Option<
    unsafe extern "C" fn(func: jit_function_t) -> *mut ::std::os::raw::c_void,
>;
pub type jit_memory_context_t = *mut ::std::os::raw::c_void;
pub type jit_function_info_t = *mut ::std::os::raw::c_void;
pub type jit_memory_manager_t = *const jit_memory_manager;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jit_memory_manager {
    pub create:
        ::std::option::Option<unsafe extern "C" fn(context: jit_context_t) -> jit_memory_context_t>,
    pub destroy: ::std::option::Option<unsafe extern "C" fn(memctx: jit_memory_context_t)>,
    pub find_function_info: ::std::option::Option<
        unsafe extern "C" fn(
            memctx: jit_memory_context_t,
            pc: *mut ::std::os::raw::c_void,
        ) -> jit_function_info_t,
    >,
    pub get_function: ::std::option::Option<
        unsafe extern "C" fn(
            memctx: jit_memory_context_t,
            info: jit_function_info_t,
        ) -> jit_function_t,
    >,
    pub get_function_start: ::std::option::Option<
        unsafe extern "C" fn(
            memctx: jit_memory_context_t,
            info: jit_function_info_t,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub get_function_end: ::std::option::Option<
        unsafe extern "C" fn(
            memctx: jit_memory_context_t,
            info: jit_function_info_t,
        ) -> *mut ::std::os::raw::c_void,
    >,
    pub alloc_function:
        ::std::option::Option<unsafe extern "C" fn(memctx: jit_memory_context_t) -> jit_function_t>,
    pub free_function: ::std::option::Option<
        unsafe extern "C" fn(memctx: jit_memory_context_t, func: jit_function_t),
    >,
    pub start_function: ::std::option::Option<
        unsafe extern "C" fn(
            memctx: jit_memory_context_t,
            func: jit_function_t,
        ) -> ::std::os::raw::c_int,
    >,
    pub end_function: ::std::option::Option<
        unsafe extern "C" fn(
            memctx: jit_memory_context_t,
            result: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub extend_limit: ::std::option::Option<
        unsafe extern "C" fn(
            memctx: jit_memory_context_t,
            count: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub get_limit: ::std::option::Option<
        unsafe extern "C" fn(memctx: jit_memory_context_t) -> *mut ::std::os::raw::c_void,
    >,
    pub get_break: ::std::option::Option<
        unsafe extern "C" fn(memctx: jit_memory_context_t) -> *mut ::std::os::raw::c_void,
    >,
    pub set_break: ::std::option::Option<
        unsafe extern "C" fn(memctx: jit_memory_context_t, brk: *mut ::std::os::raw::c_void),
    >,
    pub alloc_trampoline: ::std::option::Option<
        unsafe extern "C" fn(memctx: jit_memory_context_t) -> *mut ::std::os::raw::c_void,
    >,
    pub free_trampoline: ::std::option::Option<
        unsafe extern "C" fn(memctx: jit_memory_context_t, ptr: *mut ::std::os::raw::c_void),
    >,
    pub alloc_closure: ::std::option::Option<
        unsafe extern "C" fn(memctx: jit_memory_context_t) -> *mut ::std::os::raw::c_void,
    >,
    pub free_closure: ::std::option::Option<
        unsafe extern "C" fn(memctx: jit_memory_context_t, ptr: *mut ::std::os::raw::c_void),
    >,
    pub alloc_data: ::std::option::Option<
        unsafe extern "C" fn(
            memctx: jit_memory_context_t,
            size: jit_size_t,
            align: jit_size_t,
        ) -> *mut ::std::os::raw::c_void,
    >,
}
extern "C" {
    pub fn jit_default_memory_manager() -> jit_memory_manager_t;
    pub fn jit_context_create() -> jit_context_t;
    pub fn jit_context_destroy(context: jit_context_t);
    pub fn jit_context_build_start(context: jit_context_t);
    pub fn jit_context_build_end(context: jit_context_t);
    pub fn jit_context_set_on_demand_driver(
        context: jit_context_t,
        driver: jit_on_demand_driver_func,
    );
    pub fn jit_context_set_memory_manager(context: jit_context_t, manager: jit_memory_manager_t);
    pub fn jit_context_set_meta(
        context: jit_context_t,
        type_: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        free_data: jit_meta_free_func,
    ) -> ::std::os::raw::c_int;
    pub fn jit_context_set_meta_numeric(
        context: jit_context_t,
        type_: ::std::os::raw::c_int,
        data: jit_nuint,
    ) -> ::std::os::raw::c_int;

    pub fn jit_context_get_meta(
        context: jit_context_t,
        type_: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;

    pub fn jit_context_get_meta_numeric(
        context: jit_context_t,
        type_: ::std::os::raw::c_int,
    ) -> jit_nuint;

    pub fn jit_context_free_meta(context: jit_context_t, type_: ::std::os::raw::c_int);

    pub static jit_type_void: jit_type_t;

    pub static jit_type_sbyte: jit_type_t;

    pub static jit_type_ubyte: jit_type_t;

    pub static jit_type_short: jit_type_t;

    pub static jit_type_ushort: jit_type_t;

    pub static jit_type_int: jit_type_t;

    pub static jit_type_uint: jit_type_t;

    pub static jit_type_nint: jit_type_t;

    pub static jit_type_nuint: jit_type_t;

    pub static jit_type_long: jit_type_t;

    pub static jit_type_ulong: jit_type_t;

    pub static jit_type_float32: jit_type_t;

    pub static jit_type_float64: jit_type_t;

    pub static jit_type_nfloat: jit_type_t;

    pub static jit_type_void_ptr: jit_type_t;

    pub static jit_type_sys_bool: jit_type_t;

    pub static jit_type_sys_char: jit_type_t;

    pub static jit_type_sys_schar: jit_type_t;

    pub static jit_type_sys_uchar: jit_type_t;

    pub static jit_type_sys_short: jit_type_t;

    pub static jit_type_sys_ushort: jit_type_t;

    pub static jit_type_sys_int: jit_type_t;

    pub static jit_type_sys_uint: jit_type_t;

    pub static jit_type_sys_long: jit_type_t;

    pub static jit_type_sys_ulong: jit_type_t;

    pub static jit_type_sys_longlong: jit_type_t;

    pub static jit_type_sys_ulonglong: jit_type_t;

    pub static jit_type_sys_float: jit_type_t;

    pub static jit_type_sys_double: jit_type_t;

    pub static jit_type_sys_long_double: jit_type_t;
}
pub const jit_abi_t_jit_abi_cdecl: jit_abi_t = 0;
pub const jit_abi_t_jit_abi_vararg: jit_abi_t = 1;
pub const jit_abi_t_jit_abi_stdcall: jit_abi_t = 2;
pub const jit_abi_t_jit_abi_fastcall: jit_abi_t = 3;
pub type jit_abi_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn jit_type_copy(type_: jit_type_t) -> jit_type_t;

    pub fn jit_type_free(type_: jit_type_t);

    pub fn jit_type_create_struct(
        fields: *mut jit_type_t,
        num_fields: ::std::os::raw::c_uint,
        incref: ::std::os::raw::c_int,
    ) -> jit_type_t;

    pub fn jit_type_create_union(
        fields: *mut jit_type_t,
        num_fields: ::std::os::raw::c_uint,
        incref: ::std::os::raw::c_int,
    ) -> jit_type_t;

    pub fn jit_type_create_signature(
        abi: jit_abi_t,
        return_type: jit_type_t,
        params: *mut jit_type_t,
        num_params: ::std::os::raw::c_uint,
        incref: ::std::os::raw::c_int,
    ) -> jit_type_t;

    pub fn jit_type_create_pointer(type_: jit_type_t, incref: ::std::os::raw::c_int) -> jit_type_t;

    pub fn jit_type_create_tagged(
        type_: jit_type_t,
        kind: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        free_func: jit_meta_free_func,
        incref: ::std::os::raw::c_int,
    ) -> jit_type_t;

    pub fn jit_type_set_names(
        type_: jit_type_t,
        names: *mut *mut ::std::os::raw::c_char,
        num_names: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;

    pub fn jit_type_set_size_and_alignment(type_: jit_type_t, size: jit_nint, alignment: jit_nint);

    pub fn jit_type_set_offset(
        type_: jit_type_t,
        field_index: ::std::os::raw::c_uint,
        offset: jit_nuint,
    );

    pub fn jit_type_get_kind(type_: jit_type_t) -> ::std::os::raw::c_int;

    pub fn jit_type_get_size(type_: jit_type_t) -> jit_nuint;

    pub fn jit_type_get_alignment(type_: jit_type_t) -> jit_nuint;

    pub fn jit_type_best_alignment() -> jit_nuint;

    pub fn jit_type_num_fields(type_: jit_type_t) -> ::std::os::raw::c_uint;

    pub fn jit_type_get_field(type_: jit_type_t, field_index: ::std::os::raw::c_uint)
        -> jit_type_t;

    pub fn jit_type_get_offset(type_: jit_type_t, field_index: ::std::os::raw::c_uint)
        -> jit_nuint;

    pub fn jit_type_get_name(
        type_: jit_type_t,
        index: ::std::os::raw::c_uint,
    ) -> *const ::std::os::raw::c_char;

    pub fn jit_type_find_name(
        type_: jit_type_t,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_uint;

    pub fn jit_type_num_params(type_: jit_type_t) -> ::std::os::raw::c_uint;

    pub fn jit_type_get_return(type_: jit_type_t) -> jit_type_t;

    pub fn jit_type_get_param(type_: jit_type_t, param_index: ::std::os::raw::c_uint)
        -> jit_type_t;

    pub fn jit_type_get_abi(type_: jit_type_t) -> jit_abi_t;

    pub fn jit_type_get_ref(type_: jit_type_t) -> jit_type_t;

    pub fn jit_type_get_tagged_type(type_: jit_type_t) -> jit_type_t;

    pub fn jit_type_set_tagged_type(
        type_: jit_type_t,
        underlying: jit_type_t,
        incref: ::std::os::raw::c_int,
    );

    pub fn jit_type_get_tagged_kind(type_: jit_type_t) -> ::std::os::raw::c_int;

    pub fn jit_type_get_tagged_data(type_: jit_type_t) -> *mut ::std::os::raw::c_void;

    pub fn jit_type_set_tagged_data(
        type_: jit_type_t,
        data: *mut ::std::os::raw::c_void,
        free_func: jit_meta_free_func,
    );

    pub fn jit_type_is_primitive(type_: jit_type_t) -> ::std::os::raw::c_int;

    pub fn jit_type_is_struct(type_: jit_type_t) -> ::std::os::raw::c_int;

    pub fn jit_type_is_union(type_: jit_type_t) -> ::std::os::raw::c_int;

    pub fn jit_type_is_signature(type_: jit_type_t) -> ::std::os::raw::c_int;

    pub fn jit_type_is_pointer(type_: jit_type_t) -> ::std::os::raw::c_int;

    pub fn jit_type_is_tagged(type_: jit_type_t) -> ::std::os::raw::c_int;

    pub fn jit_type_remove_tags(type_: jit_type_t) -> jit_type_t;

    pub fn jit_type_normalize(type_: jit_type_t) -> jit_type_t;

    pub fn jit_type_promote_int(type_: jit_type_t) -> jit_type_t;

    pub fn jit_type_return_via_pointer(type_: jit_type_t) -> ::std::os::raw::c_int;

    pub fn jit_type_has_tag(
        type_: jit_type_t,
        kind: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type jit_closure_func = ::std::option::Option<
    unsafe extern "C" fn(
        signature: jit_type_t,
        result: *mut ::std::os::raw::c_void,
        args: *mut *mut ::std::os::raw::c_void,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type jit_closure_va_list = c_void;
pub type jit_closure_va_list_t = *mut jit_closure_va_list;
extern "C" {
    pub fn jit_apply(
        signature: jit_type_t,
        func: *mut ::std::os::raw::c_void,
        args: *mut *mut ::std::os::raw::c_void,
        num_fixed_args: ::std::os::raw::c_uint,
        return_value: *mut ::std::os::raw::c_void,
    );

    pub fn jit_apply_raw(
        signature: jit_type_t,
        func: *mut ::std::os::raw::c_void,
        args: *mut ::std::os::raw::c_void,
        return_value: *mut ::std::os::raw::c_void,
    );

    pub fn jit_raw_supported(signature: jit_type_t) -> ::std::os::raw::c_int;

    pub fn jit_closure_create(
        context: jit_context_t,
        signature: jit_type_t,
        func: jit_closure_func,
        user_data: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;

    pub fn jit_closure_va_get_nint(va: jit_closure_va_list_t) -> jit_nint;

    pub fn jit_closure_va_get_nuint(va: jit_closure_va_list_t) -> jit_nuint;

    pub fn jit_closure_va_get_long(va: jit_closure_va_list_t) -> jit_long;

    pub fn jit_closure_va_get_ulong(va: jit_closure_va_list_t) -> jit_ulong;

    pub fn jit_closure_va_get_float32(va: jit_closure_va_list_t) -> jit_float32;

    pub fn jit_closure_va_get_float64(va: jit_closure_va_list_t) -> jit_float64;

    pub fn jit_closure_va_get_nfloat(va: jit_closure_va_list_t) -> jit_nfloat;

    pub fn jit_closure_va_get_ptr(va: jit_closure_va_list_t) -> *mut ::std::os::raw::c_void;

    pub fn jit_closure_va_get_struct(
        va: jit_closure_va_list_t,
        buf: *mut ::std::os::raw::c_void,
        type_: jit_type_t,
    );

    /// Get the function that a particular `block` belongs to.
    pub fn jit_block_get_function(block: jit_block_t) -> jit_function_t;

    /// Get the context that a particular `block` belongs to.
    pub fn jit_block_get_context(block: jit_block_t) -> jit_context_t;

    /// Get the label associated with a block.
    pub fn jit_block_get_label(block: jit_block_t) -> jit_label_t;

    /// Get the next label associated with a block.
    pub fn jit_block_get_next_label(block: jit_block_t, label: jit_label_t) -> jit_label_t;

    /// Iterate over the blocks in a function, in order of their creation. The `previous` argument should be NULL on the first call. This function will return NULL if there are no further blocks to iterate.
    pub fn jit_block_next(func: jit_function_t, previous: jit_block_t) -> jit_block_t;

    /// Iterate over the blocks in a function, in reverse order of their creation. The `previous` argument should be NULL on the first call. This function will return NULL if there are no further blocks to iterate.
    pub fn jit_block_previous(func: jit_function_t, previous: jit_block_t) -> jit_block_t;

    /// Get the block that corresponds to a particular label. Returns NULL if there is no block associated with the label.
    pub fn jit_block_from_label(func: jit_function_t, label: jit_label_t) -> jit_block_t;

    /// Tag a block with some metadata. Returns zero if out of memory. If the `type` already has some metadata associated with it, then the previous value will be freed. Metadata may be used to store dependency graphs, branch prediction information, or any other information that is useful to optimizers or code generators.
    ///
    /// Metadata type values of 10000 or greater are reserved for internal use.
    pub fn jit_block_set_meta(
        block: jit_block_t,
        type_: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        free_data: jit_meta_free_func,
    ) -> ::std::os::raw::c_int;

    /// Get the metadata associated with a particular tag. Returns NULL if `type` does not have any metadata associated with it.
    pub fn jit_block_get_meta(
        block: jit_block_t,
        type_: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;

    /// Free metadata of a specific type on a block. Does nothing if the `type` does not have any metadata associated with it.
    pub fn jit_block_free_meta(block: jit_block_t, type_: ::std::os::raw::c_int);

    /// Determine if a block is reachable from some other point in its function. Unreachable blocks can be discarded in their entirety. If the JIT is uncertain as to whether a block is reachable, or it does not wish to perform expensive flow analysis to find out, then it will err on the side of caution and assume that it is reachable.
    pub fn jit_block_is_reachable(block: jit_block_t) -> ::std::os::raw::c_int;

    /// Determine if a block ends in a "dead" marker. That is, control will not fall out through the end of the block.
    pub fn jit_block_ends_in_dead(block: jit_block_t) -> ::std::os::raw::c_int;

    /// Determine if the current point in the function is dead. That is, there are no existing branches or fall-throughs to this point. This differs slightly from [`jit_block_ends_in_dead`] in that this can skip past zero-length blocks that may not appear to be dead to find the dead block at the head of a chain of empty blocks.
    pub fn jit_block_current_is_dead(func: jit_function_t) -> ::std::os::raw::c_int;
}
pub type jit_debugger = c_void;
pub type jit_debugger_t = *mut jit_debugger;
pub type jit_debugger_thread_id_t = jit_nint;
pub type jit_debugger_breakpoint_id_t = jit_nint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jit_debugger_event {
    pub type_: ::std::os::raw::c_int,
    pub thread: jit_debugger_thread_id_t,
    pub function: jit_function_t,
    pub data1: jit_nint,
    pub data2: jit_nint,
    pub id: jit_debugger_breakpoint_id_t,
    pub trace: jit_stack_trace_t,
}
pub type jit_debugger_event_t = jit_debugger_event;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jit_debugger_breakpoint_info {
    pub flags: ::std::os::raw::c_int,
    pub thread: jit_debugger_thread_id_t,
    pub function: jit_function_t,
    pub data1: jit_nint,
    pub data2: jit_nint,
}
pub type jit_debugger_breakpoint_info_t = *mut jit_debugger_breakpoint_info;
pub type jit_debugger_hook_func = ::std::option::Option<
    unsafe extern "C" fn(func: jit_function_t, data1: jit_nint, data2: jit_nint),
>;
extern "C" {
    pub fn jit_debugging_possible() -> ::std::os::raw::c_int;

    pub fn jit_debugger_create(context: jit_context_t) -> jit_debugger_t;

    pub fn jit_debugger_destroy(dbg: jit_debugger_t);

    pub fn jit_debugger_get_context(dbg: jit_debugger_t) -> jit_context_t;

    pub fn jit_debugger_from_context(context: jit_context_t) -> jit_debugger_t;

    pub fn jit_debugger_get_self(dbg: jit_debugger_t) -> jit_debugger_thread_id_t;

    pub fn jit_debugger_get_thread(
        dbg: jit_debugger_t,
        native_thread: *const ::std::os::raw::c_void,
    ) -> jit_debugger_thread_id_t;

    pub fn jit_debugger_get_native_thread(
        dbg: jit_debugger_t,
        thread: jit_debugger_thread_id_t,
        native_thread: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;

    pub fn jit_debugger_set_breakable(
        dbg: jit_debugger_t,
        native_thread: *const ::std::os::raw::c_void,
        flag: ::std::os::raw::c_int,
    );

    pub fn jit_debugger_attach_self(dbg: jit_debugger_t, stop_immediately: ::std::os::raw::c_int);

    pub fn jit_debugger_detach_self(dbg: jit_debugger_t);

    pub fn jit_debugger_wait_event(
        dbg: jit_debugger_t,
        event: *mut jit_debugger_event_t,
        timeout: jit_int,
    ) -> ::std::os::raw::c_int;

    pub fn jit_debugger_add_breakpoint(
        dbg: jit_debugger_t,
        info: jit_debugger_breakpoint_info_t,
    ) -> jit_debugger_breakpoint_id_t;

    pub fn jit_debugger_remove_breakpoint(dbg: jit_debugger_t, id: jit_debugger_breakpoint_id_t);

    pub fn jit_debugger_remove_all_breakpoints(dbg: jit_debugger_t);

    pub fn jit_debugger_is_alive(
        dbg: jit_debugger_t,
        thread: jit_debugger_thread_id_t,
    ) -> ::std::os::raw::c_int;

    pub fn jit_debugger_is_running(
        dbg: jit_debugger_t,
        thread: jit_debugger_thread_id_t,
    ) -> ::std::os::raw::c_int;

    pub fn jit_debugger_run(dbg: jit_debugger_t, thread: jit_debugger_thread_id_t);

    pub fn jit_debugger_step(dbg: jit_debugger_t, thread: jit_debugger_thread_id_t);

    pub fn jit_debugger_next(dbg: jit_debugger_t, thread: jit_debugger_thread_id_t);

    pub fn jit_debugger_finish(dbg: jit_debugger_t, thread: jit_debugger_thread_id_t);

    pub fn jit_debugger_break(dbg: jit_debugger_t);

    pub fn jit_debugger_quit(dbg: jit_debugger_t);

    pub fn jit_debugger_set_hook(
        context: jit_context_t,
        hook: jit_debugger_hook_func,
    ) -> jit_debugger_hook_func;

    pub fn jit_dump_type(stream: *mut FILE, type_: jit_type_t);

    pub fn jit_dump_value(
        stream: *mut FILE,
        func: jit_function_t,
        value: jit_value_t,
        prefix: *const ::std::os::raw::c_char,
    );

    pub fn jit_dump_insn(stream: *mut FILE, func: jit_function_t, insn: jit_insn_t);

    pub fn jit_dump_function(
        stream: *mut FILE,
        func: jit_function_t,
        name: *const ::std::os::raw::c_char,
    );
}
pub type jit_readelf = c_void;
pub type jit_readelf_t = *mut jit_readelf;
pub type jit_writeelf = c_void;
pub type jit_writeelf_t = *mut jit_writeelf;
extern "C" {
    pub fn jit_readelf_open(
        readelf: *mut jit_readelf_t,
        filename: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;

    pub fn jit_readelf_close(readelf: jit_readelf_t);

    pub fn jit_readelf_get_name(readelf: jit_readelf_t) -> *const ::std::os::raw::c_char;

    pub fn jit_readelf_get_symbol(
        readelf: jit_readelf_t,
        name: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void;

    pub fn jit_readelf_get_section(
        readelf: jit_readelf_t,
        name: *const ::std::os::raw::c_char,
        size: *mut jit_nuint,
    ) -> *mut ::std::os::raw::c_void;

    pub fn jit_readelf_get_section_by_type(
        readelf: jit_readelf_t,
        type_: jit_int,
        size: *mut jit_nuint,
    ) -> *mut ::std::os::raw::c_void;

    pub fn jit_readelf_map_vaddr(
        readelf: jit_readelf_t,
        vaddr: jit_nuint,
    ) -> *mut ::std::os::raw::c_void;

    pub fn jit_readelf_num_needed(readelf: jit_readelf_t) -> ::std::os::raw::c_uint;

    pub fn jit_readelf_get_needed(
        readelf: jit_readelf_t,
        index: ::std::os::raw::c_uint,
    ) -> *const ::std::os::raw::c_char;

    pub fn jit_readelf_add_to_context(readelf: jit_readelf_t, context: jit_context_t);

    pub fn jit_readelf_resolve_all(
        context: jit_context_t,
        print_failures: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;

    pub fn jit_readelf_register_symbol(
        context: jit_context_t,
        name: *const ::std::os::raw::c_char,
        value: *mut ::std::os::raw::c_void,
        after: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;

    pub fn jit_writeelf_create(library_name: *const ::std::os::raw::c_char) -> jit_writeelf_t;

    pub fn jit_writeelf_destroy(writeelf: jit_writeelf_t);

    pub fn jit_writeelf_write(
        writeelf: jit_writeelf_t,
        filename: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;

    pub fn jit_writeelf_add_function(
        writeelf: jit_writeelf_t,
        func: jit_function_t,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;

    pub fn jit_writeelf_add_needed(
        writeelf: jit_writeelf_t,
        library_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;

    pub fn jit_writeelf_write_section(
        writeelf: jit_writeelf_t,
        name: *const ::std::os::raw::c_char,
        type_: jit_int,
        buf: *const ::std::os::raw::c_void,
        len: ::std::os::raw::c_uint,
        discardable: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type jit_exception_func = ::std::option::Option<
    unsafe extern "C" fn(exception_type: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_void,
>;
extern "C" {
    /// Get the last exception object that occurred on this thread, or NULL if there is no exception object on this thread. As far as `libjit` is concerned, an exception is just a pointer. The precise meaning of the data at the pointer is determined by the front end.
    pub fn jit_exception_get_last() -> *mut ::std::os::raw::c_void;

    /// Get the last exception object that occurred on this thread and also clear the exception state to NULL. This combines the effect of both [`jit_exception_get_last`] and [`jit_exception_clear_last`].
    pub fn jit_exception_get_last_and_clear() -> *mut ::std::os::raw::c_void;

    /// Set the last exception object that occurred on this thread, so that it can be retrieved by a later call to [`jit_exception_get_last`]. This is normally used by [`jit_function_apply`] to save the exception object before returning to regular code.
    pub fn jit_exception_set_last(object: *mut ::std::os::raw::c_void);

    /// Clear the last exception object that occurred on this thread. This is equivalent to calling [`jit_exception_set_last`] with a parameter of NULL.
    pub fn jit_exception_clear_last();

    /// Throw an exception object within the current thread. As far as `libjit` is concerned, the exception object is just a pointer. The precise meaning of the data at the pointer is determined by the front end.
    ///
    /// Note: as an exception object works its way back up the stack, it may be temporarily stored in memory that is not normally visible to a garbage collector. The front-end is responsible for taking steps to "pin" the object so that it is uncollectable until explicitly copied back into a location that is visible to the collector once more.
    pub fn jit_exception_throw(object: *mut ::std::os::raw::c_void);

    /// This function is called to report a builtin exception. The JIT will automatically embed calls to this function wherever a builtin exception needs to be reported.
    /// When a builtin exception occurs, the current thread’s exception handler is called to construct an appropriate object, which is then thrown.
    /// If there is no exception handler set, or the handler returns NULL, then `libjit` will print an error message to stderr and cause the program to exit with a status of 1. You normally don’t want this behavior and you should override it if possible.
    ///
    /// The following builtin exception types are currently supported:
    ///
    /// | Type | Description |
    /// | ---- | ----------- |
    /// | JIT_RESULT_OK | The operation was performed successfully (value is 1). |
    /// | JIT_RESULT_OVERFLOW | The operation resulted in an overflow exception (value is 0). |
    /// | JIT_RESULT_ARITHMETIC | The operation resulted in an arithmetic exception. i.e. an attempt was made to divide the minimum integer value by -1 (value is -1). |
    /// | JIT_RESULT_DIVISION_BY_ZERO | The operation resulted in a division by zero exception (value is -2). |
    /// | JIT_RESULT_COMPILE_ERROR | An error occurred when attempting to dynamically compile a function (value is -3). |
    /// | JIT_RESULT_OUT_OF_MEMORY | The system ran out of memory while performing an operation (value is -4). |
    /// | JIT_RESULT_NULL_REFERENCE | An attempt was made to dereference a NULL pointer (value is -5). |
    /// | JIT_RESULT_NULL_FUNCTION | An attempt was made to call a function with a NULL function pointer (value is -6). |
    /// | JIT_RESULT_CALLED_NESTED | An attempt was made to call a nested function from a non-nested context (value is -7). |
    /// | JIT_RESULT_OUT_OF_BOUNDS | The operation resulted in an out of bounds array access (value is -8). |
    /// | JIT_RESULT_UNDEFINED_LABEL | A branch operation used a label that was not defined anywhere in the function (value is -9). |
    pub fn jit_exception_builtin(exception_type: ::std::os::raw::c_int);

    /// Set the builtin exception handler for the current thread. Returns the previous exception handler.
    pub fn jit_exception_set_handler(handler: jit_exception_func) -> jit_exception_func;

    /// Get the builtin exception handler for the current thread.
    pub fn jit_exception_get_handler() -> jit_exception_func;

    /// Create an object that represents the current call stack. This is normally used to indicate the location of an exception. Returns NULL if a stack trace is not available, or there is insufficient memory to create it.
    pub fn jit_exception_get_stack_trace() -> jit_stack_trace_t;

    /// Get the size of a stack trace.
    pub fn jit_stack_trace_get_size(trace: jit_stack_trace_t) -> ::std::os::raw::c_uint;

    /// Get the function that is at position `posn` within a stack trace. Position 0 is the function that created the stack trace. If this returns NULL, then it indicates that there is a native callout at `posn` within the stack trace.
    pub fn jit_stack_trace_get_function(
        context: jit_context_t,
        trace: jit_stack_trace_t,
        posn: ::std::os::raw::c_uint,
    ) -> jit_function_t;

    /// Get the program counter that corresponds to position `posn` within a stack trace. This is the point within the function where execution had reached at the time of the trace.
    pub fn jit_stack_trace_get_pc(
        trace: jit_stack_trace_t,
        posn: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_void;

    /// Get the bytecode offset that is recorded for position posn within a stack trace. This will be [`JIT_NO_OFFSET`] if there is no bytecode offset associated with `posn`.
    pub fn jit_stack_trace_get_offset(
        context: jit_context_t,
        trace: jit_stack_trace_t,
        posn: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;

    /// Free the memory associated with a stack trace.
    pub fn jit_stack_trace_free(trace: jit_stack_trace_t);

    pub fn jit_function_create(context: jit_context_t, signature: jit_type_t) -> jit_function_t;

    pub fn jit_function_create_nested(
        context: jit_context_t,
        signature: jit_type_t,
        parent: jit_function_t,
    ) -> jit_function_t;

    pub fn jit_function_abandon(func: jit_function_t);

    pub fn jit_function_get_context(func: jit_function_t) -> jit_context_t;

    pub fn jit_function_get_signature(func: jit_function_t) -> jit_type_t;

    pub fn jit_function_set_meta(
        func: jit_function_t,
        type_: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        free_data: jit_meta_free_func,
        build_only: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;

    pub fn jit_function_get_meta(
        func: jit_function_t,
        type_: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;

    pub fn jit_function_free_meta(func: jit_function_t, type_: ::std::os::raw::c_int);

    pub fn jit_function_next(context: jit_context_t, prev: jit_function_t) -> jit_function_t;

    pub fn jit_function_previous(context: jit_context_t, prev: jit_function_t) -> jit_function_t;

    pub fn jit_function_get_entry(func: jit_function_t) -> jit_block_t;

    pub fn jit_function_get_current(func: jit_function_t) -> jit_block_t;

    pub fn jit_function_get_nested_parent(func: jit_function_t) -> jit_function_t;

    pub fn jit_function_set_parent_frame(func: jit_function_t, parent_frame: jit_value_t);

    pub fn jit_function_compile(func: jit_function_t) -> ::std::os::raw::c_int;

    pub fn jit_function_is_compiled(func: jit_function_t) -> ::std::os::raw::c_int;

    pub fn jit_function_set_recompilable(func: jit_function_t);

    pub fn jit_function_clear_recompilable(func: jit_function_t);

    pub fn jit_function_is_recompilable(func: jit_function_t) -> ::std::os::raw::c_int;

    pub fn jit_function_compile_entry(
        func: jit_function_t,
        entry_point: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;

    pub fn jit_function_setup_entry(func: jit_function_t, entry_point: *mut ::std::os::raw::c_void);

    pub fn jit_function_to_closure(func: jit_function_t) -> *mut ::std::os::raw::c_void;

    pub fn jit_function_from_closure(
        context: jit_context_t,
        closure: *mut ::std::os::raw::c_void,
    ) -> jit_function_t;

    pub fn jit_function_from_pc(
        context: jit_context_t,
        pc: *mut ::std::os::raw::c_void,
        handler: *mut *mut ::std::os::raw::c_void,
    ) -> jit_function_t;

    pub fn jit_function_to_vtable_pointer(func: jit_function_t) -> *mut ::std::os::raw::c_void;

    pub fn jit_function_from_vtable_pointer(
        context: jit_context_t,
        vtable_pointer: *mut ::std::os::raw::c_void,
    ) -> jit_function_t;

    pub fn jit_function_set_on_demand_compiler(func: jit_function_t, on_demand: jit_on_demand_func);

    pub fn jit_function_get_on_demand_compiler(func: jit_function_t) -> jit_on_demand_func;

    pub fn jit_function_apply(
        func: jit_function_t,
        args: *mut *mut ::std::os::raw::c_void,
        return_area: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;

    pub fn jit_function_apply_vararg(
        func: jit_function_t,
        signature: jit_type_t,
        args: *mut *mut ::std::os::raw::c_void,
        return_area: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;

    pub fn jit_function_set_optimization_level(func: jit_function_t, level: ::std::os::raw::c_uint);

    pub fn jit_function_get_optimization_level(func: jit_function_t) -> ::std::os::raw::c_uint;

    pub fn jit_function_get_max_optimization_level() -> ::std::os::raw::c_uint;

    pub fn jit_function_reserve_label(func: jit_function_t) -> jit_label_t;

    pub fn jit_function_labels_equal(
        func: jit_function_t,
        label: jit_label_t,
        label2: jit_label_t,
    ) -> ::std::os::raw::c_int;

    pub fn jit_optimize(func: jit_function_t) -> ::std::os::raw::c_int;

    pub fn jit_compile(func: jit_function_t) -> ::std::os::raw::c_int;

    pub fn jit_compile_entry(
        func: jit_function_t,
        entry_point: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;

    pub fn jit_init();

    pub fn jit_uses_interpreter() -> ::std::os::raw::c_int;

    pub fn jit_supports_threads() -> ::std::os::raw::c_int;

    pub fn jit_supports_virtual_memory() -> ::std::os::raw::c_int;

    pub fn jit_supports_closures() -> ::std::os::raw::c_int;

    pub fn jit_get_closure_size() -> ::std::os::raw::c_uint;

    pub fn jit_get_closure_alignment() -> ::std::os::raw::c_uint;

    pub fn jit_get_trampoline_size() -> ::std::os::raw::c_uint;

    pub fn jit_get_trampoline_alignment() -> ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jit_intrinsic_descr_t {
    pub return_type: jit_type_t,
    pub ptr_result_type: jit_type_t,
    pub arg1_type: jit_type_t,
    pub arg2_type: jit_type_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jit_insn_iter_t {
    pub block: jit_block_t,
    pub posn: ::std::os::raw::c_int,
}

extern "C" {
    /// Get the opcode that is associated with an instruction.
    pub fn jit_insn_get_opcode(insn: jit_insn_t) -> ::std::os::raw::c_int;

    /// Get the destination value that is associated with an instruction. Returns NULL if the instruction does not have a destination.
    pub fn jit_insn_get_dest(insn: jit_insn_t) -> jit_value_t;

    /// Get the first argument value that is associated with an instruction. Returns NULL if the instruction does not have a first argument value.
    pub fn jit_insn_get_value1(insn: jit_insn_t) -> jit_value_t;

    /// Get the second argument value that is associated with an instruction. Returns NULL if the instruction does not have a second argument value.
    pub fn jit_insn_get_value2(insn: jit_insn_t) -> jit_value_t;

    /// Get the label for a branch target from an instruction. Returns NULL if the instruction does not have a branch target.
    pub fn jit_insn_get_label(insn: jit_insn_t) -> jit_label_t;

    /// Get the function for a call instruction. Returns NULL if the instruction does not refer to a called function.
    pub fn jit_insn_get_function(insn: jit_insn_t) -> jit_function_t;

    /// Get the function pointer for a native call instruction. Returns NULL if the instruction does not refer to a native function call.
    pub fn jit_insn_get_native(insn: jit_insn_t) -> *mut ::std::os::raw::c_void;

    /// Get the diagnostic name for a function call. Returns NULL if the instruction does not have a diagnostic name.
    pub fn jit_insn_get_name(insn: jit_insn_t) -> *const ::std::os::raw::c_char;

    /// Get the signature for a function call instruction. Returns NULL if the instruction is not a function call.
    pub fn jit_insn_get_signature(insn: jit_insn_t) -> jit_type_t;

    /// Returns a non-zero value if the destination for `insn` is actually a source value. This can happen with instructions such as jit_insn_store_relative where the instruction needs three source operands, and the real destination is a side-effect on one of the sources.
    pub fn jit_insn_dest_is_value(insn: jit_insn_t) -> ::std::os::raw::c_int;

    /// Start a new basic block within the function `func` and give it the specified `label`. Returns zero if out of memory.
    ///
    /// If the contents of `label` are [`jit_label_undefined`], then this function will allocate a new label for this block. Otherwise it will reuse the specified label from a previous branch instruction.
    pub fn jit_insn_label(func: jit_function_t, label: *mut jit_label_t) -> ::std::os::raw::c_int;

    /// Start a new basic block within the function `func` and give it the specified `label` but attempt to reuse the last block if it is empty. Returns zero if out of memory.

    /// If the contents of `label` are [`jit_label_undefined`], then this function will allocate a new label for this block. Otherwise it will reuse the specified label from a previous branch instruction.
    pub fn jit_insn_label_tight(
        func: jit_function_t,
        label: *mut jit_label_t,
    ) -> ::std::os::raw::c_int;

    /// Start a new basic block, without giving it an explicit label. Returns a non-zero value on success.
    pub fn jit_insn_new_block(func: jit_function_t) -> ::std::os::raw::c_int;

    /// Load the contents of `value` into a new temporary, essentially duplicating the value. Constants are not duplicated.
    pub fn jit_insn_load(func: jit_function_t, value: jit_value_t) -> jit_value_t;

    /// This is the same as [`jit_insn_load`], but the name may better reflect how it is used in some front ends.
    pub fn jit_insn_dup(func: jit_function_t, value: jit_value_t) -> jit_value_t;

    /// Store the contents of `value` at the location referred to by `dest`. The `dest` should be a [`jit_value_t`] representing a local variable or temporary. Use [`jit_insn_store_relative`] to store to a location referred to by a pointer.
    pub fn jit_insn_store(
        func: jit_function_t,
        dest: jit_value_t,
        value: jit_value_t,
    ) -> ::std::os::raw::c_int;

    /// Load a value of the specified type from the effective address (`value + offset`), where `value` is a pointer.
    pub fn jit_insn_load_relative(
        func: jit_function_t,
        value: jit_value_t,
        offset: jit_nint,
        type_: jit_type_t,
    ) -> jit_value_t;

    /// Store value at the effective address (`dest + offset`), where `dest` is a pointer. Returns a non-zero value on success.
    pub fn jit_insn_store_relative(
        func: jit_function_t,
        dest: jit_value_t,
        offset: jit_nint,
        value: jit_value_t,
    ) -> ::std::os::raw::c_int;

    /// Add the constant `offset` to the specified pointer `value`. This is functionally identical to calling [`jit_insn_add`], but the JIT can optimize the code better if it knows that the addition is being used to perform a relative adjustment on a pointer. In particular, multiple relative adjustments on the same pointer can be collapsed into a single adjustment.
    pub fn jit_insn_add_relative(
        func: jit_function_t,
        value: jit_value_t,
        offset: jit_nint,
    ) -> jit_value_t;

    /// Load an element of type `elem_type` from position `index` within the array starting at `base_addr`. The effective address of the array element is `base_addr + index * sizeof(elem_type)`.
    pub fn jit_insn_load_elem(
        func: jit_function_t,
        base_addr: jit_value_t,
        index: jit_value_t,
        elem_type: jit_type_t,
    ) -> jit_value_t;

    /// Load the effective address of an `element` of type `elem_type` at position `index` within the array starting at `base_addr`. Essentially, this computes the expression `base_addr + index * sizeof(elem_type)`, but may be more efficient than performing the steps with [`jit_insn_mul`] and [`jit_insn_add`].
    pub fn jit_insn_load_elem_address(
        func: jit_function_t,
        base_addr: jit_value_t,
        index: jit_value_t,
        elem_type: jit_type_t,
    ) -> jit_value_t;

    /// Store `value` at position `index` of the array starting at `base_addr`. The effective address of the storage location is `base_addr + index * sizeof(jit_value_get_type(value))`.
    pub fn jit_insn_store_elem(
        func: jit_function_t,
        base_addr: jit_value_t,
        index: jit_value_t,
        value: jit_value_t,
    ) -> ::std::os::raw::c_int;

    /// Check `value` to see if it is NULL. If it is, then throw the built-in [`JIT_RESULT_NULL_REFERENCE`] exception.
    pub fn jit_insn_check_null(func: jit_function_t, value: jit_value_t) -> ::std::os::raw::c_int;

    /// Emits "no operation" instruction. You may want to do that if you need an empty block to move it with `jit_insn_move_blocks_XXX` later. If you will not put empty instruction between two labels, both labels will point to the same block, and block moving will fail.
    pub fn jit_insn_nop(func: jit_function_t) -> ::std::os::raw::c_int;

    /// Add two values together and return the result in a new temporary value.
    pub fn jit_insn_add(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Add two values together and return the result in a new temporary value. Throw an exception if overflow occurs.
    pub fn jit_insn_add_ovf(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Subtract two values and return the result in a new temporary value.
    pub fn jit_insn_sub(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Subtract two values and return the result in a new temporary value. Throw an exception if overflow occurs.
    pub fn jit_insn_sub_ovf(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Multiply two values and return the result in a new temporary value.
    pub fn jit_insn_mul(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Multiply two values and return the result in a new temporary value. Throw an exception if overflow occurs.
    pub fn jit_insn_mul_ovf(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Divide two values and return the quotient in a new temporary value. Throws an exception on division by zero or arithmetic error (an arithmetic error is one where the minimum possible signed integer value is divided by -1).
    pub fn jit_insn_div(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Divide two values and return the remainder in a new temporary value. Throws an exception on division by zero or arithmetic error (an arithmetic error is one where the minimum possible signed integer value is divided by -1).
    pub fn jit_insn_rem(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Divide two values and return the remainder in a new temporary value. Throws an exception on division by zero or arithmetic error (an arithmetic error is one where the minimum possible signed integer value is divided by -1). This function is identical to [`jit_insn_rem`], except that it uses IEEE rules for computing the remainder of floating-point values.
    pub fn jit_insn_rem_ieee(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Negate a value and return the result in a new temporary value.
    pub fn jit_insn_neg(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    /// Bitwise AND two values and return the result in a new temporary value.
    pub fn jit_insn_and(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Bitwise OR two values and return the result in a new temporary value.
    pub fn jit_insn_or(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Bitwise XOR two values and return the result in a new temporary value.
    pub fn jit_insn_xor(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Bitwise NOT a value and return the result in a new temporary value.
    pub fn jit_insn_not(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    /// Perform a bitwise left shift on two values and return the result in a new temporary value.
    pub fn jit_insn_shl(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Perform a bitwise right shift on two values and return the result in a new temporary value. This performs a signed shift on signed operators, and an unsigned shift on unsigned operands.
    pub fn jit_insn_shr(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Perform a bitwise right shift on two values and return the result in a new temporary value. This performs an unsigned shift on both signed and unsigned operands.
    pub fn jit_insn_ushr(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Perform a bitwise right shift on two values and return the result in a new temporary value. This performs an signed shift on both signed and unsigned operands.
    pub fn jit_insn_sshr(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Compare two values for equality and return the result in a new temporary value.
    pub fn jit_insn_eq(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Compare two values for inequality and return the result in a new temporary value.
    pub fn jit_insn_ne(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Compare two values for less than and return the result in a new temporary value.
    pub fn jit_insn_lt(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Compare two values for less than or equal and return the result in a new temporary value.
    pub fn jit_insn_le(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Compare two values for greater than and return the result in a new temporary value.
    pub fn jit_insn_gt(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Compare two values for greater than or equal and return the result in a new temporary value.
    pub fn jit_insn_ge(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Compare two values, and return a -1, 0, or 1 result. If either value is "not a number", then -1 is returned.
    pub fn jit_insn_cmpl(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Compare two values, and return a -1, 0, or 1 result. If either value is "not a number", then 1 is returned.
    pub fn jit_insn_cmpg(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Convert a value into a boolean 0 or 1 result of type [`jit_type_int`].
    pub fn jit_insn_to_bool(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    /// Convert a value into a boolean 1 or 0 result of type [`jit_type_int`] (i.e. the inverse of [`jit_insn_to_bool`]).
    pub fn jit_insn_to_not_bool(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_acos(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_asin(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_atan(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_atan2(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Round `value1` up towads positive infinity.
    pub fn jit_insn_ceil(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_cos(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_cosh(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_exp(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    /// Round `value1` down towards negative infinity.
    pub fn jit_insn_floor(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_log(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_log10(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_pow(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    /// Round `value1` to the nearest integer. Half-way cases are rounded to the even number.
    pub fn jit_insn_rint(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    /// Round `value1` to the nearest integer. Half-way cases are rounded away from zero.
    pub fn jit_insn_round(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_sin(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_sinh(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_sqrt(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_tan(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_tanh(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    /// Round `value1` towards zero.
    pub fn jit_insn_trunc(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_is_nan(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_is_finite(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_is_inf(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_abs(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    pub fn jit_insn_min(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    pub fn jit_insn_max(
        func: jit_function_t,
        value1: jit_value_t,
        value2: jit_value_t,
    ) -> jit_value_t;

    pub fn jit_insn_sign(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    /// Terminate the current block by branching unconditionally to a specific label. Returns zero if out of memory.
    pub fn jit_insn_branch(func: jit_function_t, label: *mut jit_label_t) -> ::std::os::raw::c_int;

    /// Terminate the current block by branching to a specific label if the specified value is non-zero. Returns zero if out of memory.
    ///
    /// If value refers to a conditional expression that was created by [`jit_insn_eq`], [`jit_insn_ne`], etc, then the conditional expression will be replaced by an appropriate conditional branch instruction.
    pub fn jit_insn_branch_if(
        func: jit_function_t,
        value: jit_value_t,
        label: *mut jit_label_t,
    ) -> ::std::os::raw::c_int;

    /// Terminate the current block by branching to a specific label if the specified value is zero. Returns zero if out of memory.
    ///
    /// If value refers to a conditional expression that was created by [`jit_insn_eq`], [`jit_insn_ne`], etc, then the conditional expression will be followed by an appropriate conditional branch instruction, instead of a value load.
    pub fn jit_insn_branch_if_not(
        func: jit_function_t,
        value: jit_value_t,
        label: *mut jit_label_t,
    ) -> ::std::os::raw::c_int;

    /// Branch to a label from the `labels` table. The `value` is the index of the label. It is allowed to have identical labels in the table. If an entry in the table has [`jit_label_undefined`] value then it is replaced with a newly allocated label.
    pub fn jit_insn_jump_table(
        func: jit_function_t,
        value: jit_value_t,
        labels: *mut jit_label_t,
        num_labels: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;

    /// Get the address of a value into a new temporary.
    pub fn jit_insn_address_of(func: jit_function_t, value1: jit_value_t) -> jit_value_t;

    /// Get the address of `label` into a new temporary. This is typically used for exception handling, to track where in a function an exception was actually thrown.
    pub fn jit_insn_address_of_label(func: jit_function_t, label: *mut jit_label_t) -> jit_value_t;

    /// Convert the contents of a value into a new type, with optional overflow checking.
    pub fn jit_insn_convert(
        func: jit_function_t,
        value: jit_value_t,
        type_: jit_type_t,
        overflow_check: ::std::os::raw::c_int,
    ) -> jit_value_t;

    /// Call the function `jit_func`, which may or may not be translated yet. The name is for diagnostic purposes only, and can be NULL.
    ///
    /// If `signature` is NULL, then the actual signature of `jit_func` is used in its place. This is the usual case. However, if the function takes a variable number of arguments, then you may need to construct an explicit signature for the non-fixed argument values.
    ///
    /// The `flags` parameter specifies additional information about the type of call to perform:
    ///
    /// | Flag | Description |
    /// | ---- | ----------- |
    /// | `JIT_CALL_NOTHROW` | The function never throws exceptions. |
    /// | `JIT_CALL_NORETURN` | The function will never return directly to its caller. It may however return to the caller indirectly by throwing an exception that the caller catches. |
    /// | `JIT_CALL_TAIL` | Apply tail call optimizations, as the result of this function call will be immediately returned from the containing function. Tail calls are only appropriate when the signature of the called function matches the callee, and none of the parameters point to local variables. |
    ///
    /// If `jit_func` has already been compiled, then [`jit_insn_call`] may be able to intuit some of the above flags for itself. Otherwise it is up to the caller to determine when the flags may be appropriate.
    pub fn jit_insn_call(
        func: jit_function_t,
        name: *const ::std::os::raw::c_char,
        jit_func: jit_function_t,
        signature: jit_type_t,
        args: *mut jit_value_t,
        num_args: ::std::os::raw::c_uint,
        flags: ::std::os::raw::c_int,
    ) -> jit_value_t;

    /// Call a function via an indirect pointer.
    pub fn jit_insn_call_indirect(
        func: jit_function_t,
        value: jit_value_t,
        signature: jit_type_t,
        args: *mut jit_value_t,
        num_args: ::std::os::raw::c_uint,
        flags: ::std::os::raw::c_int,
    ) -> jit_value_t;

    /// Call a jit function that is nested via an indirect pointer. `parent_frame` should be a pointer to the frame of the parent of `*value`.
    pub fn jit_insn_call_nested_indirect(
        func: jit_function_t,
        value: jit_value_t,
        parent_frame: jit_value_t,
        signature: jit_type_t,
        args: *mut jit_value_t,
        num_args: ::std::os::raw::c_uint,
        flags: ::std::os::raw::c_int,
    ) -> jit_value_t;

    /// Call a function via an indirect pointer. This version differs from [`jit_insn_call_indirect`] in that we assume that `value` contains a pointer that resulted from calling [`jit_function_to_vtable_pointer`]. Indirect vtable pointer calls may be more efficient on some platforms than regular indirect calls.
    pub fn jit_insn_call_indirect_vtable(
        func: jit_function_t,
        value: jit_value_t,
        signature: jit_type_t,
        args: *mut jit_value_t,
        num_args: ::std::os::raw::c_uint,
        flags: ::std::os::raw::c_int,
    ) -> jit_value_t;

    /// Output an instruction that calls an external native function. The `name` is for diagnostic purposes only, and can be NULL.
    pub fn jit_insn_call_native(
        func: jit_function_t,
        name: *const ::std::os::raw::c_char,
        native_func: *mut ::std::os::raw::c_void,
        signature: jit_type_t,
        args: *mut jit_value_t,
        num_args: ::std::os::raw::c_uint,
        flags: ::std::os::raw::c_int,
    ) -> jit_value_t;

    /// Output an instruction that calls an intrinsic function.
    ///
    /// The descriptor contains the following fields:
    ///
    /// | Field | Description |
    /// | ----- | ----------- |
    /// | return_type | The type of value that is returned from the intrinsic. |
    /// | ptr_result_type | This should be NULL for an ordinary intrinsic, or the result type if the intrinsic reports exceptions. |
    /// | arg1_type | The type of the first argument. |
    /// | arg2_type | The type of the second argument, or NULL for a unary intrinsic. |
    ///
    /// If all of the arguments are constant, then [`jit_insn_call_intrinsic`] will call the intrinsic directly to calculate the constant result. If the constant computation will result in an exception, then code is output to cause the exception at runtime.
    ///
    /// The `name` is for diagnostic purposes only, and can be NULL.
    pub fn jit_insn_call_intrinsic(
        func: jit_function_t,
        name: *const ::std::os::raw::c_char,
        intrinsic_func: *mut ::std::os::raw::c_void,
        descriptor: *const jit_intrinsic_descr_t,
        arg1: jit_value_t,
        arg2: jit_value_t,
    ) -> jit_value_t;

    /// Output an instruction that notes that the contents of `value` can be found in the register `reg` at this point in the code.
    ///
    /// You normally wouldn’t call this yourself - it is used internally by the CPU back ends to set up the function’s entry frame and the values of registers on return from a subroutine call.
    pub fn jit_insn_incoming_reg(
        func: jit_function_t,
        value: jit_value_t,
        reg: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;

    /// Output an instruction that notes that the contents of `value` can be found in the stack frame at `frame_offset`. This should only be called once per value, to prevent values from changing their address when they might be addressable.
    ///
    /// You normally wouldn’t call this yourself - it is used internally by the CPU back ends to set up the function’s entry frame.
    pub fn jit_insn_incoming_frame_posn(
        func: jit_function_t,
        value: jit_value_t,
        frame_offset: jit_nint,
    ) -> ::std::os::raw::c_int;

    /// Output an instruction that copies the contents of `value` into the register `reg` at this point in the code. This is typically used just before making an outgoing subroutine call.
    ///
    /// You normally wouldn’t call this yourself - it is used internally by the CPU back ends to set up the registers for a subroutine call.
    pub fn jit_insn_outgoing_reg(
        func: jit_function_t,
        value: jit_value_t,
        reg: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;

    /// Output an instruction that stores the contents of `value` in the stack frame at `frame_offset`.
    ///
    /// You normally wouldn’t call this yourself - it is used internally by the CPU back ends to set up an outgoing frame for tail calls.
    pub fn jit_insn_outgoing_frame_posn(
        func: jit_function_t,
        value: jit_value_t,
        frame_offset: jit_nint,
    ) -> ::std::os::raw::c_int;

    /// Output an instruction that notes that the contents of `value` can be found in the register `reg` at this point in the code. This is similar to [`jit_insn_incoming_reg`], except that it refers to return values, not parameter values.
    ///
    /// You normally wouldn’t call this yourself - it is used internally by the CPU back ends to handle returns from subroutine calls.
    pub fn jit_insn_return_reg(
        func: jit_function_t,
        value: jit_value_t,
        reg: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;

    pub fn jit_insn_setup_for_nested(
        func: jit_function_t,
        nested_level: ::std::os::raw::c_int,
        reg: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;

    /// Flush a small structure return value out of registers and back into the local variable frame. You normally wouldn’t call this yourself - it is used internally by the CPU back ends to handle structure returns from functions.
    pub fn jit_insn_flush_struct(func: jit_function_t, value: jit_value_t)
        -> ::std::os::raw::c_int;

    /// Retrieve the frame pointer of function `func`. Returns NULL if out of memory.
    pub fn jit_insn_get_frame_pointer(func: jit_function_t) -> jit_value_t;

    /// Retrieve the frame pointer of the parent of `target`. Returns NULL when `target` is not a sibling, an ancestor, or a sibling of one of the ancestors of `func`. Returns NULL if out of memory.
    pub fn jit_insn_get_parent_frame_pointer_of(
        func: jit_function_t,
        target: jit_function_t,
    ) -> jit_value_t;

    /// Import `value` from an outer nested scope into `func`. Returns the effective address of the value for local access via a pointer. Returns NULL if out of memory or the value is not accessible via a parent, grandparent, or other ancestor of `func`.
    pub fn jit_insn_import(func: jit_function_t, value: jit_value_t) -> jit_value_t;

    /// Push a value onto the function call stack, in preparation for a call. You normally wouldn’t call this yourself - it is used internally by the CPU back ends to set up the stack for a subroutine call.
    pub fn jit_insn_push(func: jit_function_t, value: jit_value_t) -> ::std::os::raw::c_int;

    /// Push `*value` onto the function call stack, in preparation for a call. This is normally used for returning `struct` and `union` values where you have the effective address of the structure, rather than the structure’s contents, in `value`.
    ///
    /// You normally wouldn’t call this yourself - it is used internally by the CPU back ends to set up the stack for a subroutine call.
    pub fn jit_insn_push_ptr(
        func: jit_function_t,
        value: jit_value_t,
        type_: jit_type_t,
    ) -> ::std::os::raw::c_int;

    /// Set the parameter `slot` at offset in the outgoing parameter area to `value`. This may be used instead of [`jit_insn_push`] if it is more efficient to store directly to the stack than to push. The outgoing parameter area is allocated within the frame when the function is first entered.  
    ///
    /// You normally wouldn’t call this yourself - it is used internally by the CPU back ends to set up the stack for a subroutine call.
    pub fn jit_insn_set_param(
        func: jit_function_t,
        value: jit_value_t,
        offset: jit_nint,
    ) -> ::std::os::raw::c_int;

    /// Same as [`jit_insn_set_param`], except that the parameter is at `*value`.
    pub fn jit_insn_set_param_ptr(
        func: jit_function_t,
        value: jit_value_t,
        type_: jit_type_t,
        offset: jit_nint,
    ) -> ::std::os::raw::c_int;

    /// Push the interpreter’s return area pointer onto the stack. You normally wouldn’t call this yourself - it is used internally by the CPU back ends to set up the stack for a subroutine call.
    pub fn jit_insn_push_return_area_ptr(func: jit_function_t) -> ::std::os::raw::c_int;

    /// Pop `num_items` items from the function call stack. You normally wouldn’t call this yourself - it is used by CPU back ends to clean up the stack after calling a subroutine. The size of an item is specific to the back end (it could be bytes, words, or some other measurement).
    pub fn jit_insn_pop_stack(func: jit_function_t, num_items: jit_nint) -> ::std::os::raw::c_int;

    /// This is similar to [`jit_insn_pop_stack`], except that it tries to defer the pop as long as possible. Multiple subroutine calls may result in parameters collecting up on the stack, and only being popped at the next branch or label instruction. You normally wouldn’t call this yourself - it is used by CPU back ends.
    pub fn jit_insn_defer_pop_stack(
        func: jit_function_t,
        num_items: jit_nint,
    ) -> ::std::os::raw::c_int;

    /// Flush any deferred items that were scheduled for popping by [`jit_insn_defer_pop_stack`] if there are `num_items` or more items scheduled. You normally wouldn’t call this yourself - it is used by CPU back ends to clean up the stack just prior to a subroutine call when too many items have collected up. Calling `jit_insn_flush_defer_pop(func, 0)` will flush all deferred items.
    pub fn jit_insn_flush_defer_pop(
        func: jit_function_t,
        num_items: jit_nint,
    ) -> ::std::os::raw::c_int;

    /// Output an instruction to return `value` as the function’s result. If `value` is NULL, then the function is assumed to return `void`. If the function returns a structure, this will copy the value into the memory at the structure return address.
    pub fn jit_insn_return(func: jit_function_t, value: jit_value_t) -> ::std::os::raw::c_int;

    /// Output an instruction to return `*value` as the function’s result. This is normally used for returning `struct` and `union` values where you have the effective address of the structure, rather than the structure’s contents, in `value`.
    pub fn jit_insn_return_ptr(
        func: jit_function_t,
        value: jit_value_t,
        type_: jit_type_t,
    ) -> ::std::os::raw::c_int;

    /// Add an instruction to return a default value if control reaches this point. This is typically used at the end of a function to ensure that all paths return to the caller. Returns zero if out of memory, 1 if a default return was added, and 2 if a default return was not needed.
    ///
    /// Note: if this returns 1, but the function signature does not return void, then it indicates that a higher-level language error has occurred and the function should be abandoned.
    pub fn jit_insn_default_return(func: jit_function_t) -> ::std::os::raw::c_int;

    /// Throw a pointer `value` as an exception object. This can also be used to "rethrow" an object from a catch handler that is not interested in handling the exception.
    pub fn jit_insn_throw(func: jit_function_t, value: jit_value_t) -> ::std::os::raw::c_int;

    /// Get an object that represents the current position in the code, and all of the functions that are currently on the call stack. This is equivalent to calling [`jit_exception_get_stack_trace`], and is normally used just prior to [`jit_insn_throw`] to record the location of the exception that is being thrown.
    pub fn jit_insn_get_call_stack(func: jit_function_t) -> jit_value_t;

    /// Get the value that holds the most recent thrown exception. This is typically used in `catch` clauses.
    pub fn jit_insn_thrown_exception(func: jit_function_t) -> jit_value_t;

    /// Notify the function building process that func contains some form of `catch` clause for catching exceptions. This must be called before any instruction that is covered by a `try`, ideally at the start of the function output process.
    pub fn jit_insn_uses_catcher(func: jit_function_t) -> ::std::os::raw::c_int;

    /// Start the catcher block for `func`. There should be exactly one catcher block for any function that involves a `try`. All exceptions that are thrown within the function will cause control to jump to this point. Returns a value that holds the exception that was thrown.
    pub fn jit_insn_start_catcher(func: jit_function_t) -> jit_value_t;

    /// Branch to `label` if the program counter where an exception occurred does not fall between `start_label` and `end_label`.
    pub fn jit_insn_branch_if_pc_not_in_range(
        func: jit_function_t,
        start_label: jit_label_t,
        end_label: jit_label_t,
        label: *mut jit_label_t,
    ) -> ::std::os::raw::c_int;

    /// Rethrow the current exception because it cannot be handled by any of the `catch` blocks in the current function.
    ///
    /// Note: this is intended for use within catcher blocks. It should not be used to rethrow exceptions in response to programmer requests (e.g. throw; in C#). The [`jit_insn_throw`] function should be used for that purpose.
    pub fn jit_insn_rethrow_unhandled(func: jit_function_t) -> ::std::os::raw::c_int;

    /// Start a `finally` clause.
    pub fn jit_insn_start_finally(
        func: jit_function_t,
        finally_label: *mut jit_label_t,
    ) -> ::std::os::raw::c_int;

    /// Return from the `finally` clause to where it was called from. This is usually the last instruction in a `finally` clause.
    pub fn jit_insn_return_from_finally(func: jit_function_t) -> ::std::os::raw::c_int;

    /// Call a `finally` clause.
    pub fn jit_insn_call_finally(
        func: jit_function_t,
        finally_label: *mut jit_label_t,
    ) -> ::std::os::raw::c_int;

    /// Define the start of a filter. Filters are embedded subroutines within functions that are used to filter exceptions in `catch` blocks.
    ///
    /// A filter subroutine takes a single argument (usually a pointer) and returns a single result (usually a boolean). The filter has complete access to the local variables of the function, and can use any of them in the filtering process.
    ///
    /// This function returns a temporary value of the specified `type`, indicating the parameter that is supplied to the filter.
    pub fn jit_insn_start_filter(
        func: jit_function_t,
        label: *mut jit_label_t,
        type_: jit_type_t,
    ) -> jit_value_t;

    /// Return from a filter subroutine with the specified `value` as its result.
    pub fn jit_insn_return_from_filter(
        func: jit_function_t,
        value: jit_value_t,
    ) -> ::std::os::raw::c_int;

    /// Call the filter subroutine at `label`, passing it value as its argument. This function returns a value of the specified `type`, indicating the filter’s result.
    pub fn jit_insn_call_filter(
        func: jit_function_t,
        label: *mut jit_label_t,
        value: jit_value_t,
        type_: jit_type_t,
    ) -> jit_value_t;

    /// Copy the `size` bytes of memory at `src` to `dest`. It is assumed that the source and destination do not overlap.
    pub fn jit_insn_memcpy(
        func: jit_function_t,
        dest: jit_value_t,
        src: jit_value_t,
        size: jit_value_t,
    ) -> ::std::os::raw::c_int;

    /// Copy the `size` bytes of memory at `src` to `dest`. This is safe to use if the source and destination overlap.
    pub fn jit_insn_memmove(
        func: jit_function_t,
        dest: jit_value_t,
        src: jit_value_t,
        size: jit_value_t,
    ) -> ::std::os::raw::c_int;

    /// Set the `size` bytes at `dest` to `value`.
    pub fn jit_insn_memset(
        func: jit_function_t,
        dest: jit_value_t,
        value: jit_value_t,
        size: jit_value_t,
    ) -> ::std::os::raw::c_int;

    /// Allocate `size` bytes of memory from the stack.
    pub fn jit_insn_alloca(func: jit_function_t, size: jit_value_t) -> jit_value_t;

    /// Move all of the blocks between `from_label` (inclusive) and `to_label` (exclusive) to the end of the current function. This is typically used to move the expression in a `while` loop to the end of the body, where it can be executed more efficiently.
    pub fn jit_insn_move_blocks_to_end(
        func: jit_function_t,
        from_label: jit_label_t,
        to_label: jit_label_t,
    ) -> ::std::os::raw::c_int;

    /// Move all of the blocks between `from_label` (inclusive) and `to_label` (exclusive) to the start of the current function. This is typically used to move initialization code to the head of the function.
    pub fn jit_insn_move_blocks_to_start(
        func: jit_function_t,
        from_label: jit_label_t,
        to_label: jit_label_t,
    ) -> ::std::os::raw::c_int;

    /// Mark the current position in `func` as corresponding to the specified bytecode `offset`. This value will be returned byw]lysw`jit_stack_trace_get_offset, and is useful for associating code positions with source line numbers.
    pub fn jit_insn_mark_offset(func: jit_function_t, offset: jit_int) -> ::std::os::raw::c_int;

    /// Mark the current position in `func` as corresponding to a breakpoint location. When a break occurs, the debugging routines are passed `func`, `data1`, and `data2` as arguments. By convention, `data1` is the type of breakpoint (source line, function entry, function exit, etc).
    ///
    /// There are two ways for a front end to receive notification about breakpoints. The bulk of this chapter describes the [`jit_debugger_t`] interface, which handles most of the ugly details. In addition, a low-level "debug hook mechanism" is provided for front ends that wish more control over the process. The debug hook mechanism is described below, under the [`jit_debugger_set_hook`] function.
    ///
    /// This debugger implementation requires a threading system to work successfully. At least two threads are required, in addition to those of the program being debugged:
    ///
    /// 1. Event thread which calls [`jit_debugger_wait_event`] to receive notifications of breakpoints and other interesting events.
    /// 2. User interface thread which calls functions like [`jit_debugger_run`], [`jit_debugger_step`], etc, to control the debug process.
    ///
    /// These two threads should be set to "unbreakable" with a call to [`jit_debugger_set_breakable`]. This prevents them from accidentally stopping at a breakpoint, which would cause a system deadlock. Other housekeeping threads, such as a finalization thread, should also be set to "unbreakable" for the same reason.
    ///
    /// Events have the following members:
    ///
    /// | Member | Description |
    /// | ------ | ----------- |
    /// | `type` | The type of event (see the next table for details). |
    /// | `thread` | The thread that the event occurred on. |
    /// | `function` | The function that the breakpoint occurred within. |
    /// | `data1` + `data2` | The data values at the breakpoint. These values are inserted into the function’s code with [`jit_insn_mark_breakpoint`]. |
    /// | `id` | The identifier for the breakpoint. |
    /// | `trace` | The stack trace corresponding to the location where the breakpoint occurred. This value is automatically freed upon the next call to [`jit_debugger_wait_event`]. If you wish to preserve the value, then you must call jit_stack_trace_copy. |
    ///
    /// The following event types are currently supported:
    ///
    /// | Event Type | Description |
    /// | ---------- | ----------- |
    /// | JIT_DEBUGGER_TYPE_QUIT | A thread called [`jit_debugger_quit`], indicating that it wanted the event thread to terminate. |
    /// | JIT_DEBUGGER_TYPE_HARD_BREAKPOINT | A thread stopped at a hard breakpoint. That is, a breakpoint defined by a call to [`jit_debugger_add_breakpoint`]. |
    /// | JIT_DEBUGGER_TYPE_SOFT_BREAKPOINT | A thread stopped at a breakpoint that wasn’t explicitly defined by a call to [`jit_debugger_add_breakpoint`]. This typicaly results from a call to a "step" function like [`jit_debugger_step`], where execution stopped at the next line but there isn’t an explicit breakpoint on that line. |
    /// | JIT_DEBUGGER_TYPE_USER_BREAKPOINT | A thread stopped because of a call to [`jit_debugger_break`]. |
    /// | JIT_DEBUGGER_TYPE_ATTACH_THREAD | A thread called [`jit_debugger_attach_self`]. The data1 field of the event is set to the value of stop_immediately for the call. |
    /// | JIT_DEBUGGER_TYPE_DETACH_THREAD | A thread called [`jit_debugger_detach_self`]. |
    ///
    pub fn jit_insn_mark_breakpoint(
        func: jit_function_t,
        data1: jit_nint,
        data2: jit_nint,
    ) -> ::std::os::raw::c_int;

    pub fn jit_insn_mark_breakpoint_variable(
        func: jit_function_t,
        data1: jit_value_t,
        data2: jit_value_t,
    ) -> ::std::os::raw::c_int;

    /// Initialize an iterator to point to the first instruction in `block`.
    pub fn jit_insn_iter_init(iter: *mut jit_insn_iter_t, block: jit_block_t);

    /// Initialize an iterator to point to the last instruction in `block`.
    pub fn jit_insn_iter_init_last(iter: *mut jit_insn_iter_t, block: jit_block_t);

    /// Get the next instruction in an iterator’s block. Returns NULL when there are no further instructions in the block.
    pub fn jit_insn_iter_next(iter: *mut jit_insn_iter_t) -> jit_insn_t;

    /// Get the previous instruction in an iterator’s block. Returns NULL when there are no further instructions in the block.
    pub fn jit_insn_iter_previous(iter: *mut jit_insn_iter_t) -> jit_insn_t;

    pub fn jit_int_add(value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_sub(value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_mul(value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_div(result: *mut jit_int, value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_rem(result: *mut jit_int, value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_add_ovf(result: *mut jit_int, value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_sub_ovf(result: *mut jit_int, value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_mul_ovf(result: *mut jit_int, value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_div_ovf(result: *mut jit_int, value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_rem_ovf(result: *mut jit_int, value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_neg(value1: jit_int) -> jit_int;

    pub fn jit_int_and(value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_or(value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_xor(value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_not(value1: jit_int) -> jit_int;

    pub fn jit_int_shl(value1: jit_int, value2: jit_uint) -> jit_int;

    pub fn jit_int_shr(value1: jit_int, value2: jit_uint) -> jit_int;

    pub fn jit_int_eq(value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_ne(value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_lt(value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_le(value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_gt(value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_ge(value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_cmp(value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_abs(value1: jit_int) -> jit_int;

    pub fn jit_int_min(value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_max(value1: jit_int, value2: jit_int) -> jit_int;

    pub fn jit_int_sign(value1: jit_int) -> jit_int;

    pub fn jit_uint_add(value1: jit_uint, value2: jit_uint) -> jit_uint;

    pub fn jit_uint_sub(value1: jit_uint, value2: jit_uint) -> jit_uint;

    pub fn jit_uint_mul(value1: jit_uint, value2: jit_uint) -> jit_uint;

    pub fn jit_uint_div(result: *mut jit_uint, value1: jit_uint, value2: jit_uint) -> jit_int;

    pub fn jit_uint_rem(result: *mut jit_uint, value1: jit_uint, value2: jit_uint) -> jit_int;

    pub fn jit_uint_add_ovf(result: *mut jit_uint, value1: jit_uint, value2: jit_uint) -> jit_int;

    pub fn jit_uint_sub_ovf(result: *mut jit_uint, value1: jit_uint, value2: jit_uint) -> jit_int;

    pub fn jit_uint_mul_ovf(result: *mut jit_uint, value1: jit_uint, value2: jit_uint) -> jit_int;

    pub fn jit_uint_div_ovf(result: *mut jit_uint, value1: jit_uint, value2: jit_uint) -> jit_int;

    pub fn jit_uint_rem_ovf(result: *mut jit_uint, value1: jit_uint, value2: jit_uint) -> jit_int;

    pub fn jit_uint_neg(value1: jit_uint) -> jit_uint;

    pub fn jit_uint_and(value1: jit_uint, value2: jit_uint) -> jit_uint;

    pub fn jit_uint_or(value1: jit_uint, value2: jit_uint) -> jit_uint;

    pub fn jit_uint_xor(value1: jit_uint, value2: jit_uint) -> jit_uint;

    pub fn jit_uint_not(value1: jit_uint) -> jit_uint;

    pub fn jit_uint_shl(value1: jit_uint, value2: jit_uint) -> jit_uint;

    pub fn jit_uint_shr(value1: jit_uint, value2: jit_uint) -> jit_uint;

    pub fn jit_uint_eq(value1: jit_uint, value2: jit_uint) -> jit_int;

    pub fn jit_uint_ne(value1: jit_uint, value2: jit_uint) -> jit_int;

    pub fn jit_uint_lt(value1: jit_uint, value2: jit_uint) -> jit_int;

    pub fn jit_uint_le(value1: jit_uint, value2: jit_uint) -> jit_int;

    pub fn jit_uint_gt(value1: jit_uint, value2: jit_uint) -> jit_int;

    pub fn jit_uint_ge(value1: jit_uint, value2: jit_uint) -> jit_int;

    pub fn jit_uint_cmp(value1: jit_uint, value2: jit_uint) -> jit_int;

    pub fn jit_uint_min(value1: jit_uint, value2: jit_uint) -> jit_uint;

    pub fn jit_uint_max(value1: jit_uint, value2: jit_uint) -> jit_uint;

    pub fn jit_long_add(value1: jit_long, value2: jit_long) -> jit_long;

    pub fn jit_long_sub(value1: jit_long, value2: jit_long) -> jit_long;

    pub fn jit_long_mul(value1: jit_long, value2: jit_long) -> jit_long;

    pub fn jit_long_div(result: *mut jit_long, value1: jit_long, value2: jit_long) -> jit_int;

    pub fn jit_long_rem(result: *mut jit_long, value1: jit_long, value2: jit_long) -> jit_int;

    pub fn jit_long_add_ovf(result: *mut jit_long, value1: jit_long, value2: jit_long) -> jit_int;

    pub fn jit_long_sub_ovf(result: *mut jit_long, value1: jit_long, value2: jit_long) -> jit_int;

    pub fn jit_long_mul_ovf(result: *mut jit_long, value1: jit_long, value2: jit_long) -> jit_int;

    pub fn jit_long_div_ovf(result: *mut jit_long, value1: jit_long, value2: jit_long) -> jit_int;

    pub fn jit_long_rem_ovf(result: *mut jit_long, value1: jit_long, value2: jit_long) -> jit_int;

    pub fn jit_long_neg(value1: jit_long) -> jit_long;

    pub fn jit_long_and(value1: jit_long, value2: jit_long) -> jit_long;

    pub fn jit_long_or(value1: jit_long, value2: jit_long) -> jit_long;

    pub fn jit_long_xor(value1: jit_long, value2: jit_long) -> jit_long;

    pub fn jit_long_not(value1: jit_long) -> jit_long;

    pub fn jit_long_shl(value1: jit_long, value2: jit_uint) -> jit_long;

    pub fn jit_long_shr(value1: jit_long, value2: jit_uint) -> jit_long;

    pub fn jit_long_eq(value1: jit_long, value2: jit_long) -> jit_int;

    pub fn jit_long_ne(value1: jit_long, value2: jit_long) -> jit_int;

    pub fn jit_long_lt(value1: jit_long, value2: jit_long) -> jit_int;

    pub fn jit_long_le(value1: jit_long, value2: jit_long) -> jit_int;

    pub fn jit_long_gt(value1: jit_long, value2: jit_long) -> jit_int;

    pub fn jit_long_ge(value1: jit_long, value2: jit_long) -> jit_int;

    pub fn jit_long_cmp(value1: jit_long, value2: jit_long) -> jit_int;

    pub fn jit_long_abs(value1: jit_long) -> jit_long;

    pub fn jit_long_min(value1: jit_long, value2: jit_long) -> jit_long;

    pub fn jit_long_max(value1: jit_long, value2: jit_long) -> jit_long;

    pub fn jit_long_sign(value1: jit_long) -> jit_int;

    pub fn jit_ulong_add(value1: jit_ulong, value2: jit_ulong) -> jit_ulong;

    pub fn jit_ulong_sub(value1: jit_ulong, value2: jit_ulong) -> jit_ulong;

    pub fn jit_ulong_mul(value1: jit_ulong, value2: jit_ulong) -> jit_ulong;

    pub fn jit_ulong_div(result: *mut jit_ulong, value1: jit_ulong, value2: jit_ulong) -> jit_int;

    pub fn jit_ulong_rem(result: *mut jit_ulong, value1: jit_ulong, value2: jit_ulong) -> jit_int;

    pub fn jit_ulong_add_ovf(
        result: *mut jit_ulong,
        value1: jit_ulong,
        value2: jit_ulong,
    ) -> jit_int;

    pub fn jit_ulong_sub_ovf(
        result: *mut jit_ulong,
        value1: jit_ulong,
        value2: jit_ulong,
    ) -> jit_int;

    pub fn jit_ulong_mul_ovf(
        result: *mut jit_ulong,
        value1: jit_ulong,
        value2: jit_ulong,
    ) -> jit_int;

    pub fn jit_ulong_div_ovf(
        result: *mut jit_ulong,
        value1: jit_ulong,
        value2: jit_ulong,
    ) -> jit_int;

    pub fn jit_ulong_rem_ovf(
        result: *mut jit_ulong,
        value1: jit_ulong,
        value2: jit_ulong,
    ) -> jit_int;

    pub fn jit_ulong_neg(value1: jit_ulong) -> jit_ulong;

    pub fn jit_ulong_and(value1: jit_ulong, value2: jit_ulong) -> jit_ulong;

    pub fn jit_ulong_or(value1: jit_ulong, value2: jit_ulong) -> jit_ulong;

    pub fn jit_ulong_xor(value1: jit_ulong, value2: jit_ulong) -> jit_ulong;

    pub fn jit_ulong_not(value1: jit_ulong) -> jit_ulong;

    pub fn jit_ulong_shl(value1: jit_ulong, value2: jit_uint) -> jit_ulong;

    pub fn jit_ulong_shr(value1: jit_ulong, value2: jit_uint) -> jit_ulong;

    pub fn jit_ulong_eq(value1: jit_ulong, value2: jit_ulong) -> jit_int;

    pub fn jit_ulong_ne(value1: jit_ulong, value2: jit_ulong) -> jit_int;

    pub fn jit_ulong_lt(value1: jit_ulong, value2: jit_ulong) -> jit_int;

    pub fn jit_ulong_le(value1: jit_ulong, value2: jit_ulong) -> jit_int;

    pub fn jit_ulong_gt(value1: jit_ulong, value2: jit_ulong) -> jit_int;

    pub fn jit_ulong_ge(value1: jit_ulong, value2: jit_ulong) -> jit_int;

    pub fn jit_ulong_cmp(value1: jit_ulong, value2: jit_ulong) -> jit_int;

    pub fn jit_ulong_min(value1: jit_ulong, value2: jit_ulong) -> jit_ulong;

    pub fn jit_ulong_max(value1: jit_ulong, value2: jit_ulong) -> jit_ulong;

    pub fn jit_float32_add(value1: jit_float32, value2: jit_float32) -> jit_float32;

    pub fn jit_float32_sub(value1: jit_float32, value2: jit_float32) -> jit_float32;

    pub fn jit_float32_mul(value1: jit_float32, value2: jit_float32) -> jit_float32;

    pub fn jit_float32_div(value1: jit_float32, value2: jit_float32) -> jit_float32;

    pub fn jit_float32_rem(value1: jit_float32, value2: jit_float32) -> jit_float32;

    pub fn jit_float32_ieee_rem(value1: jit_float32, value2: jit_float32) -> jit_float32;

    pub fn jit_float32_neg(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_eq(value1: jit_float32, value2: jit_float32) -> jit_int;

    pub fn jit_float32_ne(value1: jit_float32, value2: jit_float32) -> jit_int;

    pub fn jit_float32_lt(value1: jit_float32, value2: jit_float32) -> jit_int;

    pub fn jit_float32_le(value1: jit_float32, value2: jit_float32) -> jit_int;

    pub fn jit_float32_gt(value1: jit_float32, value2: jit_float32) -> jit_int;

    pub fn jit_float32_ge(value1: jit_float32, value2: jit_float32) -> jit_int;

    pub fn jit_float32_cmpl(value1: jit_float32, value2: jit_float32) -> jit_int;

    pub fn jit_float32_cmpg(value1: jit_float32, value2: jit_float32) -> jit_int;

    pub fn jit_float32_acos(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_asin(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_atan(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_atan2(value1: jit_float32, value2: jit_float32) -> jit_float32;

    pub fn jit_float32_ceil(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_cos(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_cosh(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_exp(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_floor(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_log(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_log10(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_pow(value1: jit_float32, value2: jit_float32) -> jit_float32;

    pub fn jit_float32_rint(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_round(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_sin(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_sinh(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_sqrt(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_tan(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_tanh(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_trunc(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_is_finite(value: jit_float32) -> jit_int;

    pub fn jit_float32_is_nan(value: jit_float32) -> jit_int;

    pub fn jit_float32_is_inf(value: jit_float32) -> jit_int;

    pub fn jit_float32_abs(value1: jit_float32) -> jit_float32;

    pub fn jit_float32_min(value1: jit_float32, value2: jit_float32) -> jit_float32;

    pub fn jit_float32_max(value1: jit_float32, value2: jit_float32) -> jit_float32;

    pub fn jit_float32_sign(value1: jit_float32) -> jit_int;

    pub fn jit_float64_add(value1: jit_float64, value2: jit_float64) -> jit_float64;

    pub fn jit_float64_sub(value1: jit_float64, value2: jit_float64) -> jit_float64;

    pub fn jit_float64_mul(value1: jit_float64, value2: jit_float64) -> jit_float64;

    pub fn jit_float64_div(value1: jit_float64, value2: jit_float64) -> jit_float64;

    pub fn jit_float64_rem(value1: jit_float64, value2: jit_float64) -> jit_float64;

    pub fn jit_float64_ieee_rem(value1: jit_float64, value2: jit_float64) -> jit_float64;

    pub fn jit_float64_neg(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_eq(value1: jit_float64, value2: jit_float64) -> jit_int;

    pub fn jit_float64_ne(value1: jit_float64, value2: jit_float64) -> jit_int;

    pub fn jit_float64_lt(value1: jit_float64, value2: jit_float64) -> jit_int;

    pub fn jit_float64_le(value1: jit_float64, value2: jit_float64) -> jit_int;

    pub fn jit_float64_gt(value1: jit_float64, value2: jit_float64) -> jit_int;

    pub fn jit_float64_ge(value1: jit_float64, value2: jit_float64) -> jit_int;

    pub fn jit_float64_cmpl(value1: jit_float64, value2: jit_float64) -> jit_int;

    pub fn jit_float64_cmpg(value1: jit_float64, value2: jit_float64) -> jit_int;

    pub fn jit_float64_acos(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_asin(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_atan(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_atan2(value1: jit_float64, value2: jit_float64) -> jit_float64;

    pub fn jit_float64_ceil(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_cos(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_cosh(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_exp(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_floor(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_log(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_log10(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_pow(value1: jit_float64, value2: jit_float64) -> jit_float64;

    pub fn jit_float64_rint(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_round(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_sin(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_sinh(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_sqrt(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_tan(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_tanh(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_trunc(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_is_finite(value: jit_float64) -> jit_int;

    pub fn jit_float64_is_nan(value: jit_float64) -> jit_int;

    pub fn jit_float64_is_inf(value: jit_float64) -> jit_int;

    pub fn jit_float64_abs(value1: jit_float64) -> jit_float64;

    pub fn jit_float64_min(value1: jit_float64, value2: jit_float64) -> jit_float64;

    pub fn jit_float64_max(value1: jit_float64, value2: jit_float64) -> jit_float64;

    pub fn jit_float64_sign(value1: jit_float64) -> jit_int;

    pub fn jit_nfloat_add(value1: jit_nfloat, value2: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_sub(value1: jit_nfloat, value2: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_mul(value1: jit_nfloat, value2: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_div(value1: jit_nfloat, value2: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_rem(value1: jit_nfloat, value2: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_ieee_rem(value1: jit_nfloat, value2: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_neg(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_eq(value1: jit_nfloat, value2: jit_nfloat) -> jit_int;

    pub fn jit_nfloat_ne(value1: jit_nfloat, value2: jit_nfloat) -> jit_int;

    pub fn jit_nfloat_lt(value1: jit_nfloat, value2: jit_nfloat) -> jit_int;

    pub fn jit_nfloat_le(value1: jit_nfloat, value2: jit_nfloat) -> jit_int;

    pub fn jit_nfloat_gt(value1: jit_nfloat, value2: jit_nfloat) -> jit_int;

    pub fn jit_nfloat_ge(value1: jit_nfloat, value2: jit_nfloat) -> jit_int;

    pub fn jit_nfloat_cmpl(value1: jit_nfloat, value2: jit_nfloat) -> jit_int;

    pub fn jit_nfloat_cmpg(value1: jit_nfloat, value2: jit_nfloat) -> jit_int;

    pub fn jit_nfloat_acos(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_asin(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_atan(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_atan2(value1: jit_nfloat, value2: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_ceil(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_cos(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_cosh(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_exp(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_floor(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_log(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_log10(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_pow(value1: jit_nfloat, value2: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_rint(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_round(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_sin(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_sinh(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_sqrt(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_tan(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_tanh(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_trunc(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_is_finite(value: jit_nfloat) -> jit_int;

    pub fn jit_nfloat_is_nan(value: jit_nfloat) -> jit_int;

    pub fn jit_nfloat_is_inf(value: jit_nfloat) -> jit_int;

    pub fn jit_nfloat_abs(value1: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_min(value1: jit_nfloat, value2: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_max(value1: jit_nfloat, value2: jit_nfloat) -> jit_nfloat;

    pub fn jit_nfloat_sign(value1: jit_nfloat) -> jit_int;

    pub fn jit_int_to_sbyte(value: jit_int) -> jit_int;

    pub fn jit_int_to_ubyte(value: jit_int) -> jit_int;

    pub fn jit_int_to_short(value: jit_int) -> jit_int;

    pub fn jit_int_to_ushort(value: jit_int) -> jit_int;

    pub fn jit_int_to_int(value: jit_int) -> jit_int;

    pub fn jit_int_to_uint(value: jit_int) -> jit_uint;

    pub fn jit_int_to_long(value: jit_int) -> jit_long;

    pub fn jit_int_to_ulong(value: jit_int) -> jit_ulong;

    pub fn jit_uint_to_int(value: jit_uint) -> jit_int;

    pub fn jit_uint_to_uint(value: jit_uint) -> jit_uint;

    pub fn jit_uint_to_long(value: jit_uint) -> jit_long;

    pub fn jit_uint_to_ulong(value: jit_uint) -> jit_ulong;

    pub fn jit_long_to_int(value: jit_long) -> jit_int;

    pub fn jit_long_to_uint(value: jit_long) -> jit_uint;

    pub fn jit_long_to_long(value: jit_long) -> jit_long;

    pub fn jit_long_to_ulong(value: jit_long) -> jit_ulong;

    pub fn jit_ulong_to_int(value: jit_ulong) -> jit_int;

    pub fn jit_ulong_to_uint(value: jit_ulong) -> jit_uint;

    pub fn jit_ulong_to_long(value: jit_ulong) -> jit_long;

    pub fn jit_ulong_to_ulong(value: jit_ulong) -> jit_ulong;

    pub fn jit_int_to_sbyte_ovf(result: *mut jit_int, value: jit_int) -> jit_int;

    pub fn jit_int_to_ubyte_ovf(result: *mut jit_int, value: jit_int) -> jit_int;

    pub fn jit_int_to_short_ovf(result: *mut jit_int, value: jit_int) -> jit_int;

    pub fn jit_int_to_ushort_ovf(result: *mut jit_int, value: jit_int) -> jit_int;

    pub fn jit_int_to_int_ovf(result: *mut jit_int, value: jit_int) -> jit_int;

    pub fn jit_int_to_uint_ovf(result: *mut jit_uint, value: jit_int) -> jit_int;

    pub fn jit_int_to_long_ovf(result: *mut jit_long, value: jit_int) -> jit_int;

    pub fn jit_int_to_ulong_ovf(result: *mut jit_ulong, value: jit_int) -> jit_int;

    pub fn jit_uint_to_int_ovf(result: *mut jit_int, value: jit_uint) -> jit_int;

    pub fn jit_uint_to_uint_ovf(result: *mut jit_uint, value: jit_uint) -> jit_int;

    pub fn jit_uint_to_long_ovf(result: *mut jit_long, value: jit_uint) -> jit_int;

    pub fn jit_uint_to_ulong_ovf(result: *mut jit_ulong, value: jit_uint) -> jit_int;

    pub fn jit_long_to_int_ovf(result: *mut jit_int, value: jit_long) -> jit_int;

    pub fn jit_long_to_uint_ovf(result: *mut jit_uint, value: jit_long) -> jit_int;

    pub fn jit_long_to_long_ovf(result: *mut jit_long, value: jit_long) -> jit_int;

    pub fn jit_long_to_ulong_ovf(result: *mut jit_ulong, value: jit_long) -> jit_int;

    pub fn jit_ulong_to_int_ovf(result: *mut jit_int, value: jit_ulong) -> jit_int;

    pub fn jit_ulong_to_uint_ovf(result: *mut jit_uint, value: jit_ulong) -> jit_int;

    pub fn jit_ulong_to_long_ovf(result: *mut jit_long, value: jit_ulong) -> jit_int;

    pub fn jit_ulong_to_ulong_ovf(result: *mut jit_ulong, value: jit_ulong) -> jit_int;

    pub fn jit_float32_to_int(value: jit_float32) -> jit_int;

    pub fn jit_float32_to_uint(value: jit_float32) -> jit_uint;

    pub fn jit_float32_to_long(value: jit_float32) -> jit_long;

    pub fn jit_float32_to_ulong(value: jit_float32) -> jit_ulong;

    pub fn jit_float32_to_int_ovf(result: *mut jit_int, value: jit_float32) -> jit_int;

    pub fn jit_float32_to_uint_ovf(result: *mut jit_uint, value: jit_float32) -> jit_int;

    pub fn jit_float32_to_long_ovf(result: *mut jit_long, value: jit_float32) -> jit_int;

    pub fn jit_float32_to_ulong_ovf(result: *mut jit_ulong, value: jit_float32) -> jit_int;

    pub fn jit_float64_to_int(value: jit_float64) -> jit_int;

    pub fn jit_float64_to_uint(value: jit_float64) -> jit_uint;

    pub fn jit_float64_to_long(value: jit_float64) -> jit_long;

    pub fn jit_float64_to_ulong(value: jit_float64) -> jit_ulong;

    pub fn jit_float64_to_int_ovf(result: *mut jit_int, value: jit_float64) -> jit_int;

    pub fn jit_float64_to_uint_ovf(result: *mut jit_uint, value: jit_float64) -> jit_int;

    pub fn jit_float64_to_long_ovf(result: *mut jit_long, value: jit_float64) -> jit_int;

    pub fn jit_float64_to_ulong_ovf(result: *mut jit_ulong, value: jit_float64) -> jit_int;

    pub fn jit_nfloat_to_int(value: jit_nfloat) -> jit_int;

    pub fn jit_nfloat_to_uint(value: jit_nfloat) -> jit_uint;

    pub fn jit_nfloat_to_long(value: jit_nfloat) -> jit_long;

    pub fn jit_nfloat_to_ulong(value: jit_nfloat) -> jit_ulong;

    pub fn jit_nfloat_to_int_ovf(result: *mut jit_int, value: jit_nfloat) -> jit_int;

    pub fn jit_nfloat_to_uint_ovf(result: *mut jit_uint, value: jit_nfloat) -> jit_int;

    pub fn jit_nfloat_to_long_ovf(result: *mut jit_long, value: jit_nfloat) -> jit_int;

    pub fn jit_nfloat_to_ulong_ovf(result: *mut jit_ulong, value: jit_nfloat) -> jit_int;

    pub fn jit_int_to_float32(value: jit_int) -> jit_float32;

    pub fn jit_int_to_float64(value: jit_int) -> jit_float64;

    pub fn jit_int_to_nfloat(value: jit_int) -> jit_nfloat;

    pub fn jit_uint_to_float32(value: jit_uint) -> jit_float32;

    pub fn jit_uint_to_float64(value: jit_uint) -> jit_float64;

    pub fn jit_uint_to_nfloat(value: jit_uint) -> jit_nfloat;

    pub fn jit_long_to_float32(value: jit_long) -> jit_float32;

    pub fn jit_long_to_float64(value: jit_long) -> jit_float64;

    pub fn jit_long_to_nfloat(value: jit_long) -> jit_nfloat;

    pub fn jit_ulong_to_float32(value: jit_ulong) -> jit_float32;

    pub fn jit_ulong_to_float64(value: jit_ulong) -> jit_float64;

    pub fn jit_ulong_to_nfloat(value: jit_ulong) -> jit_nfloat;

    pub fn jit_float32_to_float64(value: jit_float32) -> jit_float64;

    pub fn jit_float32_to_nfloat(value: jit_float32) -> jit_nfloat;

    pub fn jit_float64_to_float32(value: jit_float64) -> jit_float32;

    pub fn jit_float64_to_nfloat(value: jit_float64) -> jit_nfloat;

    pub fn jit_nfloat_to_float32(value: jit_nfloat) -> jit_float32;

    pub fn jit_nfloat_to_float64(value: jit_nfloat) -> jit_float64;
}
pub type _jit_meta = c_void;
pub type jit_meta_t = *mut _jit_meta;
extern "C" {
    pub fn jit_meta_set(
        list: *mut jit_meta_t,
        type_: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        free_data: jit_meta_free_func,
        pool_owner: jit_function_t,
    ) -> ::std::os::raw::c_int;

    pub fn jit_meta_get(
        list: jit_meta_t,
        type_: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;

    pub fn jit_meta_free(list: *mut jit_meta_t, type_: ::std::os::raw::c_int);

    pub fn jit_meta_destroy(list: *mut jit_meta_t);
}
pub type jit_objmodel = c_void;
pub type jit_objmodel_t = *mut jit_objmodel;
pub type jitom_class = c_void;
pub type jitom_class_t = *mut jitom_class;
pub type jitom_field = c_void;
pub type jitom_field_t = *mut jitom_field;
pub type jitom_method = c_void;
pub type jitom_method_t = *mut jitom_method;
extern "C" {
    pub fn jitom_destroy_model(model: jit_objmodel_t);

    pub fn jitom_get_class_by_name(
        model: jit_objmodel_t,
        name: *const ::std::os::raw::c_char,
    ) -> jitom_class_t;

    pub fn jitom_class_get_name(
        model: jit_objmodel_t,
        klass: jitom_class_t,
    ) -> *mut ::std::os::raw::c_char;

    pub fn jitom_class_get_modifiers(
        model: jit_objmodel_t,
        klass: jitom_class_t,
    ) -> ::std::os::raw::c_int;

    pub fn jitom_class_get_type(model: jit_objmodel_t, klass: jitom_class_t) -> jit_type_t;

    pub fn jitom_class_get_value_type(model: jit_objmodel_t, klass: jitom_class_t) -> jit_type_t;

    pub fn jitom_class_get_primary_super(
        model: jit_objmodel_t,
        klass: jitom_class_t,
    ) -> jitom_class_t;

    pub fn jitom_class_get_all_supers(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        num: *mut ::std::os::raw::c_uint,
    ) -> *mut jitom_class_t;

    pub fn jitom_class_get_interfaces(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        num: *mut ::std::os::raw::c_uint,
    ) -> *mut jitom_class_t;

    pub fn jitom_class_get_fields(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        num: *mut ::std::os::raw::c_uint,
    ) -> *mut jitom_field_t;

    pub fn jitom_class_get_methods(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        num: *mut ::std::os::raw::c_uint,
    ) -> *mut jitom_method_t;

    pub fn jitom_class_new(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        ctor: jitom_method_t,
        func: jit_function_t,
        args: *mut jit_value_t,
        num_args: ::std::os::raw::c_uint,
        flags: ::std::os::raw::c_int,
    ) -> jit_value_t;

    pub fn jitom_class_new_value(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        ctor: jitom_method_t,
        func: jit_function_t,
        args: *mut jit_value_t,
        num_args: ::std::os::raw::c_uint,
        flags: ::std::os::raw::c_int,
    ) -> jit_value_t;

    pub fn jitom_class_delete(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        obj_value: jit_value_t,
    ) -> ::std::os::raw::c_int;

    pub fn jitom_class_add_ref(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        obj_value: jit_value_t,
    ) -> ::std::os::raw::c_int;

    pub fn jitom_field_get_name(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        field: jitom_field_t,
    ) -> *mut ::std::os::raw::c_char;

    pub fn jitom_field_get_type(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        field: jitom_field_t,
    ) -> jit_type_t;

    pub fn jitom_field_get_modifiers(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        field: jitom_field_t,
    ) -> ::std::os::raw::c_int;

    pub fn jitom_field_load(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        field: jitom_field_t,
        func: jit_function_t,
        obj_value: jit_value_t,
    ) -> jit_value_t;

    pub fn jitom_field_load_address(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        field: jitom_field_t,
        func: jit_function_t,
        obj_value: jit_value_t,
    ) -> jit_value_t;

    pub fn jitom_field_store(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        field: jitom_field_t,
        func: jit_function_t,
        obj_value: jit_value_t,
        value: jit_value_t,
    ) -> ::std::os::raw::c_int;

    pub fn jitom_method_get_name(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        method: jitom_method_t,
    ) -> *mut ::std::os::raw::c_char;

    pub fn jitom_method_get_type(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        method: jitom_method_t,
    ) -> jit_type_t;

    pub fn jitom_method_get_modifiers(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        method: jitom_method_t,
    ) -> ::std::os::raw::c_int;

    pub fn jitom_method_invoke(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        method: jitom_method_t,
        func: jit_function_t,
        args: *mut jit_value_t,
        num_args: ::std::os::raw::c_uint,
        flags: ::std::os::raw::c_int,
    ) -> jit_value_t;

    pub fn jitom_method_invoke_virtual(
        model: jit_objmodel_t,
        klass: jitom_class_t,
        method: jitom_method_t,
        func: jit_function_t,
        args: *mut jit_value_t,
        num_args: ::std::os::raw::c_uint,
        flags: ::std::os::raw::c_int,
    ) -> jit_value_t;

    pub fn jitom_type_tag_as_class(
        type_: jit_type_t,
        model: jit_objmodel_t,
        klass: jitom_class_t,
        incref: ::std::os::raw::c_int,
    ) -> jit_type_t;

    pub fn jitom_type_tag_as_value(
        type_: jit_type_t,
        model: jit_objmodel_t,
        klass: jitom_class_t,
        incref: ::std::os::raw::c_int,
    ) -> jit_type_t;

    pub fn jitom_type_is_class(type_: jit_type_t) -> ::std::os::raw::c_int;

    pub fn jitom_type_is_value(type_: jit_type_t) -> ::std::os::raw::c_int;

    pub fn jitom_type_get_model(type_: jit_type_t) -> jit_objmodel_t;

    pub fn jitom_type_get_class(type_: jit_type_t) -> jitom_class_t;
}
pub type jit_opcode_info_t = jit_opcode_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jit_opcode_info {
    pub name: *const ::std::os::raw::c_char,
    pub flags: ::std::os::raw::c_int,
}
extern "C" {
    pub static jit_opcodes: [jit_opcode_info_t; 437usize];
}

pub type _jit_arch_frame_t = _jit_arch_frame;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jit_arch_frame {
    pub next_frame: *mut _jit_arch_frame_t,
    pub return_address: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jit_unwind_context_t {
    pub frame: *mut ::std::os::raw::c_void,
    pub cache: *mut ::std::os::raw::c_void,
    pub context: jit_context_t,
}

extern "C" {
    pub fn jit_unwind_init(
        unwind: *mut jit_unwind_context_t,
        context: jit_context_t,
    ) -> ::std::os::raw::c_int;

    pub fn jit_unwind_free(unwind: *mut jit_unwind_context_t);

    pub fn jit_unwind_next(unwind: *mut jit_unwind_context_t) -> ::std::os::raw::c_int;

    pub fn jit_unwind_next_pc(unwind: *mut jit_unwind_context_t) -> ::std::os::raw::c_int;

    pub fn jit_unwind_get_pc(unwind: *mut jit_unwind_context_t) -> *mut ::std::os::raw::c_void;

    pub fn jit_unwind_jump(
        unwind: *mut jit_unwind_context_t,
        pc: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;

    pub fn jit_unwind_get_function(unwind: *mut jit_unwind_context_t) -> jit_function_t;

    pub fn jit_unwind_get_offset(unwind: *mut jit_unwind_context_t) -> ::std::os::raw::c_uint;

    pub fn jit_malloc(size: ::std::os::raw::c_uint) -> *mut ::std::os::raw::c_void;

    pub fn jit_calloc(
        num: ::std::os::raw::c_uint,
        size: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_void;

    pub fn jit_realloc(
        ptr: *mut ::std::os::raw::c_void,
        size: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_void;

    pub fn jit_free(ptr: *mut ::std::os::raw::c_void);

    pub fn jit_memset(
        dest: *mut ::std::os::raw::c_void,
        ch: ::std::os::raw::c_int,
        len: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_void;

    pub fn jit_memcpy(
        dest: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        len: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_void;

    pub fn jit_memmove(
        dest: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        len: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_void;

    pub fn jit_memcmp(
        s1: *const ::std::os::raw::c_void,
        s2: *const ::std::os::raw::c_void,
        len: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;

    pub fn jit_memchr(
        str_: *const ::std::os::raw::c_void,
        ch: ::std::os::raw::c_int,
        len: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_void;

    pub fn jit_strlen(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_uint;

    pub fn jit_strcpy(
        dest: *mut ::std::os::raw::c_char,
        src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;

    pub fn jit_strcat(
        dest: *mut ::std::os::raw::c_char,
        src: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;

    pub fn jit_strncpy(
        dest: *mut ::std::os::raw::c_char,
        src: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_char;

    pub fn jit_strdup(str_: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;

    pub fn jit_strndup(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_char;

    pub fn jit_strcmp(
        str1: *const ::std::os::raw::c_char,
        str2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;

    pub fn jit_strncmp(
        str1: *const ::std::os::raw::c_char,
        str2: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;

    pub fn jit_stricmp(
        str1: *const ::std::os::raw::c_char,
        str2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;

    pub fn jit_strnicmp(
        str1: *const ::std::os::raw::c_char,
        str2: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;

    pub fn jit_strchr(
        str_: *const ::std::os::raw::c_char,
        ch: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;

    pub fn jit_strrchr(
        str_: *const ::std::os::raw::c_char,
        ch: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;

    pub fn jit_sprintf(
        str_: *mut ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;

    pub fn jit_snprintf(
        str_: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_uint,
        format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[repr(align(16))]
#[derive(Copy, Clone)]
pub struct jit_constant_t {
    pub type_: jit_type_t,
    pub __bindgen_padding_0: u64,
    pub un: jit_constant_t__bindgen_ty_1,
}
#[repr(C)]
#[repr(align(16))]
#[derive(Copy, Clone)]
pub union jit_constant_t__bindgen_ty_1 {
    pub ptr_value: *mut ::std::os::raw::c_void,
    pub int_value: jit_int,
    pub uint_value: jit_uint,
    pub nint_value: jit_nint,
    pub nuint_value: jit_nuint,
    pub long_value: jit_long,
    pub ulong_value: jit_ulong,
    pub float32_value: jit_float32,
    pub float64_value: jit_float64,
    pub nfloat_value: jit_nfloat,
}

extern "C" {
    /// Create a new value in the context of a function’s current block. The value initially starts off as a block-specific temporary. It will be converted into a function-wide local variable if it is ever referenced from a different block. Returns NULL if out of memory.
    ///
    /// Note: It isn’t possible to refer to global variables directly using values. If you need to access a global variable, then load its address into a temporary and use [`jit_insn_load_relative`] or [`jit_insn_store_relative`] to manipulate it. It simplifies the JIT if it can assume that all values are local.
    pub fn jit_value_create(func: jit_function_t, type_: jit_type_t) -> jit_value_t;

    /// Create a new native integer constant in the specified function. Returns NULL if out of memory.
    ///
    /// The `type` parameter indicates the actual type of the constant, if it happens to be something other than [`jit_type_nint`]. For example, the following will create an unsigned byte constant:
    ///
    /// ```no_run
    /// value = jit_value_create_nint_constant(func, jit_type_ubyte, 128);
    /// ```
    /// This function can be used to create constants of type [`jit_type_sbyte`], [`jit_type_ubyte`], [`jit_type_short`], [`jit_type_ushort`], [`jit_type_int`], [`jit_type_uint`], [`jit_type_nint`], [`jit_type_nuint`], and all pointer types.
    pub fn jit_value_create_nint_constant(
        func: jit_function_t,
        type_: jit_type_t,
        const_value: jit_nint,
    ) -> jit_value_t;

    /// Create a new 64-bit integer constant in the specified function. This can also be used to create constants of type [`jit_type_ulong`]. Returns NULL if out of memory.
    pub fn jit_value_create_long_constant(
        func: jit_function_t,
        type_: jit_type_t,
        const_value: jit_long,
    ) -> jit_value_t;

    /// Create a new 32-bit floating-point constant in the specified function. Returns NULL if out of memory.
    pub fn jit_value_create_float32_constant(
        func: jit_function_t,
        type_: jit_type_t,
        const_value: jit_float32,
    ) -> jit_value_t;

    /// Create a new 64-bit floating-point constant in the specified function. Returns NULL if out of memory.
    pub fn jit_value_create_float64_constant(
        func: jit_function_t,
        type_: jit_type_t,
        const_value: jit_float64,
    ) -> jit_value_t;

    /// Create a new native floating-point constant in the specified function. Returns NULL if out of memory.
    pub fn jit_value_create_nfloat_constant(
        func: jit_function_t,
        type_: jit_type_t,
        const_value: jit_nfloat,
    ) -> jit_value_t;

    /// Create a new constant from a generic constant structure in the specified function. Returns NULL if out of memory or if the type in `const_value` is not suitable for a constant.
    pub fn jit_value_create_constant(
        func: jit_function_t,
        const_value: *const jit_constant_t,
    ) -> jit_value_t;

    /// Get the value that corresponds to a specified function parameter. Returns NULL if out of memory or `param` is invalid.
    pub fn jit_value_get_param(func: jit_function_t, param: ::std::os::raw::c_uint) -> jit_value_t;

    /// Get the value that contains the structure return pointer for a function. If the function does not have a structure return pointer (i.e. structures are returned in registers), then this returns NULL.
    pub fn jit_value_get_struct_pointer(func: jit_function_t) -> jit_value_t;

    /// Determine if a value is temporary. i.e. its scope extends over a single block within its function.
    pub fn jit_value_is_temporary(value: jit_value_t) -> ::std::os::raw::c_int;

    /// Determine if a value is local. i.e. its scope extends over multiple blocks within its function.
    pub fn jit_value_is_local(value: jit_value_t) -> ::std::os::raw::c_int;

    /// Determine if a value is a constant.
    pub fn jit_value_is_constant(value: jit_value_t) -> ::std::os::raw::c_int;

    /// Determine if a value is a function parameter.
    pub fn jit_value_is_parameter(value: jit_value_t) -> ::std::os::raw::c_int;

    /// Create a reference to the specified `value` from the current block in `func`. This will convert a temporary `value` into a local value if value is being referenced from a different block than its original.
    ///
    /// It is not necessary that `func` be the same function as the one where the value was originally created. It may be a nested function, referring to a local variable in its parent function.
    pub fn jit_value_ref(func: jit_function_t, value: jit_value_t);

    /// Set a flag on a value to indicate that it is volatile. The contents of the value must always be reloaded from memory, never from a cached register copy.
    pub fn jit_value_set_volatile(value: jit_value_t);

    /// Determine if a value is volatile.
    pub fn jit_value_is_volatile(value: jit_value_t) -> ::std::os::raw::c_int;

    /// Set a flag on a value to indicate that it is addressable. This should be used when you want to take the address of a value (e.g. `&variable` in C). The value is guaranteed to not be stored in a register across a function call. If you refer to a value from a nested function ([`jit_value_ref`]), then the value will be automatically marked as addressable.
    pub fn jit_value_set_addressable(value: jit_value_t);

    /// Determine if a value is addressable.
    pub fn jit_value_is_addressable(value: jit_value_t) -> ::std::os::raw::c_int;

    /// Get the type that is associated with a value.
    pub fn jit_value_get_type(value: jit_value_t) -> jit_type_t;

    /// Get the function which owns a particular `value`.
    pub fn jit_value_get_function(value: jit_value_t) -> jit_function_t;

    /// Get the block which owns a particular `value`.
    pub fn jit_value_get_block(value: jit_value_t) -> jit_block_t;

    /// Get the context which owns a particular `value`.
    pub fn jit_value_get_context(value: jit_value_t) -> jit_context_t;

    /// Get the constant value within a particular `value`. The returned structure’s type field will be [`jit_type_void`] if `value` is not a constant.
    pub fn jit_value_get_constant(value: jit_value_t) -> jit_constant_t;

    /// Get the constant value within a particular `value`, assuming that its type is compatible with [`jit_type_nint`].
    pub fn jit_value_get_nint_constant(value: jit_value_t) -> jit_nint;

    /// Get the constant value within a particular `value`, assuming that its type is compatible with [`jit_type_long`].
    pub fn jit_value_get_long_constant(value: jit_value_t) -> jit_long;

    /// Get the constant value within a particular `value`, assuming that its type is compatible with [`jit_type_float32`].
    pub fn jit_value_get_float32_constant(value: jit_value_t) -> jit_float32;

    /// Get the constant value within a particular `value`, assuming that its type is compatible with [`jit_type_float64`].
    pub fn jit_value_get_float64_constant(value: jit_value_t) -> jit_float64;

    /// Get the constant value within a particular `value`, assuming that its type is compatible with [`jit_type_nfloat`].
    pub fn jit_value_get_nfloat_constant(value: jit_value_t) -> jit_nfloat;

    /// Determine if `value` is constant and non-zero.
    pub fn jit_value_is_true(value: jit_value_t) -> ::std::os::raw::c_int;

    /// Convert a the constant `value` into a new `type`, and return its value in `result`. Returns zero if the conversion is not possible, usually due to overflow.
    pub fn jit_constant_convert(
        result: *mut jit_constant_t,
        value: *const jit_constant_t,
        type_: jit_type_t,
        overflow_check: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub const jit_prot_t_JIT_PROT_NONE: jit_prot_t = 0;
pub const jit_prot_t_JIT_PROT_READ: jit_prot_t = 1;
pub const jit_prot_t_JIT_PROT_READ_WRITE: jit_prot_t = 2;
pub const jit_prot_t_JIT_PROT_EXEC_READ: jit_prot_t = 3;
pub const jit_prot_t_JIT_PROT_EXEC_READ_WRITE: jit_prot_t = 4;
pub type jit_prot_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn jit_vmem_init();

    pub fn jit_vmem_page_size() -> jit_uint;

    pub fn jit_vmem_round_up(value: jit_nuint) -> jit_nuint;

    pub fn jit_vmem_round_down(value: jit_nuint) -> jit_nuint;

    pub fn jit_vmem_reserve(size: jit_uint) -> *mut ::std::os::raw::c_void;

    pub fn jit_vmem_reserve_committed(
        size: jit_uint,
        prot: jit_prot_t,
    ) -> *mut ::std::os::raw::c_void;

    pub fn jit_vmem_release(
        addr: *mut ::std::os::raw::c_void,
        size: jit_uint,
    ) -> ::std::os::raw::c_int;

    pub fn jit_vmem_commit(
        addr: *mut ::std::os::raw::c_void,
        size: jit_uint,
        prot: jit_prot_t,
    ) -> ::std::os::raw::c_int;

    pub fn jit_vmem_decommit(
        addr: *mut ::std::os::raw::c_void,
        size: jit_uint,
    ) -> ::std::os::raw::c_int;

    pub fn jit_vmem_protect(
        addr: *mut ::std::os::raw::c_void,
        size: jit_uint,
        prot: jit_prot_t,
    ) -> ::std::os::raw::c_int;

    pub fn _jit_get_frame_address(
        start: *mut ::std::os::raw::c_void,
        n: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_void;

    pub fn _jit_get_next_frame_address(
        frame: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;

    pub fn _jit_get_return_address(
        frame: *mut ::std::os::raw::c_void,
        frame0: *mut ::std::os::raw::c_void,
        return0: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jit_crawl_mark_t {
    pub mark: *mut ::std::os::raw::c_void,
}

extern "C" {
    pub fn jit_frame_contains_crawl_mark(
        frame: *mut ::std::os::raw::c_void,
        mark: *mut jit_crawl_mark_t,
    ) -> ::std::os::raw::c_int;
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}

#[test]
fn sanity() {
    unsafe {
        let ctx = jit_context_create();

        jit_context_build_start(ctx);

        let mut params = vec![];
        params.push(jit_type_int);
        params.push(jit_type_int);

        let sig = jit_type_create_signature(
            jit_abi_t_jit_abi_cdecl,
            jit_type_int,
            params.as_mut_ptr(),
            params.len() as u32,
            1,
        );

        let func = jit_function_create(ctx, sig);

        let x_param = jit_value_get_param(func, 0);
        let y_param = jit_value_get_param(func, 1);

        let temp = jit_insn_add(func, x_param, y_param);
        jit_insn_return(func, temp);

        jit_function_compile(func);
        jit_context_build_end(ctx);

        let arg_values: Vec<jit_int> = vec![123, 456];
        let arg_ptrs: Vec<*const jit_int> =
            arg_values.iter().map(|p| p as *const jit_int).collect();
        let mut result: jit_int = 0;

        jit_function_apply(
            func,
            // We can probably use a smaller hammer than
            // std::mem::translate.
            std::mem::transmute(arg_ptrs.as_ptr()),
            std::mem::transmute(&mut result),
        );

        jit_context_destroy(ctx);
        assert_eq!(result, 123 + 456);
    }
}
