/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// WorkflowCondition : The workflow transition rule conditions tree.


#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
#[serde(tag = "nodetype")]
pub enum WorkflowCondition {
    #[serde(rename="compound")]
    WorkflowCompoundCondition {
        /// The compound condition operator.
        #[serde(rename = "operator")]
        operator: Operator,
        /// The list of workflow conditions.
        #[serde(rename = "conditions")]
        conditions: Vec<crate::models::WorkflowCondition>,
    },
    #[serde(rename="simple")]
    WorkflowSimpleCondition {
        /// The type of the transition rule.
        #[serde(rename = "type")]
        _type: String,
        /// EXPERIMENTAL. The configuration of the transition rule.
        #[serde(rename = "configuration", skip_serializing_if = "Option::is_none")]
        configuration: Option<serde_json::Value>,
    },
}



/// The compound condition operator.
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Operator {
    #[serde(rename = "AND")]
    AND,
    #[serde(rename = "OR")]
    OR,
}

impl Default for Operator {
    fn default() -> Operator {
        Self::AND
    }
}

