/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// UserPermission : Details of a permission and its availability to a user.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct UserPermission {
    /// The ID of the permission. Either `id` or `key` must be specified. Use [Get all permissions](#api-rest-api-2-permissions-get) to get the list of permissions.
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// The key of the permission. Either `id` or `key` must be specified. Use [Get all permissions](#api-rest-api-2-permissions-get) to get the list of permissions.
    #[serde(rename = "key", skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    /// The name of the permission.
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// The type of the permission.
    #[serde(rename = "type", skip_serializing_if = "Option::is_none")]
    pub _type: Option<Type>,
    /// The description of the permission.
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    /// Whether the permission is available to the user in the queried context.
    #[serde(rename = "havePermission", skip_serializing_if = "Option::is_none")]
    pub have_permission: Option<bool>,
    /// Indicate whether the permission key is deprecated. Note that deprecated keys cannot be used in the `permissions parameter of Get my permissions. Deprecated keys are not returned by Get all permissions.`
    #[serde(rename = "deprecatedKey", skip_serializing_if = "Option::is_none")]
    pub deprecated_key: Option<bool>,
}

impl UserPermission {
    /// Details of a permission and its availability to a user.
    pub fn new() -> UserPermission {
        UserPermission {
            id: None,
            key: None,
            name: None,
            _type: None,
            description: None,
            have_permission: None,
            deprecated_key: None,
        }
    }
}

/// The type of the permission.
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Type {
    #[serde(rename = "GLOBAL")]
    GLOBAL,
    #[serde(rename = "PROJECT")]
    PROJECT,
}

impl Default for Type {
    fn default() -> Type {
        Self::GLOBAL
    }
}

