/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// ProjectIssueCreateMetadata : Details of the issue creation metadata for a project.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct ProjectIssueCreateMetadata {
    /// Expand options that include additional project issue create metadata details in the response.
    #[serde(rename = "expand", skip_serializing_if = "Option::is_none")]
    pub expand: Option<String>,
    /// The URL of the project.
    #[serde(rename = "self", skip_serializing_if = "Option::is_none")]
    pub _self: Option<String>,
    /// The ID of the project.
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// The key of the project.
    #[serde(rename = "key", skip_serializing_if = "Option::is_none")]
    pub key: Option<String>,
    /// The name of the project.
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// List of the project's avatars, returning the avatar size and associated URL.
    #[serde(rename = "avatarUrls", skip_serializing_if = "Option::is_none")]
    pub avatar_urls: Option<crate::models::AvatarUrlsBean>,
    /// List of the issue types supported by the project.
    #[serde(rename = "issuetypes", skip_serializing_if = "Option::is_none")]
    pub issuetypes: Option<Vec<crate::models::IssueTypeIssueCreateMetadata>>,
}

impl ProjectIssueCreateMetadata {
    /// Details of the issue creation metadata for a project.
    pub fn new() -> ProjectIssueCreateMetadata {
        ProjectIssueCreateMetadata {
            expand: None,
            _self: None,
            id: None,
            key: None,
            name: None,
            avatar_urls: None,
            issuetypes: None,
        }
    }
}


