/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// IssueTransition : Details of an issue transition.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct IssueTransition {
    /// The ID of the issue transition. Required when specifying a transition to undertake.
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// The name of the issue transition.
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    /// Details of the issue status after the transition.
    #[serde(rename = "to", skip_serializing_if = "Option::is_none")]
    pub to: Option<crate::models::StatusDetails>,
    /// Whether there is a screen associated with the issue transition.
    #[serde(rename = "hasScreen", skip_serializing_if = "Option::is_none")]
    pub has_screen: Option<bool>,
    /// Whether the issue transition is global, that is, the transition is applied to issues regardless of their status.
    #[serde(rename = "isGlobal", skip_serializing_if = "Option::is_none")]
    pub is_global: Option<bool>,
    /// Whether this is the initial issue transition for the workflow.
    #[serde(rename = "isInitial", skip_serializing_if = "Option::is_none")]
    pub is_initial: Option<bool>,
    /// Whether the transition is available to be performed.
    #[serde(rename = "isAvailable", skip_serializing_if = "Option::is_none")]
    pub is_available: Option<bool>,
    /// Whether the issue has to meet criteria before the issue transition is applied.
    #[serde(rename = "isConditional", skip_serializing_if = "Option::is_none")]
    pub is_conditional: Option<bool>,
    /// Details of the fields associated with the issue transition screen. Use this information to populate `fields` and `update` in a transition request.
    #[serde(rename = "fields", skip_serializing_if = "Option::is_none")]
    pub fields: Option<::std::collections::HashMap<String, crate::models::FieldMetadata>>,
    /// Expand options that include additional transition details in the response.
    #[serde(rename = "expand", skip_serializing_if = "Option::is_none")]
    pub expand: Option<String>,
    #[serde(rename = "looped", skip_serializing_if = "Option::is_none")]
    pub looped: Option<bool>,
}

impl IssueTransition {
    /// Details of an issue transition.
    pub fn new() -> IssueTransition {
        IssueTransition {
            id: None,
            name: None,
            to: None,
            has_screen: None,
            is_global: None,
            is_initial: None,
            is_available: None,
            is_conditional: None,
            fields: None,
            expand: None,
            looped: None,
        }
    }
}


