/*
 * The Jira Cloud platform REST API
 *
 * Jira Cloud platform REST API documentation
 *
 * The version of the OpenAPI document: 1001.0.0-SNAPSHOT
 * Contact: ecosystem@atlassian.com
 * Generated by: https://openapi-generator.tech
 */

/// FailedWebhook : Details about a failed webhook.



#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct FailedWebhook {
    /// The webhook ID, as sent in the `X-Atlassian-Webhook-Identifier` header with the webhook.
    #[serde(rename = "id")]
    pub id: String,
    /// The webhook body.
    #[serde(rename = "body", skip_serializing_if = "Option::is_none")]
    pub body: Option<String>,
    /// The original webhook destination.
    #[serde(rename = "url")]
    pub url: String,
    /// The time the webhook was added to the list of failed webhooks (that is, the time of the last failed retry).
    #[serde(rename = "failureTime")]
    pub failure_time: i64,
}

impl FailedWebhook {
    /// Details about a failed webhook.
    pub fn new(id: String, url: String, failure_time: i64) -> FailedWebhook {
        FailedWebhook {
            id,
            body: None,
            url,
            failure_time,
        }
    }
}


